/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.app;

import com.kingdee.bos.security.framework.ISignatureConfig;
import com.kingdee.bos.security.framework.SignatureFieldInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class SignatureConfiguration
implements ISignatureConfig {
    private static final Logger logger = Logger.getLogger(SignatureConfiguration.class);
    private ConfigDao dao = ConfigDao.getConfigDao();
    private static ISignatureConfig instance;

    private SignatureConfiguration() {
    }

    public static ISignatureConfig getInstance() {
        return new SignatureConfiguration();
    }

    public static ISignatureConfig getCacheInstance() {
        if (instance == null) {
            instance = SignatureConfiguration.getInstance();
        }
        return instance;
    }

    public boolean isCanSignature() {
        return this.dao.isSignatureNeeded;
    }

    public boolean isCansignature(BOSObjectType bosType) {
        boolean bResult = false;
        if (bosType == null) {
            return false;
        }
        SignatureFieldInfo signatureFieldInfo = this.getSignatureFieldInfo(bosType);
        if (signatureFieldInfo != null) {
            bResult = signatureFieldInfo.isSignatureNeeded();
        }
        return bResult;
    }

    public SignatureFieldInfo getSignatureFieldInfo(BOSObjectType bosType) {
        SignatureFieldInfo signatureFieldInfo = (SignatureFieldInfo)this.dao.fieldConfigMap.get(bosType.toString());
        if (signatureFieldInfo == null) {
            signatureFieldInfo = new SignatureFieldInfo();
            signatureFieldInfo.setBosType(bosType);
        }
        return signatureFieldInfo;
    }

    public Collection getSignatureFieldCollection() {
        return this.dao.fieldConfigMap.values();
    }

    public Map getSignatureConfiguration() {
        return this.dao.fieldConfigMap;
    }

    public static void main(String[] args) {
        SignatureConfiguration config = new SignatureConfiguration();
        logger.info((Object)("config.isCanSignature() = " + config.isCanSignature()));
        logger.info((Object)config.getSignatureFieldInfo(BOSObjectType.create((String)"bostype1")));
    }

    static class ConfigDao {
        private final String FILE = "SignatureConfiguration.xml";
        private static ConfigDao dao = null;
        private Map fieldConfigMap = new HashMap();
        private boolean isSignatureNeeded = false;

        private ConfigDao() {
            this.initConfig();
        }

        public static ConfigDao getConfigDao() {
            dao = new ConfigDao();
            return dao;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void initConfig() {
            InputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(this.getConfigFile()));
                Element document = XMLParser.parseXML((InputStream)inputStream).getRootElement();
                this.loadConfigurationInfo(document);
                return;
            }
            catch (IOException e) {
                logger.error((Object)"\u8bfb\u53d6\u6570\u5b57\u7b7e\u540d\u5b57\u6bb5\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                return;
            }
            catch (JDOMException e) {
                logger.error((Object)"\u6570\u5b57\u7b7e\u540d\u5b57\u6bb5\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u51fa\u9519", (Throwable)e);
                return;
            }
            finally {
                try {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        inputStream = null;
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                        inputStream = null;
                    }
                }
                catch (Throwable throwable) {
                    inputStream = null;
                    throw throwable;
                }
            }
        }

        private File getConfigFile() throws IOException {
            String ctrlFilePath = new StringBuffer().append(System.getProperty("EAS_HOME")).append(File.separator).append("server").append(File.separator).append("properties").append(File.separator).append("SignatureConfiguration.xml").toString();
            File configFile = new File(ctrlFilePath);
            logger.debug((Object)("\u6570\u5b57\u7b7e\u540d \u5c5e\u6027\u914d\u7f6e\u6587\u4ef6\u4e3a:" + configFile.toString()));
            return configFile;
        }

        private void loadConfigurationInfo(Element root) {
            this.isSignatureNeeded = root.getAttribute("isSignatureNeeded") != null ? "true".equalsIgnoreCase(root.getAttribute("isSignatureNeeded").getValue()) : true;
            List childrens = root.getChildren();
            int size = childrens.size();
            for (int i = 0; i < size; ++i) {
                Element element = (Element)childrens.get(i);
                String elementName = element.getName();
                SignatureFieldInfo fieldInfo = new SignatureFieldInfo();
                String bosType = null;
                boolean isSignNeeded = true;
                if (element.getAttribute("bosType") == null) continue;
                bosType = element.getAttribute("bosType").getValue();
                if (element.getAttribute("isSignatureNeeded") != null) {
                    isSignNeeded = "true".equals(element.getAttribute("isSignatureNeeded").getValue());
                }
                fieldInfo.setBosType(BOSObjectType.create((String)bosType));
                fieldInfo.setSignatureNeeded(isSignNeeded);
                if ("configitem".equalsIgnoreCase(elementName)) {
                    List fields = element.getChildren();
                    int fieldSize = fields.size();
                    for (int index = 0; index < fieldSize; ++index) {
                        Element fieldElement = (Element)fields.get(index);
                        String fieldName = null;
                        String fieldAlias = null;
                        if (fieldElement.getAttribute("fieldName") == null) continue;
                        fieldName = fieldElement.getAttribute("fieldName").getValue();
                        if (fieldElement.getAttribute("fieldAlias") != null) {
                            fieldAlias = fieldElement.getAttribute("fieldAlias").getValue();
                        }
                        fieldInfo.addField(fieldName, fieldAlias);
                    }
                }
                if (fieldInfo.getBosType() == null) continue;
                this.fieldConfigMap.put(fieldInfo.getBosType().toString(), fieldInfo);
            }
        }
    }
}

