/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.app.signatureconfig;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.security.IEASSignatrueConfigHelper;
import com.kingdee.eas.base.security.IEASSignatureConfigProvider;
import com.kingdee.eas.base.security.app.signatureconfig.EASSignatrueConfigHelperUtil;
import com.kingdee.eas.base.security.app.signatureconfig.TreeNodeComparator;
import com.kingdee.eas.base.security.app.signatureconfig.uiobjectgeneractor.UIObjectGeneractor;
import com.kingdee.eas.base.security.signatureconfig.AbEntityInfo;
import com.kingdee.eas.base.security.signatureconfig.AbTreeNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;

public class EASSignatrueConfigHelper
extends AbstractBOSObject
implements IEASSignatrueConfigHelper {
    static final Logger logger;
    private static final BOSObjectType BOSTYPE;
    private static List<HashMap<String, String>> billList;
    private static String[] providers;
    private static Comparator<AbTreeNode> cmp;

    public EASSignatrueConfigHelper() {
    }

    public EASSignatrueConfigHelper(Context ctx) {
        super(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropertie(String file, Properties map) {
        File f = new File(file);
        if (!f.exists()) {
            return;
        }
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            properties.load(fis);
        }
        catch (Exception e) {
            logger.error((Object)("load wf_billdigest.properties from " + file + " failed!"), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Enumeration<Object> em = properties.keys();
        while (em.hasMoreElements()) {
            Object o;
            Object key = em.nextElement();
            Object value = properties.get(key);
            if (value instanceof String) {
                try {
                    value = new String(((String)value).getBytes("ISO8859-1"), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    value = properties.get(key);
                }
                value = ((String)value).trim();
            }
            if ((o = map.put(key, value)) == null) continue;
            StringBuffer msg = new StringBuffer();
            msg.append("wf_billabstract config {").append(key).append("=").append(o).append("} is overridden by {").append(file).append("}, with new value{").append(value).append("}");
            logger.info((Object)msg);
        }
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    @Override
    public String getProviderType() {
        return null;
    }

    @Override
    public AbTreeNode getRootNode() {
        AbTreeNode rtn = new AbTreeNode(this, null, "EAS", "EAS");
        boolean flag = false;
        for (int i = 0; i < providers.length; ++i) {
            if (providers[i] == null) continue;
            IEASSignatureConfigProvider provider = null;
            try {
                provider = this.getProvider(providers[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (provider == null) {
                EASSignatrueConfigHelper.providers[i] = null;
                continue;
            }
            AbTreeNode tmp = null;
            try {
                tmp = provider.getRootNode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tmp == null) continue;
            if ("eas".equalsIgnoreCase(tmp.getAlias())) {
                rtn.getChildren().addAll(tmp.getChildren());
            } else {
                rtn.getChildren().add(tmp);
            }
            flag = true;
        }
        if (flag) {
            Collections.sort(rtn.getChildren(), cmp);
        }
        return rtn;
    }

    @Override
    public AbEntityInfo getEntityInfo(String pk) {
        AbEntityInfo rtn = null;
        String[] pks = pk.split(";", 2);
        String providerType = "EAS";
        if (pks.length == 2) {
            pk = pks[0];
            providerType = pks[1];
        }
        IEASSignatureConfigProvider easprovider = null;
        IEASSignatureConfigProvider curprovider = null;
        for (int i = 0; i < providers.length; ++i) {
            if (providers[i] == null) continue;
            IEASSignatureConfigProvider provider = null;
            try {
                provider = this.getProvider(providers[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (provider == null) {
                EASSignatrueConfigHelper.providers[i] = null;
                continue;
            }
            if (curprovider == null && providerType.equalsIgnoreCase(provider.getClass().getName())) {
                curprovider = provider;
            }
            if (easprovider != null || !"EAS".equalsIgnoreCase(provider.getProviderType())) continue;
            easprovider = provider;
        }
        if (curprovider != null) {
            try {
                rtn = curprovider.getEntityInfo(pk);
            }
            catch (Exception e) {
                logger.error((Object)(curprovider.getClass().getName() + " getEntityInfo error!"), (Throwable)e);
                rtn = null;
            }
        }
        if (rtn == null && easprovider != null && curprovider != easprovider) {
            try {
                rtn = easprovider.getEntityInfo(pk);
            }
            catch (Exception e) {
                rtn = null;
            }
        }
        return rtn;
    }

    @Override
    public AbTreeNode getNodeByPk(String pk) {
        AbTreeNode rtn = null;
        if (pk == null) {
            rtn = new AbTreeNode(this, null, "EAS", "EAS");
            boolean flag = false;
            for (int i = 0; i < providers.length; ++i) {
                if (providers[i] == null) continue;
                IEASSignatureConfigProvider provider = null;
                try {
                    provider = this.getProvider(providers[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (provider == null) {
                    EASSignatrueConfigHelper.providers[i] = null;
                    continue;
                }
                AbTreeNode tmp = null;
                try {
                    tmp = provider.getNodeByPk(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tmp == null) continue;
                if ("eas".equalsIgnoreCase(tmp.getAlias())) {
                    rtn.getChildren().addAll(tmp.getChildren());
                } else {
                    rtn.getChildren().add(tmp);
                }
                flag = true;
            }
            if (flag) {
                Collections.sort(rtn.getChildren(), cmp);
            }
        } else {
            String[] pks = pk.split(";", 2);
            String providerType = "EAS";
            if (pks.length == 2) {
                pk = pks[0];
                providerType = pks[1];
            }
            IEASSignatureConfigProvider easprovider = null;
            IEASSignatureConfigProvider curprovider = null;
            for (int i = 0; i < providers.length; ++i) {
                if (providers[i] == null) continue;
                IEASSignatureConfigProvider provider = null;
                try {
                    provider = this.getProvider(providers[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (provider == null) {
                    EASSignatrueConfigHelper.providers[i] = null;
                    continue;
                }
                if (curprovider == null && providerType.equalsIgnoreCase(provider.getClass().getName())) {
                    curprovider = provider;
                }
                if (easprovider != null || !"EAS".equalsIgnoreCase(provider.getProviderType())) continue;
                easprovider = provider;
            }
            if (curprovider != null) {
                try {
                    rtn = curprovider.getNodeByPk(pk);
                }
                catch (Exception e) {
                    logger.error((Object)(curprovider.getClass().getName() + " getEntityInfo error!"), (Throwable)e);
                    rtn = null;
                }
            }
            if (rtn == null && easprovider != null && curprovider != easprovider) {
                try {
                    rtn = easprovider.getNodeByPk(pk);
                }
                catch (Exception e) {
                    logger.error((Object)(easprovider.getClass().getName() + " getEntityInfo error!"), (Throwable)e);
                    rtn = null;
                }
            }
        }
        return rtn;
    }

    private IEASSignatureConfigProvider getProvider(String clzName) throws Exception {
        Class<?> clz = Class.forName(clzName);
        Constructor<?> con = clz.getConstructor(Context.class);
        return (IEASSignatureConfigProvider)con.newInstance(this.getContext());
    }

    @Override
    public AbTreeNode getUITreeNodeByPk(String pk) {
        AbTreeNode rtn = EASSignatrueConfigHelperUtil.getNode(this.getContext(), this, MetaDataTypeList.UIOBJECT, MetaDataPK.create((String)"com_kingdee_eas_base_ui"), cmp, pk, new String[]{"listui"});
        return rtn;
    }

    @Override
    public String UIObjectGeneracte(String pk) {
        return UIObjectGeneractor.Generactor(this.getContext(), pk);
    }

    @Override
    public Map<?, ?> getDataByUIObjectPk(String pk) {
        DataObjectInfo doi;
        String billdigest = this.UIObjectGeneracte(pk);
        HashMap<String, String> rtn = new HashMap<String, String>();
        IMetaDataLoader mdloader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext());
        UIObjectInfo ui = (UIObjectInfo)mdloader.get(MetaDataTypeList.UIOBJECT, (IMetaDataPK)MetaDataPK.create((String)pk));
        if (ui != null && ui.getDataObjects() != null && ui.getDataObjects().size() > 0 && (doi = ui.getDataObjects().get(0)).getType() != null) {
            String bostype = this.getBosTypeByPk(doi.getType());
            rtn.put("template", billdigest);
            rtn.put("name", ui.getAlias());
            rtn.put("entityname", doi.getType());
            rtn.put("bostype", bostype);
        }
        return rtn;
    }

    private String getBosTypeByPk(String pk) {
        int hash = pk.hashCode();
        String type = Integer.toHexString(hash).toUpperCase();
        if (type.length() > 8) {
            type = type.substring(0, 8);
        } else if (type.length() < 8) {
            int n = type.length();
            for (int i = 0; i < 8 - n; ++i) {
                type = "0" + type;
            }
        }
        return type;
    }

    @Override
    public int getCount() {
        return 2;
    }

    @Override
    public List<?> list(int start, int end, String name, String bostype, String entityName, String purpose) {
        billList.clear();
        String easHome = System.getProperty("EAS_HOME");
        try {
            SAXBuilder builder;
            Document configDoc;
            Element e_config;
            List list;
            String filePath = easHome + "/server/properties/SignatureConfiguration.xml";
            if (new File(filePath).exists() && (list = (e_config = (Element)XPath.selectSingleNode((Object)(configDoc = (builder = new SAXBuilder()).build(new File(filePath))), (String)"/config")).getChildren()) != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    HashMap<String, String> item = new HashMap<String, String>();
                    Element e_child = (Element)list.get(i);
                    String bosType = e_child.getAttributeValue("bosType");
                    String bosTypeName = e_child.getAttributeValue("name");
                    String isSign = e_child.getAttributeValue("isSignatureNeeded");
                    item.put("bosType", bosType);
                    item.put("name", bosTypeName);
                    item.put("entityname", bosTypeName);
                    item.put("isSignatureNeeded", isSign);
                    List attr_list = e_child.getChildren();
                    String attrStr = "";
                    for (int k = 0; k < attr_list.size(); ++k) {
                        Element e_attr = (Element)attr_list.get(k);
                        attrStr = attrStr + "\r\n<attribute fieldName=\"" + e_attr.getAttributeValue("fieldName") + "\" fieldAlias=\"" + e_attr.getAttributeValue("fieldAlias") + "\"/>";
                    }
                    item.put("attributes", attrStr);
                    billList.add(item);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return billList;
    }

    @Override
    public Map<?, ?> getById(String id) {
        if (id == null || id.length() <= 0) {
            return new HashMap();
        }
        if (billList != null && billList.size() > 0) {
            for (HashMap<String, String> item : billList) {
                if (!id.equals(item.get("bosType"))) continue;
                return item;
            }
        }
        return new HashMap();
    }

    private boolean searchByBosType(String id, boolean delete) {
        String easHome = System.getProperty("EAS_HOME");
        try {
            SAXBuilder builder;
            Document configDoc;
            Element e_config;
            List list;
            String filePath = easHome + "/server/properties/SignatureConfiguration.xml";
            if (new File(filePath).exists() && (list = (e_config = (Element)XPath.selectSingleNode((Object)(configDoc = (builder = new SAXBuilder()).build(new File(filePath))), (String)"/config")).getChildren()) != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Element e_child = (Element)list.get(i);
                    String bosType = e_child.getAttributeValue("bosType");
                    if (!id.equals(bosType)) continue;
                    if (delete) {
                        e_child.detach();
                        this.saveDocument(configDoc, filePath);
                    }
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    @Override
    public boolean deleteById(String id) {
        if (id == null || id.length() <= 0) {
            return true;
        }
        return this.searchByBosType(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument(Document doc, String filepath) {
        OutputStreamWriter writer = null;
        try {
            Format format = Format.getCompactFormat();
            format.setIndent("  ");
            format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
            XMLOutputter XMLOut = new XMLOutputter(format);
            writer = new FileWriter(filepath);
            XMLOut.output(doc, (Writer)writer);
            writer.flush();
        }
        catch (Throwable ex) {
            logger.error((Object)("Save xml file[" + filepath + "] failed!"), ex);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean addnew(String bostype, String name, String entityName, String purpose, String template) {
        String easHome = System.getProperty("EAS_HOME");
        try {
            String filePath = easHome + "/server/properties/SignatureConfiguration.xml";
            if (new File(filePath).exists()) {
                SAXBuilder builder = new SAXBuilder();
                Document configDoc = builder.build(new File(filePath));
                Element e_root = configDoc.getRootElement();
                Element e_configItem = new Element("configitem");
                e_configItem.setAttribute("bosType", bostype);
                e_configItem.setAttribute("isSignatureNeeded", "true");
                e_configItem.setAttribute("name", name);
                e_configItem.setAttribute("entityname", entityName);
                String[] attributes = template.split(";");
                if (attributes != null && attributes.length > 0) {
                    for (String attribute : attributes) {
                        Element e_attribute = new Element("attribute");
                        String[] strs = attribute.split(":");
                        String fieldName = strs[0];
                        int index = fieldName.lastIndexOf(".");
                        if (index > 0) {
                            fieldName = fieldName.substring(index + 1);
                        }
                        e_attribute.setAttribute("fieldName", fieldName);
                        if (strs.length > 1) {
                            e_attribute.setAttribute("fieldAlias", strs[1]);
                        }
                        e_configItem.addContent((Content)e_attribute);
                    }
                }
                e_root.addContent((Content)e_configItem);
                this.saveDocument(configDoc, filePath);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    @Override
    public boolean update(String bostype, String name, String entityName, String purpose, String template) {
        this.delete(bostype, entityName, purpose);
        this.addnew(bostype, name, entityName, purpose, template);
        return true;
    }

    @Override
    public boolean delete(String bostype, String entityName, String purpose) {
        return this.deleteById(bostype);
    }

    @Override
    public boolean exists(String bostype, String entityName, String purpose) {
        return this.searchByBosType(bostype, false);
    }

    @Override
    public boolean isExistSignature(BOSObjectType bosType, String scene) throws Exception {
        return false;
    }

    static {
        int i;
        logger = Logger.getLogger((String)EASSignatrueConfigHelper.class.getName());
        BOSTYPE = BOSObjectType.create((String)"BAHFBCBD");
        billList = new ArrayList<HashMap<String, String>>();
        cmp = new TreeNodeComparator<AbTreeNode>();
        Properties properties = new Properties();
        String tmp = System.getProperty("java.security.auth.login.config");
        int n = i = tmp == null ? -1 : tmp.lastIndexOf("/");
        if (i < 0) {
            providers = new String[0];
            logger.error((Object)"System.getProperty('java.security.auth.login.config') not found!");
        } else {
            String path = tmp.substring(0, i) + "/";
            String file = path + "wf_billdigest.properties";
            EASSignatrueConfigHelper.loadPropertie(file, properties);
            file = path + "wf_billdigest-sp.properties";
            EASSignatrueConfigHelper.loadPropertie(file, properties);
            ArrayList<String> list = new ArrayList<String>();
            list.add("com.kingdee.eas.base.security.app.signatureconfig.EASSignatrueConfigProvider");
            Enumeration<Object> em = properties.keys();
            while (em.hasMoreElements()) {
                Object key = em.nextElement();
                Object value = properties.get(key);
                if (value == null || !"true".equalsIgnoreCase(value.toString())) continue;
                try {
                    String str = key.toString();
                    if (list.contains(str)) continue;
                    list.add(str);
                }
                catch (Exception exception) {}
            }
            providers = list.toArray(new String[list.size()]);
        }
    }
}

