/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.util;

import com.kingdee.eas.base.security.util.DERUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class CipherUtils {
    public static String md5(String plainText) {
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("System doesn't support MD5 algorithm.");
        }
        msgDigest.update(plainText.getBytes());
        return DERUtils.BytesToHexString(msgDigest.digest());
    }

    public static String sha1(String plainText) {
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("System doesn't support SHA1 algorithm.");
        }
        msgDigest.update(plainText.getBytes());
        return DERUtils.BytesToHexString(msgDigest.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeKeyObjectToFile(String keyObjectFileName, String algorithm) throws NoSuchAlgorithmException, IOException {
        algorithm = algorithm != null ? algorithm : "DES";
        SecureRandom sr = new SecureRandom();
        KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
        keyGenerator.init(sr);
        SecretKey key = keyGenerator.generateKey();
        try (ObjectOutputStream out = null;){
            out = new ObjectOutputStream(new FileOutputStream(keyObjectFileName));
            out.writeObject(key);
        }
    }

    public static Key recoverKeyObjectFromFile(String keyObjectFileName) throws FileNotFoundException, IOException, ClassNotFoundException {
        Key key;
        try (ObjectInputStream in = null;){
            in = new ObjectInputStream(new FileInputStream(keyObjectFileName));
            key = (Key)in.readObject();
        }
        return key;
    }

    public static byte[] encrypt(byte[] inputBytes, Key key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(1, key);
        byte[] encryptedBytes = cipher.doFinal(inputBytes);
        return encryptedBytes;
    }

    public static byte[] decrypt(byte[] encryptedBytes, Key key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(2, key);
        byte[] decryptedData = cipher.doFinal(encryptedBytes);
        return decryptedData;
    }
}

