/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.ssc.AssignFaultType;
import com.kingdee.eas.base.ssc.AssignJobFacadeFactory;
import com.kingdee.eas.base.ssc.AssignRuleCollection;
import com.kingdee.eas.base.ssc.AssignRuleFactory;
import com.kingdee.eas.base.ssc.AssignRuleInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeEntryCollection;
import com.kingdee.eas.base.ssc.BussinessAttributeEntryFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeEntryInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.DynamicValueCollection;
import com.kingdee.eas.base.ssc.JobExpireState;
import com.kingdee.eas.base.ssc.JobExtFactory;
import com.kingdee.eas.base.ssc.JobExtInfo;
import com.kingdee.eas.base.ssc.JobFactory;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.JobPoolingType;
import com.kingdee.eas.base.ssc.JobState;
import com.kingdee.eas.base.ssc.JobStateTimeFactory;
import com.kingdee.eas.base.ssc.JobStateTimeInfo;
import com.kingdee.eas.base.ssc.Operation;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.UserGroupFactory;
import com.kingdee.eas.base.ssc.UserGroupInfo;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.WorkPressureFactory;
import com.kingdee.eas.base.ssc.app.AssignJobFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.AssignJobThreadEx;
import com.kingdee.eas.base.ssc.app.OldJobStateEnum;
import com.kingdee.eas.base.ssc.assign.AssignEngineFacadeFactory;
import com.kingdee.eas.base.ssc.assign.AssignModelInfo;
import com.kingdee.eas.base.ssc.bussiness.bean.JobBean;
import com.kingdee.eas.base.ssc.external.TransferFlowSend;
import com.kingdee.eas.base.ssc.tool.EqualDivisionUtils;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.JobUtils;
import com.kingdee.eas.base.ssc.tool.SSCDbUtil;
import com.kingdee.eas.base.ssc.tool.SSCUtil;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.base.wssc.dynamicthreadpool.threadlocal.WSSCThreadLocal;
import com.kingdee.eas.base.wssc.util.common.LockDataUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AssignJobThread
extends Thread {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.AssignJobThread");
    protected String id = null;
    private boolean isFree = true;
    private Context ctx = null;
    private BussinessAttributeInfo bussinessAttributeInfo = null;
    private DataBaseInfo shareCenterInfo = null;
    private String shareCenterId = null;
    private String bussinessAttributeId = null;

    public AssignJobThread(Context ctx, BussinessAttributeInfo bussinessAttributeInfo, DataBaseInfo shareCenterInfo) {
        this.ctx = ctx;
        this.bussinessAttributeInfo = bussinessAttributeInfo;
        this.shareCenterInfo = shareCenterInfo;
        this.shareCenterId = shareCenterInfo.getId().toString();
        this.bussinessAttributeId = bussinessAttributeInfo.getId().toString();
        this.id = "[" + ctx.getAIS() + ":" + shareCenterInfo.get("number") + ":" + bussinessAttributeInfo.getNumber() + "]";
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public BussinessAttributeInfo getBussinessAttributeInfo() {
        return this.bussinessAttributeInfo;
    }

    public void setBussinessAttributeInfo(BussinessAttributeInfo bussinessAttributeInfo) {
        this.bussinessAttributeInfo = bussinessAttributeInfo;
    }

    public DataBaseInfo getShareCenterInfo() {
        return this.shareCenterInfo;
    }

    public void setShareCenterInfo(DataBaseInfo shareCenterInfo) {
        this.shareCenterInfo = shareCenterInfo;
    }

    public synchronized boolean isFree() {
        return this.isFree;
    }

    public synchronized void setFree(boolean isFree) {
        this.isFree = isFree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List lockDataId = null;
        List<JobInfo> list = new ArrayList();
        try {
            this.setFree(false);
            list = AssignJobFacadeFactory.getLocalInstance(this.ctx).queryUnassginJob(this.bussinessAttributeId, this.shareCenterId);
            Map map = LockDataUtils.lockData((Context)this.ctx, list, (String)"0");
            list = (List)map.get("list");
            lockDataId = (List)map.get("lockId");
            logger.error((Object)("\u5f00\u59cb\u751f\u6210assignModel\uff0cbussinessAttributeId\uff1a" + this.bussinessAttributeId + "\uff1blist.size()\uff1a" + list.size()));
            this.setThreadLocal(list);
            AssignModelInfo info = null;
            for (int i = 0; i < list.size(); ++i) {
                info = new AssignModelInfo();
                info.setFlowRegisterNumber("SSCAssignFlow");
                info.setTaskId(list.get(i).getId());
                info.setTaskType(list.get(i).getId().getType().toString());
                AssignEngineFacadeFactory.getLocalInstance(this.ctx).saveAndExecuteModel(info);
            }
            this.setFree(true);
        }
        catch (Exception e) {
            try {
                logger.error((Object)(this.id + "****AssignJobThread run\u51fa\u73b0\u5f02\u5e38,\u8f93\u51fa\u6808\u5806,\u5206\u914d\u4e2d\u65ad." + e.getMessage()), (Throwable)e);
                this.setFree(true);
            }
            catch (Throwable throwable) {
                this.setFree(true);
                logger.error((Object)(this.id + "****finally****setFree****shareCenterInfo:" + this.shareCenterInfo.getNumber()));
                LockDataUtils.unLockData((Context)this.ctx, lockDataId);
                throw throwable;
            }
            logger.error((Object)(this.id + "****finally****setFree****shareCenterInfo:" + this.shareCenterInfo.getNumber()));
            LockDataUtils.unLockData((Context)this.ctx, (List)lockDataId);
        }
        logger.error((Object)(this.id + "****finally****setFree****shareCenterInfo:" + this.shareCenterInfo.getNumber()));
        LockDataUtils.unLockData((Context)this.ctx, (List)lockDataId);
    }

    private void setThreadLocal(List<JobInfo> list) {
        JSONObject o = new JSONObject();
        o.put("busId", (Object)this.bussinessAttributeId);
        o.put("shareCenterId", (Object)this.shareCenterId);
        o.put("jobAmount", (Object)list.size());
        o.put("threadName", (Object)Thread.currentThread().getName());
        WSSCThreadLocal.THREAD_LOCAL.set(o.toJSONString());
    }

    public boolean saveAssignUser(JobInfo job) {
        if (job.getFaultType() != null && !job.getFaultType().equals((Object)AssignFaultType.NORMAL)) {
            return false;
        }
        try {
            job.setAssignCount(job.getAssignCount() + 1);
            String sql = "update t_ssc_job set FPERSONNELIDID = ? where fid = ? and FPERSONNELIDID is null";
            int count = SSCDbUtil.executeUpdate(this.ctx, sql, new Object[]{job.getPersonnelID().getId().toString(), job.getId().toString()});
            if (count != 0) {
                JobFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)job);
                String groupId = this.getGroupIdByUserId(job.getPersonnelID().getId().toString());
                sql = "update t_ssc_jobext set FGroupId = ? where fjobId = ?";
                SSCDbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{groupId, job.getId().toString()});
                this.updateWorkPressure(job);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u66f4\u65b0\u5904\u7406\u4eba\u5931\u8d25\uff01", (Throwable)e);
        }
        return false;
    }

    public JobInfo setAssignUser(JobInfo job, UserInfo user) throws Exception {
        job.setPersonnelID(user);
        job.setJobPoolingType(JobPoolingType.Operating);
        if (job.getOldJobState() == OldJobStateEnum.paues) {
            job.setJobState(JobState.Pause);
        } else if (job.getOldJobState() == OldJobStateEnum.rescan) {
            job.setJobState(JobState.ReScan);
        } else if (job.getOldJobState() == OldJobStateEnum.imageReCan) {
            job.setJobState(JobState.REUPLOAD_IMAGE);
        } else {
            job.setJobState(JobState.Normal);
        }
        job.setReceiveTime(new Timestamp(new Date().getTime()));
        BigDecimal timeDuration = this.getTimeByIds(this.ctx, this.bussinessAttributeInfo.getId().toString(), job.getJoblevel().getId().toString(), job.getShareCenterID().getId().toString());
        job.setRemainderTime(timeDuration);
        job.setIsExpired(false);
        job.setExpireState(JobExpireState.Normal);
        return job;
    }

    public String getGroupIdByUserId(String userId) {
        try {
            if (UserGroupFactory.getLocalInstance(this.ctx).exists("where user.id='" + userId + "'")) {
                UserGroupInfo userGroupInfo = UserGroupFactory.getLocalInstance(this.ctx).getUserGroupInfo("where user.id='" + userId + "'");
                String groupId = userGroupInfo.getGroup().getId().toString();
                return groupId;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6groupId\u5931\u8d25\uff01userId\uff1a" + userId), (Throwable)e);
        }
        return "";
    }

    public UserInfo getAssignUser(JobInfo job, UserInfo user) throws Exception {
        UserInfo info;
        String jobID = job.getId().toString();
        String position = this.id + "**jobInfo :{" + jobID + "@@" + job.getSubject() + "}";
        List<String> userIds = AssignJobThreadEx.getAssignUser(this.ctx, job);
        if (null != userIds) {
            userIds = JobUtils.user2sscUser(this.ctx, userIds);
            if (null != user) {
                if (userIds.contains(user.getId().toString())) {
                    return user;
                }
                return null;
            }
            return JobUtils.getPackageAssignUser(this.ctx, job, userIds, null, null, null);
        }
        if (JobUtils.isCallbackToOriginalPerso(this.ctx, job.getShareCenterID().getId().toString()) && null != (info = JobUtils.handleRejectedJob(this.ctx, job))) {
            if (!SSCUtil.checkPermission(this.ctx, info, job)) {
                SSCUtil.genAndAllotCompelRole(this.ctx, job.getBussAttrID().getId().toString(), info.getId().toString(), info.getShareCenterId(), false);
                logger.info((Object)(info.getId().toString() + "\u5206\u914d" + job.getBussAttrID().getId().toString() + "\u6743\u9650\u6210\u529f"));
            }
            return info;
        }
        Map<String, Object> map = this.getCustomerAssignUser(this.ctx, job, user);
        UserInfo assignUser = (UserInfo)map.get("assignUser");
        boolean matchRule = (Boolean)map.get("matchRule");
        JobExtInfo jobExtInfo = JobExtFactory.getLocalInstance(this.ctx).getJobExtInfo("where job.id = '" + job.getId().toString() + "'");
        if (assignUser != null) {
            if (null != assignUser.getId()) {
                logger.info((Object)(position + "\u7b26\u5408\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219.****assignUser****" + assignUser.getNumber() + ",userId:" + assignUser.getId()));
                jobExtInfo.setAssignFailReason(position + "\u7b26\u5408\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219.\u4f46\u662fassignUser.getId()\u662f\u7a7a");
                JobExtFactory.getLocalInstance(this.ctx).update(H.PK(job.getId()), jobExtInfo);
                return assignUser;
            }
            logger.info((Object)(position + "\u7b26\u5408\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219.\u4f46\u662fassignUser.getId()\u662f\u7a7a,\u7ed3\u675f\u5206\u914d\u5e76\u629b\u51fa\u5f02\u5e38"));
            throw new Exception(position + "\u4efb\u52a1\u5206\u914d\u5931\u8d25\u3002\u81ea\u5b9a\u4e49\u89c4\u5219\u914d\u7f6e\u6709\u8bef\uff0c\u627e\u4e0d\u5230\u7b26\u5408\u8be5\u89c4\u5219\u7684\u4e1a\u52a1\u5458\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002");
        }
        if (matchRule) {
            jobExtInfo.setAssignFailReason("\u7b26\u5408\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219,\u4f46\u6ca1\u6709\u53ef\u5206\u914d\u7684\u4eba");
            JobExtFactory.getLocalInstance(this.ctx).update(H.PK(job.getId()), jobExtInfo);
            logger.info((Object)(position + "\u7b26\u5408\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219.\u4f46\u662f\u5e76\u6ca1\u6709\u53ef\u5206\u914d\u7684\u4eba\u5458.\u4e0d\u5c1d\u8bd5\u9ed8\u8ba4\u5206\u914d\u89c4\u5219\u4e86.\u5206\u914d\u5931\u8d25!"));
            return null;
        }
        assignUser = this.defaultAssignJob(this.ctx, job, user);
        if (assignUser != null) {
            if (null != assignUser.getId()) {
                logger.info((Object)(position + "\u7b26\u5408\u9ed8\u8ba4\u5206\u914d\u89c4\u5219.****assignUser****" + assignUser.getNumber() + ",userId:" + assignUser.getId()));
                return assignUser;
            }
            jobExtInfo.setAssignFailReason("\u8bf7\u68c0\u67e5\u7528\u6237\u662f\u5426\u88ab\u7981\u7528\u6216\u6682\u505c\u5206\u914d");
            JobExtFactory.getLocalInstance(this.ctx).update(H.PK(job.getId()), jobExtInfo);
            throw new Exception(position + "\u4efb\u52a1\u5206\u914d\u5931\u8d25\u3002\u8bf7\u68c0\u67e5\u7528\u6237\u662f\u5426\u88ab\u7981\u7528\u6216\u6682\u505c\u5206\u914d\u3002");
        }
        jobExtInfo.setAssignFailReason("\u65e0\u7b26\u5408\u4eba\u5458");
        JobExtFactory.getLocalInstance(this.ctx).update(H.PK(job.getId()), jobExtInfo);
        logger.info((Object)(position + "\u6253\u56de\u4efb\u52a1,\u81ea\u5b9a\u4e49\u89c4\u5219,\u9ed8\u8ba4\u5206\u914d,\u90fd\u6ca1\u627e\u5230\u4eba,\u8fd9\u5c31\u5f88\u5c34\u5c2c\u4e86.\u8fd4\u56de\u7a7a!!!"));
        return assignUser;
    }

    private Map<String, Object> getCustomerAssignUser(Context ctx, JobInfo job, UserInfo user) throws BOSException, Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("matchRule", false);
        map.put("assignUser", null);
        String position = this.id + "**jobInfo :{" + job.getId() + "@@" + job.getSubject() + "},\u5904\u7406\u81ea\u5b9a\u4e49\u89c4\u5219\u903b\u8f91**";
        UserInfo assignUser = null;
        AssignRuleCollection assignRuleCollection = this.getCustomerAssignRule(job);
        logger.error((Object)(position + "\u67e5\u8be2\u5f97\u5230assignRuleCollection.size()" + (assignRuleCollection == null ? "null" : Integer.valueOf(assignRuleCollection.size()))));
        if (assignRuleCollection != null && assignRuleCollection.size() > 0) {
            DynamicValueCollection dynamicValueCollection = JobUtils.getCustomerAssignRuleColumn(ctx, job.getId().toString());
            for (int j = 0; j < assignRuleCollection.size(); ++j) {
                AssignRuleInfo assignRuleInfo = assignRuleCollection.get(j);
                if (!JobUtils.isAssignRuleMatchNew(ctx, assignRuleInfo, dynamicValueCollection, job)) continue;
                map.put("matchRule", true);
                assignUser = this.getUserMatchOrg(ctx, job, assignRuleInfo, assignRuleCollection, user);
                if (assignUser != null) {
                    logger.error((Object)(position + "assignRuleInfo:" + assignRuleInfo.getNumber() + "\u5339\u914d\u6210\u529f,\u8fd4\u56de\u7528\u6237,assignUser,number:" + assignUser.getNumber() + "id:" + assignUser.getId()));
                    map.put("assignUser", assignUser);
                    return map;
                }
                return map;
            }
        }
        logger.error((Object)(position + "\u8fd4\u56de\u7a7a!!!!!"));
        return map;
    }

    private UserInfo defaultAssignJob(Context ctx, JobInfo job, UserInfo user) throws Exception {
        int i;
        ArrayList<String> ruleUserIds = new ArrayList<String>();
        ArrayList<String> ruleRoleIds = new ArrayList<String>();
        AssignRuleCollection assignRuleCollection = this.getCustomerAssignRule(job);
        if (assignRuleCollection != null && assignRuleCollection.size() > 0) {
            for (int j = 0; j < assignRuleCollection.size(); ++j) {
                AssignRuleInfo assignRuleInfo = assignRuleCollection.get(j);
                if (assignRuleInfo.isIsExclusive() && null != assignRuleInfo.getUser()) {
                    ruleUserIds.add(assignRuleInfo.getUser().getId().toString());
                    continue;
                }
                if (!assignRuleInfo.isIsExclusive() || null == assignRuleInfo.getRoles()) continue;
                String[] roles = assignRuleInfo.getRoles().split(",");
                for (i = 0; i < roles.length; ++i) {
                    ruleRoleIds.add(roles[i]);
                }
            }
        }
        List<String> defaultUserIds = JobUtils.getPermissionUserIdsExcludeRule(ctx, job, ruleRoleIds, ruleUserIds);
        List<Object> userIds = new ArrayList();
        if (user != null) {
            String userId = user.getId().toString();
            userIds = JobUtils.getAllConsignerIDs(ctx, job.getBussAttrID().getId().toString(), userId);
            for (i = 0; i < userIds.size(); ++i) {
                if (defaultUserIds.contains(userIds.get(i))) continue;
                defaultUserIds.add((String)userIds.get(i));
            }
        }
        logger.error((Object)(job.getSubject() + ",\u9ed8\u8ba4\u5206\u914d\u7684\u4eba\u5458ID\uff1a" + defaultUserIds));
        return JobUtils.getPackageAssignUser(ctx, job, defaultUserIds, null, null, user);
    }

    private UserInfo getUserMatchOrg(Context ctx, JobInfo job, AssignRuleInfo assignRuleInfo, AssignRuleCollection assignRuleCollection, UserInfo user) throws Exception {
        UserInfo assignUser;
        List<String> userIds = AssignJobThreadEx.getAssignUser(ctx, job, assignRuleInfo);
        if (null != userIds) {
            userIds = JobUtils.user2sscUser(ctx, userIds);
            if (null != user) {
                if (userIds.contains(user.getId().toString())) {
                    return user;
                }
                return null;
            }
            return JobUtils.getPackageAssignUser(ctx, job, userIds, assignRuleInfo, assignRuleCollection, null);
        }
        String bussAttrId = job.getBussAttrID().getId().toString();
        String orgId = job.getOrgID().getId().toString();
        if (null == userIds) {
            userIds = new ArrayList<String>();
        }
        if ((assignUser = assignRuleInfo.getUser()) != null) {
            userIds.add(assignUser.getId().toString());
        }
        if (!userIds.isEmpty()) {
            return JobUtils.getLeastTaskPermissionUser(ctx, job, bussAttrId, null, userIds, orgId, assignRuleInfo, assignRuleCollection, user);
        }
        if (assignRuleInfo.getRoles() != null) {
            ArrayList<String> roleIdList = new ArrayList<String>();
            String[] roles = assignRuleInfo.getRoles().split(",");
            for (int i = 0; i < roles.length; ++i) {
                roleIdList.add(roles[i]);
            }
            UserInfo userInfo = JobUtils.getLeastTaskPermissionUser(ctx, job, bussAttrId, roleIdList, null, orgId, assignRuleInfo, assignRuleCollection, user);
            if (null == userInfo && JobUtils.isExistsOrgPermission(ctx, bussAttrId, roleIdList, orgId)) {
                userInfo = new UserInfo();
            }
            return userInfo;
        }
        return null;
    }

    public void jobStateTime(Context ctx, List<JobBean> jobBeanList, UserInfo userInfo, Operation op) throws Exception {
        try {
            if (jobBeanList != null && jobBeanList.size() > 0) {
                JobBean jobBean = null;
                CoreBaseCollection jobstatetimeList = new CoreBaseCollection();
                for (int i = 0; i < jobBeanList.size(); ++i) {
                    jobBean = jobBeanList.get(i);
                    if (jobBean == null) continue;
                    JobStateTimeInfo jobstatetime = new JobStateTimeInfo();
                    jobstatetime.setJobID(jobBean.getJobInfo());
                    jobstatetime.setNewJobState(jobBean.getJobState());
                    jobstatetime.setOldJobState(jobBean.getJobState());
                    jobstatetime.setChangeTime(new Timestamp(new Date().getTime()));
                    if (userInfo != null) {
                        jobstatetime.setOperatorID(userInfo);
                    }
                    jobstatetime.setOperation(op == null ? Operation.AutoAssign : op);
                    jobstatetime.setBussAttr(jobBean.getJobInfo().getBussAttrID());
                    jobstatetimeList.add((CoreBaseInfo)jobstatetime);
                }
                JobStateTimeFactory.getLocalInstance(ctx).addnew(jobstatetimeList);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new Exception(ex);
        }
    }

    public void sendTask(List<JobBean> jobBeanList) throws Exception {
        if (jobBeanList != null && jobBeanList.size() > 0) {
            JobBean job = null;
            JobInfo jobInfo = null;
            for (int i = 0; i < jobBeanList.size(); ++i) {
                job = jobBeanList.get(i);
                if (job == null || (jobInfo = job.getJobInfo()) == null) continue;
                String FassignId = jobInfo.getAssignId();
                String solution = jobInfo.getSolution();
                String dataCenter = jobInfo.getDataCenter();
                String useID = job.getUserId();
                logger.debug((Object)("transfer interface send--" + FassignId + "--" + solution + "--" + dataCenter + "--" + useID));
                TransferFlowSend transferFlowSend = new TransferFlowSend();
                boolean sendOk = true;
                try {
                    sendOk = transferFlowSend.sendTask(this.ctx, jobInfo, solution, dataCenter, FassignId, useID);
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                if (!sendOk) {
                    logger.error((Object)("transfer interface not send--" + FassignId + "--" + solution + "--" + dataCenter + "--" + useID));
                }
                logger.debug((Object)"transfer interface end-----------");
            }
        }
    }

    private BigDecimal getTimeByIds(Context ctx, String BussinessAttributeId, String jobLevelId, String shareCenterID) throws Exception {
        shareCenterID = shareCenterID == null ? "" : shareCenterID;
        BigDecimal value = new BigDecimal(48);
        BussinessAttributeEntryInfo entryInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)BussinessAttributeId));
        filter.getFilterItems().add(new FilterItemInfo("jobLevelName.id", (Object)jobLevelId));
        view.setFilter(filter);
        SelectorItemCollection selectors = new SelectorItemCollection();
        view.setSelector(selectors);
        BussinessAttributeEntryCollection attCollection = BussinessAttributeEntryFactory.getLocalInstance(ctx).getBussinessAttributeEntryCollection(view);
        if (attCollection != null) {
            if (attCollection.size() == 1) {
                entryInfo = attCollection.get(0);
                value = entryInfo.getTaskDuration();
            } else if (attCollection.size() > 1) {
                entryInfo = attCollection.get(0);
                value = entryInfo.getTaskDuration();
                int size = attCollection.size();
                for (int i = 0; i < size; ++i) {
                    entryInfo = attCollection.get(i);
                    if (!shareCenterID.equals(entryInfo.getShareCenterId())) continue;
                    value = entryInfo.getTaskDuration();
                    break;
                }
            }
        }
        return value;
    }

    private AssignRuleCollection getCustomerAssignRule(JobInfo job) throws SSCException {
        String busID = job.getBussAttrID().getId().toString();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bussAttr", (Object)busID));
        filter.getFilterItems().add(new FilterItemInfo("shareCenterID", this.shareCenterInfo.get("id")));
        String topShareCenterID = "";
        try {
            topShareCenterID = ShareCenterUtils.getTopShareCenter(this.ctx).get("id") + "";
        }
        catch (BOSException e1) {
            logger.error((Object)("find top shareCenterInfo exception!" + (Object)((Object)e1)));
        }
        filter.getFilterItems().add(new FilterItemInfo("shareCenterID", (Object)topShareCenterID));
        filter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)new Boolean(true)));
        filter.setMaskString("#0 and (#1 or #2) and #3");
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("user.*");
        selector.add("role.*");
        selector.add("bussAttr.*");
        selector.add("entry.*");
        entityViewInfo.setSelector(selector);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(new SorterItemInfo("priority"));
        entityViewInfo.setSorter(sorterItemCollection);
        try {
            return AssignRuleFactory.getLocalInstance(this.ctx).getAssignRuleCollection(entityViewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)"\u67e5\u8be2\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    private void updateWorkPressure(JobInfo job) {
        try {
            if (EqualDivisionUtils.isEqualDivision(this.ctx, job.getShareCenterID().getId().toString())) {
                BigDecimal workpress;
                BigDecimal approvecoe;
                String personId;
                if (null != job.getConsigner() && StringUtils.isNotBlank((String)job.getConsigner().getId().toString())) {
                    personId = this.shareCenterId + job.getConsigner().getId().toString();
                    if (AssignJobFacadeControllerBean.userMap.get(personId) == null) {
                        WorkPressureFactory.getLocalInstance(this.ctx).init();
                        if (AssignJobFacadeControllerBean.userMap.get(personId) == null) {
                            logger.error((Object)("current user WorkPressure is null Consigner:" + personId));
                            return;
                        }
                    }
                    approvecoe = AssignJobFacadeControllerBean.userMap.get(personId).getApproveCoe() == null ? new BigDecimal(1) : AssignJobFacadeControllerBean.userMap.get(personId).getApproveCoe();
                    workpress = job.getStandardCoe().divide(approvecoe, 4, 4);
                    WorkPressureFactory.getLocalInstance(this.ctx).add(job.getConsigner().getId().toString(), workpress);
                }
                if (null != job.getPersonnelID() && StringUtils.isNotBlank((String)job.getPersonnelID().getId().toString())) {
                    personId = this.shareCenterId + job.getPersonnelID().getId().toString();
                    if (AssignJobFacadeControllerBean.userMap.get(personId) == null) {
                        WorkPressureFactory.getLocalInstance(this.ctx).init();
                        if (AssignJobFacadeControllerBean.userMap.get(personId) == null) {
                            logger.error((Object)("current user WorkPressure is null Personnel:" + personId));
                            return;
                        }
                    }
                    approvecoe = AssignJobFacadeControllerBean.userMap.get(personId).getApproveCoe() == null ? new BigDecimal(1) : AssignJobFacadeControllerBean.userMap.get(personId).getApproveCoe();
                    workpress = job.getStandardCoe().divide(approvecoe, 4, 4);
                    WorkPressureFactory.getLocalInstance(this.ctx).add(job.getPersonnelID().getId().toString(), workpress);
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"\u66f4\u65b0\u5de5\u4f5c\u538b\u529b\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"\u66f4\u65b0\u5de5\u4f5c\u538b\u529b\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"\u66f4\u65b0\u5de5\u4f5c\u538b\u529b\u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

