/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.BussFunDecisionFactory;
import com.kingdee.eas.base.ssc.BussFunMapFactory;
import com.kingdee.eas.base.ssc.BussFunMapInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeCollection;
import com.kingdee.eas.base.ssc.BussinessAttributeEntryCollection;
import com.kingdee.eas.base.ssc.BussinessAttributeEntryInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeExtCollection;
import com.kingdee.eas.base.ssc.BussinessAttributeExtFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeExtInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.JobLevelCollection;
import com.kingdee.eas.base.ssc.JobLevelFactory;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.AbstractBussinessAttributeControllerBean;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class BussinessAttributeControllerBean
extends AbstractBussinessAttributeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.BussinessAttributeControllerBean");
    private final Set defaultBussAttrId = new HashSet(){
        {
            this.add("AP_OtherBill");
            this.add("AP_PaymentbillAudit");
            this.add("AP_PaymentbillPay");
            this.add("AP_PayRequestBill");
            this.add("AR_ReceivingBillAudit");
            this.add("AR_ReceivingBillRec");
            this.add("AR_InvoiceBill");
            this.add("CAS_PaymentbillAudit");
            this.add("CAS_PaymentbillPay");
            this.add("CAS_ReceivingBillAudit");
            this.add("CAS_ReceivingBillRec");
            this.add("ER_clbx");
            this.add("ER_fybx");
        }
    };

    @Override
    protected String _getBillTypeFilterItems(Context ctx, String shareCenterId) throws BOSException, EASDBException {
        StringBuffer sb = new StringBuffer();
        UserInfo userInfo = null;
        try {
            userInfo = ShareCenterUtils.getSSCUserInfoByCtx(ctx);
        }
        catch (SSCException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        if (ShareCenterUtils.isCurrentUserSSCAdmin(ctx, userInfo)) {
            sb.append(" select bt.fid id,bt.fname_l2 name ");
            sb.append(" from t_ssc_billtype bt ");
            sb.append(" inner join T_SSC_SystemAttribute sa on sa.fid=bt.fsysattrid ");
        } else {
            sb.append("select bt.fid id,bt.fname_l2 name from t_ssc_billtype bt").append(" where bt.fid in (select sb.fid ").append(" FROM T_SSC_SysAttrOrgSCMap AS SA ").append(" INNER JOIN t_org_sharecenterorgunit AS OS ").append(" ON sa.fsharecenterid = os.fid ").append(" INNER JOIN t_ssc_org AS ORG ").append(" ON sa.forgid = org.fid ").append(" INNER JOIN t_ssc_systemAttribute AS SS ").append(" ON ss.FID = sa.fsystemattributeid ").append(" INNER JOIN t_ssc_billtype AS SB ").append(" ON ss.fid = sb.FSysAttrID ").append(" WHERE os.fnumber = '" + shareCenterId + "') ");
        }
        ArrayList list = new ArrayList();
        HashMap<String, String> map = null;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rowSet.next()) {
                map = new HashMap<String, String>();
                map.put("value", rowSet.getString("id"));
                map.put("name", rowSet.getString("name"));
                list.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, list);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, (IObjectValue)((DataBaseInfo)model));
        BussinessAttributeInfo info = (BussinessAttributeInfo)model;
        info.setIsAutoAssign(!info.getAutoAssignType().getValue().equals("0"));
        this.checkJobLevel(ctx, info);
        UserInfo userInfo = ShareCenterUtils.getSSCUserInfoByCtx(ctx);
        String shareCenterId = userInfo.getShareCenterId();
        if (info.getShareCenterId() != null) {
            shareCenterId = info.getShareCenterId();
        }
        info.setShareCenterId(shareCenterId);
        BussinessAttributeEntryCollection bEntryColl = info.getEntry();
        for (int i = 0; i < bEntryColl.size(); ++i) {
            bEntryColl.get(i).setShareCenterId(shareCenterId);
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        CoreBaseCollection colls = this._getDefaultBussFunMapCollection(ctx, pk.toString());
        BussFunMapFactory.getLocalInstance(ctx).addnewBatchData(colls);
        return pk;
    }

    private CoreBaseCollection _getDefaultBussFunMapCollection(Context ctx, String bssAttrId) throws EASBizException, BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        BussFunMapInfo pass = new BussFunMapInfo();
        BussFunMapInfo unpass = new BussFunMapInfo();
        BussFunMapInfo callback = new BussFunMapInfo();
        BussFunMapInfo viewvoucher = new BussFunMapInfo();
        BussFunMapInfo transmit = new BussFunMapInfo();
        pass.put("functionId", "mgmqNfqKQy2MCtAq5/LvptBa4Sw=");
        unpass.put("functionId", "Uil0VQRsRTeYxDG9c2+OftBa4Sw=");
        callback.put("functionId", "WLqbEfjRTa23Z92X5G8cPdBa4Sw=");
        viewvoucher.put("functionId", "Y/tBODzTAfbgUzA/qMDHitBa4Sw=");
        transmit.put("functionId", "9U1DVa77VUSOgr0S2mkeJdBa4Sw=");
        transmit.put("bussinessAttrId", bssAttrId);
        transmit.setDisabled(true);
        pass.put("bussinessAttrId", bssAttrId);
        unpass.put("bussinessAttrId", bssAttrId);
        callback.put("bussinessAttrId", bssAttrId);
        viewvoucher.put("bussinessAttrId", bssAttrId);
        viewvoucher.setDisabled(true);
        BussFunMapInfo rescan = new BussFunMapInfo();
        rescan.put("functionId", "KoPuX/wLbUC41+ZsX2frxtBa4Sw=");
        rescan.put("bussinessAttrId", bssAttrId);
        rescan.setDisabled(false);
        BussFunMapInfo unrescan = new BussFunMapInfo();
        unrescan.put("functionId", "PD+hSTd7yUCpDMFQOFeYxNBa4Sw=");
        unrescan.put("bussinessAttrId", bssAttrId);
        unrescan.setDisabled(true);
        BussinessAttributeInfo info = BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeInfo(H.PK(bssAttrId));
        if (info.getJobClassification().getValue() == 2 || info.getJobClassification().getValue() == 4) {
            unrescan.setDisabled(false);
            rescan.setDisabled(true);
        }
        if (info.getJobClassification().getValue() == 2) {
            viewvoucher.setDisabled(false);
        }
        BussFunMapInfo coupletimage = new BussFunMapInfo();
        coupletimage.put("functionId", "T4zUpxrzNkiLfIDnRWN5fdBa4Sw=");
        coupletimage.put("bussinessAttrId", bssAttrId);
        coupletimage.setDisabled(true);
        BussFunMapInfo viewattachment = new BussFunMapInfo();
        viewattachment.put("functionId", "ooTBWkjyTUSw7DO+HrlK/tBa4Sw=");
        viewattachment.put("bussinessAttrId", bssAttrId);
        viewattachment.setDisabled(true);
        BussFunMapInfo deal = new BussFunMapInfo();
        deal.put("functionId", "aVpBA1gBeky5ngMV07PR5tBa4Sw=");
        deal.put("bussinessAttrId", bssAttrId);
        deal.setDisabled(false);
        BussFunMapInfo batchDeal = new BussFunMapInfo();
        batchDeal.put("functionId", "Ot5wLcv09E+InqXGtp7lotBa4Sw=");
        batchDeal.put("bussinessAttrId", bssAttrId);
        batchDeal.setDisabled(true);
        BussFunMapInfo backRescan = new BussFunMapInfo();
        backRescan.put("functionId", "lo0aF4HKFEOfCKTqAm3QatBa4Sw=");
        backRescan.put("bussinessAttrId", bssAttrId);
        backRescan.setDisabled(false);
        colls.add((CoreBaseInfo)rescan);
        colls.add((CoreBaseInfo)unrescan);
        colls.add((CoreBaseInfo)coupletimage);
        colls.add((CoreBaseInfo)pass);
        colls.add((CoreBaseInfo)unpass);
        colls.add((CoreBaseInfo)callback);
        colls.add((CoreBaseInfo)viewvoucher);
        colls.add((CoreBaseInfo)transmit);
        colls.add((CoreBaseInfo)viewattachment);
        colls.add((CoreBaseInfo)deal);
        colls.add((CoreBaseInfo)batchDeal);
        colls.add((CoreBaseInfo)backRescan);
        return colls;
    }

    private void checkJobLevel(Context ctx, BussinessAttributeInfo info) throws BOSException {
        JobLevelCollection jobLevelCollection = JobLevelFactory.getLocalInstance(ctx).getJobLevelCollection("select id");
        BussinessAttributeEntryCollection entry = info.getEntry();
        ArrayList<String> list = new ArrayList<String>(jobLevelCollection.size());
        for (int i = 0; i < jobLevelCollection.size(); ++i) {
            list.add(jobLevelCollection.get(i).getId().toString());
        }
        for (int j = 0; j < entry.size(); ++j) {
            if (list.indexOf(entry.get(j).getJobLevelName().getId().toString()) >= 0) continue;
            entry.removeObject(j);
            --j;
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BussinessAttributeInfo info = (BussinessAttributeInfo)model;
        this.checkJobLevel(ctx, info);
        UserInfo userInfo = ShareCenterUtils.getSSCUserInfoByCtx(ctx);
        if (ShareCenterUtils.isCurrentUserSSCAdmin(ctx, userInfo)) {
            this._checkNumberDup(ctx, (IObjectValue)((DataBaseInfo)model));
            this._updateData(ctx, pk, info);
        } else if (!ShareCenterUtils.isCurrentUserSSCAdmin(ctx, userInfo) && ShareCenterUtils.isTopShareCenter(ctx, info.getShareCenterId()).booleanValue()) {
            if (!ShareCenterUtils.isCurrentUserSSCAdmin(ctx, userInfo)) {
                BussinessAttributeExtInfo beInfo;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bussId", (Object)pk.toString()));
                filter.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)ShareCenterUtils.getShareCenterIdByCtx(ctx)));
                view.setFilter(filter);
                BussinessAttributeExtCollection beColl = BussinessAttributeExtFactory.getLocalInstance(ctx).getBussinessAttributeExtCollection(view);
                if (beColl.size() > 0) {
                    beInfo = beColl.get(0);
                    beInfo.setStandardCoe(info.getStandardCoe());
                    beInfo.setStandardEfficiency(info.getStandardEfficiency());
                    beInfo.setCaType(info.getCaType());
                    beInfo.setIsAutoAssign(!info.getAutoAssignType().getValue().equals("0"));
                    beInfo.setIsOpenImage(info.isIsOpenImage());
                    beInfo.setIsOpenPreImage(info.isIsOpenPreImage());
                    beInfo.setPreBussAttr(info.getPreBussAttr());
                    beInfo.setIsCanUpdateBill(info.isIsCanUpdateBill());
                    beInfo.setIsShowBillToolBar(info.isIsShowBillToolBar());
                    beInfo.setIsNotAllowDeal(info.isIsNotAllowDeal());
                    beInfo.setIsNotNeedPhotoWithAssign(info.isIsNotNeedPhotoWithAssign());
                    beInfo.setIsSmartWorkMode(info.isIsSmartWorkMode());
                    beInfo.setIsDisplayBillInfo(info.isIsDisplayBillInfo());
                    beInfo.setCurBusUipk(info.getCurBusUipk());
                    beInfo.setCurAdminUipk(info.getCurAdminUipk());
                    beInfo.setHisBusUipk(info.getHisBusUipk());
                    beInfo.setHisAdminUipk(info.getHisAdminUipk());
                    beInfo.setBaseBillPro(info.getBaseBillPro());
                    beInfo.setBaseBillEdit(info.getBaseBillEdit());
                    beInfo.setBaseBillState(info.getBaseBillState());
                    beInfo.setShareCenterId(userInfo.getShareCenterId());
                    info.setId(BOSUuid.read((String)pk.toString()));
                    beInfo.setBussId(info);
                    beInfo.setAutoAssignType(info.getAutoAssignType());
                    beInfo.setCustomAssignTime(info.getCustomAssignTime());
                    BussinessAttributeExtFactory.getLocalInstance(ctx).update(H.PK(beInfo.getId()), beInfo);
                } else {
                    beInfo = new BussinessAttributeExtInfo();
                    beInfo.setStandardCoe(info.getStandardCoe());
                    beInfo.setStandardEfficiency(info.getStandardEfficiency());
                    beInfo.setCaType(info.getCaType());
                    beInfo.setIsAutoAssign(!info.getAutoAssignType().getValue().equals("0"));
                    beInfo.setIsOpenImage(info.isIsOpenImage());
                    beInfo.setIsOpenPreImage(info.isIsOpenPreImage());
                    beInfo.setIsCanUpdateBill(info.isIsCanUpdateBill());
                    beInfo.setIsShowBillToolBar(info.isIsShowBillToolBar());
                    beInfo.setPreBussAttr(info.getPreBussAttr());
                    beInfo.setIsNotAllowDeal(info.isIsNotAllowDeal());
                    beInfo.setIsNotNeedPhotoWithAssign(info.isIsNotNeedPhotoWithAssign());
                    beInfo.setIsSmartWorkMode(info.isIsSmartWorkMode());
                    beInfo.setIsDisplayBillInfo(info.isIsDisplayBillInfo());
                    beInfo.setCurBusUipk(info.getCurBusUipk());
                    beInfo.setCurAdminUipk(info.getCurAdminUipk());
                    beInfo.setHisBusUipk(info.getHisBusUipk());
                    beInfo.setHisAdminUipk(info.getHisAdminUipk());
                    beInfo.setBaseBillPro(info.getBaseBillPro());
                    beInfo.setBaseBillEdit(info.getBaseBillEdit());
                    beInfo.setBaseBillState(info.getBaseBillState());
                    beInfo.setShareCenterId(userInfo.getShareCenterId());
                    beInfo.setShareCenterId(userInfo.getShareCenterId());
                    info.setId(BOSUuid.read((String)pk.toString()));
                    beInfo.setBussId(info);
                    beInfo.setAutoAssignType(info.getAutoAssignType());
                    beInfo.setCustomAssignTime(info.getCustomAssignTime());
                    BussinessAttributeExtFactory.getLocalInstance(ctx).addnew(beInfo);
                }
                String delSql = "delete from T_SSC_BussinessAttributeentry where fparentid='" + pk.toString() + "'";
                DbUtil.execute((Context)ctx, (String)delSql);
                BussinessAttributeEntryCollection bEntryColl = info.getEntry();
                for (int i = 0; i < bEntryColl.size(); ++i) {
                    StringBuffer sb = new StringBuffer();
                    BussinessAttributeEntryInfo entryInfo = bEntryColl.get(i);
                    sb.append(" insert into T_SSC_BussinessAttributeEntry (fid,fparentid,fjoblevelnameid,fjoblevelid,ftaskduration,flevelnumber) ");
                    sb.append(" values('" + BOSUuid.create((String)"3B500013") + "','" + pk.toString() + "','" + entryInfo.getJobLevelName().getId().toString() + "','" + entryInfo.getJobLevelName().getId().toString() + "'," + entryInfo.getTaskDuration() + "," + entryInfo.getLevelNumber() + ") ");
                    DbUtil.execute((Context)ctx, (String)sb.toString());
                }
            }
        } else {
            this._checkNumberDup(ctx, (IObjectValue)((DataBaseInfo)model));
            info.setIsAutoAssign(!info.getAutoAssignType().getValue().equals("0"));
            super._update(ctx, pk, (IObjectValue)info);
        }
    }

    private void _updateData(Context ctx, IObjectPK pk, BussinessAttributeInfo info) throws EASBizException, BOSException {
        info.setIsAutoAssign(!info.getAutoAssignType().getValue().equals("0"));
        super.innerUpdate(ctx, pk, (IObjectValue)info);
        String del = " delete from T_SSC_BussinessAttributeEntry where fparentid='" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)del);
        BussinessAttributeEntryCollection entry = info.getEntry();
        for (int i = 0; i < entry.size(); ++i) {
            StringBuffer sb = new StringBuffer();
            BussinessAttributeEntryInfo entryInfoCopy = new BussinessAttributeEntryInfo();
            BussinessAttributeEntryInfo entryInfo = entry.get(i);
            sb.append(" insert into T_SSC_BussinessAttributeEntry (fid,fparentid,fjoblevelnameid,fjoblevelid,ftaskduration,flevelnumber) ");
            sb.append(" values('" + BOSUuid.create((String)"3B500013") + "','" + pk.toString() + "','" + entryInfo.getJobLevelName().getId().toString() + "','" + entryInfo.getJobLevelName().getId().toString() + "'," + entryInfo.getTaskDuration() + "," + entryInfo.getLevelNumber() + ") ");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    private String getStringNotNull(String str) {
        if ("".equals(str) || str == null) {
            return "";
        }
        return str;
    }

    private boolean isOnlyUpdateStander(BussinessAttributeInfo oldInfo, BussinessAttributeInfo newInfo) {
        boolean flag = oldInfo.getNumber().equals(newInfo.getNumber()) && oldInfo.getName().equals(newInfo.getName()) && oldInfo.getBillType().getId().equals((Object)newInfo.getBillType().getId()) && oldInfo.getSystemAttribute().getId().equals(newInfo.getSystemAttribute().getIdentity()) && oldInfo.getUrl() == newInfo.getUrl() && oldInfo.getDescription().equals(newInfo.getDescription());
        return flag;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BussinessAttributeInfo info = (BussinessAttributeInfo)BussinessAttributeFactory.getLocalInstance(ctx).getValue(pk);
        if (info.getDataSrc() != null && "shr".equalsIgnoreCase(info.getDataSrc().getValue())) {
            throw new EASBizException(new NumericExceptionSubItem("", "s-HR\u9884\u7f6e\u4efb\u52a1\u7c7b\u578b\u548c\u63a5\u53e3\u521b\u5efa\u7684\u4efb\u52a1\u7c7b\u578b\u4e0d\u5141\u8bb8\u5220\u9664!"));
        }
        BussFunDecisionFactory.getLocalInstance(ctx).delete("where bussAttrid='" + pk.toString() + "'");
        BussFunMapFactory.getLocalInstance(ctx).delete("where bussinessAttrId='" + pk.toString() + "'");
        if (ShareCenterUtils.getShareCenterIdByCtx(ctx).equals(info.getShareCenterId())) {
            String sql = "select fid from t_ssc_rolebussattr  where fbussnameID='" + info.getId().toString() + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rs.next()) {
                    throw new EASBizException(new NumericExceptionSubItem("", "\u6570\u636e\u5df2\u88ab\u5f15\u7528,\u4e0d\u80fd\u5220\u9664\uff01"));
                }
                super._delete(ctx, pk);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            throw new SSCException(SSCException.SSC_BASEDATE_DELETE, new Object[]{info});
        }
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> pkSet = new HashSet<String>();
        for (int i = 0; i > pkArray.length; ++i) {
            pkSet.add("'" + pkArray[i] + "'");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", pkSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        view.setFilter(filter);
        view.setSelector(sic);
        BussinessAttributeCollection bac = BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeCollection(view);
        BussinessAttributeInfo attrInfo = null;
        for (int i = 0; i > bac.size(); ++i) {
            attrInfo = bac.get(i);
            if (attrInfo.getDataSrc() != null && "shr".equalsIgnoreCase(attrInfo.getDataSrc().getValue())) {
                throw new EASBizException(new NumericExceptionSubItem("", "s-HR\u9884\u7f6e\u4efb\u52a1\u7c7b\u578b\u548c\u63a5\u53e3\u521b\u5efa\u7684\u4efb\u52a1\u7c7b\u578b\u4e0d\u5141\u8bb8\u5220\u9664![" + attrInfo.getNumber() + "]"));
            }
            if (!this._isDefault(ctx, attrInfo.getNumber())) continue;
            throw new SSCException(SSCException.DEFAULTNOTDELETE, new Object[]{attrInfo.getNumber()});
        }
        super._deleteBatchData(ctx, pkArray);
    }

    @Override
    protected boolean _isDefault(Context ctx, String number) throws BOSException, EASBizException {
        return this.defaultBussAttrId.contains(number);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " : " + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }
}

