/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.ssc.AssignTypeEnum;
import com.kingdee.eas.base.ssc.BillTypeInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.CheckRangeCollection;
import com.kingdee.eas.base.ssc.CheckRangeInfo;
import com.kingdee.eas.base.ssc.CheckSchemeCheckOrgCollection;
import com.kingdee.eas.base.ssc.CheckSchemeCheckOrgInfo;
import com.kingdee.eas.base.ssc.CheckSchemeCheckPersonCollection;
import com.kingdee.eas.base.ssc.CheckSchemeCheckPersonInfo;
import com.kingdee.eas.base.ssc.CheckSchemeCollection;
import com.kingdee.eas.base.ssc.CheckSchemeFactory;
import com.kingdee.eas.base.ssc.CheckSchemeInfo;
import com.kingdee.eas.base.ssc.CheckSchemeToSampleLibFactory;
import com.kingdee.eas.base.ssc.CheckTypeEnum;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.OrgInfo;
import com.kingdee.eas.base.ssc.RecheckStateEnum;
import com.kingdee.eas.base.ssc.RenderPlanFinishTimeFactory;
import com.kingdee.eas.base.ssc.ReviseStateEnum;
import com.kingdee.eas.base.ssc.SampleLibraryFacadeFactory;
import com.kingdee.eas.base.ssc.SampleLibraryInfo;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskFacadeFactory;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskInfo;
import com.kingdee.eas.base.ssc.SampleStateEnum;
import com.kingdee.eas.base.ssc.SampleTaskStateEnum;
import com.kingdee.eas.base.ssc.app.AbstractCheckSchemeToSampleLibControllerBean;
import com.kingdee.eas.base.ssc.app.CheckSchemeTimeType;
import com.kingdee.eas.base.ssc.app.checkscheme.CheckRiskFacadeFactory;
import com.kingdee.eas.base.ssc.assign.AssignEngineFacadeFactory;
import com.kingdee.eas.base.ssc.assign.AssignModelCollection;
import com.kingdee.eas.base.ssc.assign.AssignModelFactory;
import com.kingdee.eas.base.ssc.assign.AssignModelInfo;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.SSCBaseBillUtils;
import com.kingdee.eas.base.ssc.tool.SSCCompareUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.log4j.Logger;

public class CheckSchemeToSampleLibControllerBean
extends AbstractCheckSchemeToSampleLibControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.CheckSchemeToSampleLibControllerBean");
    private Integer sqlCount = 0;

    public Integer getSqlCount() {
        return this.sqlCount;
    }

    @Override
    protected IObjectPK _generateSampleLibrary(Context ctx, CheckSchemeInfo checkSchemeInfo) throws BOSException, EASBizException {
        IObjectPK objPk = CheckSchemeToSampleLibFactory.getLocalInstance(ctx).schemeToSampleLibrary(checkSchemeInfo);
        return objPk;
    }

    @Override
    protected IObjectPK _schemeToSampleLibrary(Context ctx, CheckSchemeInfo checkSchemeInfo) throws BOSException, EASBizException {
        try {
            SampleLibraryInfo sample = new SampleLibraryInfo();
            String org = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCurrentAppOUID((IObjectValue)sample);
            try {
                CodingRuleInfo codingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule((IObjectValue)sample, org);
                if (codingRule == null || !codingRule.isIsEnabled()) {
                    throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{"\u6837\u672c\u5e93"});
                }
            }
            catch (Exception e) {
                throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{"\u6837\u672c\u5e93"});
            }
        }
        catch (Exception e) {
            throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{"\u6837\u672c\u5e93"});
        }
        AssignModelCollection modelColls = new AssignModelCollection();
        CoreBaseCollection colls = new CoreBaseCollection();
        AssignModelInfo info = new AssignModelInfo();
        info.setFlowRegisterNumber("DefaultCheckSchemeFlow");
        info.setTaskId(checkSchemeInfo.getId());
        info.setTaskType(checkSchemeInfo.getId().getType().toString());
        info.setDynamicAttributes("schemeInfo", checkSchemeInfo);
        colls.add((CoreBaseInfo)info);
        modelColls.add(info);
        AssignModelFactory.getLocalInstance(ctx).addnew(colls);
        AssignEngineFacadeFactory.getLocalInstance(ctx).execute(modelColls);
        String pk = (String)info.getExtendPropertiesForMap().get("pk");
        return H.PK(pk);
    }

    private Integer getTimesCount(Context ctx, String countSql) {
        String[] strings = (countSql = countSql.toUpperCase()).split("BETWEEN");
        if (strings != null && strings.length > 0) {
            return strings.length - 1;
        }
        return 0;
    }

    @Override
    protected IObjectPK[] _batchGenerateSampleLibrary(Context ctx, CheckSchemeCollection checkSchemeCollection) throws BOSException, EASBizException {
        ObjectUuidPK[] objPks = null;
        if (checkSchemeCollection != null && checkSchemeCollection.size() > 0) {
            objPks = new ObjectUuidPK[checkSchemeCollection.size()];
            for (int i = 0; i < checkSchemeCollection.size(); ++i) {
                objPks[i] = CheckSchemeToSampleLibFactory.getLocalInstance(ctx).generateSampleLibrary(checkSchemeCollection.get(i));
            }
        }
        return objPks;
    }

    @Override
    protected IObjectPK[] _batchGenerateSampleLibrary(Context ctx, String[] checkSchemeIDArray) throws BOSException, EASBizException {
        IObjectPK[] objPks = null;
        if (checkSchemeIDArray != null && checkSchemeIDArray.length > 0) {
            StringBuffer condition = new StringBuffer("(");
            for (int i = 0; i < checkSchemeIDArray.length; ++i) {
                condition.append("'").append(checkSchemeIDArray[i]).append("'");
                if (i >= checkSchemeIDArray.length - 1) continue;
                condition.append(",");
            }
            condition.append(")");
            String language = ctx.getLocale().getLanguage();
            String oql = "select fid,fnumber,fname_" + language + ",fdescription_" + language + ",fcheckcondition,fassigntype,fchecktype,ftimelimit,fbilltypeid,fstatus,fcheckpercent,fcheckqty from t_ssc_checkscheme where fid in " + condition;
            CheckSchemeCollection checkSchemeCollection = CheckSchemeFactory.getLocalInstance(ctx).getCheckSchemeCollection(oql);
            objPks = CheckSchemeToSampleLibFactory.getLocalInstance(ctx).batchGenerateSampleLibrary(checkSchemeCollection);
        }
        return objPks;
    }

    @Override
    protected IObjectPK _generateSampleLibrary(Context ctx, String checkSchemeId) throws BOSException, EASBizException {
        IObjectPK objPk = null;
        CheckSchemeInfo checkSchemeInfo = CheckSchemeFactory.getLocalInstance(ctx).getCheckSchemeInfo((IObjectPK)new ObjectUuidPK(checkSchemeId));
        objPk = CheckSchemeToSampleLibFactory.getLocalInstance(ctx).generateSampleLibrary(checkSchemeInfo);
        return objPk;
    }

    private String formatNumber(int number) {
        String numStr = String.valueOf(number);
        StringBuffer result = new StringBuffer(numStr);
        if (numStr != null && numStr.length() <= 4) {
            for (int i = 0; i < 4 - numStr.length(); ++i) {
                result.insert(0, "0");
            }
        }
        return result.toString();
    }

    private List<SampleLibraryQualityTaskInfo> getQueryTaskInfos(Context ctx, int baseNumber, String countSql, String querySql, Object[] timeParams, CheckRangeCollection checkRangeCollection, String billTypeId) throws BOSException, UuidException, SQLException {
        List<SampleLibraryQualityTaskInfo> qualityTasks = new ArrayList<SampleLibraryQualityTaskInfo>();
        IRowSet rowset = null;
        logger.info((Object)("**CheckSchemeToSampleLib**--@\u67e5\u8be2\u8d28\u68c0\u4efb\u52a1\u6570\u91cfSQL@--: " + countSql));
        long logBegin = System.currentTimeMillis();
        long logEnd = 0L;
        countSql = "/*dialect*/SELECT COUNT(1) NUM FROM (" + countSql + ") TEMP";
        rowset = DbUtil.executeQuery((Context)ctx, (String)countSql, (Object[])timeParams);
        logEnd = System.currentTimeMillis();
        logger.info((Object)("**CheckSchemeToSampleLib**--@\u67e5\u8be2\u8d28\u68c0\u4efb\u52a1\u8017\u65f6@--: " + (logEnd - logBegin) + "ms"));
        Long number = 0L;
        if (rowset.next()) {
            number = rowset.getLong("NUM");
        }
        logger.info((Object)("**CheckSchemeToSampleLib**--@\u67e5\u8be2\u5230\u7684\u8d28\u68c0\u4efb\u52a1\u6570\u91cf@--: " + number));
        if (number > 0L) {
            querySql = "/*dialect*/" + querySql;
            logger.info((Object)("**CheckSchemeToSampleLib**--@\u67e5\u8be2\u8d28\u68c0\u4efb\u52a1SQL@--: " + querySql));
            if (number > (long)baseNumber) {
                double queryCount = Math.floor(number.doubleValue() / (double)baseNumber);
                logBegin = System.currentTimeMillis();
                long begTime = 0L;
                long endTime = 0L;
                Long remain = number % (long)baseNumber;
                int i = 0;
                while ((double)i < queryCount) {
                    begTime = System.currentTimeMillis();
                    rowset = ExtDBUtil.executeQuery(ctx, querySql, timeParams, i * baseNumber, baseNumber);
                    endTime = System.currentTimeMillis();
                    logger.info((Object)("**CheckSchemeToSampleLib**--@\u5206\u6279\u67e5\u8be2(\u6bcf\u6b21\u67e5\u8be2" + baseNumber + "\u6761)\uff0c\u7b2c" + i + "\u6b21\u8017\u65f6@--: " + (endTime - begTime) + "ms"));
                    qualityTasks.addAll(this.getTaskInfos(ctx, rowset, checkRangeCollection, billTypeId));
                    ++i;
                }
                if (remain > 0L) {
                    begTime = System.currentTimeMillis();
                    rowset = ExtDBUtil.executeQuery(ctx, querySql, timeParams, i * baseNumber, remain.intValue());
                    endTime = System.currentTimeMillis();
                    logger.info((Object)("**CheckSchemeToSampleLib**--@\u4f59\u6570\u6761\u6570(" + remain + "\u6761)\u67e5\u8be2\uff0c\u7b2c" + i + "\u6b21\u8017\u65f6@--: " + (endTime - begTime) + "ms"));
                    qualityTasks.addAll(this.getTaskInfos(ctx, rowset, checkRangeCollection, billTypeId));
                }
                logEnd = System.currentTimeMillis();
                logger.info((Object)("**CheckSchemeToSampleLib**--@\u67e5\u8be2\u8d28\u68c0\u4efb\u52a1(\u5927\u4e8e" + baseNumber + "\u6761)\u8017\u65f6@--: " + (logEnd - logBegin) + "ms"));
            } else {
                logBegin = System.currentTimeMillis();
                rowset = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])timeParams);
                logEnd = System.currentTimeMillis();
                logger.info((Object)("**CheckSchemeToSampleLib**--@\u67e5\u8be2\u8d28\u68c0\u4efb\u52a1(\u5c0f\u4e8e" + baseNumber + "\u6761)\u8017\u65f6@--: " + (logEnd - logBegin) + "ms"));
                qualityTasks = this.getTaskInfos(ctx, rowset, checkRangeCollection, billTypeId);
            }
        }
        return qualityTasks;
    }

    private StringBuffer getSql(String shareCenterId, String type, boolean hasDynamic, String billTypeId, CheckTypeEnum checkType, CheckSchemeCheckOrgCollection orgCollection, CheckSchemeCheckPersonCollection personCollection, String extractCondition, String checkSituation) throws BOSException {
        int i;
        String jobCheckType = CheckTypeEnum.afterAudit.equals((Object)checkType) ? "1" : "2";
        StringBuffer sql = new StringBuffer();
        StringBuffer orgSql = new StringBuffer();
        StringBuffer personSql = new StringBuffer();
        if (!orgCollection.isEmpty()) {
            CheckSchemeCheckOrgInfo checkOrg = null;
            for (i = 0; i < orgCollection.size(); ++i) {
                checkOrg = orgCollection.get(i);
                orgSql.append("ORG.FID = '").append(checkOrg.getOrgID()).append("'");
                if (i >= orgCollection.size() - 1) continue;
                orgSql.append(" OR ");
            }
        }
        if (!personCollection.isEmpty()) {
            CheckSchemeCheckPersonInfo checkPersonInfo = null;
            personSql.append("AND JH.FPERSONNELIDID IN (");
            for (i = 0; i < personCollection.size(); ++i) {
                checkPersonInfo = personCollection.get(i);
                if (i == personCollection.size() - 1) {
                    personSql.append("'" + checkPersonInfo.getPersonID() + "'");
                    continue;
                }
                personSql.append("'" + checkPersonInfo.getPersonID() + "',");
            }
            personSql.append(")");
        }
        if ("count".equals(type)) {
            sql.append("SELECT DISTINCT JH.FBILLID FBILLID FROM T_SSC_JOBHIS JH ");
        } else {
            sql.append("SELECT DISTINCT JH.FBILLID,JH.FSUBJECT,BA.FBILLTYPEID BTID,JH.FORGIDID ORGFID, JH.FBussAttrIDID FBussAttrID, JH.FSscBillID, JH.FID, JH.FShareCenterID FROM T_SSC_JOBHIS JH ");
        }
        sql.append("INNER JOIN T_SSC_BUSSINESSATTRIBUTE BA ON JH.FBUSSATTRIDID = BA.FID ");
        if (orgSql.length() > 0) {
            sql.append("INNER JOIN T_SSC_ORG ORG ON JH.FORGIDID = ORG.FID ");
        }
        if (hasDynamic) {
            sql.append("INNER JOIN T_SSC_DYNVALUEHIS DV ON JH.FID = DV.FJOBIDID ").append("INNER JOIN T_SSC_DYNAMICATTRIBUTE DT ON DV.FDYNAMICIDID = DT.FID ");
        }
        sql.append("WHERE  (JH.FJOBSTATE = '3' OR JH.FJOBSTATE = '10') ").append("AND BA.FBILLTYPEID = '").append(billTypeId).append("' AND (JH.FCHECKTYPE is null OR JH.FCHECKTYPE != '").append("3").append("') AND (JH.FCHECKTYPE is null OR JH.FCHECKTYPE != '").append(jobCheckType).append("') ");
        if (personSql.length() > 0) {
            sql.append(personSql);
            sql.append(" AND EXISTS (SELECT 1 FROM T_SSC_JOBHIS JH1 WHERE JH.FBILLID = JH1.FBILLID AND JH1.FISLASTLEVEL = 1) ");
        } else {
            sql.append(" AND JH.FISLASTLEVEL = 1 ");
        }
        sql.append(" AND JH.FshareCenterId='" + shareCenterId + "'");
        if (CheckTypeEnum.afterAudit.equals((Object)checkType)) {
            sql.append("AND JH.FAUTOAPPROVE = 1 and JH.FPhotoCopyFlag = 1 ");
            if ("unSpotQuality".equals(checkSituation)) {
                sql.append("AND (JH.FCheckType in (0,2)  OR JH.FCheckType is null)");
            } else if ("unQuaAndUnSpotQua".equals(checkSituation)) {
                sql.append("AND (JH.FCheckType = 0 OR JH.FCheckType is null)");
            } else if ("unSpotQuaButQua".equals(checkSituation)) {
                sql.append("AND JH.FCheckType = 2 ");
            }
            sql.append(" AND JH.FArchState < 2 AND JH.FImageUploadTime BETWEEN ? AND ? ");
        } else if ("none".equals(extractCondition)) {
            sql.append("AND ((JH.FAUTOAPPROVE <> 1 AND JH.FCompleteTme BETWEEN ? AND ? ) or (JH.FAUTOAPPROVE = 1 and JH.FPhotoCopyFlag = 1 AND JH.FImageUploadTime BETWEEN ? AND ? )) ");
        } else if ("auto".equals(extractCondition)) {
            sql.append("AND (JH.FAUTOAPPROVE = 1 and JH.FPhotoCopyFlag = 1 AND JH.FImageUploadTime BETWEEN ? AND ? AND JH.FImageUploadTime BETWEEN ? AND ? ) ");
            if ("unQuality".equals(checkSituation)) {
                sql.append("AND (JH.FCheckType in (0,1) OR JH.FCheckType is null)");
            } else if ("unQuaAndUnSpotQua".equals(checkSituation)) {
                sql.append("AND (JH.FCheckType = 0 OR JH.FCheckType is null)");
            } else if ("unQuaButSpotQua".equals(checkSituation)) {
                sql.append("AND JH.FCheckType = 1 ");
            }
        } else if ("manual".equals(extractCondition)) {
            sql.append("AND (JH.FAUTOAPPROVE <> 1 AND JH.FCompleteTme BETWEEN ? AND ? AND JH.FCompleteTme BETWEEN ? AND ? ) ");
        }
        if (orgSql.length() > 0) {
            sql.append("AND (").append(orgSql).append(")");
        }
        return sql;
    }

    private List<SampleLibraryQualityTaskInfo> getTaskInfos(Context ctx, IRowSet rowset, CheckRangeCollection checkRangeCollection, String billTypeId) throws SQLException {
        ArrayList<SampleLibraryQualityTaskInfo> qualityTasks = new ArrayList<SampleLibraryQualityTaskInfo>();
        if (rowset != null) {
            SampleLibraryQualityTaskInfo qtyTaskInfo = null;
            OrgInfo orgInfo = null;
            BillTypeInfo billType = null;
            StringBuffer log = new StringBuffer("**taskInfo\u8bbe\u7f6e\u7684\u503c****");
            while (rowset.next()) {
                boolean ruleFlag = this.checkRule(ctx, rowset, checkRangeCollection, billTypeId);
                if (!ruleFlag) continue;
                qtyTaskInfo = new SampleLibraryQualityTaskInfo();
                qtyTaskInfo.setSubject(rowset.getString("FSUBJECT"));
                qtyTaskInfo.setBillId(rowset.getString("FBILLID"));
                if (rowset.getString("ORGFID") != null) {
                    orgInfo = new OrgInfo();
                    orgInfo.setId(BOSUuid.read((String)rowset.getString("ORGFID")));
                    qtyTaskInfo.setOrg(orgInfo);
                }
                qtyTaskInfo.setTaskState(SampleStateEnum.Undistributed);
                if (rowset.getString("BTID") != null) {
                    billType = new BillTypeInfo();
                    billType.setId(BOSUuid.read((String)rowset.getString("BTID")));
                    qtyTaskInfo.setBillType(billType);
                }
                qtyTaskInfo.setRecheckstate(RecheckStateEnum.Normal);
                qtyTaskInfo.setTaskStateN(SampleTaskStateEnum.NORMAL);
                qtyTaskInfo.setReviseState(ReviseStateEnum.NotRevised);
                qualityTasks.add(qtyTaskInfo);
                logger.info((Object)log.toString());
            }
        }
        return qualityTasks;
    }

    private boolean checkRule(Context ctx, IRowSet rowset, CheckRangeCollection checkRangeCollection, String billTypeId) {
        try {
            ArrayList<DealInfo> listBool = new ArrayList<DealInfo>();
            for (int i = 0; i < checkRangeCollection.size(); ++i) {
                JobHisInfo jobHisInfo = new JobHisInfo();
                jobHisInfo.setBillID(rowset.getString("FBILLID"));
                BussinessAttributeInfo bussinessAttributeInfo = new BussinessAttributeInfo();
                bussinessAttributeInfo.setId(BOSUuid.read((String)rowset.getString("FBussAttrID")));
                jobHisInfo.setBussAttrID(bussinessAttributeInfo);
                jobHisInfo.setSscBillID(rowset.getString("FSscBillID"));
                jobHisInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                FullOrgUnitInfo shareCenter = new FullOrgUnitInfo();
                shareCenter.setId(BOSUuid.read((String)rowset.getString("FShareCenterID")));
                jobHisInfo.setShareCenterID(shareCenter);
                CheckRangeInfo entryInfo = checkRangeCollection.get(i);
                DealInfo dealInfo = new DealInfo();
                dealInfo.setLeftBracket(entryInfo.getLeftBracket());
                dealInfo.setRightBracket(entryInfo.getRightBracket());
                String key = entryInfo.getProperty();
                String realKey = SSCBaseBillUtils.getRealKey(ctx, key, jobHisInfo, billTypeId);
                String value = entryInfo.getCompareValue();
                String realValue = SSCBaseBillUtils.getRealKey(ctx, value, jobHisInfo, billTypeId);
                boolean b = SSCCompareUtils.compare(entryInfo.getCompareType(), realKey, realValue);
                dealInfo.setBool(b);
                String luogi = "";
                if (!StringUtils.isEmpty((String)entryInfo.getFilterItem())) {
                    luogi = "and".equals(entryInfo.getFilterItem()) ? "&&" : "||";
                }
                dealInfo.setLuogi(luogi);
                listBool.add(dealInfo);
            }
            boolean endBool = true;
            String luoj = " && ";
            if (listBool.size() > 0) {
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < listBool.size(); ++j) {
                    DealInfo dealInfo = (DealInfo)listBool.get(j);
                    sb.append(StringUtils.isEmpty((String)dealInfo.getLeftBracket()) ? "" : dealInfo.getLeftBracket());
                    sb.append(dealInfo.isBool());
                    sb.append(StringUtils.isEmpty((String)dealInfo.getRightBracket()) ? "" : dealInfo.getRightBracket());
                    String luoji = dealInfo.getLuogi();
                    if (j >= listBool.size() - 1) continue;
                    if (!StringUtils.isEmpty((String)luoji)) {
                        sb.append(dealInfo.getLuogi());
                        continue;
                    }
                    sb.append(luoj);
                }
                try {
                    ScriptEngineManager manager = new ScriptEngineManager();
                    ScriptEngine engine = manager.getEngineByName("JavaScript");
                    engine.eval("function t() {return " + sb.toString() + ";}");
                    Invocable invocable = (Invocable)((Object)engine);
                    Object o = invocable.invokeFunction("t", new Object[0]);
                    endBool = Boolean.parseBoolean(o.toString());
                    return endBool;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            return endBool;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private Object[] getQueryTimeParams(Context ctx, CheckSchemeInfo checkSchemeInfo, int times) throws EASBizException, BOSException {
        CheckSchemeTimeType timeType = checkSchemeInfo.getCheckSchemeTimeType();
        Timestamp[] queryTimeParams = SampleLibraryQualityTaskFacadeFactory.getLocalInstance(ctx).getQueryTimeParams(checkSchemeInfo);
        Timestamp beginDate = queryTimeParams[0];
        Timestamp endDate = queryTimeParams[1];
        int length = times * 2;
        Object[] timeParams = new Object[length];
        for (int i = 0; i < length; ++i) {
            timeParams[i] = i % 2 == 0 ? beginDate : endDate;
        }
        return timeParams;
    }

    private Map<String, Object> getTimeRangeSQL(String sqlField, String timeStr, String compareType) throws ParseException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Timestamp> params = new ArrayList<Timestamp>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new SimpleDateFormat("yyyy-MM-dd").parse(timeStr));
        StringBuffer sql = new StringBuffer(" ");
        Timestamp dayBegin = new Timestamp(calendar.getTimeInMillis());
        calendar.add(11, 24);
        calendar.add(13, -1);
        Timestamp dayEnd = new Timestamp(calendar.getTimeInMillis());
        if ("=".equals(compareType) || "in".equals(compareType) || "like".equals(compareType)) {
            sql.append(sqlField).append(" between ? and ? ");
            params.add(dayBegin);
            params.add(dayEnd);
        } else if ("<>".equals(compareType) || "not in".equals(compareType)) {
            sql.append(sqlField).append(" < ? or ").append(sqlField).append(" > ?");
            params.add(dayBegin);
            params.add(dayEnd);
        } else if (">".equals(compareType)) {
            sql.append(sqlField).append(" > ?");
            params.add(dayEnd);
        } else if (">=".equals(compareType)) {
            sql.append(sqlField).append(" > ?");
            params.add(dayBegin);
        } else if ("<".equals(compareType)) {
            sql.append(sqlField).append(" < ?");
            params.add(dayBegin);
        } else if ("<=".equals(compareType)) {
            sql.append(sqlField).append(" < ?");
            params.add(dayEnd);
        }
        result.put("sql", sql);
        result.put("params", params);
        return result;
    }

    private Map<String, String> parseCheckranges(Context ctx, StringBuffer baseCountSql, StringBuffer baseQuerySql, CheckRangeCollection checkRangeCollection, String billTypeId) throws EASBizException, BOSException, SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        String queryCount = baseCountSql.toString();
        String queryResult = baseQuerySql.toString();
        if (checkRangeCollection != null && checkRangeCollection.size() > 0) {
            CheckRangeInfo checkRangeInfo = null;
            String compareValue = null;
            String compareType = null;
            String leftBracket = null;
            String rightBracket = null;
            String filterItem = null;
            IRowSet rowSet = null;
            String property = null;
            String ftype = null;
            int bracketCount = 0;
            StringBuffer dynCondition = new StringBuffer();
            ArrayList<String> compareValues = new ArrayList<String>();
            for (int i = 0; i < checkRangeCollection.size(); ++i) {
                checkRangeInfo = checkRangeCollection.get(i);
                property = checkRangeInfo.getProperty();
                compareValue = checkRangeInfo.getCompareValue();
                compareType = checkRangeInfo.getCompareType();
                if (compareType != null) {
                    compareType = compareType.toUpperCase().trim();
                }
                filterItem = checkRangeInfo.getFilterItem();
                rowSet = DbUtil.executeQuery((Context)ctx, (String)("SELECT DISTINCT FTYPE FROM T_SSC_DYNAMICATTRIBUTE WHERE FNUMBER = '" + property + "' AND FBILLTYPEID = '" + billTypeId + "'"));
                if (!rowSet.next()) continue;
                ftype = rowSet.getString("FTYPE");
                leftBracket = checkRangeInfo.getLeftBracket();
                rightBracket = checkRangeInfo.getRightBracket();
                if (leftBracket != null && ++bracketCount > 1) {
                    NumericExceptionSubItem item = new NumericExceptionSubItem("CheckSchemeToSampleLib.BracketException", "\u62ec\u53f7\u4e0d\u652f\u6301\u5d4c\u5957!");
                    throw new EASBizException(item);
                }
                if (rightBracket != null) {
                    --bracketCount;
                }
                dynCondition.append(leftBracket == null ? "" : leftBracket);
                if ("1".equals(ftype)) {
                    dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & DV.FDIGIVALUE ").append(compareType).append(" ").append(Double.parseDouble(compareValue)).append(" ] ");
                } else if ("2".equals(ftype)) {
                    dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & subString${DV.FDINAMICVALUE,1,10 subString$} ").append(compareType).append(" '").append(compareValue).append("' ] ");
                } else {
                    if (compareValue == null || compareValue.indexOf("&") > -1 || compareValue.indexOf("?") > -1 || compareValue.indexOf("^") > -1) {
                        NumericExceptionSubItem item = new NumericExceptionSubItem("CheckSchemeToSampleLib.CompareValueException", "\u6bd4\u8f83\u503c\u4e0d\u80fd\u4e3a\u7a7a\u800c\u4e14\u4e0d\u80fd\u5305\u542b&\u3001?\u3001^\u7b49\u7279\u6b8a\u5b57\u7b26!");
                        throw new EASBizException(item);
                    }
                    if ("<>".equals(compareType)) {
                        dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & [DV.FDINAMICVALUE <> '^' or DV.FDINAMICVALUE IS NULL] ]");
                    } else if ("NOT LIKE".equals(compareType)) {
                        dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & [DV.FDINAMICVALUE NOT LIKE '%^%' or DV.FDINAMICVALUE IS NULL] ]");
                    } else {
                        dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & DV.FDINAMICVALUE ").append(compareType);
                        if ("IN".equals(compareType) || "NOT IN".equals(compareType)) {
                            dynCondition.append(" ['^'] ");
                        } else if ("LIKE".equals(compareType)) {
                            dynCondition.append(" '%^%'");
                        } else {
                            dynCondition.append(" '^'");
                        }
                        dynCondition.append(" ] ");
                    }
                    compareValues.add(compareValue);
                }
                dynCondition.append(rightBracket == null ? "" : rightBracket);
                if (i >= checkRangeCollection.size() - 1) continue;
                if (StringUtils.isEmpty((String)filterItem)) {
                    dynCondition.append("AND");
                    continue;
                }
                dynCondition.append(filterItem.toUpperCase());
            }
            if (bracketCount != 0) {
                NumericExceptionSubItem item = new NumericExceptionSubItem("CheckSchemeToSampleLib.BracketException", "\u62ec\u53f7\u4e0d\u5bf9\u79f0,\u8bf7\u68c0\u67e5\u62bd\u68c0\u8303\u56f4\u6761\u4ef6\u4e2d\u7684\u62ec\u53f7!");
                throw new EASBizException(item);
            }
            ArrayList<SQLInfo> sqlInfos = new ArrayList<SQLInfo>();
            this.parseDynamicCondition(dynCondition.toString(), sqlInfos);
            queryCount = this.generateSQLByInfo(baseCountSql.toString(), sqlInfos);
            int i = 0;
            while (queryCount.indexOf("^") > -1) {
                queryCount = queryCount.replaceFirst("\\^", (String)compareValues.get(i));
                ++i;
            }
            this.sqlCount = 0;
            queryResult = this.generateSQLByInfo(baseQuerySql.toString(), sqlInfos);
            i = 0;
            while (queryResult.indexOf("^") > -1) {
                queryResult = queryResult.replaceFirst("\\^", (String)compareValues.get(i));
                ++i;
            }
        } else {
            this.sqlCount = 1;
        }
        queryCount = queryCount.replace("subString${", "subStr(");
        queryCount = queryCount.replace("subString$}", ")");
        queryResult = queryResult.replace("subString${", "subStr(");
        queryResult = queryResult.replace("subString$}", ")");
        result.put("countSql", queryCount);
        result.put("querySql", queryResult);
        result.put("times", String.valueOf(this.sqlCount));
        return result;
    }

    private void parseDynamicCondition(String dynSql, List<SQLInfo> infos) {
        int leftBracketPoint = dynSql.indexOf("(");
        int andPoint = dynSql.indexOf("AND");
        int orPoint = dynSql.indexOf("OR");
        if (leftBracketPoint > -1) {
            if (andPoint > -1) {
                if (leftBracketPoint < andPoint) {
                    if (orPoint > -1) {
                        if (leftBracketPoint < orPoint) {
                            this.parseBracket(dynSql, leftBracketPoint, infos);
                        } else {
                            this.parseOr(dynSql, orPoint, infos);
                        }
                    } else {
                        this.parseBracket(dynSql, leftBracketPoint, infos);
                    }
                } else if (orPoint > -1) {
                    if (andPoint < orPoint) {
                        this.parseAnd(dynSql, andPoint, infos);
                    } else {
                        this.parseOr(dynSql, orPoint, infos);
                    }
                } else {
                    this.parseAnd(dynSql, andPoint, infos);
                }
            } else if (orPoint > -1) {
                if (leftBracketPoint < orPoint) {
                    this.parseBracket(dynSql, leftBracketPoint, infos);
                } else {
                    this.parseOr(dynSql, orPoint, infos);
                }
            } else {
                this.parseBracket(dynSql, leftBracketPoint, infos);
            }
        } else if (andPoint > -1) {
            if (orPoint > -1) {
                if (andPoint < orPoint) {
                    this.parseAnd(dynSql, andPoint, infos);
                } else {
                    this.parseOr(dynSql, orPoint, infos);
                }
            } else {
                this.parseAnd(dynSql, andPoint, infos);
            }
        } else if (orPoint > -1) {
            this.parseOr(dynSql, orPoint, infos);
        } else {
            SQLInfo info = new SQLInfo();
            info.setSql(dynSql);
            infos.add(info);
            return;
        }
    }

    private void parseOr(String dynSql, int orPoint, List<SQLInfo> infos) {
        String temp = dynSql.substring(0, orPoint);
        SQLInfo info = new SQLInfo();
        info.setSql(temp);
        info.setJoinType("OR");
        infos.add(info);
        if (temp.length() < dynSql.length()) {
            dynSql = dynSql.substring(temp.length() + 2, dynSql.length());
            this.parseDynamicCondition(dynSql, infos);
        }
    }

    private void parseAnd(String dynSql, int andPoint, List<SQLInfo> infos) {
        String temp = dynSql.substring(0, andPoint);
        SQLInfo info = new SQLInfo();
        info.setSql(temp);
        info.setJoinType("AND");
        infos.add(info);
        if (temp.length() < dynSql.length()) {
            dynSql = dynSql.substring(temp.length() + 3, dynSql.length());
            this.parseDynamicCondition(dynSql, infos);
        }
    }

    private void parseBracket(String dynSql, int leftBracketPoint, List<SQLInfo> infos) {
        int nextPoint = dynSql.indexOf(")");
        String temp = dynSql.substring(leftBracketPoint, nextPoint + 1);
        SQLInfo info = new SQLInfo();
        info.setSql(temp);
        if (temp.length() < dynSql.length()) {
            dynSql = dynSql.substring(temp.length(), dynSql.length());
            int andJoinPoint = dynSql.indexOf("AND");
            int orJoinPoint = dynSql.indexOf("OR");
            if (andJoinPoint > -1) {
                if (orJoinPoint > -1) {
                    if (andJoinPoint < orJoinPoint) {
                        info.setJoinType("AND");
                        infos.add(info);
                        dynSql = dynSql.substring(andJoinPoint + 3, dynSql.length());
                        this.parseDynamicCondition(dynSql, infos);
                    } else {
                        info.setJoinType("OR");
                        infos.add(info);
                        dynSql = dynSql.substring(orJoinPoint + 2, dynSql.length());
                        this.parseDynamicCondition(dynSql, infos);
                    }
                } else {
                    info.setJoinType("AND");
                    infos.add(info);
                    dynSql = dynSql.substring(andJoinPoint + 3, dynSql.length());
                    this.parseDynamicCondition(dynSql, infos);
                }
            } else if (orJoinPoint > -1) {
                info.setJoinType("OR");
                infos.add(info);
                dynSql = dynSql.substring(orJoinPoint + 2, dynSql.length());
                this.parseDynamicCondition(dynSql, infos);
            }
        } else {
            infos.add(info);
        }
    }

    private String generateSQLByInfo(String baseSql, List<SQLInfo> sqlInfos) {
        StringBuffer allSql = new StringBuffer("(");
        StringBuffer tmpSql = null;
        String joinType = null;
        String infoSql = null;
        for (SQLInfo info : sqlInfos) {
            joinType = info.getJoinType();
            infoSql = info.getSql();
            joinType = "AND".equals(joinType) ? " INTERSECT " : ("OR".equals(joinType) ? ") UNION (" : "");
            if (infoSql.indexOf("AND") > -1) {
                allSql.append("(");
                ArrayList<SQLInfo> tempInfos = new ArrayList<SQLInfo>();
                infoSql = infoSql.substring(1, infoSql.length() - 1);
                this.parseDynamicCondition(infoSql, tempInfos);
                allSql.append(this.generateSQLByInfo(baseSql, tempInfos).replaceAll("&", "AND").replaceAll("\\[", "(").replaceAll("\\]", ")")).append(")").append(joinType);
                continue;
            }
            tmpSql = new StringBuffer("(");
            tmpSql.append(baseSql).append(" AND ").append(infoSql.replaceAll("&", "AND").replaceAll("\\[", "(").replaceAll("\\]", ")")).append(")").append(joinType);
            allSql.append(tmpSql);
            Integer n = this.sqlCount;
            Integer n2 = this.sqlCount = Integer.valueOf(this.sqlCount + 1);
        }
        return allSql.append(")").toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int[] _updateQualityTaskContent(Context ctx, String sampleLibId) throws BOSException, EASBizException {
        int[] ret = new int[]{};
        Connection conn = null;
        Statement stmt = null;
        String samtmpTable = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            samtmpTable = this.createSamtmpTable(ctx, conn);
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into ").append(samtmpTable).append("(fid,fdvalue)  ").append("  SELECT  ST.fid ,DV.FDINAMICVALUE dvalue ").append("  FROM T_SSC_SAMPLELIBRARYQUALITYTASK ST ").append("  inner join T_SSC_JOBHIS JH on JH.FBILLID = ST.FBILLID ").append(" INNER JOIN T_SSC_DYNVALUEHIS DV ON JH.FID = DV.FJOBIDID ").append(" INNER JOIN T_SSC_DYNAMICATTRIBUTE DT ON DV.FDYNAMICIDID = DT.FID ").append("  WHERE DT.FNUMBER = 'REMARK' and jH.fjobstate='3' and jh.FISLASTLEVEL = 1 ").append("  and ST.fparentId = ? ");
            logger.error((Object)("@checkToSamplelib----insertSql------" + insertSql));
            long t1 = System.currentTimeMillis();
            stmt = conn.prepareStatement(insertSql.toString());
            stmt.setString(1, sampleLibId);
            stmt.executeUpdate();
            logger.error((Object)("***insertSql over***" + (System.currentTimeMillis() - t1) / 1000L));
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" update T_SSC_SAMPLELIBRARYQUALITYTASK a set fcontent = ").append(" (select distinct fdvalue from ").append(samtmpTable).append(" b where b.fid = a.fid) where a.fparentId=?");
            logger.error((Object)("@checkToSamplelib----updateSql------" + updateSql));
            long t11 = System.currentTimeMillis();
            stmt = null;
            stmt = conn.prepareStatement(updateSql.toString());
            stmt.setString(1, sampleLibId);
            stmt.executeUpdate();
            logger.error((Object)("***updateSql over***" + (System.currentTimeMillis() - t11) / 1000L));
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException("CheckSchemeToSampleLibControllerBean updateQualityTaskContent exception : ", (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    TempTablePool.getInstance((Context)ctx).releaseTable(samtmpTable);
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                    if (stmt == null) throw throwable;
                    stmt.close();
                    stmt = null;
                    throw throwable;
                }
                catch (Exception e2) {
                    logger.error((Object)e2.getMessage(), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(samtmpTable);
            if (conn != null) {
                conn.close();
                conn = null;
            }
            if (stmt == null) return ret;
            stmt.close();
            stmt = null;
            return ret;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return ret;
        }
    }

    private String createSamtmpTable(Context ctx, Connection conn) throws BOSException {
        String varHGIDtmp = null;
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append(" create table samtmptask ");
        createTableSql.append(" (fid varchar(44), Fdvalue nvarchar(1024) ) ");
        try {
            varHGIDtmp = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return varHGIDtmp;
    }

    private void createSampTmpIndex(Context ctx, String varHGIDtmp, Connection conn) {
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(varHGIDtmp, "fid", false, false);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _doOtherThings(Context ctx, String sampleLibId, AssignTypeEnum assignType) throws BOSException, EASBizException {
        long logBegin = 0L;
        long logEnd = 0L;
        try {
            logBegin = System.currentTimeMillis();
            CheckRiskFacadeFactory.getLocalInstance(ctx).executeCheckRisk(sampleLibId);
            logEnd = System.currentTimeMillis();
            logger.info((Object)("**CheckSchemeToSampleLib**--@\u8ba1\u7b97\u98ce\u63a7\u6d1e\u5bdf\u7ed3\u679c\u8017\u65f6@--: " + (logEnd - logBegin) + "ms"));
        }
        catch (Exception e) {
            logger.error((Object)"executeCheckRisk error", (Throwable)e);
        }
        try {
            logBegin = System.currentTimeMillis();
            RenderPlanFinishTimeFactory.getLocalInstance(ctx).calRenderPlanFinishTime(sampleLibId);
            logEnd = System.currentTimeMillis();
            logger.info((Object)("**CheckSchemeToSampleLib**--@\u8bbe\u7f6e\u5b8c\u6210\u65f6\u95f4\u8017\u65f6@--: " + (logEnd - logBegin) + "ms"));
        }
        catch (Exception e) {
            logger.error((Object)"calRenderPlanFinish error", (Throwable)e);
        }
        try {
            if (AssignTypeEnum.auto.equals((Object)assignType)) {
                logBegin = System.currentTimeMillis();
                SampleLibraryFacadeFactory.getLocalInstance(ctx).assignAll(sampleLibId);
                logEnd = System.currentTimeMillis();
                logger.info((Object)("**CheckSchemeToSampleLib**--@\u81ea\u52a8\u5206\u914d\u8017\u65f6@--: " + (logEnd - logBegin) + "ms"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"assignAll error", (Throwable)e);
        }
    }

    class DoOtherThingsThread
    extends Thread {
        private Context ctx;
        private AssignTypeEnum assignType;
        private String sampleLibId;

        public DoOtherThingsThread() {
        }

        public DoOtherThingsThread(Context ctx, AssignTypeEnum assignType, String sampleLibId) {
            this.ctx = ctx;
            this.assignType = assignType;
            this.sampleLibId = sampleLibId;
        }

        @Override
        public void run() {
            try {
                CheckSchemeToSampleLibFactory.getLocalInstance(this.ctx).doOtherThings(this.sampleLibId, this.assignType);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    static class ExtDBUtil
    extends DbUtil {
        private static final Logger logger = Logger.getLogger(ExtDBUtil.class);

        ExtDBUtil() {
        }

        public static IRowSet executeQuery(Context ctx, String sql, Object[] params, int start, int rows) throws BOSException {
            JdbcRowSet jdbcRowSet;
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                conn = EJBFactory.getQueryConnection((Context)ctx);
                ps = conn.prepareStatement(sql);
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
                rs = ps.executeQuery();
                JdbcRowSet rowset = new JdbcRowSet();
                rowset.populate(rs, start, rows, true);
                jdbcRowSet = rowset;
            }
            catch (SQLException exc) {
                try {
                    StringBuffer sb = new StringBuffer("");
                    for (int i = 0; i < params.length; ++i) {
                        sb.append("param ").append(i).append(" is:").append(params[i]);
                    }
                    logger.error((Object)("ExtDBUtil query sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
                    throw new BOSException("CheckSchemeToSampleLibControllerBean ExtDBUtil execute exception : " + sql, (Throwable)exc);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            return jdbcRowSet;
        }

        public static int[] executeBatch(Context ctx, List<String> sqls) throws BOSException {
            if (sqls == null || !sqls.isEmpty()) {
                return new int[0];
            }
            Connection conn = null;
            Statement statement = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
            }
            catch (SQLException exc) {
                SQLUtils.cleanup((Connection)conn);
                throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
            }
            StringBuffer logSql = new StringBuffer();
            try {
                int[] ret;
                statement = conn.createStatement();
                for (String sql : sqls) {
                    statement.addBatch(sql);
                    logSql.append(sql);
                }
                logger.info((Object)("**Update CheckScheme SQL**: " + logSql));
                int[] nArray = ret = statement.executeBatch();
                return nArray;
            }
            catch (SQLException exc) {
                throw new BOSException("Sql1 execute exception : " + logSql, (Throwable)exc);
            }
            finally {
                SQLUtils.cleanup((Statement)statement, (Connection)conn);
            }
        }
    }

    class SQLInfo {
        private String sql;
        private String joinType;

        SQLInfo() {
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public String getJoinType() {
            return this.joinType;
        }

        public void setJoinType(String joinType) {
            this.joinType = joinType;
        }

        public String toString() {
            return "SQL: " + this.sql + "\r\nJoinType: " + this.joinType;
        }
    }

    class DealInfo {
        private boolean bool;
        private String leftBracket;
        private String rightBracket;
        private String luogi;

        DealInfo() {
        }

        public String getLuogi() {
            return this.luogi;
        }

        public void setLuogi(String luogi) {
            this.luogi = luogi;
        }

        public boolean isBool() {
            return this.bool;
        }

        public void setBool(boolean bool) {
            this.bool = bool;
        }

        public String getLeftBracket() {
            return this.leftBracket;
        }

        public void setLeftBracket(String leftBracket) {
            this.leftBracket = leftBracket;
        }

        public String getRightBracket() {
            return this.rightBracket;
        }

        public void setRightBracket(String rightBracket) {
            this.rightBracket = rightBracket;
        }
    }
}

