/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.ssc.CreditDeImageLogFactory;
import com.kingdee.eas.base.ssc.CreditDeImageLogInfo;
import com.kingdee.eas.base.ssc.CreditFilesNewFactory;
import com.kingdee.eas.base.ssc.CreditFilesNewInfo;
import com.kingdee.eas.base.ssc.CreditLogFactory;
import com.kingdee.eas.base.ssc.CreditLogInfo;
import com.kingdee.eas.base.ssc.CreditParamsFacadeFactory;
import com.kingdee.eas.base.ssc.CreditScoreCollection;
import com.kingdee.eas.base.ssc.CreditScoreFacadeFactory;
import com.kingdee.eas.base.ssc.CreditScoreFactory;
import com.kingdee.eas.base.ssc.CreditScoreInfo;
import com.kingdee.eas.base.ssc.CreditScoreLdRuleInfo;
import com.kingdee.eas.base.ssc.CreditScoreLdRuleVideoOutofdateEntryCollection;
import com.kingdee.eas.base.ssc.CreditScoreLdRuleVideoOutofdateEntryInfo;
import com.kingdee.eas.base.ssc.app.AbstractCreditDemotionForImageFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.ChangeSourceEnum;
import com.kingdee.eas.base.ssc.app.CreditChangeTypeEnum;
import com.kingdee.eas.base.ssc.tool.credit.CreditUtils;
import com.kingdee.eas.basedata.orgext.ShareCenterOrgUnitCollection;
import com.kingdee.eas.basedata.orgext.ShareCenterOrgUnitFactory;
import com.kingdee.eas.basedata.orgext.ShareCenterOrgUnitInfo;
import com.kingdee.eas.fm.common.H;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreditDemotionForImageFacadeControllerBean
extends AbstractCreditDemotionForImageFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.CreditDemotionForImageFacadeControllerBean");

    @Override
    protected boolean _creditDemotion(Context ctx) throws BOSException {
        logger.error((Object)"CreditDemotionForImageFacadeControllerBean_creditDemotion-------start-------------------------");
        Calendar cCalendar = Calendar.getInstance();
        long currTime = cCalendar.getTimeInMillis();
        try {
            Map tCreScoreMap = this.getCreditScoreMap(ctx);
            if (tCreScoreMap == null) {
                logger.error((Object)" not Maintain CreditScore error ---------");
                return false;
            }
            ShareCenterOrgUnitCollection shareCenterOrgUnitCollection = ShareCenterOrgUnitFactory.getLocalInstance((Context)ctx).getShareCenterOrgUnitCollection("where (isSealUp = 0 or isSealUp is null) and isBizUnit = 1");
            for (int i = 0; i < shareCenterOrgUnitCollection.size(); ++i) {
                ShareCenterOrgUnitInfo scOrg = shareCenterOrgUnitCollection.get(i);
                String isCredit = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK((Object)scOrg.getId()), (String)"SSC_CREDIT_MANAGER");
                if (!isCredit.equalsIgnoreCase("true")) {
                    logger.error((Object)(scOrg.getId() + "Credit is false-----"));
                    continue;
                }
                CreditScoreLdRuleInfo creditScoreLdRule = CreditScoreFacadeFactory.getLocalInstance(ctx).getCreditScoreLdRule(scOrg.getId().toString());
                CreditScoreLdRuleVideoOutofdateEntryCollection tCSLdRuleImageCollection = creditScoreLdRule.getVideoOutofdateEntry();
                if (tCSLdRuleImageCollection == null || tCSLdRuleImageCollection.size() <= 0) continue;
                for (int index = 0; index < tCSLdRuleImageCollection.size(); ++index) {
                    CreditScoreLdRuleVideoOutofdateEntryInfo tCSLdRuleImageInfo = tCSLdRuleImageCollection.get(index);
                    String tCreditImageId = tCSLdRuleImageInfo.getId().toString();
                    int tOutofdatNum = tCSLdRuleImageInfo.getOutofdateNum();
                    int tReduceLevelNum = tCSLdRuleImageInfo.getReduceLevelNum();
                    String tCreditName = tCSLdRuleImageInfo.getMinCreditLevel().getName();
                    int tCreditLevel = tCSLdRuleImageInfo.getMinCreditLevel().getSeqNo();
                    List tList = this.getJobList(ctx, scOrg.getId().toString(), "", tOutofdatNum, tCreditImageId);
                    this.dealCreditDe(ctx, scOrg.getId().toString(), tCreScoreMap, tList, tReduceLevelNum, tCreditLevel, tCreditName, tOutofdatNum, tCreditImageId);
                    tList.clear();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("_creditDemotion----error" + e.getMessage()));
            e.printStackTrace();
        }
        cCalendar = Calendar.getInstance();
        long currTime2 = cCalendar.getTimeInMillis();
        long diff2 = currTime2 - currTime;
        logger.error((Object)("using============== TIMES=" + diff2 / 1000L + "s============================="));
        logger.error((Object)"CreditDemotionForImageFacadeControllerBean_creditDemotion-------end-------------------------");
        return true;
    }

    private List getJobList(Context ctx, String scOrgId, String querySql, int tOutOfDate, String tCreditImageId) {
        ArrayList tList = new ArrayList();
        try {
            StringBuffer tStrBuff = new StringBuffer();
            tStrBuff.append(" /*dialect*/ select a.fid jobid,b.fdinamicvalue creator,a.fsubject subject,c.fbilltypeid billtypeid,a.fbillid billid ");
            tStrBuff.append("from t_ssc_jobhis a,t_ssc_dynvaluehis b ,t_ssc_bussinessattribute c ");
            tStrBuff.append("where 1=1 ");
            tStrBuff.append("and a.fautoapprove = 1 and a.fphotocopyflag = 0  ");
            tStrBuff.append("and (a.fjobstate = '3' or a.fjobstate = '4') and a.fisLastLevel = 1 ");
            tStrBuff.append("and not exists ( select 1 from t_ssc_creditdeimagelog where fjobid = a.fid and  fcreditimageid = '" + tCreditImageId + "') ");
            tStrBuff.append("and a.FShareCenterID = '" + scOrgId + "' and a.fid = b.fjobidid and b.fdynamicidid = '4VBUlqSUQuO8g8sPkTkXsZvLn80=' ");
            tStrBuff.append("AND DATEDIFF(hour, a.FLASTUPDATETIME, GETDATE()) >= " + tOutOfDate * 24 + " ");
            tStrBuff.append("and a.fbussattridid = c.fid ");
            try {
                String querysql = CreditParamsFacadeFactory.getLocalInstance(ctx).getBatchFilterSql(scOrgId, "a", "c");
                tStrBuff.append(querysql);
                logger.error((Object)("query-----------sql:--" + tStrBuff.toString()));
            }
            catch (Exception e) {
                logger.error((Object)(" query conditions error" + e.getMessage()));
                e.printStackTrace();
                return null;
            }
            IRowSet tIRowSet = DbUtil.executeQuery((Context)ctx, (String)tStrBuff.toString());
            while (tIRowSet.next()) {
                HashMap<String, String> tMap = new HashMap<String, String>();
                String jobid = tIRowSet.getString("jobid");
                String creatorId = tIRowSet.getString("creator");
                String subject = tIRowSet.getString("subject");
                String billtypeid = tIRowSet.getString("billtypeid");
                String billid = tIRowSet.getString("billid");
                tMap.put("jobid", jobid);
                tMap.put("creatorId", creatorId);
                tMap.put("subject", subject);
                tMap.put("billtypeid", billtypeid);
                tMap.put("billid", billid);
                tList.add(tMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)("-----query CreditDemotion getJobList error:" + e.getMessage()));
            e.printStackTrace();
        }
        return tList;
    }

    private void dealCreditDe(Context ctx, String scOrgId, Map tCreScoreMap, List tJobList, int tReduceLevelNum, int tMinCreditLevel, String tMinCreditName, int tOutOfDate, String tCreditImageId) {
        if (tJobList != null && tJobList.size() > 0) {
            try {
                CoreBaseCollection tDeImageLogColl = new CoreBaseCollection();
                CoreBaseCollection tCreditLogColl = new CoreBaseCollection();
                CoreBaseCollection tCreFilesColl = new CoreBaseCollection();
                HashMap<String, CreditFilesNewInfo> tPersonCrMap = new HashMap<String, CreditFilesNewInfo>();
                for (int index = 0; index < tJobList.size(); ++index) {
                    CreditFilesNewInfo tCreditFilesInfo;
                    Map tMap = (Map)tJobList.get(index);
                    String jobid = (String)tMap.get("jobid");
                    String creatorId = (String)tMap.get("creatorId");
                    String subject = (String)tMap.get("subject");
                    String billtypeid = (String)tMap.get("billtypeid");
                    String billid = (String)tMap.get("billid");
                    boolean hasBill = CreditUtils.hasBill(ctx, scOrgId, billtypeid);
                    if (!hasBill || (tCreditFilesInfo = CreditFilesNewFactory.getLocalInstance(ctx).getCreditFilesNewInfoByUserId(creatorId)) == null) continue;
                    if (tPersonCrMap.containsKey(tCreditFilesInfo.getUserAccount())) {
                        tCreditFilesInfo = (CreditFilesNewInfo)tPersonCrMap.get(tCreditFilesInfo.getUserAccount());
                    }
                    CreditFilesNewInfo tOldCreditFilesInfo = (CreditFilesNewInfo)tCreditFilesInfo.clone();
                    int tCurrentRating = tCreditFilesInfo.getCreditRating().getSeqNo();
                    int tRating = 0;
                    boolean isDemotion = true;
                    if (tCurrentRating >= tMinCreditLevel) {
                        tRating = tCurrentRating;
                        isDemotion = false;
                    } else {
                        tRating = tCurrentRating + tReduceLevelNum > tMinCreditLevel ? tMinCreditLevel : tCurrentRating + tReduceLevelNum;
                    }
                    if (isDemotion) {
                        CreditScoreInfo tCreditScoreInfo = (CreditScoreInfo)tCreScoreMap.get(tRating);
                        tCreditFilesInfo.setCreditScore(tCreditScoreInfo.getScore());
                        tCreditFilesInfo.setCreditRating(tCreditScoreInfo);
                    }
                    tCreditFilesInfo.setUnqualifiedTotalNum(tOldCreditFilesInfo.getUnqualifiedTotalNum() + 1);
                    tCreditFilesInfo.setThisYearUnqualifiedNum(tOldCreditFilesInfo.getThisYearUnqualifiedNum() + 1);
                    tPersonCrMap.put(tCreditFilesInfo.getUserAccount(), tCreditFilesInfo);
                    tCreFilesColl.add((CoreBaseInfo)tCreditFilesInfo);
                    CreditLogInfo tCreditLogInfo = new CreditLogInfo();
                    tCreditLogInfo.setCreditFilesNew(tCreditFilesInfo);
                    tCreditLogInfo.setCreditChangeType(CreditChangeTypeEnum.degrade);
                    tCreditLogInfo.setChangeSource(ChangeSourceEnum.imageOverdue);
                    tCreditLogInfo.setOriginalGrade(tOldCreditFilesInfo.getCreditRating());
                    tCreditLogInfo.setOriginalScore(tOldCreditFilesInfo.getCreditScore());
                    tCreditLogInfo.setCurrentGrade(tCreditFilesInfo.getCreditRating());
                    tCreditLogInfo.setCurrentScore(tCreditFilesInfo.getCreditScore());
                    BigDecimal changScore = tOldCreditFilesInfo.getCreditScore().add(tCreditFilesInfo.getCreditScore().negate());
                    tCreditLogInfo.setChangeScore(changScore);
                    tCreditLogInfo.setChangeDate(new Date());
                    int changeGrade = tCreditFilesInfo.getCreditRating().getSeqNo() - tOldCreditFilesInfo.getCreditRating().getSeqNo();
                    tCreditLogInfo.setChangGrade(changeGrade);
                    tCreditLogInfo.setBillID(billid);
                    tCreditLogInfo.setSubject(subject);
                    StringBuffer tDescription = new StringBuffer();
                    tDescription.append(" \u81ea\u52a8\u5ba1\u6279\u7684\u4efb\u52a1\u5f71\u50cf\u8d85\u671f\u672a\u4e0a\u4f20" + tOutOfDate + "\u5929,\u4ece" + tOldCreditFilesInfo.getCreditRating().getName() + "\u7ea7\u522b\u964d\u7ea7\u4e3a");
                    tDescription.append(tCreditFilesInfo.getCreditRating().getName() + "\u7ea7\u522b");
                    tCreditLogInfo.setDescription(tDescription.toString());
                    tCreditLogColl.add((CoreBaseInfo)tCreditLogInfo);
                    CreditDeImageLogInfo tCreditDeImageLog = this.getCreditDeImageLog(ctx, jobid, tCreditImageId, creatorId, tDescription.toString());
                    tDeImageLogColl.add((CoreBaseInfo)tCreditDeImageLog);
                }
                CreditFilesNewFactory.getLocalInstance(ctx).update(tCreFilesColl);
                CreditLogFactory.getLocalInstance(ctx).addnew(tCreditLogColl);
                CreditDeImageLogFactory.getLocalInstance(ctx).addnew(tDeImageLogColl);
            }
            catch (Exception e) {
                logger.error((Object)("dealCreditDe error------------ " + e.getMessage()));
                e.printStackTrace();
            }
        } else {
            logger.error((Object)("jobList error------\u81ea\u52a8\u5ba1\u6279\u7684\u4efb\u52a1\u5f71\u50cf\u8d85\u671f\u672a\u4e0a\u4f20" + tOutOfDate + "\u5929------0 \u6761 "));
        }
    }

    private CreditDeImageLogInfo getCreditDeImageLog(Context ctx, String jodId, String creditImageId, String creatorId, String detionDescript) {
        CreditDeImageLogInfo tCreditDeImageLogInfo = new CreditDeImageLogInfo();
        tCreditDeImageLogInfo.setJobId(jodId);
        tCreditDeImageLogInfo.setCreditImageId(creditImageId);
        tCreditDeImageLogInfo.setBizCreatorId(creatorId);
        tCreditDeImageLogInfo.setDetionDescript(detionDescript);
        return tCreditDeImageLogInfo;
    }

    private Map getCreditScoreMap(Context ctx) {
        HashMap<Integer, CreditScoreInfo> tMap = new HashMap<Integer, CreditScoreInfo>();
        try {
            CreditScoreCollection tCreScoreColl = CreditScoreFactory.getLocalInstance(ctx).getCreditScoreCollection();
            if (tCreScoreColl != null && tCreScoreColl.size() > 0) {
                for (int index = 0; index < tCreScoreColl.size(); ++index) {
                    CreditScoreInfo tCreditScoreInfo = tCreScoreColl.get(index);
                    tMap.put(tCreditScoreInfo.getSeqNo(), tCreditScoreInfo);
                }
            }
        }
        catch (BOSException e) {
            tMap = null;
            e.printStackTrace();
        }
        return tMap;
    }

    public static void main(String[] args) {
        CreditDemotionForImageFacadeControllerBean tt = new CreditDemotionForImageFacadeControllerBean();
        System.out.println("ttttt");
    }
}

