/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.ssc.CreditFilesCollection;
import com.kingdee.eas.base.ssc.CreditFilesFactory;
import com.kingdee.eas.base.ssc.CreditFilesNewCollection;
import com.kingdee.eas.base.ssc.CreditFilesNewFactory;
import com.kingdee.eas.base.ssc.CreditFilesNewInfo;
import com.kingdee.eas.base.ssc.CreditLogFactory;
import com.kingdee.eas.base.ssc.CreditLogInfo;
import com.kingdee.eas.base.ssc.CreditScoreInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.app.AbstractCreditFilesNewControllerBean;
import com.kingdee.eas.base.ssc.app.ChangeSourceEnum;
import com.kingdee.eas.base.ssc.app.CreditChangeTypeEnum;
import com.kingdee.eas.base.ssc.tool.credit.CreditUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CreditFilesNewControllerBean
extends AbstractCreditFilesNewControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.CreditFilesNewControllerBean");

    @Override
    protected void _manualEdit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CreditFilesNewInfo filesInfo = null;
        if (model instanceof CreditFilesNewInfo) {
            filesInfo = (CreditFilesNewInfo)model;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection tSelectColl = new SelectorItemCollection();
        tSelectColl.add(new SelectorItemInfo("*"));
        tSelectColl.add(new SelectorItemInfo("creditRating.*"));
        viewInfo.setSelector(tSelectColl);
        FilterInfo filterReLevel = new FilterInfo();
        filterReLevel.appendFilterItem("id", (Object)pk.toString());
        viewInfo.setFilter(filterReLevel);
        CreditFilesNewCollection oldcreditFilesColl = CreditFilesNewFactory.getLocalInstance(ctx).getCreditFilesNewCollection(viewInfo);
        BigDecimal score_new = (BigDecimal)model.get("creditScore");
        CreditScoreInfo creditScore_new = CreditUtils.getCreditInfo(ctx, score_new);
        if (null == creditScore_new) {
            throw new SSCException(SSCException.UNKNOW, new Object[]{score_new + ResourceBase.getString((String)"com.kingdee.eas.base.ssc.SSCAutoGenerateResource", (String)"1281_CreditFilesControllerBean", (Locale)ctx.getLocale())});
        }
        model.put("creditRating", (Object)creditScore_new);
        CoreBaseCollection newcreditFilesColl = new CoreBaseCollection();
        newcreditFilesColl.add((CoreBaseInfo)filesInfo);
        this.writeCreditLogs(ctx, oldcreditFilesColl, newcreditFilesColl, creditScore_new, score_new);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _updateBatchFiles(Context ctx, String id, String creditRateId, String creditScore, String description) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection tSelectColl = new SelectorItemCollection();
        tSelectColl.add(new SelectorItemInfo("*"));
        tSelectColl.add(new SelectorItemInfo("creditRating.*"));
        viewInfo.setSelector(tSelectColl);
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet(Arrays.asList((Object[])id.split(",")));
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        CreditFilesNewCollection oldcreditFilesColl = CreditFilesNewFactory.getLocalInstance(ctx).getCreditFilesNewCollection(viewInfo);
        BigDecimal score_new = new BigDecimal(creditScore);
        CreditScoreInfo creditScore_new = CreditUtils.getCreditInfo(ctx, score_new);
        if (null == creditScore_new) {
            throw new SSCException(SSCException.UNKNOW, new Object[]{score_new + ResourceBase.getString((String)"com.kingdee.eas.base.ssc.SSCAutoGenerateResource", (String)"1281_CreditFilesControllerBean", (Locale)ctx.getLocale())});
        }
        CoreBaseCollection newcreditFilesColl = new CoreBaseCollection();
        CreditFilesNewInfo info = null;
        CreditScoreInfo creditScoreInfo = new CreditScoreInfo();
        creditScoreInfo.setId(creditScore_new.getId());
        for (int i = 0; i < oldcreditFilesColl.size(); ++i) {
            info = (CreditFilesNewInfo)oldcreditFilesColl.get(i).clone();
            info.setDescription(description);
            info.setCreditScore(new BigDecimal(creditScore));
            info.setCreditRating(creditScoreInfo);
            newcreditFilesColl.add((CoreBaseInfo)info);
        }
        this.writeCreditLogs(ctx, oldcreditFilesColl, newcreditFilesColl, creditScore_new, score_new);
        CreditFilesNewFactory.getLocalInstance(ctx).updateBatchData(newcreditFilesColl);
    }

    private void writeCreditLogs(Context ctx, CreditFilesNewCollection oldCreditFilesColl, CoreBaseCollection newCreditFilesColl, CreditScoreInfo creditScore_new, BigDecimal score_new) {
        CoreBaseCollection cores = new CoreBaseCollection();
        CreditLogInfo creditLogInfo = null;
        oldCreditFilesColl.sort("id");
        newCreditFilesColl.sort("id");
        for (int i = 0; i < oldCreditFilesColl.size(); ++i) {
            try {
                CreditFilesNewInfo oldCreditFiles = oldCreditFilesColl.get(i);
                if (oldCreditFiles.getCreditScore() == null || oldCreditFiles.getCreditRating() == null) continue;
                CreditFilesNewInfo newFilesInfo = (CreditFilesNewInfo)newCreditFilesColl.get(i);
                newFilesInfo.setUnqualifiedTotalNum(newFilesInfo.getUnqualifiedTotalNum() + 1);
                if (oldCreditFiles.getCreditScore().compareTo(score_new) < 0) {
                    creditLogInfo = !oldCreditFiles.getCreditRating().getName(ctx.getLocale()).equals(creditScore_new.getName(ctx.getLocale())) ? this.generateCreditLogs(ctx, creditScore_new, newFilesInfo, score_new, oldCreditFiles, 1) : this.generateCreditLogs(ctx, creditScore_new, newFilesInfo, score_new, oldCreditFiles, 3);
                } else if (oldCreditFiles.getCreditScore().compareTo(score_new) > 0) {
                    creditLogInfo = !oldCreditFiles.getCreditRating().getName(ctx.getLocale()).equals(creditScore_new.getName(ctx.getLocale())) ? this.generateCreditLogs(ctx, creditScore_new, newFilesInfo, score_new, oldCreditFiles, 2) : this.generateCreditLogs(ctx, creditScore_new, newFilesInfo, score_new, oldCreditFiles, 4);
                }
                if (creditLogInfo != null) {
                    cores.add(creditLogInfo);
                }
                CreditLogFactory.getLocalInstance(ctx).saveBatchData(cores);
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.base.ssc.SSCAutoGenerateResource", (String)"104_CreditFilesControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.base.ssc.SSCAutoGenerateResource", (String)"105_CreditFilesControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
            }
        }
    }

    private CreditLogInfo generateCreditLogs(Context ctx, CreditScoreInfo creditScore_new, CreditFilesNewInfo newFilesInfo, BigDecimal score_new, CreditFilesNewInfo oldCreditFiles, int i) {
        CreditLogInfo tCreditLogInfo = new CreditLogInfo();
        tCreditLogInfo.setCreditFilesNew(oldCreditFiles);
        tCreditLogInfo.setChangeSource(ChangeSourceEnum.manualUpdate);
        tCreditLogInfo.setOriginalGrade(oldCreditFiles.getCreditRating());
        tCreditLogInfo.setCurrentGrade(creditScore_new);
        tCreditLogInfo.setOriginalScore(oldCreditFiles.getCreditScore());
        tCreditLogInfo.setCurrentScore(score_new);
        tCreditLogInfo.setChangeScore(oldCreditFiles.getCreditScore().add(score_new.negate()).abs());
        if (oldCreditFiles.getCreditRating().getName(ctx.getLocale()).equals(creditScore_new.getName(ctx.getLocale()))) {
            tCreditLogInfo.setChangGrade(0);
        } else {
            tCreditLogInfo.setChangGrade(Math.abs(oldCreditFiles.getCreditRating().getSeqNo() - creditScore_new.getSeqNo()));
        }
        tCreditLogInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        tCreditLogInfo.setChangeDate(new Date());
        StringBuffer tDescription = new StringBuffer();
        if (i == 1) {
            tCreditLogInfo.setCreditChangeType(CreditChangeTypeEnum.upgrade);
        } else if (i == 2) {
            tCreditLogInfo.setCreditChangeType(CreditChangeTypeEnum.degrade);
        } else if (i == 3) {
            tCreditLogInfo.setCreditChangeType(CreditChangeTypeEnum.bonusPoint);
        } else if (i == 4) {
            tCreditLogInfo.setCreditChangeType(CreditChangeTypeEnum.deduction);
        }
        String des = newFilesInfo.getDescription(ctx.getLocale());
        des = StringUtils.isEmpty((String)des) ? "" : "\uff0c\u8bf4\u660e\uff1a" + des;
        tDescription.append("\u624b\u5de5\u4fee\u6539" + des + "\uff0c\u4ece" + Double.parseDouble(tCreditLogInfo.getOriginalScore().toString()) + "\u5206\u53d8\u66f4\u5230");
        tDescription.append(Double.parseDouble(tCreditLogInfo.getCurrentScore().toString()) + "\u5206\uff0c");
        tDescription.append("\u4ece" + oldCreditFiles.getCreditRating() + "\u7ea7\u53d8\u66f4\u5230");
        tDescription.append(tCreditLogInfo.getCurrentGrade() + "\u7ea7");
        tCreditLogInfo.setDescription(tDescription.toString());
        return tCreditLogInfo;
    }

    @Override
    protected CreditFilesNewInfo _getCreditFilesNewInfoByUserId(Context ctx, String userId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection tSelectColl = new SelectorItemCollection();
        tSelectColl.add(new SelectorItemInfo("*"));
        tSelectColl.add(new SelectorItemInfo("creditFilesNew.*"));
        tSelectColl.add(new SelectorItemInfo("creditFilesNew.org.*"));
        tSelectColl.add(new SelectorItemInfo("creditFilesNew.creditRating.*"));
        viewInfo.setSelector(tSelectColl);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userId", (Object)userId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        CreditFilesCollection infos = CreditFilesFactory.getLocalInstance(ctx).getCreditFilesCollection(viewInfo);
        if (0 == infos.size()) {
            return null;
        }
        CreditFilesNewInfo creditFilesNew = infos.get(0).getCreditFilesNew();
        creditFilesNew.setUserEmail(infos.get(0).getUserEmail());
        return creditFilesNew;
    }
}

