/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.ssc.CheckSchemeCollection;
import com.kingdee.eas.base.ssc.CheckSchemeFactory;
import com.kingdee.eas.base.ssc.DynamicAttributeCollection;
import com.kingdee.eas.base.ssc.DynamicAttributeFactory;
import com.kingdee.eas.base.ssc.DynamicAttributeInfo;
import com.kingdee.eas.base.ssc.IntelligentAuditCheckpointCollection;
import com.kingdee.eas.base.ssc.IntelligentAuditCheckpointFactory;
import com.kingdee.eas.base.ssc.IntelligentAuditExecuteRuleEntryInfo;
import com.kingdee.eas.base.ssc.JobLevelRuleCollection;
import com.kingdee.eas.base.ssc.JobLevelRuleFactory;
import com.kingdee.eas.base.ssc.PackageConfigCollection;
import com.kingdee.eas.base.ssc.PackageConfigFactory;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.SatisfactionDataFilteringRuleCollection;
import com.kingdee.eas.base.ssc.SatisfactionDataFilteringRuleFactory;
import com.kingdee.eas.base.ssc.SatisfactionSettingEntryCollection;
import com.kingdee.eas.base.ssc.SatisfactionSettingEntryFactory;
import com.kingdee.eas.base.ssc.StandardBillRuleCollection;
import com.kingdee.eas.base.ssc.StandardBillRuleFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.AbstractDynamicAttributeControllerBean;
import com.kingdee.eas.base.ssc.common.script.ScriptHelper;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynamicAttributeControllerBean
extends AbstractDynamicAttributeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.DynamicAttributeControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DynamicAttributeInfo info = (DynamicAttributeInfo)model;
        DataBaseInfo dbInfo = ShareCenterUtils.getShareCenterInfo(ctx);
        info.setShareCenterId(dbInfo.getId().toString());
        this._checkNumberDup(ctx, (IObjectValue)info);
        this._checkNameDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DynamicAttributeInfo dynamicAttributeInfo;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if ((dynamicAttributeInfo = (DynamicAttributeInfo)model).getBillType() != null) {
            filterItem = new FilterItemInfo("billType.id", (Object)dynamicAttributeInfo.getBillType().getId().toString());
            filter.getFilterItems().add(filterItem);
        }
        if (dynamicAttributeInfo.getShareCenterId() != null) {
            filterItem = new FilterItemInfo("shareCenterId", (Object)dynamicAttributeInfo.getShareCenterId());
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + " : " + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
        UserInfo userInfo = ShareCenterUtils.getSSCUserInfoByCtx(ctx);
        if (ShareCenterUtils.isCurrentUserSSCAdmin(ctx, userInfo)) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billType.id", (Object)dynamicAttributeInfo.getBillType().getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)ShareCenterUtils.getTopShareCenter(ctx).getId().toString(), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)dynamicAttributeInfo.getName()));
            viewInfo.setFilter(filterInfo);
            DynamicAttributeCollection dyColl = DynamicAttributeFactory.getLocalInstance(ctx).getDynamicAttributeCollection(viewInfo);
            if (dyColl.size() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u540d\u79f0\u91cd\u590d\uff0c\u5b50\u5171\u4eab\u4e2d\u5fc3\u5df2\u7ecf\u521b\u5efa\u4e86\u540d\u79f0\u4e3a " + dynamicAttributeInfo.getName() + " \u7684\u89c4\u5219\u5b57\u6bb5\uff01"));
            }
        } else {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billType.id", (Object)dynamicAttributeInfo.getBillType().getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)ShareCenterUtils.getTopShareCenter(ctx).getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)dynamicAttributeInfo.getName()));
            viewInfo.setFilter(filterInfo);
            DynamicAttributeCollection dyColl = DynamicAttributeFactory.getLocalInstance(ctx).getDynamicAttributeCollection(viewInfo);
            if (dyColl.size() > 0) {
                String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + " : " + dataBaseInfo.getName();
                throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
            }
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DynamicAttributeInfo info = (DynamicAttributeInfo)model;
        this._checkNumberDup(ctx, (IObjectValue)info);
        this._checkNameDup(ctx, (IObjectValue)info);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _isReferenced(Context ctx, IObjectPK pk, Connection cn) throws ObjectReferedException {
        try {
            super._isReferenced(ctx, pk, cn);
            DynamicAttributeInfo daInfo = (DynamicAttributeInfo)this.getDAO(ctx, cn).getValue(pk);
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 ba.fid, ar.fid, ar.fnumber,ar.fname_l2 ").append(" from t_ssc_dynamicAttribute da inner join t_ssc_bussinessAttribute ba on da.FBillTypeID = ba.FBillTypeID ").append(" inner join T_SSC_AssignRule ar on ba.fid=ar.FBussAttrID ").append(" where ar.fattrNumber like '%" + daInfo.getNumber() + ",%' and da.fid='" + pk + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                throw new Exception();
            }
        }
        catch (BOSException e) {
            if (e instanceof ObjectReferedException) {
                throw (ObjectReferedException)e;
            }
            throw new ObjectReferedException((Object)"assign rule ref", (Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            BizReference reference = new BizReference();
            reference.setRefTableName("T_SSC_AssignRule");
            reference.setRefFieldName("fattrNumber");
            reference.setRefEntityName("AssignRule");
            reference.setRefEntityAlias_L1("");
            reference.setRefEntityAlias_L2("\u4efb\u52a1\u5206\u914d\u89c4\u5219");
            reference.setRefEntityAlias_L3("");
            throw new ObjectReferedException((Object)reference);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DynamicAttributeInfo dynamicAttributeInfo;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if ((dynamicAttributeInfo = (DynamicAttributeInfo)model).getBillType() != null) {
            filterItem = new FilterItemInfo("billType.id", (Object)dynamicAttributeInfo.getBillType().getId().toString());
            filter.getFilterItems().add(filterItem);
        }
        if (dynamicAttributeInfo.getShareCenterId() != null) {
            filterItem = new FilterItemInfo("shareCenterId", (Object)dynamicAttributeInfo.getShareCenterId());
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " : " + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
        UserInfo userInfo = ShareCenterUtils.getSSCUserInfoByCtx(ctx);
        if (ShareCenterUtils.isCurrentUserSSCAdmin(ctx, userInfo)) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billType.id", (Object)dynamicAttributeInfo.getBillType().getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)ShareCenterUtils.getTopShareCenter(ctx).getId().toString(), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)dynamicAttributeInfo.getNumber()));
            viewInfo.setFilter(filterInfo);
            DynamicAttributeCollection dyColl = DynamicAttributeFactory.getLocalInstance(ctx).getDynamicAttributeCollection(viewInfo);
            if (dyColl.size() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u7f16\u7801\u91cd\u590d\uff0c\u5b50\u5171\u4eab\u4e2d\u5fc3\u5df2\u7ecf\u521b\u5efa\u4e86\u7f16\u7801\u4e3a " + dynamicAttributeInfo.getNumber() + " \u7684\u89c4\u5219\u5b57\u6bb5\uff01"));
            }
        } else {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billType.id", (Object)dynamicAttributeInfo.getBillType().getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)ShareCenterUtils.getTopShareCenter(ctx).getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)dynamicAttributeInfo.getNumber(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            DynamicAttributeCollection dyColl = DynamicAttributeFactory.getLocalInstance(ctx).getDynamicAttributeCollection(viewInfo);
            if (dyColl.size() > 0) {
                String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " : " + dataBaseInfo.getNumber();
                throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
            }
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DynamicAttributeInfo dynamicAttributeInfo = (DynamicAttributeInfo)DynamicAttributeFactory.getLocalInstance(ctx).getValue(pk);
        if (ShareCenterUtils.getShareCenterIdByCtx(ctx).equals(dynamicAttributeInfo.getShareCenterId())) {
            boolean refFlag = false;
            ArrayList<DynamicAttributeInfo> infoList = new ArrayList<DynamicAttributeInfo>();
            if (this.isUsedByJobLevelRule(ctx, dynamicAttributeInfo)) {
                refFlag = true;
                infoList.add(dynamicAttributeInfo);
            }
            if (this.isUsedByStandardBillRule(ctx, dynamicAttributeInfo)) {
                refFlag = true;
            }
            if (this.isUsedByCheckScheme(ctx, dynamicAttributeInfo)) {
                refFlag = true;
            }
            if (this.isUsedByIntelligentAuditCheck(ctx, dynamicAttributeInfo)) {
                refFlag = true;
            }
            if (this.isUsedByPackageConfig(ctx, dynamicAttributeInfo)) {
                refFlag = true;
            }
            if (this.isUsedByStandardBillRule(ctx, dynamicAttributeInfo)) {
                refFlag = true;
            }
            if (this.isUsedBySatisfaction(ctx, dynamicAttributeInfo)) {
                refFlag = true;
            }
            if (refFlag) {
                throw new SSCException(SSCException.DYVALUEISUSE, infoList.toArray());
            }
        } else {
            throw new SSCException(SSCException.SSC_BASEDATE_DELETE, new Object[]{dynamicAttributeInfo});
        }
        super._delete(ctx, pk);
    }

    private boolean isUsedByJobLevelRule(Context ctx, DynamicAttributeInfo dynamicAttributeInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bussType.billType.id", (Object)dynamicAttributeInfo.getBillType().getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        JobLevelRuleCollection beColl = JobLevelRuleFactory.getLocalInstance(ctx).getJobLevelRuleCollection(view);
        for (int i = 0; i < beColl.size(); ++i) {
            String script = beColl.get(i).getScript();
            List scriptEntry = ScriptHelper.parseScript2MapList(script);
            if (scriptEntry == null) continue;
            for (int j = 0; j < scriptEntry.size(); ++j) {
                Map hashMap = (Map)scriptEntry.get(j);
                String dynamicAtt = (String)hashMap.get("dynamicAtt");
                if (!dynamicAtt.contains(dynamicAttributeInfo.getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUsedByIntelligentAuditCheck(Context ctx, DynamicAttributeInfo dynamicAttributeInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)dynamicAttributeInfo.getBillType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("shareCenterID", (Object)dynamicAttributeInfo.getShareCenterId(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("executRule.compareValue");
        selectorItemCollection.add("executRule.compareField");
        view.setSelector(selectorItemCollection);
        IntelligentAuditCheckpointCollection beColl = IntelligentAuditCheckpointFactory.getLocalInstance(ctx).getIntelligentAuditCheckpointCollection(view);
        for (int i = 0; i < beColl.size(); ++i) {
            for (int j = 0; j < beColl.get(i).getExecuteRule().size(); ++j) {
                IntelligentAuditExecuteRuleEntryInfo info = beColl.get(i).getExecuteRule().get(j);
                String bu = "{@" + dynamicAttributeInfo.getNumber() + "}";
                if (!bu.equals(info.getCompareField()) && !bu.equals(info.getCompareValue())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUsedByPackageConfig(Context ctx, DynamicAttributeInfo dynamicAttributeInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bussAttr.billType.id", (Object)dynamicAttributeInfo.getBillType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("shareCenterID", (Object)dynamicAttributeInfo.getShareCenterId(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("entry.attrNumber");
        view.setSelector(selectorItemCollection);
        PackageConfigCollection pcColl = PackageConfigFactory.getLocalInstance(ctx).getPackageConfigCollection(view);
        for (int i = 0; i < pcColl.size(); ++i) {
            for (int j = 0; j < pcColl.get(i).getEntry().size(); ++j) {
                if (!pcColl.get(i).getEntry().get(j).getAttrNumber().contains(dynamicAttributeInfo.getId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUsedByCheckScheme(Context ctx, DynamicAttributeInfo dynamicAttributeInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)dynamicAttributeInfo.getBillType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)dynamicAttributeInfo.getShareCenterId(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("checkRange.property");
        view.setSelector(selectorItemCollection);
        CheckSchemeCollection csColl = CheckSchemeFactory.getLocalInstance(ctx).getCheckSchemeCollection(view);
        for (int i = 0; i < csColl.size(); ++i) {
            for (int j = 0; j < csColl.get(i).getCheckRange().size(); ++j) {
                if (!dynamicAttributeInfo.getNumber().equals(csColl.get(i).getCheckRange().get(j).getProperty())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUsedBySatisfaction(Context ctx, DynamicAttributeInfo dynamicAttributeInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billtypeName", (Object)dynamicAttributeInfo.getBillType().getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SatisfactionSettingEntryCollection ssColl = SatisfactionSettingEntryFactory.getLocalInstance(ctx).getSatisfactionSettingEntryCollection(view);
        for (int i = 0; i < ssColl.size(); ++i) {
            EntityViewInfo view1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            if (null == ssColl.get(i).getDataFilterRule()) continue;
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ssColl.get(i).getDataFilterRule().toString(), CompareType.EQUALS));
            view.setFilter(filter1);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("entrys.property");
            view.setSelector(selectorItemCollection);
            SatisfactionDataFilteringRuleCollection sdColl = SatisfactionDataFilteringRuleFactory.getLocalInstance(ctx).getSatisfactionDataFilteringRuleCollection(view1);
            for (int j = 0; j < sdColl.size(); ++j) {
                for (int k = 0; k < sdColl.get(j).getEntrys().size(); ++k) {
                    if (!dynamicAttributeInfo.getNumber().equals(sdColl.get(j).getEntrys().get(k).getProperty())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isUsedByStandardBillRule(Context ctx, DynamicAttributeInfo dynamicAttributeInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bussAttr.billType.id", (Object)dynamicAttributeInfo.getBillType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("shareCenterID", (Object)dynamicAttributeInfo.getShareCenterId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("attrNumber", (Object)dynamicAttributeInfo.getNumber(), CompareType.LIKE));
        view.setFilter(filter);
        StandardBillRuleCollection sbColl = StandardBillRuleFactory.getLocalInstance(ctx).getStandardBillRuleCollection(view);
        return sbColl.size() > 0;
    }
}

