/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.ssc.AnalysisEnum;
import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.SatisfactionBillInquireCollection;
import com.kingdee.eas.base.ssc.SatisfactionBillInquireFactory;
import com.kingdee.eas.base.ssc.SatisfactionBillInquireInfo;
import com.kingdee.eas.base.ssc.SatisfactionDimensionEntryInfo;
import com.kingdee.eas.base.ssc.SatisfactionSettingFactory;
import com.kingdee.eas.base.ssc.SatisfactionSettingInfo;
import com.kingdee.eas.base.ssc.StfcBillInquireDimensionEntryCollection;
import com.kingdee.eas.base.ssc.StfcBillInquireDimensionEntryInfo;
import com.kingdee.eas.base.ssc.YesOrNo;
import com.kingdee.eas.base.ssc.analysis.ThreadPoll.AnalysisFlowFactory;
import com.kingdee.eas.base.ssc.analysis.ThreadPoll.IAnalysisFlowCallback;
import com.kingdee.eas.base.ssc.analysis.util.AnalysisData;
import com.kingdee.eas.base.ssc.app.AbstractSatisfactionOutdateAutoEvaluationFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.SatisfactionEvaluateEnum;
import com.kingdee.eas.base.ssc.app.SatisfactionHisAssess;
import com.kingdee.eas.base.ssc.app.SatisfactionHisSendEnum;
import com.kingdee.eas.base.ssc.app.erp.ERPUtil;
import com.kingdee.eas.base.ssc.app.erp.ERPWebService;
import com.kingdee.eas.base.ssc.app.erp.ERPWebServiceBill;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.base.ssc.workDate.WorkDateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SatisfactionOutdateAutoEvaluationFacadeControllerBean
extends AbstractSatisfactionOutdateAutoEvaluationFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.SatisfactionOutdateAutoEvaluationFacadeControllerBean");

    @Override
    protected boolean _automaticEvaluation(Context ctx, String defaultDate, String shareCenterNumber) throws BOSException, EASBizException {
        int days = 5;
        if (StringUtils.isNotBlank((String)defaultDate)) {
            try {
                days = Integer.parseInt(defaultDate);
            }
            catch (Exception e) {
                logger.error((Object)("SatisfactionOutdateAutoEvaluationFacadeControllerBean \u540e\u53f0\u53c2\u6570\u8f6c\u6362\u51fa\u5dee" + defaultDate + " " + e.getMessage()), (Throwable)e);
            }
        }
        if (StringUtils.isEmpty((String)shareCenterNumber)) {
            List<DataBaseInfo> list = ShareCenterUtils.getAllValidShareCenterInfo(ctx);
            for (int i = 0; i < list.size(); ++i) {
                DataBaseInfo shareCenterInfo = list.get(i);
                String isSatisfaction = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK(shareCenterInfo.getId().toString()), (String)"SSC_SatisfactionControl");
                if (!"true".equals(isSatisfaction)) continue;
                this.runAutoSatisfaction(ctx, shareCenterInfo.getId().toString(), days);
            }
            return true;
        }
        DataBaseInfo shareCenterInfo = ShareCenterUtils.getShareCenterInfoByNumber(ctx, shareCenterNumber);
        String isSatisfaction = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK(shareCenterInfo.getId().toString()), (String)"SSC_SatisfactionControl");
        if (!"true".equals(isSatisfaction)) {
            return false;
        }
        this.runAutoSatisfaction(ctx, shareCenterInfo.getId().toString(), days);
        return false;
    }

    private boolean runAutoSatisfaction(Context ctx, String shareCenterId, int days) {
        try {
            int i;
            String dateStr = WorkDateUtil.getInstance(ctx, shareCenterId, false).getFullDate(new Date(), -days);
            Date date = this.getDateByString(dateStr);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)shareCenterId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isEvaluate", (Object)SatisfactionHisAssess.nuAssess));
            filter.getFilterItems().add(new FilterItemInfo("sendOfdate", (Object)date, CompareType.LESS));
            filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)date, CompareType.LESS));
            filter.getFilterItems().add(new FilterItemInfo("satisfactionHisSend", (Object)SatisfactionHisSendEnum.unSend));
            filter.setMaskString("#0 and #1 and (#2 or (#3 and #4))");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("jobhisid.id");
            sic.add("jobhisid.billID");
            view.setFilter(filter);
            view.setSelector(sic);
            SatisfactionBillInquireCollection coll = SatisfactionBillInquireFactory.getLocalInstance(ctx).getSatisfactionBillInquireCollection(view);
            SatisfactionSettingInfo setInfo = SatisfactionSettingFactory.getLocalInstance(ctx).getValueBySCOrg(H.PK(shareCenterId));
            CoreBaseCollection core = new CoreBaseCollection();
            String[] jobList = new String[coll.size()];
            for (int i2 = 0; i2 < coll.size(); ++i2) {
                SatisfactionBillInquireInfo info = coll.get(i2);
                info.setEvaluateOfdate(new Timestamp(new Date().getTime()));
                info.setEvaluateResult(SatisfactionEvaluateEnum.contentment);
                this.setDimensions(ctx, info, setInfo, SatisfactionEvaluateEnum.contentment);
                info.setAutoEvaluate(YesOrNo.Yes);
                info.setIsEvaluate(SatisfactionHisAssess.hisAssess);
                jobList[i2] = info.getJobhisid().getBillID();
                core.add((CoreBaseInfo)info);
            }
            SatisfactionBillInquireFactory.getLocalInstance(ctx).updateBatchData(core);
            IAnalysisFlowCallback ctr = AnalysisFlowFactory.getInstanse("com.kingdee.eas.base.ssc.analysis.ThreadPoll.AnalysisThreadPool");
            for (i = 0; i < jobList.length; ++i) {
                try {
                    AnalysisData analysisJobData = new AnalysisData();
                    analysisJobData.setAnalysisType("bill").setDate(new Date()).setUuid(jobList[i]).setOperateType(AnalysisEnum.BILL_SATISFIED);
                    ctr.afterFlow(ctx, analysisJobData);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            for (i = 0; i < coll.size(); ++i) {
                ExtendERPInfo extendERPInfo = ERPUtil.getExtendERPInfo(ctx, coll.get(i).getJobhisid().getId().toString());
                try {
                    ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, extendERPInfo.getId().toString());
                    if (service == null) {
                        throw new BOSException("can not find ERPWebServiceImpl");
                    }
                    if (!(service instanceof ERPWebServiceBill)) {
                        throw new BOSException(service + " is not a instanceof AbstractERPWebService!");
                    }
                    ((ERPWebServiceBill)((Object)service)).sendSatisfaction(ctx, extendERPInfo, coll.get(i).getJobhisid().getBillID());
                    logger.error((Object)("****JobId***: " + coll.get(i).getJobhisid().getId().toString() + " *****billID*****: " + coll.get(i).getJobhisid().getBillID()));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private void setDimensions(Context ctx, SatisfactionBillInquireInfo info, SatisfactionSettingInfo setInfo, SatisfactionEvaluateEnum evaluateEnum) throws BOSException {
        StfcBillInquireDimensionEntryCollection entries = new StfcBillInquireDimensionEntryCollection();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < setInfo.getDimensionEntry().size(); ++i) {
            StfcBillInquireDimensionEntryInfo billInquire = new StfcBillInquireDimensionEntryInfo();
            billInquire.setParent(info);
            SatisfactionDimensionEntryInfo satisfactionDimensionEntryInfo = setInfo.getDimensionEntry().get(i);
            billInquire.setDimension(satisfactionDimensionEntryInfo);
            billInquire.setName(satisfactionDimensionEntryInfo.getName());
            billInquire.setNumber(satisfactionDimensionEntryInfo.getNumber());
            billInquire.setEvaluateResult(evaluateEnum);
            entries.add(billInquire);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", satisfactionDimensionEntryInfo.getId().toString());
            map.put("name", satisfactionDimensionEntryInfo.getName());
            map.put("number", satisfactionDimensionEntryInfo.getNumber());
            map.put("score", Math.abs(Integer.parseInt(evaluateEnum.getValue()) - 4) + "");
            arrayList.add(map);
        }
        info.setDimensionStr(JSONUtils.convertObjectToJson((Context)ctx, arrayList));
        info.put("dimension", (Object)entries);
    }

    private Date getDateByString(String d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(d);
        }
        catch (ParseException e) {
            logger.error((Object)("*****************ParseException************" + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

