/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.ssc.SpotCheckFollowEntryCollection;
import com.kingdee.eas.base.ssc.SpotCheckFollowEntryInfo;
import com.kingdee.eas.base.ssc.SpotCheckFollowFactory;
import com.kingdee.eas.base.ssc.SpotCheckFollowInfo;
import com.kingdee.eas.base.ssc.app.AbstractSpotCheckFollowFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.CheckSchemeTimeType;
import com.kingdee.eas.base.ssc.thread.NoticeImageSysArchThread;
import com.kingdee.eas.base.ssc.tool.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;

public class SpotCheckFollowFacadeControllerBean
extends AbstractSpotCheckFollowFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.SpotCheckFollowFacadeControllerBean");

    @Override
    protected void _enable(Context ctx, BOSUuid planId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("enable"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        SpotCheckFollowInfo scfInfo = new SpotCheckFollowInfo();
        scfInfo.setId(planId);
        scfInfo.setEnable(true);
        scfInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
        SpotCheckFollowFactory.getLocalInstance(ctx).updatePartial(scfInfo, sic);
    }

    @Override
    protected void _disable(Context ctx, BOSUuid planId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("enable"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        SpotCheckFollowInfo scfInfo = new SpotCheckFollowInfo();
        scfInfo.setId(planId);
        scfInfo.setEnable(false);
        scfInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
        SpotCheckFollowFactory.getLocalInstance(ctx).updatePartial(scfInfo, sic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _execute(Context ctx, String checkFollowId) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean flag = mutexService.requestObjIDForUpdate(checkFollowId, ctx.getUserName());
        if (!flag) {
            throw new EASBizException(new NumericExceptionSubItem("CheckScheme is currently in use!", "\u65b9\u6848\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u4f7f\u7528\uff01"));
        }
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("entries.*"));
            selector.add(new SelectorItemInfo("entries.billType.id"));
            selector.add(new SelectorItemInfo("enable"));
            selector.add(new SelectorItemInfo("timeType"));
            selector.add(new SelectorItemInfo("startDate"));
            selector.add(new SelectorItemInfo("endDate"));
            selector.add(new SelectorItemInfo("scOrg"));
            SpotCheckFollowInfo spotCheckFollowInfo = SpotCheckFollowFactory.getLocalInstance(ctx).getSpotCheckFollowInfo((IObjectPK)new ObjectUuidPK(checkFollowId), selector);
            if (!spotCheckFollowInfo.isEnable()) {
                return;
            }
            Date startDate = null;
            Date endDate = null;
            if (spotCheckFollowInfo.getTimeType() == CheckSchemeTimeType.between) {
                startDate = spotCheckFollowInfo.getStartDate();
                endDate = spotCheckFollowInfo.getEndDate();
            } else {
                Timestamp[] dates = DateUtil.getDatesByTimeType(spotCheckFollowInfo.getTimeType());
                startDate = dates[0];
                endDate = dates[1];
            }
            SpotCheckFollowEntryCollection entries = spotCheckFollowInfo.getEntries();
            CountDownLatch countDownLatch = new CountDownLatch(entries.size());
            for (int i = 0; i < entries.size(); ++i) {
                SpotCheckFollowEntryInfo spotCheckFollowEntryInfo = entries.get(i);
                if (1 == spotCheckFollowEntryInfo.getExecuteState()) {
                    countDownLatch.countDown();
                    continue;
                }
                new Thread(new NoticeImageSysArchThread(ctx, countDownLatch, spotCheckFollowEntryInfo, spotCheckFollowInfo.getScOrg().getId().toString(), startDate, endDate)).start();
            }
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            mutexService.releaseObjIDForUpdate(checkFollowId);
        }
    }
}

