/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.RoleUserCollection;
import com.kingdee.eas.base.ssc.RoleUserFactory;
import com.kingdee.eas.base.ssc.UserDimissionStateTimeFactory;
import com.kingdee.eas.base.ssc.UserDimissionStateTimeInfo;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserGroupFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.WorkingState;
import com.kingdee.eas.base.ssc.app.AbstractUserControllerBean;
import com.kingdee.eas.base.ssc.app.DimissionState;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UserControllerBean
extends AbstractUserControllerBean {
    private static final long serialVersionUID = -162074615401118350L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.UserControllerBean");

    private boolean isExistTreatedTask(Context ctx, String userId) throws SQLException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select count(1) from t_ssc_jobhis j");
        sb.append(" where j.FPersonnelIDID = ?;");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{userId});
        int treatedTaskNum = 0;
        if (rs.next()) {
            treatedTaskNum = rs.getInt(1);
        }
        return treatedTaskNum > 0;
    }

    private boolean isExistUntreatedTask(Context ctx, String userId) throws SQLException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select sum(num) num from ( ");
        sb.append(" select count(1) num from t_ssc_job j");
        sb.append(" where j.FPersonnelIDID = ?");
        sb.append(" and j.FJobPoolingType = '2'");
        sb.append(" union all ");
        sb.append(" select count(1) from t_ssc_jobhis j");
        sb.append(" where j.FPersonnelIDID = ?");
        sb.append(" ) temp ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{userId, userId});
        int untreatedTaskNum = 0;
        if (rs.next()) {
            untreatedTaskNum = rs.getInt(1);
        }
        return untreatedTaskNum > 0;
    }

    private boolean isChildSSCAdmin(Context ctx, String userId) throws SQLException, BOSException {
        String sql = "select u.fid from t_ssc_user u inner join t_ssc_roleuser ru on u.fid = ru.FUSERIDID inner join t_ssc_role r on ru.FROLEIDID = r.fid where u.fid = ? and  r.FROLETYPEIDID = '/4qlL+q5zE2iZxXCPaHgBC0WZ4A='";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userId});
        return rs.next();
    }

    private boolean checkDelete(Context ctx, String userId) throws SQLException, BOSException {
        return !this.isExistUntreatedTask(ctx, userId) && !this.isChildSSCAdmin(ctx, userId);
    }

    @Override
    protected boolean _isBizAdmin(Context ctx, String userId, String bussinessAttributeId) throws BOSException, EASBizException {
        if (StringUtils.isBlank((String)userId)) {
            throw new BOSException("userId is not null");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userID.id", (Object)userId));
        if (!StringUtils.isBlank((String)bussinessAttributeId)) {
            filter.getFilterItems().add(new FilterItemInfo("roleID.bussattr.bussName.id", (Object)bussinessAttributeId));
        }
        filter.getFilterItems().add(new FilterItemInfo("roleID.roleTypeID.id", (Object)"hEw8bwRNR8qPRPajcUdX4C0WZ4A="));
        view.setFilter(filter);
        RoleUserCollection coll = RoleUserFactory.getLocalInstance(ctx).getRoleUserCollection(view);
        return coll != null && coll.size() != 0;
    }

    @Override
    protected boolean _isBizAudit(Context ctx, String userId, String bussinessAttributeId) throws BOSException, EASBizException {
        if (StringUtils.isBlank((String)userId)) {
            throw new BOSException("userId is not null");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userID.id", (Object)userId));
        if (!StringUtils.isBlank((String)bussinessAttributeId)) {
            filter.getFilterItems().add(new FilterItemInfo("roleID.bussattr.billName.id", (Object)bussinessAttributeId));
        }
        filter.getFilterItems().add(new FilterItemInfo("roleID.roleTypeID.id", (Object)"BqMHsn0QTrafsG4XPzjMpC0WZ4A="));
        view.setFilter(filter);
        RoleUserCollection coll = RoleUserFactory.getLocalInstance(ctx).getRoleUserCollection(view);
        return coll != null && coll.size() != 0;
    }

    @Override
    protected boolean _isBizLater(Context ctx, String userId, String bussinessAttributeId) throws BOSException, EASBizException {
        if (StringUtils.isBlank((String)userId)) {
            throw new BOSException("userId is not null");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userID.id", (Object)userId));
        if (!StringUtils.isBlank((String)bussinessAttributeId)) {
            filter.getFilterItems().add(new FilterItemInfo("roleID.bussattr.billName.id", (Object)bussinessAttributeId));
        }
        filter.getFilterItems().add(new FilterItemInfo("roleID.roleTypeID.id", (Object)"o9Taq/+5QSKDMQrAQo+1uS0WZ4A="));
        view.setFilter(filter);
        RoleUserCollection coll = RoleUserFactory.getLocalInstance(ctx).getRoleUserCollection(view);
        return coll != null && coll.size() != 0;
    }

    @Override
    protected boolean _isQuality(Context ctx, String userId, String bussinessAttributeId) throws BOSException, EASBizException {
        if (StringUtils.isBlank((String)userId)) {
            throw new BOSException("userId is not null");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userID.id", (Object)userId));
        if (!StringUtils.isBlank((String)bussinessAttributeId)) {
            filter.getFilterItems().add(new FilterItemInfo("roleID.bussattr.billName.id", (Object)bussinessAttributeId));
        }
        filter.getFilterItems().add(new FilterItemInfo("roleID.roleTypeID.id", (Object)"dH8LikDSRvuYwxTuw5HhRC0WZ4A="));
        view.setFilter(filter);
        RoleUserCollection coll = RoleUserFactory.getLocalInstance(ctx).getRoleUserCollection(view);
        return coll != null && coll.size() != 0;
    }

    @Override
    protected boolean _isBizPerson(Context ctx, String userId, String bussinessAttributeId) throws BOSException, EASBizException {
        if (StringUtils.isBlank((String)userId)) {
            throw new BOSException("userId is not null");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userID.id", (Object)userId));
        if (!StringUtils.isBlank((String)bussinessAttributeId)) {
            filter.getFilterItems().add(new FilterItemInfo("roleID.bussattr.bussName.id", (Object)bussinessAttributeId));
        }
        filter.getFilterItems().add(new FilterItemInfo("roleID.roleTypeID.id", (Object)"F68lZzqpRWC1K1nV8ZYPgS0WZ4A="));
        view.setFilter(filter);
        RoleUserCollection coll = RoleUserFactory.getLocalInstance(ctx).getRoleUserCollection(view);
        return coll != null && coll.size() != 0;
    }

    @Override
    protected boolean _isCreditFilesManager(Context ctx, String userId, String bussinessAttributeId) throws BOSException, EASBizException {
        if (StringUtils.isBlank((String)userId)) {
            throw new BOSException("userId is not null");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userID.id", (Object)userId));
        if (!StringUtils.isBlank((String)bussinessAttributeId)) {
            filter.getFilterItems().add(new FilterItemInfo("roleID.bussattr.bussName.id", (Object)bussinessAttributeId));
        }
        filter.getFilterItems().add(new FilterItemInfo("roleID.roleTypeID.id", (Object)"MvHxSZbdRYqug4E/DXHfES0WZ4A="));
        view.setFilter(filter);
        RoleUserCollection coll = RoleUserFactory.getLocalInstance(ctx).getRoleUserCollection(view);
        return coll != null && coll.size() != 0;
    }

    @Override
    protected boolean _isRecheckAdmin(Context ctx, String userId, String bussinessAttributeId) throws BOSException {
        if (StringUtils.isBlank((String)userId)) {
            throw new BOSException("userId is not null");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userID.id", (Object)userId));
        if (!StringUtils.isBlank((String)bussinessAttributeId)) {
            filter.getFilterItems().add(new FilterItemInfo("roleID.bussattr.billName.id", (Object)bussinessAttributeId));
        }
        filter.getFilterItems().add(new FilterItemInfo("roleID.roleTypeID.id", (Object)"6Wn1FlPySgCeSKzwlcjYqy0WZ4A="));
        view.setFilter(filter);
        RoleUserCollection coll = RoleUserFactory.getLocalInstance(ctx).getRoleUserCollection(view);
        return coll != null && coll.size() != 0;
    }

    @Override
    protected List _deleteUserInfos(Context ctx, List userIds) throws BOSException, EASBizException {
        ArrayList noDeleteUser = new ArrayList();
        for (Object id : userIds) {
            try {
                UserInfo user;
                HashMap<String, String> result = new HashMap<String, String>();
                String idstr = id.toString();
                if (this.isExistUntreatedTask(ctx, idstr)) {
                    user = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)idstr)));
                    result.put("name", user.getName());
                    result.put("errorType", "0");
                    noDeleteUser.add(result);
                    continue;
                }
                if (this.isChildSSCAdmin(ctx, idstr)) {
                    user = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)idstr)));
                    result.put("name", user.getName());
                    result.put("errorType", "1");
                    noDeleteUser.add(result);
                    continue;
                }
                if (this.isExistTreatedTask(ctx, idstr)) {
                    user = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)idstr)));
                    result.put("name", user.getName());
                    result.put("errorType", "2");
                    noDeleteUser.add(result);
                    continue;
                }
                String uoql = "where id = '" + idstr + "'";
                UserFactory.getLocalInstance(ctx).delete(uoql);
                String ruoql = "where userID = '" + idstr + "'";
                RoleUserFactory.getLocalInstance(ctx).delete(ruoql);
                String ugoql = "where user = '" + idstr + "'";
                UserGroupFactory.getLocalInstance(ctx).delete(ugoql);
            }
            catch (UuidException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return noDeleteUser;
    }

    @Override
    protected String _dimission(Context ctx, String jsonStr) throws BOSException, EASBizException {
        HashMap map = JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr);
        String userId = (String)map.get("userId");
        UserInfo userinfo = UserFactory.getLocalInstance(ctx).getUserInfo("select * where id = '" + userId + "' ");
        try {
            if (userinfo != null && userinfo.getDimission().getValue() == 1) {
                userinfo.setDimission(WorkingState.leave);
                UserFactory.getLocalInstance(ctx).save((CoreBaseInfo)userinfo);
                UserDimissionStateTimeInfo info = new UserDimissionStateTimeInfo();
                info.setUserID(userinfo);
                info.setDimissionState(DimissionState.Dimission);
                info.setChangeTime(new Timestamp(System.currentTimeMillis()));
                UserDimissionStateTimeFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
            }
        }
        catch (Exception e) {
            logger.error((Object)("sql:&&&&&" + e.getMessage()));
            logger.error((Object)("sql1:&&&&&" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected String _getJobtime(Context ctx, String json) throws BOSException, EASBizException {
        HashMap map = JSONUtils.convertJsonToObject((Context)ctx, (String)json);
        String userId = (String)map.get("userId");
        String shareCenterId = (String)map.get("shareCenterId");
        IRowSet rs0 = null;
        IRowSet rs1 = null;
        IRowSet rs2 = null;
        String state = null;
        long dimissionTime = 0L;
        long onTheTime = 0L;
        long lastchangetime = 0L;
        double time = 0.0;
        String sql0 = "select FDimissionState state,FChangeTime changetime from t_ssc_UserDimissionStateTime  where fchangetime < CURDATE()+1 and CURDATE()<fchangetime and FDimissionState ='0' and FUserID = ?";
        String sql1 = "select FDimissionState state,FChangeTime changetime from t_ssc_UserDimissionStateTime where fchangetime < CURDATE()+1 and CURDATE()<fchangetime and FDimissionState ='1' and FUserID = ?";
        String sql2 = "select FDimissionState state,FChangeTime changetime from t_ssc_UserDimissionStateTime  where fchangetime < CURDATE()+1 and CURDATE()<fchangetime and FUserID = ?  order by fchangetime desc";
        HashMap<String, Object> mapRte = new HashMap<String, Object>();
        try {
            rs0 = DbUtil.executeQuery((Context)ctx, (String)sql0, (Object[])new Object[]{userId});
            while (rs0.next()) {
                long changetime = rs0.getTimestamp("changetime").getTime();
                dimissionTime += changetime;
            }
        }
        catch (Exception e) {
            logger.error((Object)("sql0:" + sql0 + "...userId:" + userId));
        }
        try {
            rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{userId});
            while (rs1.next()) {
                long changetime = rs1.getTimestamp("changetime").getTime();
                onTheTime += changetime;
            }
        }
        catch (Exception e) {
            logger.error((Object)("sql1:" + sql1 + "...userId:" + userId));
        }
        try {
            rs2 = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{userId});
            if (rs2.next()) {
                state = rs2.getString("state");
                lastchangetime = rs2.getTimestamp("changetime").getTime();
            }
        }
        catch (Exception e) {
            logger.error((Object)("sql2:" + sql2 + "...userId:" + userId));
        }
        if ("0".equals(state)) {
            time = (double)(dimissionTime - onTheTime) / 3600000.0;
        } else if ("1".equals(state)) {
            long nowtime = new Timestamp(System.currentTimeMillis()).getTime();
            time = (double)(dimissionTime + nowtime - onTheTime) / 3600000.0;
        } else {
            state = "1";
            time = 0.0;
        }
        if (time < 0.0 || time > 24.0) {
            time = this.dealIssueDate(ctx, userId);
        }
        BigDecimal bigDecimal = new BigDecimal(time);
        bigDecimal = bigDecimal.setScale(2, 4);
        mapRte.put("state", state);
        mapRte.put("time", bigDecimal);
        return JSONUtils.convertObjectToJson((Context)ctx, mapRte);
    }

    private double dealIssueDate(Context ctx, String userId) {
        String sql = "select FDimissionState state,FChangeTime changetime from t_ssc_UserDimissionStateTime  where fchangetime < CURDATE()+1 and CURDATE()<fchangetime  and FUserID = ? order by fchangetime asc ";
        IRowSet rs = null;
        String state = "2";
        String endState = "2";
        long dimissionTime = 0L;
        long onTheTime = 0L;
        double time = 0.0;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userId});
            while (rs.next()) {
                String tempState = rs.getString("state");
                if (rs.isFirst()) {
                    "0".equals(tempState);
                    continue;
                }
                if (state.equalsIgnoreCase(tempState)) {
                    state = tempState;
                    endState = tempState;
                    continue;
                }
                if ("0".equalsIgnoreCase(tempState)) {
                    dimissionTime += rs.getTimestamp("changetime").getTime();
                } else {
                    onTheTime += rs.getTimestamp("changetime").getTime();
                }
                state = tempState;
                endState = tempState;
            }
        }
        catch (Exception e) {
            logger.error((Object)("sql1:" + sql));
        }
        if ("0".equals(endState)) {
            time = (double)(dimissionTime - onTheTime) / 3600000.0;
        } else if ("1".equals(endState)) {
            long nowtime = new Timestamp(System.currentTimeMillis()).getTime();
            time = (double)(dimissionTime + nowtime - onTheTime) / 3600000.0;
        } else {
            state = "1";
            time = 0.0;
        }
        return time;
    }

    @Override
    protected String _onTheJob(Context ctx, String jsonStr) throws BOSException, EASBizException {
        HashMap map = JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr);
        String userId = (String)map.get("userId");
        String shareCenterId = (String)map.get("shareCenterId");
        UserInfo userinfo = UserFactory.getLocalInstance(ctx).getUserInfo("select * where id = '" + userId + "' ");
        IRowSet rs = null;
        try {
            String sql = "select FDimissionState from t_ssc_UserDimissionStateTime where CURDATE()<fchangetime and FUserID = ? order by fchangetime desc ";
            if (userinfo != null && userinfo.getDimission().getValue() == 0) {
                userinfo.setDimission(WorkingState.working);
                UserFactory.getLocalInstance(ctx).save((CoreBaseInfo)userinfo);
                UserDimissionStateTimeInfo info = new UserDimissionStateTimeInfo();
                info.setUserID(userinfo);
                info.setDimissionState(DimissionState.OnTheJob);
                info.setChangeTime(new Timestamp(System.currentTimeMillis()));
                UserDimissionStateTimeFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
            } else if (userinfo != null && userinfo.getDimission().getValue() == 1) {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userId});
                String state = "";
                if (rs.next()) {
                    state = rs.getString("FDimissionState");
                }
                if (!"1".equals(state + "")) {
                    UserDimissionStateTimeInfo info = new UserDimissionStateTimeInfo();
                    info.setUserID(userinfo);
                    info.setDimissionState(DimissionState.OnTheJob);
                    info.setChangeTime(new Timestamp(System.currentTimeMillis()));
                    UserDimissionStateTimeFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("sql:&&&&&" + e.getMessage()));
            logger.error((Object)("sql1:&&&&&" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

