/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkpointext.compare.function;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.function.AggregationFunction;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.DataInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.FieldModelInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.ModelTypeEnum;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SumFunction
extends AggregationFunction {
    @Override
    public DataInfo execute(DataInfo args, String columnNames) {
        List<BigDecimal> listForCalculate = CheckPointUtils.getListForCalculate(args, columnNames);
        if (listForCalculate == null || listForCalculate.isEmpty()) {
            return args;
        }
        BigDecimal result = SumFunction.getSum(listForCalculate);
        args.setType(ModelTypeEnum.Field);
        FieldModelInfo fieldModelInfo = new FieldModelInfo();
        fieldModelInfo.setF(columnNames);
        fieldModelInfo.setV(result.stripTrailingZeros().toPlainString());
        ArrayList<FieldModelInfo> fieldModelInfos = new ArrayList<FieldModelInfo>();
        fieldModelInfos.add(fieldModelInfo);
        args.setFieldModels(fieldModelInfos);
        return args;
    }

    protected static BigDecimal getSum(List<BigDecimal> listForCalculate) {
        String expression = "reduce(list , + , 0)";
        Expression compile = AviatorEvaluator.compile((String)expression);
        HashMap<String, List<BigDecimal>> env = new HashMap<String, List<BigDecimal>>();
        env.put("list", listForCalculate);
        BigDecimal result = BigDecimal.ZERO;
        Object execute = compile.execute(env);
        result = execute instanceof Long ? new BigDecimal((Long)execute) : (BigDecimal)execute;
        return result;
    }

    @Override
    public String getFunctionName() {
        return "sum";
    }

    @Override
    public String getFunctionAlias() {
        return "\u6c42\u548c(" + this.getFunctionName() + ")";
    }

    @Override
    public String getFunctionDesc() {
        return "\u6c42\u548c\u51fd\u6570\uff1a\u4e00\u4e2a\u53c2\u6570\uff0c\u6570\u5b57\u7c7b\u578b\u3002\n\u53c2\u6570\u4e00\u822c\u8bbe\u7f6e\u5206\u5f55\u5b57\u6bb5\uff0c\u6c42\u591a\u6761\u5206\u5f55\u4e2d\u8be5\u5b57\u6bb5\u7684\u548c\u3002";
    }

    @Override
    public String getFuncParamType() {
        return "0:false";
    }
}

