/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkscheme.node.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.ssc.AssignException;
import com.kingdee.eas.base.ssc.CheckSchemeInfo;
import com.kingdee.eas.base.ssc.CheckTypeEnum;
import com.kingdee.eas.base.ssc.SampleLibraryFactory;
import com.kingdee.eas.base.ssc.SampleLibraryInfo;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskCollection;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskInfo;
import com.kingdee.eas.base.ssc.SampleStateEnum;
import com.kingdee.eas.base.ssc.app.assign.node.pojo.NodeTrackPojo;
import com.kingdee.eas.base.ssc.app.checkscheme.node.impl.AbstractCheckSchemeNode;
import com.kingdee.eas.base.ssc.assign.AssignFlowNodeInfo;
import com.kingdee.eas.base.ssc.assign.AssignModelInfo;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Collections;
import java.util.List;

public class CreateJobNode
extends AbstractCheckSchemeNode {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAssignee4MatchSuccess(Context ctx, AssignFlowNodeInfo assignFlowNode, AssignModelInfo modelInfo) throws AssignException {
        CheckSchemeInfo checkSchemeInfo = (CheckSchemeInfo)modelInfo.getDynamicAttributes("schemeInfo");
        List updateBillIds = (List)modelInfo.getDynamicAttributes("updateBillIds");
        SampleLibraryQualityTaskCollection taskCollection = (SampleLibraryQualityTaskCollection)((Object)modelInfo.getDynamicAttributes("taskCollection"));
        NodeTrackPojo nodeTrack = new NodeTrackPojo("\u751f\u6210\u4efb\u52a1");
        try {
            if (updateBillIds.size() > 0) {
                this.updateJobHis(ctx, checkSchemeInfo, updateBillIds, nodeTrack);
            }
            nodeTrack.setDesc(nodeTrack.getDesc() + "\u66f4\u65b0\u5386\u53f2\u4efb\u52a1\u8bb0\u5f55\uff1a" + updateBillIds.size() + "\u6761\uff1b");
            String samplePk = this.saveSampleTask(ctx, checkSchemeInfo, taskCollection);
            nodeTrack.setDesc(nodeTrack.getDesc() + "\u751f\u6210\u7684\u6837\u672c\u5e93ID\uff1a\u3010" + samplePk + "\u3011\uff1b");
            modelInfo.setTaskId(BOSUuid.read((String)samplePk));
            modelInfo.setDynamicAttributes("samplePk", samplePk);
            modelInfo.removeDynamicAttributes("updateBillIds");
            modelInfo.removeDynamicAttributes("taskCollection");
        }
        finally {
            try {
                this.saveNodeTrack(ctx, modelInfo, nodeTrack.getValues());
            }
            catch (Exception e) {
                logger.error((Object)("\u4fdd\u5b58\u8282\u70b9\u8ddf\u8e2a\u8bb0\u5f55\u5931\u8d25" + e.getMessage()), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private String saveSampleTask(Context ctx, CheckSchemeInfo checkSchemeInfo, SampleLibraryQualityTaskCollection taskCollection) throws AssignException {
        SampleLibraryInfo sample = new SampleLibraryInfo();
        String sampleNumber = null;
        sample.setCheckScheme(checkSchemeInfo);
        sample.setCheckType(checkSchemeInfo.getCheckType());
        sample.setDescription(checkSchemeInfo.getDescription(ctx.getLocale()), ctx.getLocale());
        sample.setState(SampleStateEnum.Undistributed);
        try {
            sampleNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)sample, "");
        }
        catch (Exception e) {
            throw new AssignException(new NumericExceptionSubItem("001", "\u83b7\u53d6\u6837\u672c\u5e93\u7f16\u7801\u5931\u8d25\uff01"), e);
        }
        sample.setNumber(sampleNumber);
        sample.setName(sampleNumber, ctx.getLocale());
        int count = 0;
        int len = taskCollection.size();
        for (int i = 0; i < len; ++i) {
            SampleLibraryQualityTaskInfo taskInfo = taskCollection.get(i);
            taskInfo.setNumber(sampleNumber + this.formatNumber(++count));
        }
        sample.put("QualityTask", (Object)taskCollection);
        try {
            IObjectPK objectPK = SampleLibraryFactory.getLocalInstance(ctx).save((CoreBaseInfo)sample);
            return objectPK.toString();
        }
        catch (Exception e) {
            throw new AssignException(new NumericExceptionSubItem("001", "\u4fdd\u5b58\u6837\u672c\u5e93\u6570\u636e\u5931\u8d25\uff01"), e);
        }
    }

    private void updateJobHis(Context ctx, CheckSchemeInfo checkSchemeInfo, List<String> updateBillids, NodeTrackPojo nodeTrack) throws AssignException {
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update t_ssc_jobhis set fcheckType = ? where fcheckType != ? and fbillid in ").append(FormatUtils.collection2Sql(updateBillids)).append(";");
        updateSql.append("update t_ssc_jobhis set fcheckType = ? where (fcheckType = ? or fcheckType is null) and fbillid in ").append(FormatUtils.collection2Sql(updateBillids)).append(";");
        String jobCheckType = CheckTypeEnum.afterAudit.equals((Object)checkSchemeInfo.getCheckType()) ? "1" : "2";
        try {
            nodeTrack.setDesc("\u66f4\u65b0\u4efb\u52a1\u8868SQL\uff1a" + updateSql);
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{"3", "0", jobCheckType, "0"});
        }
        catch (BOSException e) {
            throw new AssignException(new NumericExceptionSubItem("001", "\u66f4\u65b0\u5386\u53f2\u4efb\u52a1\u5b57\u6bb5\u5931\u8d25\uff01"), e);
        }
    }

    private String formatNumber(int number) {
        String numStr = String.valueOf(number);
        StringBuffer result = new StringBuffer(numStr);
        if (numStr != null && numStr.length() <= 4) {
            for (int i = 0; i < 4 - numStr.length(); ++i) {
                result.insert(0, "0");
            }
        }
        return result.toString();
    }
}

