/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.erp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.ExtendERPFactory;
import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskInfo;
import com.kingdee.eas.base.ssc.app.JobUtil;
import com.kingdee.eas.base.ssc.app.erp.ERPWebService;
import com.kingdee.eas.base.ssc.app.erp.eas.CommonUtil;
import com.kingdee.eas.base.ssc.app.erp.eas.EASCfgUtil;
import com.kingdee.eas.base.ssc.app.erp.eas.EASWebServiceHandler;
import com.kingdee.eas.base.ssc.app.erp.webserviceproxy.ERPWebServiceDynamicProxy;
import com.kingdee.eas.base.ssc.app.erp.webserviceproxy.ERPWebServiceInvocation;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ERPUtil {
    private static Logger logger = Logger.getLogger(ERPUtil.class);
    public static ConcurrentHashMap<String, ERPWebService> insMap = new ConcurrentHashMap();

    public static ERPWebService getERPWebServiceImpl(Context ctx, String roleId) throws BOSException {
        if (StringUtils.isEmpty((String)roleId)) {
            logger.error((Object)"roleId is null,can not find ERPWebServiceImpl");
            throw new BOSException("roleId is null,can not find ERPWebServiceImpl");
        }
        String handler = ERPUtil.getHandlerByRole(ctx, roleId);
        return ERPUtil.getERPWebServiceImpl(ctx, handler.split(";")[0], handler.split(";")[1]);
    }

    public static ERPWebService getERPWebServiceImplByJob(Context ctx, String jobId) throws BOSException {
        if (StringUtils.isEmpty((String)jobId)) {
            logger.error((Object)"jobId is null,can not find ERPWebServiceImpl");
            throw new BOSException("jobId is null,can not find ERPWebServiceImpl");
        }
        String handler = ERPUtil.getHandlerByJob(ctx, jobId);
        return ERPUtil.getERPWebServiceImpl(ctx, handler.split(";")[0], handler.split(";")[1]);
    }

    public static ERPWebService getERPWebServiceImplByTask(Context ctx, String bussAtrrID) throws BOSException {
        if (StringUtils.isEmpty((String)bussAtrrID)) {
            logger.error((Object)"bussAtrrID is null,can not find ERPWebServiceImpl");
            throw new BOSException("bussAtrrID is null,can not find ERPWebServiceImpl");
        }
        String handler = ERPUtil.getHandlerByTask(ctx, bussAtrrID);
        return ERPUtil.getERPWebServiceImpl(ctx, handler.split(";")[0], handler.split(";")[1]);
    }

    public static ERPWebService getERPWebServiceImplByERPId(Context ctx, String extendERPId) throws BOSException {
        if (StringUtils.isEmpty((String)extendERPId)) {
            logger.error((Object)"extendERPId is null,can not find ERPWebServiceImpl");
            throw new BOSException("extendERPId is null,can not find ERPWebServiceImpl");
        }
        String handler = ERPUtil.getHandlerByERPId(ctx, extendERPId);
        return ERPUtil.getERPWebServiceImpl(ctx, handler, extendERPId);
    }

    public static ERPWebService getERPWebServiceImpl(Context ctx, String handler, String extendERPId) throws BOSException {
        if (StringUtils.isEmpty((String)handler)) {
            logger.error((Object)"ERPWebServiceImpl is null");
            throw new BOSException("ERPWebServiceImpl is null");
        }
        ERPWebService proxy = insMap.get(ctx.getAIS() + ";" + extendERPId);
        if (proxy == null) {
            try {
                Class<?> o = Class.forName(handler);
                ERPWebService retSer = (ERPWebService)o.newInstance();
                ExtendERPInfo extendERPInfo = ExtendERPFactory.getLocalInstance(ctx).getExtendERPInfo((IObjectPK)new ObjectUuidPK(extendERPId));
                String deployType = EASCfgUtil.getValue(ctx, extendERPInfo, "deployType");
                if (StringUtils.isEmpty((String)deployType)) {
                    deployType = EASWebServiceHandler.DPLOY_TYPE_UNION;
                }
                if (EASWebServiceHandler.DPLOY_TYPE_INDEPENDENT.equals(deployType)) {
                    extendERPInfo.setString("ais", ctx.getAIS());
                    ERPWebServiceInvocation serviceInvocation = new ERPWebServiceInvocation(retSer, extendERPInfo, CommonUtil.getEASLoginBean(ctx, extendERPInfo));
                    proxy = (ERPWebService)new ERPWebServiceDynamicProxy(retSer, serviceInvocation).getERPWebServiceProxy();
                } else {
                    proxy = retSer;
                }
                ERPWebService service = insMap.putIfAbsent(ctx.getAIS() + ";" + extendERPId, proxy);
                if (service != null) {
                    proxy = service;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return proxy;
    }

    public static ERPWebService getERPWebServiceImpl(String handler) throws BOSException {
        if (StringUtils.isEmpty((String)handler)) {
            logger.error((Object)"ERPWebServiceImpl is null");
            throw new BOSException("ERPWebServiceImpl is null");
        }
        ERPWebService retSer = insMap.get(handler);
        if (retSer == null) {
            try {
                Class<?> o = Class.forName(handler);
                retSer = (ERPWebService)o.newInstance();
                insMap.put(handler, retSer);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return retSer;
    }

    private static Boolean getRoleTypeByRoleId(Context ctx, String roleId) {
        String sql = "select rt.fnumber from t_ssc_role r  inner join t_ssc_roletype rt on r.froletypeidid=rt.fid where r.fid='" + roleId + "' and rt.fnumber in ('ROLE_BIZ','ROLE_BIZADMIN')";
        boolean flag = false;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                flag = true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        return flag;
    }

    private static String getHandlerByRole(Context ctx, String roleId) throws BOSException {
        Boolean flag = ERPUtil.getRoleTypeByRoleId(ctx, roleId);
        String sql1 = new StringBuffer().append(" select ERP.FImpleClass,ERP.fid from T_SSC_ExtendErp as ERP ").append(" inner join T_SSC_SystemAttribute as System ").append(" on ERP.FID = System.FExtendErpID ").append(" inner join T_SSC_billtype as billtype ").append(" on System.FID = billtype.fsysattrid ").append(" inner join (select role.fid,rb.fbillnameid from  t_ssc_role role inner join  T_SSC_RoleBussattr rb on role.fid= rb.fparentid ) tem ").append(" on billtype.FID = tem.fbillnameid ").append(" where tem.FID = ? ").toString();
        String sql2 = new StringBuffer().append(" select ERP.FImpleClass,ERP.fid from T_SSC_ExtendErp as ERP ").append(" inner join T_SSC_SystemAttribute as System ").append(" on ERP.FID = System.FExtendErpID ").append(" inner join t_ssc_billtype as sb on sb.FSYSATTRID = System.fid ").append(" inner join T_SSC_BussinessAttribute as BussAttr ").append(" on sb.FID = BussAttr.FBILLTYPEID ").append(" inner join (select role.fid,rb.fbussnameid from  t_ssc_role role inner join  T_SSC_RoleBussattr rb on role.fid= rb.fparentid ) tem ").append(" on BussAttr.FID = tem.fbussnameid ").append(" where tem.FID = ? ").toString();
        IRowSet rowSet = null;
        try {
            rowSet = flag != false ? DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{roleId}) : DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{roleId});
            if (rowSet.next()) {
                return rowSet.getString(1) + ";" + rowSet.getString(2);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private static String getHandlerByJob(Context ctx, String jobId) throws BOSException {
        try {
            String tableName = "T_SSC_JOB";
            if (!JobUtil.isCurrent(ctx, jobId)) {
                tableName = "T_SSC_JOBHIS";
            }
            String sql = new StringBuffer().append("select ERP.FImpleClass,ERP.fid  from T_SSC_ExtendErp as ERP").append(" inner join T_SSC_SystemAttribute as System").append(" on ERP.FID = System.FExtendErpID").append(" inner join t_ssc_billtype as sb on sb.FSYSATTRID = System.fid ").append(" inner join T_SSC_BussinessAttribute as BussAttr ").append(" on sb.FID = BussAttr.FBILLTYPEID ").append(" inner join ").append(tableName).append(" as Job").append(" on BussAttr.FID = Job.FBussAttrIDID").append(" where Job.FID = ?").toString();
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{jobId});
            if (rowSet.next()) {
                return rowSet.getString(1) + ";" + rowSet.getString(2);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private static String getHandlerByTask(Context ctx, String bussAtrrID) throws BOSException {
        try {
            String sql = new StringBuffer().append("select ERP.FImpleClass from T_SSC_ExtendErp as ERP").append(" inner join T_SSC_SystemAttribute as System").append(" on ERP.FID = System.FExtendErpID").append(" inner join t_ssc_billtype as sb on sb.FSYSATTRID = System.fid ").append(" inner join T_SSC_BussinessAttribute as BussAttr ").append(" on sb.FID = BussAttr.FBILLTYPEID ").append(" where BussAttr.FID = ?").toString();
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bussAtrrID});
            if (rowSet.next()) {
                return rowSet.getString(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static String getERPIdByJobId(Context ctx, String jobId) throws BOSException {
        try {
            String tableName = "T_SSC_JOB";
            if (!JobUtil.isCurrent(ctx, jobId)) {
                tableName = "T_SSC_JOBHIS";
            }
            String sql = new StringBuffer().append("select ERP.FId from T_SSC_ExtendErp as ERP").append(" inner join T_SSC_SystemAttribute as System").append(" on ERP.FID = System.FExtendErpID").append(" inner join t_ssc_billtype as sb on sb.FSYSATTRID = System.fid ").append(" inner join T_SSC_BussinessAttribute as BussAttr ").append(" on sb.FID = BussAttr.FBILLTYPEID ").append(" inner join ").append(tableName).append(" as Job").append(" on BussAttr.FID = Job.FBussAttrIDID").append(" where Job.FID = ?").toString();
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{jobId});
            if (rowSet.next()) {
                return rowSet.getString(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static ExtendERPInfo getExtendERPInfo(Context ctx, JobInfo jobInfo) throws BOSException {
        return ERPUtil.getExtendERPInfo(ctx, jobInfo.getId().toString());
    }

    public static ExtendERPInfo getExtendERPInfo(Context ctx, SampleLibraryQualityTaskInfo taskInfo) throws BOSException {
        return ERPUtil.getExtendERPInfo(ctx, taskInfo.getId().toString());
    }

    public static ExtendERPInfo getExtendERPInfo(Context ctx, String jobId) throws BOSException {
        try {
            String tableName = "T_SSC_JOB";
            if (!JobUtil.isCurrent(ctx, jobId)) {
                tableName = "T_SSC_JOBHIS";
            }
            String sb = ERPUtil.getetExtendERPSql(ctx, tableName);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb, (Object[])new Object[]{jobId});
            if (rs.next()) {
                String extendErpId = rs.getString(1);
                return ExtendERPFactory.getLocalInstance(ctx).getExtendERPInfo((IObjectPK)new ObjectUuidPK(extendErpId));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static String getetExtendERPSql(Context ctx, String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select d.fid from ").append(tableName).append(" a ").append(" inner join t_ssc_bussinessAttribute b on a.fbussattrIDID = b.fid ").append(" inner join t_ssc_billtype bt on b.fbilltypeid=bt.fid ").append(" inner join t_ssc_systemattribute c on bt.fsysattrid = c.fid ").append(" inner join t_ssc_extenderp d on c.fextendErpid = d.fid ").append(" where a.fid = ? ");
        return sb.toString();
    }

    public static ExtendERPInfo getExtendERPInfo(Context ctx, String jobId, boolean isHis) throws BOSException {
        try {
            String tableName = "T_SSC_JOB";
            if (isHis) {
                tableName = "T_SSC_JOBHIS";
            }
            String sb = ERPUtil.getetExtendERPSql(ctx, tableName);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb, (Object[])new Object[]{jobId});
            if (rs.next()) {
                String extendErpId = rs.getString(1);
                return ExtendERPFactory.getLocalInstance(ctx).getExtendERPInfo((IObjectPK)new ObjectUuidPK(extendErpId));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static ExtendERPInfo getExtendERPInfos(Context ctx, String bussAttrID) throws BOSException {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select d.fid from t_ssc_bussinessAttribute b ").append(" inner join t_ssc_billtype bt on b.fbilltypeid = bt.fid ").append(" inner join t_ssc_systemattribute c on bt.fsysattrid = c.fid ").append(" inner join t_ssc_extenderp d on c.fextendErpid = d.fid ").append(" where b.fid = ? ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{bussAttrID});
            if (rs.next()) {
                String extendErpId = rs.getString(1);
                return ExtendERPFactory.getLocalInstance(ctx).getExtendERPInfo((IObjectPK)new ObjectUuidPK(extendErpId));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static ExtendERPInfo getExtendERPInfoByID(Context ctx, String extendERPId) throws EASBizException, BOSException {
        ExtendERPInfo extendERPInfo = ExtendERPFactory.getLocalInstance(ctx).getExtendERPInfo((IObjectPK)new ObjectUuidPK(extendERPId));
        return extendERPInfo;
    }

    private static String getHandlerByERPId(Context ctx, String extendERPId) throws BOSException {
        String sql = new StringBuffer().append("select ERP.FImpleClass from T_SSC_ExtendErp as ERP").append(" where ERP.FID = ?").toString();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{extendERPId});
            if (rowSet.next()) {
                return rowSet.getString(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static String getERPIdByRoleId(Context ctx, String roleId) throws BOSException {
        Boolean flag = ERPUtil.getRoleTypeByRoleId(ctx, roleId);
        String sql1 = new StringBuffer().append(" select ERP.fid from T_SSC_ExtendErp as ERP ").append(" inner join T_SSC_SystemAttribute as System ").append(" on ERP.FID = System.FExtendErpID ").append(" inner join T_SSC_billtype as billtype ").append(" on System.FID = billtype.fsysattrid ").append(" inner join (select role.fid,rb.fbillnameid from  t_ssc_role role inner join  T_SSC_RoleBussattr rb on role.fid= rb.fparentid ) tem ").append(" on billtype.FID = tem.fbillnameid ").append(" where tem.FID = ? ").toString();
        String sql2 = new StringBuffer().append(" select ERP.Fid from T_SSC_ExtendErp as ERP ").append(" inner join T_SSC_SystemAttribute as System ").append(" on ERP.FID = System.FExtendErpID ").append(" inner join t_ssc_billtype as sb on sb.FSYSATTRID = System.fid ").append(" inner join T_SSC_BussinessAttribute as BussAttr ").append(" on sb.FID = BussAttr.FBILLTYPEID ").append(" inner join (select role.fid,rb.fbussnameid from  t_ssc_role role inner join  T_SSC_RoleBussattr rb on role.fid= rb.fparentid ) tem ").append(" on BussAttr.FID = tem.fbussnameid ").append(" where tem.FID = ? ").toString();
        IRowSet rowSet = null;
        try {
            rowSet = flag != false ? DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{roleId}) : DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{roleId});
            if (rowSet.next()) {
                return rowSet.getString(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Deprecated
    public static String getERPIdByBizId(Context ctx, String bizId) throws BOSException {
        String sql = new StringBuffer().append("select ERP.Fid from T_SSC_ExtendErp as ERP").append(" inner join T_SSC_SystemAttribute as System").append(" on ERP.FID = System.FExtendErpID").append(" inner join t_ssc_billtype as sb on sb.FSYSATTRID = System.fid ").append(" inner join T_SSC_BussinessAttribute as BussAttr ").append(" on sb.FID = BussAttr.FBILLTYPEID ").append(" where BussAttr.FID = ?").toString();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bizId});
            if (rowSet.next()) {
                return rowSet.getString(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static ExtendERPInfo getERPInfoByBizId(Context ctx, String bizId) throws BOSException {
        String sql = new StringBuffer().append("select ERP.Fid, ERP.Fnumber, ERP.FOrgExtendERPId from T_SSC_ExtendErp as ERP").append(" inner join T_SSC_SystemAttribute as System").append(" on ERP.FID = System.FExtendErpID").append(" inner join t_ssc_billtype as sb on sb.FSYSATTRID = System.fid ").append(" inner join T_SSC_BussinessAttribute as BussAttr ").append(" on sb.FID = BussAttr.FBILLTYPEID ").append(" where BussAttr.FID = ?").toString();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bizId});
            if (rowSet.next()) {
                ExtendERPInfo info = new ExtendERPInfo();
                info.setId(BOSUuid.read((String)rowSet.getString(1)));
                info.setNumber(rowSet.getString(2));
                ExtendERPInfo orgInfo = new ExtendERPInfo();
                orgInfo.setId(BOSUuid.read((String)rowSet.getString(3)));
                info.setOrgExtendERPId(orgInfo);
                return info;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

