/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.erp.check.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.ssc.InteligentAuditParamsCollection;
import com.kingdee.eas.base.ssc.InteligentAuditParamsFactory;
import com.kingdee.eas.base.ssc.InteligentAuditParamsInfo;
import com.kingdee.eas.base.ssc.IntelligentAuditCheckpointInfo;
import com.kingdee.eas.base.ssc.JobFactory;
import com.kingdee.eas.base.ssc.JobHisFactory;
import com.kingdee.eas.base.ssc.app.erp.IntelligentCheckService;
import com.kingdee.eas.base.ssc.app.erp.check.constant.InvoiceConstant;
import com.kingdee.eas.base.ssc.tool.CheckPointUtils;
import com.kingdee.eas.common.EASBizException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class BaseCheckService
implements IntelligentCheckService,
InvoiceConstant {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.erp.check.BaseCheckService");
    protected static Cache<String, Object> cache = CacheBuilder.newBuilder().maximumSize(20L).expireAfterWrite(5L, TimeUnit.SECONDS).build();

    @Override
    public abstract Map<String, String> check(Map var1);

    public String getBillId(Map map) {
        String billId = null;
        try {
            Context ctx = (Context)map.get("ctx");
            String jobId = (String)map.get("jobId");
            if (JobFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(jobId))) {
                billId = JobFactory.getLocalInstance(ctx).getJobInfo((IObjectPK)new ObjectUuidPK(jobId)).getBillID();
            } else if (JobHisFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(jobId))) {
                billId = JobHisFactory.getLocalInstance(ctx).getJobHisInfo((IObjectPK)new ObjectUuidPK(jobId)).getBillID();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return billId;
    }

    public void intParam(Map map) {
        Context ctx = (Context)map.get("ctx");
        String jobId = (String)map.get("jobId");
        IntelligentAuditCheckpointInfo checkpointInfo = (IntelligentAuditCheckpointInfo)map.get("checkPoint");
        InteligentAuditParamsCollection colls = new InteligentAuditParamsCollection();
        try {
            colls = InteligentAuditParamsFactory.getLocalInstance(ctx).getInteligentAuditParamsCollection("where parent.id = '" + checkpointInfo.getId().toString() + "' order by seq asc");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (colls == null || colls.isEmpty()) {
            return;
        }
        HashMap<Integer, Object> param = new HashMap<Integer, Object>();
        for (int i = 0; i < colls.size(); ++i) {
            InteligentAuditParamsInfo paramsInfo = colls.get(i);
            try {
                if ("BILLFIELD".equals(paramsInfo.getType().getValue())) {
                    String realKey = CheckPointUtils.getRealKey(ctx, paramsInfo.getValue(), jobId);
                    param.put(i, realKey);
                } else if ("STRING".equals(paramsInfo.getType().getValue())) {
                    param.put(i, String.valueOf(paramsInfo.getValue()));
                } else if ("NUMBER".equals(paramsInfo.getType().getValue())) {
                    param.put(i, new BigDecimal(paramsInfo.getValue()));
                } else if ("DATE".equals(paramsInfo.getType().getValue())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date date = sdf.parse(paramsInfo.getValue());
                    param.put(i, date);
                }
                System.out.println();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"\u53c2\u6570\u5b57\u6bb5\u83b7\u53d6\u5931\u8d25\uff0c\u7f6e\u7a7a\u5904\u7406", (Throwable)e);
                param.put(i, null);
            }
        }
        map.put("param", param);
    }

    public String cutFirstAndEnd(String str) {
        return str.substring(1, str.length() - 1);
    }

    private Map<String, String> getResultMap(String isSuceess, String msg, String errorCode) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("isSuceess", isSuceess);
        resultMap.put("msg", msg);
        resultMap.put("errorCode", errorCode);
        return resultMap;
    }

    public Map<String, String> printLogAndReturnMap(String isSuceess, String msg, String errorCode) {
        logger.error((Object)(msg + "\n" + errorCode));
        return this.getResultMap(isSuceess, msg, errorCode);
    }
}

