/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.erp.check.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.app.erp.check.constant.InvoiceConstant;
import com.kingdee.eas.base.ssc.app.erp.check.exception.CheckException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class InvoiceAmountUtil
implements InvoiceConstant {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.erp.check.InvoiceAmountUtil");
    private static final String INCOME_AMOUNT_SQL = "select ftotalAmount from T_TM_CommonSpecialInvoice where fbizbillId=?";
    private static final String INCOME_NEW_AMOUNT_SQL = "select FAmount from T_IM_IncomeInvoice where FBizBillID=?";
    private static final String MACHINE_AMOUNT_SQL = "select ftotalAmount from T_TM_MachineInvoice where fbizbillId=?";
    private static final String OTHER_AMOUNT_SQL = "select ftotalAmount from T_TM_OtherInvoice where fbizbillId=?";
    private static final String PLANE_AMOUNT_SQL = "select ftotalAmount from T_TM_PlaneInvoice where fbizbillId=?";
    private static final String PURCHASE_AMOUNT_SQL = "select ftotalAmount from T_TM_PurchaseInvoice where fbizbillId=?";
    private static final String QUOTA_AMOUNT_SQL = "select ftotalAmount from T_TM_QuotaInvoice where fbizbillId=?";
    private static final String SECONDHANDCAR_AMOUNT_SQL = "select ftotalAmount from T_TM_SecondHandCarInvoice where fbizbillId=?";
    private static final String SHIP_AMOUNT_SQL = "select ftotalAmount from T_TM_ShipInvoice where fbizbillId=?";
    private static final String TAXI_AMOUNT_SQL = "select ftotalAmount from T_TM_TaxiInvoice where fbizbillId=?";
    private static final String TOLL_AMOUNT_SQL = "select ftotalAmount from T_TM_TollInvoice where fbizbillId=?";
    private static final String TRAIN_AMOUNT_SQL = "select ftotalAmount from T_TM_TrainInvoice where fbizbillId=?";
    private static final String VEHICLE_AMOUNT_SQL = "select ftotalAmount from T_TM_VehicleInvoice where fbizbillId=?";

    private static BigDecimal getAmount(Context ctx, String sql, String billId) {
        BigDecimal totalAmount = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
            while (rs.next()) {
                totalAmount = rs.getBigDecimal(1);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return totalAmount;
    }

    public static BigDecimal getInvoicesTotalAmount(Context ctx, String billId) throws CheckException {
        BigDecimal totalAmount = null;
        BigDecimal incomeAmount = InvoiceAmountUtil.getAmount(ctx, INCOME_AMOUNT_SQL, billId);
        totalAmount = InvoiceAmountUtil.add(totalAmount, incomeAmount);
        BigDecimal incomeAmountNew = InvoiceAmountUtil.getAmount(ctx, INCOME_NEW_AMOUNT_SQL, billId);
        totalAmount = InvoiceAmountUtil.add(totalAmount, incomeAmountNew);
        BigDecimal machineAmount = InvoiceAmountUtil.getAmount(ctx, MACHINE_AMOUNT_SQL, billId);
        totalAmount = InvoiceAmountUtil.add(totalAmount, machineAmount);
        BigDecimal otherAmount = InvoiceAmountUtil.getAmount(ctx, OTHER_AMOUNT_SQL, billId);
        totalAmount = InvoiceAmountUtil.add(totalAmount, otherAmount);
        BigDecimal planeAmount = InvoiceAmountUtil.getAmount(ctx, PLANE_AMOUNT_SQL, billId);
        totalAmount = InvoiceAmountUtil.add(totalAmount, planeAmount);
        BigDecimal purchaseAmount = InvoiceAmountUtil.getAmount(ctx, PURCHASE_AMOUNT_SQL, billId);
        totalAmount = InvoiceAmountUtil.add(totalAmount, purchaseAmount);
        BigDecimal quotaAmount = InvoiceAmountUtil.getAmount(ctx, QUOTA_AMOUNT_SQL, billId);
        totalAmount = InvoiceAmountUtil.add(totalAmount, quotaAmount);
        BigDecimal secondhandcarAmount = InvoiceAmountUtil.getAmount(ctx, SECONDHANDCAR_AMOUNT_SQL, billId);
        totalAmount = InvoiceAmountUtil.add(totalAmount, secondhandcarAmount);
        BigDecimal shipAmount = InvoiceAmountUtil.getAmount(ctx, SHIP_AMOUNT_SQL, billId);
        totalAmount = InvoiceAmountUtil.add(totalAmount, shipAmount);
        BigDecimal taxiAmount = InvoiceAmountUtil.getAmount(ctx, TAXI_AMOUNT_SQL, billId);
        totalAmount = InvoiceAmountUtil.add(totalAmount, taxiAmount);
        BigDecimal tollAmount = InvoiceAmountUtil.getAmount(ctx, TOLL_AMOUNT_SQL, billId);
        totalAmount = InvoiceAmountUtil.add(totalAmount, tollAmount);
        BigDecimal trainAmount = InvoiceAmountUtil.getAmount(ctx, TRAIN_AMOUNT_SQL, billId);
        totalAmount = InvoiceAmountUtil.add(totalAmount, trainAmount);
        BigDecimal vehicleAmount = InvoiceAmountUtil.getAmount(ctx, VEHICLE_AMOUNT_SQL, billId);
        totalAmount = InvoiceAmountUtil.add(totalAmount, vehicleAmount);
        return totalAmount;
    }

    private static BigDecimal add(BigDecimal a, BigDecimal b) {
        if (null != b) {
            if (null == a) {
                a = new BigDecimal(0);
            }
            return a.add(b);
        }
        return a;
    }
}

