/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.base.ssc.JobHisCollection;
import com.kingdee.eas.base.ssc.JobHisFactory;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.SscMultiApproveCollection;
import com.kingdee.eas.base.ssc.SscMultiApproveInfo;
import com.kingdee.eas.base.ssc.TimeStatisticalProcessFactory;
import com.kingdee.eas.base.ssc.TimeStatisticalProcessInfo;
import com.kingdee.eas.base.ssc.app.erp.ERPUtil;
import com.kingdee.eas.base.ssc.app.erp.ERPWebService;
import com.kingdee.eas.base.ssc.app.erp.ERPWebServiceBill;
import com.kingdee.eas.base.ssc.tool.FillDataUtils;
import com.kingdee.eas.base.ssc.workDate.WorkDateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WPConsumingTimeStatistical {
    private static Logger logger = Logger.getLogger(WPConsumingTimeStatistical.class);

    public void execute(Context ctx, Map<String, String> map, String shareCenterId) throws BOSException, EASBizException {
        Set<String> keySet = map.keySet();
        Iterator<String> it = keySet.iterator();
        WorkDateUtil workDUtil = WorkDateUtil.getInstance(ctx, shareCenterId, true);
        CoreBaseCollection coreBaseCol = new CoreBaseCollection();
        while (it.hasNext()) {
            String billId = it.next();
            if (this.existTimeStatisticalProcess(ctx, billId)) continue;
            try {
                TimeStatisticalProcessInfo tpInfo = new TimeStatisticalProcessInfo();
                String orgId = "";
                String billTypeId = "";
                String orgname = "";
                String billTypename = "";
                Timestamp ssccomplateTime = null;
                BigDecimal ssccomplate = BigDecimal.ZERO;
                BigDecimal sscpause = BigDecimal.ZERO;
                BigDecimal sscrescan = BigDecimal.ZERO;
                BigDecimal sscassign = BigDecimal.ZERO;
                JobHisInfo jobHisInfo = null;
                JobHisCollection jobHisColl = JobHisFactory.getLocalInstance(ctx).getJobHisCollection(" select *,orgID.id,orgID.name,bussAttrID.id,bussAttrID.name,bussAttrID.billType,bussAttrID.billType.id,bussAttrID.billType.name where billid = '" + billId + "' order by completetme asc ");
                HashMap<String, Map<String, BigDecimal>> mapEntry = new HashMap<String, Map<String, BigDecimal>>();
                for (int i = 0; i < jobHisColl.size(); ++i) {
                    BigDecimal costWorkTime;
                    double workTime;
                    long costWorkT;
                    double toBeAss;
                    long toBeAssign;
                    Map<String, BigDecimal> entry;
                    JobHisInfo hisInfo = jobHisColl.get(i);
                    List<SimpleJobStateTime> sjsList = this.getJobStateTime(ctx, hisInfo.getId().toString());
                    PauseAndRescan pauseAndRescan = this.getJobPauseAndRescanTime(ctx, sjsList);
                    SpecialOperation specialOperation = this.getJobSpecialOperation(ctx, sjsList);
                    Timestamp jobFristAssignTime = this.getJobFristAssignTime(ctx, hisInfo.getId().toString());
                    jobHisInfo = hisInfo;
                    String level = hisInfo.getLevel() + "";
                    if (i == 0) {
                        orgId = hisInfo.getOrgID().getId().toString();
                        billTypeId = hisInfo.getBussAttrID().getBillType().getId().toString();
                        orgname = hisInfo.getOrgID().getName();
                        billTypename = hisInfo.getBussAttrID().getBillType().getName();
                    }
                    if (i == jobHisColl.size() - 1) {
                        ssccomplateTime = hisInfo.getCompleteTme();
                    }
                    if (mapEntry.containsKey(level)) {
                        entry = (Map)mapEntry.get(level);
                        toBeAssign = workDUtil.calWorkTimeBetweenDays(new Date(hisInfo.getCreateTime().getTime()), new Date(jobFristAssignTime.getTime()));
                        toBeAss = (double)toBeAssign * 1.0 / 3600000.0;
                        entry.put("toBeAssign", new BigDecimal(String.valueOf(toBeAss)).add(specialOperation.getToBeAssignWaitTime()).add((BigDecimal)entry.get("toBeAssign")));
                        sscassign = sscassign.add(new BigDecimal(String.valueOf(toBeAss)).add(specialOperation.getToBeAssignWaitTime()));
                        entry.put("pause", pauseAndRescan.getPauseWaitTimes().add(specialOperation.getPauseWaitTimes()).add((BigDecimal)entry.get("pause")));
                        sscpause = sscpause.add(pauseAndRescan.getPauseWaitTimes().add(specialOperation.getPauseWaitTimes()));
                        entry.put("rescan", pauseAndRescan.getReScanWaitTime().add(specialOperation.getReScanWaitTime()).add((BigDecimal)entry.get("rescan")));
                        sscrescan = sscrescan.add(pauseAndRescan.getReScanWaitTime().add(specialOperation.getReScanWaitTime()));
                        costWorkT = workDUtil.calWorkTimeBetweenDays(new Date(jobFristAssignTime.getTime()), new Date(hisInfo.getCompleteTme().getTime()));
                        workTime = (double)costWorkT * 1.0 / 3600000.0;
                        costWorkTime = new BigDecimal(workTime).subtract(pauseAndRescan.getReScanWaitTime().add(specialOperation.getReScanWaitTime())).subtract(pauseAndRescan.getPauseWaitTimes().add(specialOperation.getPauseWaitTimes())).subtract(specialOperation.getToBeAssignWaitTime());
                        entry.put("examine", costWorkTime.add((BigDecimal)entry.get("examine")));
                        ssccomplate = ssccomplate.add(costWorkTime);
                        continue;
                    }
                    entry = new HashMap();
                    toBeAssign = workDUtil.calWorkTimeBetweenDays(new Date(hisInfo.getCreateTime().getTime()), new Date(jobFristAssignTime.getTime()));
                    toBeAss = (double)toBeAssign * 1.0 / 3600000.0;
                    entry.put("toBeAssign", new BigDecimal(String.valueOf(toBeAss)).add(specialOperation.getToBeAssignWaitTime()));
                    sscassign = sscassign.add(new BigDecimal(String.valueOf(toBeAss)).add(specialOperation.getToBeAssignWaitTime()));
                    entry.put("pause", pauseAndRescan.getPauseWaitTimes().add(specialOperation.getPauseWaitTimes()));
                    sscpause = sscpause.add(pauseAndRescan.getPauseWaitTimes().add(specialOperation.getPauseWaitTimes()));
                    entry.put("rescan", pauseAndRescan.getReScanWaitTime().add(specialOperation.getReScanWaitTime()));
                    sscrescan = sscrescan.add(pauseAndRescan.getReScanWaitTime().add(specialOperation.getReScanWaitTime()));
                    costWorkT = workDUtil.calWorkTimeBetweenDays(new Date(jobFristAssignTime.getTime()), new Date(hisInfo.getCompleteTme().getTime()));
                    workTime = (double)costWorkT * 1.0 / 3600000.0;
                    costWorkTime = new BigDecimal(String.valueOf(workTime)).subtract(pauseAndRescan.getReScanWaitTime().add(specialOperation.getReScanWaitTime())).subtract(pauseAndRescan.getPauseWaitTimes().add(specialOperation.getPauseWaitTimes())).subtract(specialOperation.getToBeAssignWaitTime());
                    entry.put("examine", costWorkTime);
                    ssccomplate = ssccomplate.add(costWorkTime);
                    entry.put("level", (BigDecimal)((Object)Integer.valueOf(jobHisInfo.getLevel())));
                    mapEntry.put(level, entry);
                }
                ERPWebService service = null;
                if (jobHisInfo == null) {
                    logger.error((Object)"jobHisInfo is null ...");
                    continue;
                }
                service = ERPUtil.getERPWebServiceImplByJob(ctx, jobHisInfo.getId().toString());
                ERPWebServiceBill erpWebService = null;
                if (!(service instanceof ERPWebServiceBill)) {
                    return;
                }
                erpWebService = (ERPWebServiceBill)((Object)service);
                String billData = erpWebService.getBillReportData(ctx, billId, jobHisInfo.getId().toString(), "");
                HashMap jsonObj = JSONUtils.convertJsonToObject((Context)ctx, (String)billData);
                String billNumber = jsonObj.get("billNumber") + "";
                tpInfo.setBillNumber(billNumber);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String billDate = jsonObj.get("billDate") + "";
                tpInfo.setBillSubmitTime(Timestamp.valueOf(billDate));
                List imageList = (List)jsonObj.get("list");
                double image = 0.0;
                HashMap<String, Double> imageTimeMap = new HashMap<String, Double>();
                if (imageList.size() > 0) {
                    for (int i = 0; i < imageList.size(); ++i) {
                        long imageTime = 0L;
                        Map mapImage = (Map)imageList.get(i);
                        String gotoImageTime = mapImage.get("gotoImageNode") + "";
                        String gooutImageTime = mapImage.get("gooutImageNode") + "";
                        String procinstid = mapImage.get("procinstid") + "";
                        Date gotoImageTimeDate = sdf.parse(gotoImageTime);
                        Date date = sdf.parse(gooutImageTime);
                        imageTime = workDUtil.calWorkTimeBetweenDays(gotoImageTimeDate, date);
                        if (imageTimeMap.get(procinstid) != null) {
                            imageTimeMap.put(procinstid, (Double)imageTimeMap.get(procinstid) + (double)imageTime * 1.0 / 3600000.0);
                            continue;
                        }
                        imageTimeMap.put(procinstid, (double)imageTime * 1.0 / 3600000.0);
                    }
                } else {
                    tpInfo.setImageUpload(BigDecimal.ZERO);
                }
                tpInfo.setSscAssign(sscassign);
                tpInfo.setSsccomplate(ssccomplate);
                tpInfo.setSscpause(sscpause);
                tpInfo.setSscrescan(sscrescan);
                tpInfo.setOrgId(orgId);
                tpInfo.setOrgName(orgname);
                tpInfo.setBilltypeId(billTypeId);
                tpInfo.setBillTypeName(billTypename);
                tpInfo.setBillId(billId);
                tpInfo.setShareCenterId(shareCenterId);
                tpInfo.setSsccomplateTime(ssccomplateTime);
                Map procinstMap = (Map)jsonObj.get("procinstMap");
                long businessApproveTime = 0L;
                Set entries = procinstMap.entrySet();
                JobHisCollection jobHisCollection = null;
                long time = 0L;
                for (Map.Entry entry : entries) {
                    String fprocinstId = (String)entry.getKey();
                    try {
                        jobHisCollection = JobHisFactory.getLocalInstance(ctx).getJobHisCollection("select createtime where PROCLNSTID='" + fprocinstId + "'");
                        if (jobHisCollection == null || jobHisCollection.size() == 0) continue;
                        time = jobHisCollection.get(0).getCreateTime().getTime();
                        for (int i = 1; i < jobHisCollection.size(); ++i) {
                            if (time >= jobHisCollection.get(i).getCreateTime().getTime()) continue;
                            time = jobHisCollection.get(i).getCreateTime().getTime();
                        }
                        if (imageTimeMap.get(fprocinstId) != null) {
                            image += ((Double)imageTimeMap.get(fprocinstId)).doubleValue();
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    Map timeMap = (Map)entry.getValue();
                    businessApproveTime += workDUtil.calWorkTimeBetweenDays(sdf.parse((String)timeMap.get("startTime")), sdf.parse(sdf.format(new Date(time))));
                }
                tpInfo.setImageUpload(new BigDecimal(String.valueOf(image)));
                for (int i = 0; i < jobHisColl.size(); ++i) {
                    JobHisInfo jobHisInfo2 = jobHisColl.get(i);
                    businessApproveTime += workDUtil.calWorkTimeBetweenDays(sdf.parse(sdf.format(new Date(jobHisInfo2.getCreateTime().getTime()))), sdf.parse(sdf.format(new Date(jobHisInfo2.getCompleteTme().getTime()))));
                }
                logger.error((Object)("businessApproveTime\uff1a" + businessApproveTime + "--billid:" + jobHisColl.get(0).getBillID()));
                double bussApp = (double)businessApproveTime * 1.0 / 3600000.0 - image;
                BigDecimal businessApprove = new BigDecimal(bussApp).subtract(sscassign).subtract(sscpause).subtract(sscrescan).subtract(ssccomplate);
                tpInfo.setBusinessApprove(businessApprove);
                FillDataUtils.fillAuditData(ctx, (ObjectBaseInfo)tpInfo);
                SscMultiApproveCollection smaColl = tpInfo.getEntry();
                Set set = mapEntry.keySet();
                Iterator its = set.iterator();
                while (its.hasNext()) {
                    SscMultiApproveInfo smaInfo = new SscMultiApproveInfo();
                    String bussid = (String)its.next();
                    Map entry = (Map)mapEntry.get(bussid);
                    smaInfo.setToBeAssign((BigDecimal)entry.get("toBeAssign"));
                    smaInfo.setPause((BigDecimal)entry.get("pause"));
                    smaInfo.setRescan((BigDecimal)entry.get("rescan"));
                    smaInfo.setExamine((BigDecimal)entry.get("examine"));
                    smaInfo.setLevel((Integer)entry.get("level"));
                    smaColl.add(smaInfo);
                }
                coreBaseCol.add((CoreBaseInfo)tpInfo);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        TimeStatisticalProcessFactory.getLocalInstance(ctx).addnewBatchData(coreBaseCol);
    }

    private Timestamp getJobFristAssignTime(Context ctx, String jobId) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  ");
        buffer.append("  SELECT top 1 ths.FCHANGETIME ");
        buffer.append("  FROM T_SSC_JOBHIS his inner join T_SSC_JOBSTATIMHIS ths  ");
        buffer.append("  on his.fid = ths.FJOBIDID  ");
        buffer.append("  where his.fid='" + jobId + "'  and ths.FOPERATION in ('14','8','6') ");
        buffer.append("  order by ths.FCHANGETIME asc ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
        if (rs.next()) {
            return rs.getTimestamp("FCHANGETIME");
        }
        buffer = new StringBuffer();
        buffer.append("  SELECT top 1 ths.FCHANGETIME ");
        buffer.append("  FROM T_SSC_JOBHIS his inner join T_SSC_JOBSTATIMHIS ths  ");
        buffer.append("  on his.fid = ths.FJOBIDID  ");
        buffer.append("  where his.fid='" + jobId + "'  and ths.FOPERATION in ('1') ");
        buffer.append("  order by ths.FCHANGETIME asc ");
        rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
        if (rs.next()) {
            return rs.getTimestamp("FCHANGETIME");
        }
        return null;
    }

    private PauseAndRescan getJobPauseAndRescanTime(Context ctx, List<SimpleJobStateTime> sjsList) throws EASBizException {
        PauseAndRescan pauseAndRescan = new PauseAndRescan();
        for (int i = 0; i < sjsList.size() - 1; ++i) {
            this.getOneCost(ctx, pauseAndRescan, sjsList.get(i), sjsList.get(i + 1));
        }
        return pauseAndRescan;
    }

    private SpecialOperation getJobSpecialOperation(Context ctx, List<SimpleJobStateTime> sjsList) throws EASBizException {
        SpecialOperation specialOperation = new SpecialOperation();
        for (int i = 0; i < sjsList.size() - 2; ++i) {
            this.getSpecialOperationTime(ctx, specialOperation, sjsList.get(i), sjsList.get(i + 1), sjsList.get(i + 2));
        }
        return specialOperation;
    }

    private void getSpecialOperationTime(Context ctx, SpecialOperation specialOperation, SimpleJobStateTime pre, SimpleJobStateTime next, SimpleJobStateTime third) throws SSCException {
        if (("2".equals(pre.getOldJobState()) || "7".equals(pre.getOldJobState())) && "1".equals(pre.getNewJobState()) && "1".equals(next.getOldJobState()) && "8".equals(next.getNewJobState()) && "8".equals(third.getOldJobState()) && ("2".equals(third.getNewJobState()) || "7".equals(third.getNewJobState()))) {
            long reScanWaitTime = (long)WorkDateUtil.getInstance(ctx, pre.getShareCenterID(), false).getCalWorkTimes(pre.getChangeTime(), next.getChangeTime(), 0);
            if (specialOperation.getReScanWaitTime() == null) {
                specialOperation.setReScanWaitTime(new BigDecimal(this.millSecondsToHour(reScanWaitTime)));
            } else {
                specialOperation.setReScanWaitTime(new BigDecimal(specialOperation.getReScanWaitTime().doubleValue() + this.millSecondsToHour(reScanWaitTime)));
            }
        }
        if (("2".equals(pre.getOldJobState()) || "7".equals(pre.getOldJobState())) && "0".equals(pre.getNewJobState()) && "0".equals(next.getOldJobState()) && "8".equals(next.getNewJobState()) && "8".equals(third.getOldJobState()) && ("2".equals(third.getNewJobState()) || "7".equals(third.getNewJobState()))) {
            long PauseWaitTimes = (long)WorkDateUtil.getInstance(ctx, pre.getShareCenterID(), false).getCalWorkTimes(pre.getChangeTime(), next.getChangeTime(), 0);
            if (specialOperation.getPauseWaitTimes() == null) {
                specialOperation.setPauseWaitTimes(new BigDecimal(this.millSecondsToHour(PauseWaitTimes)));
            } else {
                specialOperation.setPauseWaitTimes(new BigDecimal(specialOperation.getPauseWaitTimes().doubleValue() + this.millSecondsToHour(PauseWaitTimes)));
            }
        }
        if (("0".equals(pre.getOldJobState()) || "1".equals(pre.getOldJobState())) && "8".equals(pre.getNewJobState()) && "8".equals(next.getOldJobState()) && ("2".equals(next.getNewJobState()) || "7".equals(next.getNewJobState())) && ("2".equals(third.getOldJobState()) || "7".equals(third.getOldJobState())) && ("0".equals(third.getNewJobState()) || "1".equals(third.getNewJobState()))) {
            long ToBeAssignWaitTime = (long)WorkDateUtil.getInstance(ctx, next.getShareCenterID(), false).getCalWorkTimes(pre.getChangeTime(), third.getChangeTime(), 0);
            if (specialOperation.getToBeAssignWaitTime() == null) {
                specialOperation.setToBeAssignWaitTime(new BigDecimal(this.millSecondsToHour(ToBeAssignWaitTime)));
            } else {
                specialOperation.setToBeAssignWaitTime(new BigDecimal(specialOperation.getToBeAssignWaitTime().doubleValue() + this.millSecondsToHour(ToBeAssignWaitTime)));
            }
        }
    }

    private void getOneCost(Context ctx, PauseAndRescan pauseAndRescan, SimpleJobStateTime pre, SimpleJobStateTime next) throws EASBizException {
        if (("2".equals(pre.getOldJobState()) || "7".equals(pre.getOldJobState())) && "1".equals(pre.getNewJobState()) && "1".equals(next.getOldJobState()) && ("2".equals(next.getNewJobState()) || "7".equals(next.getNewJobState()))) {
            long reScanWaitTime = (long)WorkDateUtil.getInstance(ctx, pre.getShareCenterID(), false).getCalWorkTimes(pre.getChangeTime(), next.getChangeTime(), 0);
            if (pauseAndRescan.getReScanWaitTime() == null) {
                pauseAndRescan.setReScanWaitTime(new BigDecimal(this.millSecondsToHour(reScanWaitTime)));
            } else {
                pauseAndRescan.setReScanWaitTime(new BigDecimal(pauseAndRescan.getReScanWaitTime().doubleValue() + this.millSecondsToHour(reScanWaitTime)));
            }
        }
        if (("2".equals(pre.getOldJobState()) || "7".equals(pre.getOldJobState())) && "0".equals(pre.getNewJobState()) && "0".equals(next.getOldJobState()) && ("2".equals(next.getNewJobState()) || "7".equals(next.getNewJobState()))) {
            long PauseWaitTimes = (long)WorkDateUtil.getInstance(ctx, pre.getShareCenterID(), false).getCalWorkTimes(pre.getChangeTime(), next.getChangeTime(), 0);
            if (pauseAndRescan.getPauseWaitTimes() == null) {
                pauseAndRescan.setPauseWaitTimes(new BigDecimal(this.millSecondsToHour(PauseWaitTimes)));
            } else {
                pauseAndRescan.setPauseWaitTimes(new BigDecimal(pauseAndRescan.getPauseWaitTimes().doubleValue() + this.millSecondsToHour(PauseWaitTimes)));
            }
        }
    }

    private double millSecondsToHour(long ms) {
        return (double)ms / 3600000.0;
    }

    private List<SimpleJobStateTime> getJobStateTime(Context ctx, String jobId) throws BOSException, SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT his.FSHARECENTERID ,ths.FID, ths.FNEWJOBSTATE ,ths.FOLDJOBSTATE ,ths.FCHANGETIME ");
        buf.append(" FROM T_SSC_JOBHIS his inner join T_SSC_JOBSTATIMHIS ths  ");
        buf.append(" on his.fid = ths.FJOBIDID  ");
        buf.append(" where his.fid='" + jobId + "' ");
        buf.append(" order by ths.FCHANGETIME asc ");
        ArrayList<SimpleJobStateTime> list = new ArrayList<SimpleJobStateTime>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        while (rs.next()) {
            SimpleJobStateTime sjs = new SimpleJobStateTime();
            sjs.setShareCenterID(rs.getString("FSHARECENTERID"));
            sjs.setOldJobState(rs.getString("FOLDJOBSTATE"));
            sjs.setNewJobState(rs.getString("FNEWJOBSTATE"));
            sjs.setChangeTime(rs.getTimestamp("FCHANGETIME"));
            list.add(sjs);
        }
        return list;
    }

    private boolean existTimeStatisticalProcess(Context ctx, String billId) throws EASBizException, BOSException {
        return TimeStatisticalProcessFactory.getLocalInstance(ctx).exists(" where  billId = '" + billId + "'");
    }

    private class SpecialOperation {
        private BigDecimal pauseWaitTimes = new BigDecimal(0);
        private BigDecimal reScanWaitTime = new BigDecimal(0);
        private BigDecimal toBeAssignWaitTime = new BigDecimal(0);

        private SpecialOperation() {
        }

        public BigDecimal getPauseWaitTimes() {
            return this.pauseWaitTimes;
        }

        public void setPauseWaitTimes(BigDecimal pauseWaitTimes) {
            this.pauseWaitTimes = pauseWaitTimes;
        }

        public BigDecimal getReScanWaitTime() {
            return this.reScanWaitTime;
        }

        public void setReScanWaitTime(BigDecimal reScanWaitTime) {
            this.reScanWaitTime = reScanWaitTime;
        }

        public BigDecimal getToBeAssignWaitTime() {
            return this.toBeAssignWaitTime;
        }

        public void setToBeAssignWaitTime(BigDecimal toBeAssignWaitTime) {
            this.toBeAssignWaitTime = toBeAssignWaitTime;
        }
    }

    private class PauseAndRescan {
        private BigDecimal pauseWaitTimes = new BigDecimal(0);
        private BigDecimal reScanWaitTime = new BigDecimal(0);

        private PauseAndRescan() {
        }

        public BigDecimal getPauseWaitTimes() {
            return this.pauseWaitTimes;
        }

        public void setPauseWaitTimes(BigDecimal pauseWaitTimes) {
            this.pauseWaitTimes = pauseWaitTimes;
        }

        public BigDecimal getReScanWaitTime() {
            return this.reScanWaitTime;
        }

        public void setReScanWaitTime(BigDecimal reScanWaitTime) {
            this.reScanWaitTime = reScanWaitTime;
        }
    }

    private class SimpleJobStateTime {
        private Timestamp changeTime;
        private String oldJobState;
        private String newJobState;
        private String shareCenterID;

        public SimpleJobStateTime() {
        }

        public SimpleJobStateTime(Timestamp changeTime, String oldJobState, String newJobState) {
            this.changeTime = changeTime;
            this.oldJobState = oldJobState;
            this.newJobState = newJobState;
        }

        public Timestamp getChangeTime() {
            return this.changeTime;
        }

        public void setChangeTime(Timestamp changeTime) {
            this.changeTime = changeTime;
        }

        public String getOldJobState() {
            return this.oldJobState;
        }

        public void setOldJobState(String oldJobState) {
            this.oldJobState = oldJobState;
        }

        public String getNewJobState() {
            return this.newJobState;
        }

        public void setNewJobState(String newJobState) {
            this.newJobState = newJobState;
        }

        public String getShareCenterID() {
            return this.shareCenterID;
        }

        public void setShareCenterID(String shareCenterID) {
            this.shareCenterID = shareCenterID;
        }
    }
}

