/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.ISSCForewarnFacade;
import com.kingdee.eas.base.ssc.SSCForewarnFacadeFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ForeWarnThread
implements Runnable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.ForeWarnThread");
    private Context ctx;
    private String jobId;
    private String imageNo;

    public ForeWarnThread(Context ctx, String jobId, String imageNo) {
        this.jobId = jobId;
        this.ctx = ctx;
        this.imageNo = imageNo;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(3000L);
            if (StringUtils.isBlank((String)this.jobId)) {
                this.jobId = this.getJobIdByImageNo(this.ctx, this.imageNo);
            }
            ISSCForewarnFacade fa = SSCForewarnFacadeFactory.getLocalInstance(this.ctx);
            fa.changeNeedSendResacanMsg(this.jobId, "0");
            try {
                String uiName = "com.kingdee.eas.base.ssc.client.JobEditUI";
                String actionName = "ActionSubmit";
                boolean forewarnResult = this.callRightNowForewarn(this.ctx, uiName, actionName, this.jobId);
                logger.error((Object)("\u9000\u626b\u53ca\u65f6\u9884\u8b66\u5b8c\u6210!forewarnResult:" + forewarnResult + "!&taskId:" + this.jobId + "\n"));
            }
            catch (Exception e) {
                logger.error((Object)("\u9000\u626b\u53ca\u65f6\u9884\u8b66\u5f02\u5e38!\u6d41\u7a0b\u7ee7\u7eed!taskId:" + this.jobId + "\n" + e.getMessage()), (Throwable)e);
            }
            fa.markAllNeedSendResacanMsg("1");
        }
        catch (Exception e) {
            logger.error((Object)"\u9000\u626b\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private boolean callRightNowForewarn(Context ctx, String uiName, String actionName, String objID) throws Exception {
        String className = "com.kingdee.eas.base.forewarn.ForewarnRunTimeFactory";
        Class<?> factory = Class.forName(className);
        Method getInst = factory.getMethod("getLocalInstance", Context.class);
        Object controllerBean = getInst.invoke(null, ctx);
        Method execRightnowForewarn = controllerBean.getClass().getMethod("execRightnowForewarn", String.class, String.class, String.class);
        boolean result = Boolean.TRUE.equals(execRightnowForewarn.invoke(controllerBean, uiName, actionName, objID));
        return result;
    }

    private String getJobIdByImageNo(Context ctx, String imageNo) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" SELECT fjobIdId");
            sb.append(" FROM T_ssc_dynamicvalue");
            sb.append(" where FDYNAMICIDID = 'eeodQcKeReCFk5b8O7HqeZvLn80='");
            sb.append(" and FDINAMICVALUE = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{imageNo});
            if (rs.next()) {
                return rs.getString(1);
            }
            sb = new StringBuffer();
            sb.append(" SELECT fjobIdId");
            sb.append(" FROM T_ssc_dynvaluehis");
            sb.append(" where FDYNAMICIDID = 'eeodQcKeReCFk5b8O7HqeZvLn80='");
            sb.append(" and FDINAMICVALUE = ?");
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{imageNo});
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }
}

