/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.JSONUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AppSSCBaseBillUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.tool.SSCBaseBillUtils");

    public static Map<String, String> getSourceBillAttribute(Context ctx, JobInfo jobInfo, JobHisInfo jobHisInfo, List<String> keyList) {
        String bussAttrId = null;
        bussAttrId = jobInfo != null ? jobInfo.getBussAttrID().getId().toString() : jobHisInfo.getBussAttrID().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append(" select bt.fbindbillentry");
        sb.append(" from T_ssc_bussinessattribute ba,T_ssc_billtype bt");
        sb.append(" where ba.fid=?");
        sb.append(" and ba.FBILLTYPEID = bt.FID ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{bussAttrId});
            if (rs.next()) {
                String sourceBillId;
                String sscBillID;
                String sourceBillClass = rs.getString(1);
                String sourceFactoryClass = sourceBillClass.replace(".app.", ".") + "Factory";
                SelectorItemCollection sic = new SelectorItemCollection();
                if (keyList != null && keyList.size() > 0) {
                    for (int i = 0; i < keyList.size(); ++i) {
                        sic.add(new SelectorItemInfo(keyList.get(i)));
                    }
                }
                Class<?> bizCollBillFacadeClass = Class.forName(sourceFactoryClass);
                Method bizCollBillMethod = bizCollBillFacadeClass.getMethod("getLocalInstance", Context.class);
                Object object = bizCollBillMethod.invoke(null, ctx);
                Class<?> ICoreBase2 = object.getClass();
                Method existsMethod = ICoreBase2.getMethod("exists", IObjectPK.class);
                String string = sscBillID = jobInfo != null ? jobInfo.getSscBillID() : jobHisInfo.getSscBillID();
                if (!StringUtils.isEmpty((String)sscBillID) && ((Boolean)existsMethod.invoke(object, new ObjectUuidPK(BOSUuid.read((String)sscBillID)))).booleanValue()) {
                    Method method = ICoreBase2.getMethod("getValue", IObjectPK.class, SelectorItemCollection.class);
                    IObjectValue dataObj = (IObjectValue)method.invoke(object, new ObjectUuidPK(BOSUuid.read((String)sscBillID)), sic);
                    return AppSSCBaseBillUtils.getSourceBillAttribute(ctx, keyList, dataObj);
                }
                String string2 = sourceBillId = jobInfo != null ? jobInfo.getBillID() : jobHisInfo.getBillID();
                if (!StringUtils.isEmpty((String)sourceBillId) && ((Boolean)existsMethod.invoke(object, new ObjectUuidPK(BOSUuid.read((String)sourceBillId)))).booleanValue()) {
                    Method method = ICoreBase2.getMethod("getValue", IObjectPK.class, SelectorItemCollection.class);
                    IObjectValue dataObj = (IObjectValue)method.invoke(object, new ObjectUuidPK(BOSUuid.read((String)sourceBillId)), sic);
                    return AppSSCBaseBillUtils.getSourceBillAttribute(ctx, keyList, dataObj);
                }
            } else {
                logger.error((Object)("\u672a\u7ed1\u5b9a\u5355\u636e\u7c7b\u578bbussAttrId:" + bussAttrId));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return new HashMap<String, String>();
    }

    public static Map<String, String> getSourceBillAttribute(Context ctx, List<String> keyList, IObjectValue dataObj) {
        HashMap<String, String> fromSC = new HashMap<String, String>();
        for (int i = 0; i < keyList.size(); ++i) {
            String dyKey = keyList.get(i);
            Object dyValue = null;
            if (dataObj instanceof IObjectValue) {
                try {
                    dyValue = dataObj;
                    String[] keys = dyKey.split("\\.");
                    dyValue = AppSSCBaseBillUtils.getDyValue(ctx, dyValue, keys);
                    if (dyValue instanceof Map) {
                        Map dyValueMap = (Map)dyValue;
                        String retuString = "";
                        retuString = JSONUtil.map2json(dyValueMap);
                        dyValue = retuString;
                    }
                }
                catch (Exception e) {
                    dyValue = null;
                    logger.error((Object)("get params error from bill,dyKey:" + dyKey), (Throwable)e);
                }
            } else if (dataObj instanceof Map) {
                dyValue = ((Map)dataObj).get(dyKey);
            }
            String value = null;
            if (dyValue != null && !dyValue.toString().equals("null")) {
                value = String.valueOf(dyValue);
            }
            logger.info((Object)("dykey is..." + dyKey));
            logger.info((Object)("value is..." + value));
            fromSC.put(dyKey, value);
        }
        return fromSC;
    }

    private static Object getDyValue(Context ctx, Object dyValue, String[] keys) {
        block11: {
            String key = keys[0];
            try {
                Class<?> cls = dyValue.getClass();
                try {
                    String enumKey = FormatUtils.toUpperCaseFirst(key);
                    Method method = cls.getMethod("get" + enumKey, new Class[0]);
                    Object enumDyValue = method.invoke(dyValue, new Object[0]);
                    if (enumDyValue instanceof Enum) {
                        cls = enumDyValue.getClass();
                        method = cls.getMethod("getAlias", new Class[0]);
                        dyValue = method.invoke(enumDyValue, new Object[0]);
                        return dyValue;
                    }
                }
                catch (Exception enumKey) {
                    // empty catch block
                }
                Method method = cls.getMethod("get", String.class);
                dyValue = method.invoke(dyValue, key);
                if (dyValue instanceof Enum) {
                    cls = dyValue.getClass();
                    method = cls.getMethod("getAlias", new Class[0]);
                    dyValue = method.invoke(dyValue, new Object[0]);
                    break block11;
                }
                if (dyValue instanceof Timestamp) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    return format.format(dyValue);
                }
                if (dyValue instanceof IObjectCollection) {
                    IObjectCollection coll = (IObjectCollection)dyValue;
                    String[] strArr = AppSSCBaseBillUtils.removeStringArrFrist(keys);
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    for (int j = 0; j < coll.size(); ++j) {
                        IObjectValue objValue = coll.getObject(j);
                        dyValue = AppSSCBaseBillUtils.getDyValue(ctx, objValue, strArr);
                        map.put(null == objValue.get("id") ? Integer.valueOf(j) : objValue.get("id"), dyValue);
                    }
                    return map;
                }
                if (dyValue instanceof IObjectValue) {
                    String[] strArr = AppSSCBaseBillUtils.removeStringArrFrist(keys);
                    dyValue = AppSSCBaseBillUtils.getDyValue(ctx, dyValue, strArr);
                    break block11;
                }
                if (dyValue instanceof String) {
                    dyValue = dyValue != null ? ((String)dyValue).trim() : dyValue;
                }
                return dyValue;
            }
            catch (Exception e) {
                dyValue = null;
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return dyValue;
    }

    private static String[] removeStringArrFrist(String[] keys) {
        String[] arrNew = new String[keys.length - 1];
        for (int i = 1; i < keys.length; ++i) {
            arrNew[i - 1] = keys[i];
        }
        return arrNew;
    }
}

