/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.InvalidEntityViewException;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.SignatureFieldInfo;
import com.kingdee.eas.base.ssc.AssignException;
import com.kingdee.eas.base.ssc.AssignRuleCollection;
import com.kingdee.eas.base.ssc.AssignRuleEntryCollection;
import com.kingdee.eas.base.ssc.AssignRuleEntryInfo;
import com.kingdee.eas.base.ssc.AssignRuleInfo;
import com.kingdee.eas.base.ssc.AutoAssignTypeEnum;
import com.kingdee.eas.base.ssc.BussinessAttributeExtCollection;
import com.kingdee.eas.base.ssc.BussinessAttributeExtFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeExtInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.CAType;
import com.kingdee.eas.base.ssc.CreditFilesNewFactory;
import com.kingdee.eas.base.ssc.CreditFilesNewInfo;
import com.kingdee.eas.base.ssc.DynamicAttributeFactory;
import com.kingdee.eas.base.ssc.DynamicAttributeInfo;
import com.kingdee.eas.base.ssc.DynamicValueCollection;
import com.kingdee.eas.base.ssc.DynamicValueFactory;
import com.kingdee.eas.base.ssc.DynamicValueInfo;
import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.FieldType;
import com.kingdee.eas.base.ssc.IUser;
import com.kingdee.eas.base.ssc.JobCollection;
import com.kingdee.eas.base.ssc.JobFactory;
import com.kingdee.eas.base.ssc.JobHisCollection;
import com.kingdee.eas.base.ssc.JobHisFactory;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.PackageConfigEntryCollection;
import com.kingdee.eas.base.ssc.PackageConfigEntryFactory;
import com.kingdee.eas.base.ssc.PackageConfigEntryInfo;
import com.kingdee.eas.base.ssc.PackageConfigFactory;
import com.kingdee.eas.base.ssc.ParamSetFacadeFactory;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.SysParamMgerCollection;
import com.kingdee.eas.base.ssc.SysParamMgerFactory;
import com.kingdee.eas.base.ssc.SystemAttributeCollection;
import com.kingdee.eas.base.ssc.SystemAttributeFactory;
import com.kingdee.eas.base.ssc.SystemAttributeInfo;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.WorkPressureCollection;
import com.kingdee.eas.base.ssc.WorkPressureFactory;
import com.kingdee.eas.base.ssc.WorkPressureInfo;
import com.kingdee.eas.base.ssc.app.StopAssignEnum;
import com.kingdee.eas.base.ssc.app.checkpointext.ExecutionRuleConditionEnum;
import com.kingdee.eas.base.ssc.app.erp.ERPUtil;
import com.kingdee.eas.base.ssc.app.erp.ERPWebService;
import com.kingdee.eas.base.ssc.app.erp.ERPWebServiceBill;
import com.kingdee.eas.base.ssc.app.erp.eas.EASCfgUtil;
import com.kingdee.eas.base.ssc.common.compare.DealInfo;
import com.kingdee.eas.base.ssc.common.script.custom.ScriptEngineUtil;
import com.kingdee.eas.base.ssc.tool.EqualDivisionUtils;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.OrgRoleUserUtils;
import com.kingdee.eas.base.ssc.tool.SSCBaseBillUtils;
import com.kingdee.eas.base.ssc.tool.SSCCompareUtils;
import com.kingdee.eas.base.ssc.tool.SSCUtil;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.base.ssc.workDate.WorkDateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.FrameHelperFacadeFactory;
import com.kingdee.eas.framework.IFrameHelperFacade;
import com.kingdee.eas.framework.util.EntityUtility;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JobUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.tool.JobUtils");

    public static int getUserJobCount(Context ctx, String sscUserId) {
        try {
            String sql = " SELECT count(1) FROM t_ssc_Job where FPersonnelIDID=? AND FJobPoolingType='2' AND (FJobState='2' OR FJobState='7') ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{sscUserId});
            if (rs.next()) {
                return rs.getInt(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
        return 0;
    }

    public static void closeRS(IRowSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                rs = null;
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isDoTask(Context ctx, String userId) {
        IRowSet rs;
        block6: {
            boolean bl;
            StringBuffer sb = new StringBuffer();
            sb.append(" select fid from t_ssc_job where FPERSONNELIDID = ? or FCONSIGNERID = ?");
            sb.append(" union");
            sb.append(" select fid from t_ssc_jobhis where FPERSONNELIDID = ? or FCONSIGNERID = ?");
            rs = null;
            Object[] params = new Object[]{userId, userId, userId, userId};
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
                if (!rs.next()) break block6;
                bl = true;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                JobUtils.closeRS(rs);
            }
            catch (SQLException e2) {
                logger.error((Object)e2.getMessage(), (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        JobUtils.closeRS(rs);
                        throw throwable;
                    }
                }
                JobUtils.closeRS(rs);
            }
            JobUtils.closeRS(rs);
            return bl;
        }
        JobUtils.closeRS(rs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExistsOrgPermission(Context ctx, String bussAttrId, List<String> roleIdList, String orgId) throws BOSException {
        IRowSet rs;
        block4: {
            boolean bl;
            StringBuffer sql = new StringBuffer();
            sql.append(" select 1");
            sql.append(" from t_ssc_role r,t_ssc_org o,t_ssc_roleorg ro,t_ssc_rolebussattr rb");
            sql.append(" where ro.FROLEIDID = r.FID");
            sql.append(" and ro.FORGIDID  = o.FID");
            sql.append(" and rb.FParentID = r.fid");
            sql.append(" and o.FID = ?");
            sql.append(" and rb.FBUSSNAMEID = ?");
            sql.append(" and r.FID in " + FormatUtils.list2Sql(roleIdList));
            Object[] param = new Object[]{orgId, bussAttrId};
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("sql:" + sql.toString()));
                    logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                    logger.error((Object)"Query role permission error!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    JobUtils.closeRS(rs);
                    throw throwable;
                }
                JobUtils.closeRS(rs);
            }
            JobUtils.closeRS(rs);
            return bl;
        }
        JobUtils.closeRS(rs);
        return false;
    }

    public static UserInfo getLeastTaskPermissionUser(Context ctx, JobInfo job, String bussAttrId, List<String> roleIdList, List<String> userIdList, String orgID, AssignRuleInfo assignRuleInfo, AssignRuleCollection assignRuleCollection, UserInfo user) throws Exception {
        List<String> userIds = JobUtils.getPermissionUserIds(ctx, bussAttrId, roleIdList, userIdList, orgID);
        logger.error((Object)(job.getSubject() + "\uff0c\u80fd\u5206\u914d\u7684\u6709\u6743\u9650\u7684\u4eba\u5458ID\u4e3a:" + userIds.toString()));
        return JobUtils.getPackageAssignUser(ctx, job, userIds, assignRuleInfo, assignRuleCollection, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPermissionUserIds(Context ctx, String bussAttrId, List<String> roleIdList, List<String> userIdList, String orgID, String shareCenterId) {
        ArrayList<String> parentIds = new ArrayList<String>();
        parentIds.add(orgID);
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct u.fid");
        sb.append(" from t_ssc_user u,t_ssc_role r,t_ssc_org o,t_ssc_roleuser ru,t_ssc_roleorg ro,t_ssc_rolebussattr rb");
        sb.append(" where r.FROLETYPEIDID = 'F68lZzqpRWC1K1nV8ZYPgS0WZ4A='");
        sb.append(" and r.FNUMBER not like 'addForCompel%'");
        sb.append(" and ru.FROLEIDID = r.FID");
        sb.append(" and ru.FUSERIDID = u.FID");
        sb.append(" and ro.FROLEIDID = r.FID");
        sb.append(" and ro.FORGIDID  = o.FID");
        sb.append(" and rb.FParentID = r.fid");
        sb.append(" and rb.FBUSSNAMEID = ?");
        sb.append(" and o.FID in " + FormatUtils.list2Sql(parentIds));
        if (null != roleIdList && !roleIdList.isEmpty()) {
            sb.append(" and r.FID in " + FormatUtils.list2Sql(roleIdList));
        }
        if (null != userIdList && !userIdList.isEmpty()) {
            sb.append(" and u.FID in " + FormatUtils.list2Sql(userIdList));
        }
        Object[] param = new Object[]{bussAttrId};
        if (!StringUtils.isEmpty((String)shareCenterId)) {
            sb.append(" and u.FSHARECENTERID = ? ");
            param = new Object[]{bussAttrId, shareCenterId};
        }
        ArrayList<String> userIds = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            while (rs.next()) {
                userIds.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                logger.error((Object)"Query user permission error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
        }
        JobUtils.closeRS(rs);
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPermissionUserIds(Context ctx, String bussAttrId, List<String> roleIdList, List<String> userIdList, String orgID) {
        ArrayList<String> parentIds = new ArrayList<String>();
        parentIds.add(orgID);
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct u.fid");
        sb.append(" from t_ssc_user u,t_ssc_role r,t_ssc_org o,t_ssc_roleuser ru,t_ssc_roleorg ro,t_ssc_rolebussattr rb");
        sb.append(" where r.FROLETYPEIDID = 'F68lZzqpRWC1K1nV8ZYPgS0WZ4A='");
        sb.append(" and r.FNUMBER not like 'addForCompel%'");
        sb.append(" and ru.FROLEIDID = r.FID");
        sb.append(" and ru.FUSERIDID = u.FID");
        sb.append(" and ro.FROLEIDID = r.FID");
        sb.append(" and ro.FORGIDID  = o.FID");
        sb.append(" and rb.FParentID = r.fid");
        sb.append(" and rb.FBUSSNAMEID = ?");
        sb.append(" and o.FID in " + FormatUtils.list2Sql(parentIds));
        if (null != roleIdList && !roleIdList.isEmpty()) {
            sb.append(" and r.FID in " + FormatUtils.list2Sql(roleIdList));
        }
        if (null != userIdList && !userIdList.isEmpty()) {
            sb.append(" and u.FID in " + FormatUtils.list2Sql(userIdList));
        }
        Object[] param = new Object[]{bussAttrId};
        ArrayList<String> userIds = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            while (rs.next()) {
                userIds.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                logger.error((Object)"Query user permission error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
        }
        JobUtils.closeRS(rs);
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPermissionUserIdsExcludeRule(Context ctx, JobInfo job, List<String> ruleRoleIds, List<String> ruleUserIds) throws Exception {
        String orgId = job.getOrgID().getId().toString();
        String bussAttrId = job.getBussAttrID().getId().toString();
        String shareCenterId = job.getShareCenterID().getId().toString();
        ArrayList<String> parentIds = new ArrayList<String>();
        parentIds.add(orgId);
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct u.fid");
        sb.append(" from t_ssc_user u,t_ssc_role r,t_ssc_org o,t_ssc_roleuser ru,t_ssc_roleorg ro,t_ssc_rolebussattr rb");
        sb.append(" where r.FROLETYPEIDID = 'F68lZzqpRWC1K1nV8ZYPgS0WZ4A='");
        sb.append(" and r.FNUMBER not like 'addForCompel%'");
        sb.append(" and ru.FROLEIDID = r.FID");
        sb.append(" and ru.FUSERIDID = u.FID");
        sb.append(" and ro.FROLEIDID = r.FID");
        sb.append(" and ro.FORGIDID  = o.FID");
        sb.append(" and rb.FParentID = r.fid");
        sb.append(" and rb.FBUSSNAMEID = ?");
        sb.append(" and o.FID in " + FormatUtils.list2Sql(parentIds));
        if (StringUtils.isNotBlank((String)shareCenterId)) {
            sb.append(" and u.fsharecenterid = '" + shareCenterId + "'");
        }
        if (null != ruleRoleIds && 0 < ruleRoleIds.size()) {
            List<String> roleUserIds = OrgRoleUserUtils.getUsersByRole(ctx, ruleRoleIds);
            HashSet<String> temp = new HashSet<String>(ruleUserIds);
            temp.addAll(roleUserIds);
            ruleUserIds = new ArrayList<String>(temp);
        }
        if (ruleUserIds != null && !ruleUserIds.isEmpty()) {
            String userStr = FormatUtils.list2Sql(ruleUserIds);
            sb.append(" and u.FID not in " + userStr);
        }
        Object[] param = new Object[]{bussAttrId};
        ArrayList<String> userIds = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            while (rs.next()) {
                userIds.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                logger.error((Object)"Query user permission exclude rule error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
        }
        JobUtils.closeRS(rs);
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExistConsignerRelation(Context ctx, String bussAttrId, List<String> userIds, Map<String, List<String>> consignerMap, Map<String, String> assigneeMap) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT c.FCONSIGNERID,c.FASSIGNEEID");
        sb.append(" FROM T_ssc_consignation c,t_ssc_consignationentry ce");
        sb.append(" where ce.fparentid = c.FID");
        sb.append(" and c.FCONSIGNERID in " + FormatUtils.list2Sql(userIds));
        sb.append(" and ce.fbusstypeid = ?");
        sb.append(" and c.FSTATUS = ?");
        Object[] param = new Object[]{bussAttrId, "30"};
        boolean isExistConsignerRelation = false;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            while (rs.next()) {
                isExistConsignerRelation = true;
                String consignerId = rs.getString(1);
                String assigneeId = rs.getString(2);
                List<String> assigneeList = consignerMap.get(consignerId);
                if (null == assigneeList) {
                    assigneeList = new ArrayList<String>();
                }
                assigneeList.add(assigneeId);
                consignerMap.put(consignerId, assigneeList);
                assigneeMap.put(assigneeId, consignerId);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                logger.error((Object)"Query consigner relation error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
        }
        JobUtils.closeRS(rs);
        return isExistConsignerRelation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAllConsignerIDs(Context ctx, String bussAttrId, String userId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT c.FCONSIGNERID,c.FASSIGNEEID");
        sb.append(" FROM T_ssc_consignation c,t_ssc_consignationentry ce");
        sb.append(" where ce.fparentid = c.FID");
        sb.append(" and c.FASSIGNEEID = ? ");
        sb.append(" and ce.fbusstypeid = ?");
        sb.append(" and c.FSTATUS = ?");
        Object[] param = new Object[]{userId, bussAttrId, "30"};
        ArrayList<String> consignerIds = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            while (rs.next()) {
                consignerIds.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                logger.error((Object)"Query getAllConsignerIDs error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
        }
        JobUtils.closeRS(rs);
        return consignerIds;
    }

    public static List<String> replaceConsignerToAssignee(List<String> userIds, Map<String, List<String>> consignerMap) {
        HashSet<String> temp = new HashSet<String>();
        for (String consignerId : consignerMap.keySet()) {
            userIds.remove(consignerId);
            temp.addAll((Collection)consignerMap.get(consignerId));
        }
        for (String userId : userIds) {
            temp.add(userId);
        }
        userIds = new ArrayList<String>(temp);
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> sortUserIdByTaskAsc(Context ctx, String bussAttrId, List<String> userIds) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select u.fid,");
        sb.append(" (select count(1) from t_ssc_job j");
        sb.append(" where (j.FPersonnelIDID = u.fid");
        sb.append(" or j.fconsignerid = u.fid)");
        sb.append(" and j.FJobPoolingType = '2'");
        sb.append(" and j.FBussAttrIDID in");
        sb.append(" (select ba.fid from t_ssc_bussinessattribute ba inner join t_ssc_billType bt on ba.fbilltypeid=bt.fid inner join t_ssc_systemattribute sy on bt.fsysattrid=sy.fid where sy.fid =");
        sb.append(" (select sy.fid from t_ssc_bussinessattribute ba inner join t_ssc_billType bt on ba.fbilltypeid=bt.fid inner join t_ssc_systemattribute sy on bt.fsysattrid=sy.fid where ba.fid = ?)");
        sb.append(" )");
        sb.append(" ) as operatingCount");
        sb.append(" from t_ssc_user u");
        sb.append(" where u.FID in " + FormatUtils.list2Sql(userIds));
        sb.append(" order by operatingCount asc");
        Object[] param = new Object[]{bussAttrId};
        IRowSet rs = null;
        try {
            logger.error((Object)"sortUserIdByTaskAsc:");
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            userIds = JobUtils.sort(ctx, rs, bussAttrId);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                logger.error((Object)"Query least task user error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
        }
        JobUtils.closeRS(rs);
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> sortUserIdByPressureAsc(Context ctx, String bussAttrId, List<String> userIds) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select u.fid,");
        sb.append(" (select max(fworkPressure) from t_ssc_workPressure where fuserid = u.fid) as workPressure");
        sb.append(" from t_ssc_user u");
        sb.append(" where u.FID in " + FormatUtils.list2Sql(userIds));
        sb.append(" order by workPressure asc,u.fapproveCoe desc");
        Object[] param = new Object[]{bussAttrId};
        IRowSet rs = null;
        try {
            logger.error((Object)"sortUserIdByPressureAsc:");
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            userIds = JobUtils.sort(ctx, rs, bussAttrId);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                logger.error((Object)"Query least task user error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
        }
        JobUtils.closeRS(rs);
        return userIds;
    }

    public static List<String> sort(Context ctx, IRowSet rs, String bussAttrId) throws SQLException, BOSException {
        TreeMap<Float, String> map = new TreeMap<Float, String>();
        while (rs.next()) {
            Float key = Float.valueOf(rs.getFloat(2));
            String value = (String)map.get(key);
            if (value == null) {
                map.put(key, rs.getString(1));
                continue;
            }
            map.put(key, value + "," + rs.getString(1));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (Map.Entry e : map.entrySet()) {
            String[] users = ((String)e.getValue()).split(",");
            if (users.length == 1) {
                userIds.add(users[0]);
                continue;
            }
            Random r = new Random();
            ArrayList<Integer> rl = new ArrayList<Integer>();
            for (int i = 0; i < users.length; ++i) {
                int ri = r.nextInt(users.length);
                while (rl.contains(ri)) {
                    ri = r.nextInt(users.length);
                }
                rl.add(ri);
                userIds.add(users[ri]);
            }
        }
        return userIds;
    }

    public static boolean isOverMax(Context ctx, String bussAttrId, String userId) throws BOSException, EASBizException {
        if (EqualDivisionUtils.isEqualDivision(ctx, ShareCenterUtils.getShareCenterIdBySSCUserId(ctx, userId))) {
            return JobUtils.isOverMaxPressure(ctx, userId);
        }
        return JobUtils.isOverMaxJobCount(ctx, bussAttrId, userId);
    }

    private static boolean isOverMaxPressure(Context ctx, String userId) throws BOSException {
        try {
            String sid = ShareCenterUtils.getShareCenterIdBySSCUserId(ctx, userId);
            double maxPressure = EqualDivisionUtils.getEqualDivisionMaxNumber(ctx, sid);
            WorkPressureInfo info = null;
            try {
                info = WorkPressureFactory.getLocalInstance(ctx).getWorkPressureInfo("where user.id = '" + userId + "'");
            }
            catch (InvalidEntityViewException e) {
                WorkPressureCollection colls = WorkPressureFactory.getLocalInstance(ctx).getWorkPressureCollection("where user.id = '" + userId + "'");
                info = colls.get(0);
                WorkPressureFactory.getLocalInstance(ctx).delete("where user.id = '" + userId + "' and id !='" + info.getId().toString() + "'");
            }
            if (maxPressure > 0.0 && info.getWorkPressure().doubleValue() >= maxPressure) {
                return true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isOverMaxJobCount(Context ctx, String bussAttrId, String userId) throws BOSException {
        int count;
        IRowSet rs;
        Object[] param;
        StringBuffer sql;
        block5: {
            SystemAttributeInfo sysAttr = JobUtils.getSystemAttribute(ctx, bussAttrId);
            sql = new StringBuffer();
            sql.append(" select count(1) from t_ssc_job j");
            sql.append(" where j.FPersonnelIDID = ? and j.FJobPoolingType = '2'");
            sql.append(" and j.FBussAttrIDID in (select ba.fid from t_ssc_bussinessattribute ba inner join t_ssc_billType bt on ba.fbilltypeid=bt.fid inner join t_ssc_systemattribute sy on bt.fsysattrid=sy.fid where sy.fid = ? )");
            param = new Object[]{userId, sysAttr.getId().toString()};
            rs = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            if (!rs.next()) break block5;
            count = rs.getInt(1);
            logger.info((Object)("****isOverMaxJobCount**bussAttrID**" + bussAttrId + "**userId*******" + userId + "*****sysAttr****" + sysAttr.getMaxNumber() + "***count***" + count));
            if (count < sysAttr.getMaxNumber()) break block5;
            boolean bl = true;
            JobUtils.closeRS(rs);
            return bl;
        }
        try {
            count = 0;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sql.toString()));
                logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                logger.error((Object)"Query max task count error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
            return true;
        }
        JobUtils.closeRS(rs);
        return count != 0;
    }

    private static SystemAttributeInfo getSystemAttribute(Context ctx, String bussAttrId) {
        SystemAttributeInfo systemAttributeInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select sy.FID ");
        sql.append(" from T_SSC_BussinessAttribute ba");
        sql.append(" inner join T_SSC_BillType bt on ba.fbilltypeid=bt.fid ");
        sql.append(" inner join t_ssc_systemattribute sy on bt.fsysattrid = sy.fid ");
        sql.append(" where ba.fid = '" + bussAttrId + "'");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        try {
            SystemAttributeCollection systemAttributeCollection = SystemAttributeFactory.getLocalInstance(ctx).getSystemAttributeCollection(view);
            if (systemAttributeCollection != null && systemAttributeCollection.size() > 0) {
                systemAttributeInfo = systemAttributeCollection.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("sql:" + sql.toString()));
            logger.error((Object)"Query lv1 systemAttr error!", (Throwable)e);
        }
        return systemAttributeInfo;
    }

    private static boolean isCreator(Context ctx, JobInfo jobInfo, UserInfo userInfo) throws EASBizException {
        try {
            DynamicValueInfo info = DynamicValueFactory.getLocalInstance(ctx).getDynamicValueInfo("where dynamicID.id ='4VBUlqSUQuO8g8sPkTkXsZvLn80=' and jobID.id ='" + jobInfo.getId().toString() + "'");
            String createId = info.getDinamicValue();
            if (StringUtils.isNotBlank((String)createId) && (createId.equals(userInfo.getEasUserId()) || createId.equals(userInfo.getPersonnelID()) || createId.equals(userInfo.getUserID()))) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static UserInfo getCanAssignUser(Context ctx, JobInfo job, List<String> userIds, Map<String, String> assigneeMap, boolean isIgnoreMaxOver) throws AssignException, Exception {
        HashSet<String> temp = new HashSet<String>(userIds);
        boolean onlyOne = temp.size() == 1;
        boolean isEnableOnDuty = true;
        SysParamMgerCollection smColl = SysParamMgerFactory.getLocalInstance(ctx).getSysParamMgerCollection("select * where shareCenterId='" + job.getShareCenterID().getId().toString() + "'");
        if (smColl.size() > 0) {
            isEnableOnDuty = !smColl.get(0).isIsHideDimission();
        }
        for (String id : userIds) {
            try {
                UserInfo user = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                logger.error((Object)("\u6700\u7ec8\u5206\u914d\u4eba\u5458\u7684ID\uff1a" + id));
                if (!user.isIsEnabled() || StopAssignEnum.normal != user.getIsStopAssign() || isEnableOnDuty && user.getDimission() != null && 0 == user.getDimission().getValue() || !onlyOne && JobUtils.isCreator(ctx, job, user)) continue;
                if (!isIgnoreMaxOver && job.getJoblevel().getValue() > 10 && JobUtils.isOverMax(ctx, job.getBussAttrID().getId().toString(), user.getId().toString())) {
                    throw new AssignException(AssignException.OVERMAX);
                }
                String consignerId = assigneeMap.get(user.getId().toString());
                if (StringUtils.isNotBlank((String)consignerId)) {
                    UserInfo consigner = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)consignerId)));
                    job.setConsigner(consigner);
                    boolean hasPermission = SSCUtil.checkPermission(ctx, user, job);
                    if (!hasPermission) {
                        SSCUtil.genAndAllotCompelRole(ctx, job.getBussAttrID().getId().toString(), user.getId().toString(), job.getShareCenterID().getId().toString(), true);
                    }
                }
                return user;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (UuidException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        throw new AssignException(AssignException.USERSTATEERROR);
    }

    public static List<String> sortUserId(Context ctx, String bussAttrId, List<String> userIds) {
        try {
            userIds = EqualDivisionUtils.isEqualDivision(ctx, ShareCenterUtils.getShareCenterIdBySSCUserId(ctx, userIds.get(0))) ? JobUtils.sortUserIdByPressureAsc(ctx, bussAttrId, userIds) : JobUtils.sortUserIdByTaskAsc(ctx, bussAttrId, userIds);
        }
        catch (Exception e) {
            logger.error((Object)("\u6392\u5e8f\u5931\u8d25\uff0c" + e.getMessage()), (Throwable)e);
        }
        return userIds;
    }

    public static UserInfo getLeastTaskUser(Context ctx, JobInfo job, String bussAttrId, List<String> userIds, boolean isIgnoreMaxOver, UserInfo user) throws Exception {
        if (null == userIds || 0 == userIds.size()) {
            return null;
        }
        if (1 < userIds.size()) {
            userIds = JobUtils.sortUserId(ctx, bussAttrId, userIds);
        }
        logger.error((Object)(job.getSubject() + ",\u6839\u636e\u4efb\u52a1\u91cf\u6392\u5e8f\u540e\u7684\u4eba\u5458ID\uff1a" + userIds));
        UserInfo originalAssignUser = JobUtils.handleRejectedJob(ctx, job);
        if (originalAssignUser != null && userIds.contains(originalAssignUser.getId().toString())) {
            userIds.remove(originalAssignUser.getId().toString());
            userIds.add(0, originalAssignUser.getId().toString());
            isIgnoreMaxOver = true;
            logger.error((Object)("\u9ed8\u8ba4\u5206\u914d\u89c4\u5219--\u6709\u6253\u56de\u7684\u60c5\u51b5--\u539f\u5904\u7406\u4eba\u6709\u6743\u9650--\u539f\u5904\u7406\u4eba:[" + originalAssignUser.getId().toString() + "]"));
        }
        HashMap<String, List<String>> consignerMap = new HashMap<String, List<String>>();
        HashMap<String, String> assigneeMap = new HashMap<String, String>();
        boolean isExistConsignerRelation = JobUtils.isExistConsignerRelation(ctx, bussAttrId, userIds, consignerMap, assigneeMap);
        ArrayList<String> sortResult = new ArrayList<String>();
        if (isExistConsignerRelation) {
            for (String userId : userIds) {
                List<String> temp = (List<String>)consignerMap.get(userId);
                if (null == temp || 0 == temp.size()) {
                    sortResult.add(userId);
                    continue;
                }
                temp = JobUtils.sortUserId(ctx, bussAttrId, temp);
                sortResult.addAll(temp);
            }
            userIds = new ArrayList<String>(sortResult);
        }
        logger.error((Object)(job.getSubject() + ",\u8ba1\u7b97\u59d4\u6258\u4efb\u52a1\u540e\u7684\u4eba\u5458ID\uff1a" + userIds));
        if (user != null) {
            List temp = (List)consignerMap.get(user.getId().toString());
            if (temp != null && temp.size() > 0) {
                userIds.add(user.getId().toString());
            }
            if (userIds.contains(user.getId().toString())) {
                userIds.remove(user.getId().toString());
                userIds.add(0, user.getId().toString());
                isIgnoreMaxOver = true;
                logger.error((Object)("\u9ed8\u8ba4\u5206\u914d\u89c4\u5219--\u62c9\u53d6\u4efb\u52a1--\u62c9\u53d6\u4eba:[" + user.getId().toString() + "]"));
            }
        }
        return JobUtils.getCanAssignUser(ctx, job, userIds, assigneeMap, isIgnoreMaxOver);
    }

    public static boolean isEnabledForUser(Context ctx, UserInfo userInfo) {
        return userInfo.isIsEnabled() && JobUtils.isEnabledForEasUser(ctx, userInfo);
    }

    public static boolean isEnabledForEasUser(Context ctx, UserInfo userInfo) {
        com.kingdee.eas.base.permission.UserInfo easUser = null;
        try {
            easUser = com.kingdee.eas.base.permission.UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userInfo.getEasUserId()));
            if (!easUser.isIsForbidden()) {
                return true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static List<UserInfo> getEnabledUser(Context ctx, List<UserInfo> userInfos) {
        if (null == userInfos || 0 == userInfos.size()) {
            return userInfos;
        }
        ArrayList<UserInfo> enabledUsers = new ArrayList<UserInfo>();
        for (UserInfo userInfo : userInfos) {
            if (!JobUtils.isEnabledForUser(ctx, userInfo)) continue;
            enabledUsers.add(userInfo);
        }
        return enabledUsers;
    }

    public static String getAutoApproveUserId(Context ctx, String jobId, ExtendERPInfo erpInfo) throws BOSException {
        String userId = null;
        String userNumber = EASCfgUtil.getValue(ctx, erpInfo, "userName");
        StringBuffer sb = new StringBuffer();
        logger.error((Object)("\u67e5\u8be2\u81ea\u52a8\u5ba1\u6838\u4eba\u5458number:" + userNumber + "!"));
        sb.append("select fid from t_ssc_user a where a.ferpusernumber = ?  ");
        IRowSet tIRowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{userNumber});
        try {
            if (tIRowSet.next()) {
                userId = tIRowSet.getString(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u67e5\u8be2" + userNumber + "  \u81ea\u52a8\u5ba1\u6279\u4eba\u5931\u8d25!"), (Throwable)e);
        }
        logger.error((Object)("\u67e5\u8be2\u81ea\u52a8\u5ba1\u6838\u4eba\u5458\u8fd4\u56deuserId:" + userId + "!"));
        return userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserInfo handleRejectedJob(Context ctx, JobInfo job) throws BOSException, EASBizException {
        String position = "**jobInfo :{" + job.getId() + "@@" + job.getSubject() + "},\u5904\u7406\u6253\u56de\u903b\u8f91**";
        UserInfo assignUser = null;
        UserInfo consignUser = null;
        IUser iUser = UserFactory.getLocalInstance(ctx);
        String sql = "select FPERSONNELIDID, FCONSIGNERID from t_ssc_jobhis where FBUSSATTRIDID = ? and FBillID = ? and FAutoApprove = 0 order by fcreatetime desc";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{job.getBussAttrID().getId().toString(), job.getBillID()});
            if (rs.next()) {
                assignUser = new UserInfo();
                assignUser.setId(BOSUuid.read((String)rs.getString("FPERSONNELIDID")));
                assignUser = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(assignUser.getId()));
                String consignerId = rs.getString("FCONSIGNERID");
                if (!StringUtils.isBlank((String)consignerId)) {
                    consignUser = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(consignerId));
                }
            }
            JobUtils.closeRS(rs);
        }
        catch (Exception e) {
            logger.error((Object)(position + e.getMessage()), (Throwable)e);
        }
        finally {
            JobUtils.closeRS(rs);
        }
        logger.error((Object)(position + "\u67e5\u8be2\u7ed3\u679c.assignUser:" + (assignUser == null ? "null" : assignUser.getNumber()) + "**consignUser:" + (consignUser == null ? "null" : consignUser.getNumber())));
        String isReturnToOriginalPerson = ParamSetFacadeFactory.getLocalInstance(ctx).getSSCParam(job.getShareCenterID().getId().toString()).getIsReturnToOriginalPerson();
        if (Boolean.parseBoolean(isReturnToOriginalPerson) && consignUser != null && assignUser != null && !JobUtils.isEffectConsign(ctx, consignUser.getId().toString(), assignUser.getId().toString(), job.getBussAttrID().toString())) {
            assignUser = consignUser;
        }
        if (assignUser != null && JobUtils.isEnabledForUser(ctx, assignUser) && StopAssignEnum.normal == assignUser.getIsStopAssign()) {
            return assignUser;
        }
        return null;
    }

    private static boolean isEffectConsign(Context ctx, String consignerId, String assigneeId, String bussAttrId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT 1 FROM T_ssc_Consignation c,T_SSC_CONSIGNATIONENTRY ce");
        sb.append(" where c.FCONSIGNERID = ?");
        sb.append(" and c.FASSIGNEEID = ?");
        sb.append(" and ce.fbusstypeid = ?");
        sb.append(" and c.FSTATUS = '30'");
        sb.append(" and c.fid = ce.fparentid");
        Object[] params = new Object[]{consignerId, assigneeId, bussAttrId};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            if (rs.next()) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("sql:" + sb.toString()));
        }
        return false;
    }

    public static boolean isCallbackToOriginalPerso(Context ctx, String shareCenterId) {
        try {
            return ShareCenterUtils.getSysParamMgerInfo(ctx, shareCenterId).isIsCallbackToOriginalPerso();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static UserInfo getPackageAssignUser(Context ctx, JobInfo job, List<String> userIds, AssignRuleInfo assignRuleInfo, AssignRuleCollection assignRuleCollection, UserInfo user) throws Exception {
        if (userIds == null || userIds.isEmpty()) {
            return null;
        }
        ArrayList<String> prUserIds = new ArrayList();
        boolean isIgnoreMaxOver = false;
        PackageConfigEntryCollection prColl = JobUtils.getPackageAssignRule(ctx, job);
        if (prColl != null && !prColl.isEmpty()) {
            int len = prColl.size();
            for (int i = 0; i < len; ++i) {
                PackageConfigEntryInfo prInfo = prColl.get(i);
                String attrNumber = prInfo.getAttrNumber();
                if (!StringUtils.isNotBlank((String)attrNumber)) continue;
                List mapList = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)attrNumber, List.class);
                int ruleSize = mapList.size();
                StringBuffer sb = new StringBuffer();
                sb.append("where jobId = '" + job.getId().toString() + "' and (");
                for (Map map : mapList) {
                    if (ruleSize > 1) {
                        sb.append(" dynamicID = '" + map.get("id") + "' or");
                    } else {
                        sb.append(" dynamicID = '" + map.get("id") + "'");
                    }
                    --ruleSize;
                }
                sb.append(")");
                DynamicValueCollection dvColl = DynamicValueFactory.getLocalInstance(ctx).getDynamicValueCollection(sb.toString());
                if (dvColl == null || dvColl.isEmpty()) continue;
                HashMap<String, String> rule = new HashMap<String, String>();
                int len2 = dvColl.size();
                for (int j = 0; j < len2; ++j) {
                    DynamicValueInfo dvInfo = dvColl.get(j);
                    if (JobUtils.isDynamicValueNumber(ctx, dvInfo.getDynamicID().getId().toString())) {
                        rule.put(dvInfo.getDynamicID().getId().toString(), dvInfo.getDigiValue().toString());
                        continue;
                    }
                    rule.put(dvInfo.getDynamicID().getId().toString(), dvInfo.getDinamicValue());
                }
                String userId = JobUtils.getPackageAssignUser(ctx, rule, 3, userIds, job.getShareCenterID().getId().toString(), assignRuleInfo, assignRuleCollection);
                if (!StringUtils.isNotBlank((String)userId)) continue;
                prUserIds.add(userId);
                isIgnoreMaxOver = true;
                break;
            }
        }
        if (prUserIds.isEmpty()) {
            prUserIds = userIds;
        }
        logger.error((Object)(job.getSubject() + ",\u6253\u5305\u5206\u914d\u540e\u7684\u4eba\u5458ID\uff1a" + prUserIds));
        return JobUtils.getPreBussAttrUser(ctx, job, job.getBussAttrID().getId().toString(), prUserIds, isIgnoreMaxOver, user);
    }

    private static UserInfo getPreBussAttrUser(Context ctx, JobInfo job, String bussAttrId, List<String> userIds, boolean isIgnoreMaxOver, UserInfo user) throws Exception {
        BussinessAttributeInfo bussAttrInfo = JobUtils.getBussAttrInfo(ctx, job, bussAttrId);
        BussinessAttributeInfo preBussAttr = bussAttrInfo.getPreBussAttr();
        if (null != preBussAttr) {
            List<String> billIds = new ArrayList<String>();
            if (bussAttrInfo.getBillType().getId().equals((Object)preBussAttr.getBillType().getId())) {
                billIds.add(job.getBillID());
            } else {
                ERPWebService service = ERPUtil.getERPWebServiceImplByJob(ctx, job.getId().toString());
                if (service instanceof ERPWebServiceBill) {
                    billIds = ((ERPWebServiceBill)((Object)service)).getSourcesBillIds(ctx, job);
                } else {
                    logger.error((Object)(job.getSubject() + "\uff0c\u6ca1\u6709\u5b9e\u73b0ERPWebServiceBill\u83b7\u53d6\u4e0a\u6709\u5355\u636e\u7684\u63a5\u53e3"));
                }
            }
            List<String> preBussAttrUsers = JobUtils.getPreBussAttrPermissionUser(ctx, billIds, preBussAttr.getId().toString(), userIds);
            if (!preBussAttrUsers.isEmpty()) {
                if (!bussAttrInfo.isIsNotAllowDeal()) {
                    userIds = preBussAttrUsers;
                    logger.error((Object)(job.getSubject() + ",\u76f8\u540c-----\u524d\u7f6e\u4efb\u52a1\u5904\u7406\u4ebaID\uff1a" + preBussAttrUsers));
                } else {
                    userIds.removeAll(preBussAttrUsers);
                    logger.error((Object)(job.getSubject() + ",\u4e0d\u540c-----\u524d\u7f6e\u4efb\u52a1\u5904\u7406\u4ebaID\uff1a" + preBussAttrUsers));
                }
            }
        }
        logger.error((Object)(job.getSubject() + ",\u8ba1\u7b97\u524d\u7f6e\u4efb\u52a1\u540e\u7684\u4eba\u5458ID\uff1a" + userIds));
        return JobUtils.getLeastTaskUser(ctx, job, job.getBussAttrID().getId().toString(), userIds, isIgnoreMaxOver, user);
    }

    public static List<String> getPreBussAttrUser(Context ctx, JobInfo job, BussinessAttributeInfo bussAttrInfo, boolean isIgnoreMaxOver, List<String> userIds) throws SSCException {
        try {
            BussinessAttributeInfo preBussAttr = bussAttrInfo.getPreBussAttr();
            if (null != preBussAttr) {
                List<String> billIds = new ArrayList<String>();
                if (bussAttrInfo.getBillType().getId().equals((Object)preBussAttr.getBillType().getId())) {
                    billIds.add(job.getBillID());
                } else {
                    ERPWebService service = ERPUtil.getERPWebServiceImplByJob(ctx, job.getId().toString());
                    if (service instanceof ERPWebServiceBill) {
                        billIds = ((ERPWebServiceBill)((Object)service)).getSourcesBillIds(ctx, job);
                    } else {
                        logger.error((Object)(job.getSubject() + "\uff0c\u6ca1\u6709\u5b9e\u73b0ERPWebServiceBill\u83b7\u53d6\u4e0a\u6709\u5355\u636e\u7684\u63a5\u53e3"));
                    }
                }
                return JobUtils.getPreBussAttrPermissionUser(ctx, billIds, preBussAttr.getId().toString(), userIds);
            }
            return new ArrayList<String>();
        }
        catch (Exception e) {
            throw new SSCException(SSCException.UNKNOW, new Object[]{"\u83b7\u53d6\u524d\u7f6e\u4efb\u52a1\u5904\u7406\u4eba\u5f02\u5e38"});
        }
    }

    @Deprecated
    public static Boolean isAllowDeal(Context ctx, JobInfo job, String preBussAttrId, String bussAttrId) {
        Object[] params = new Object[]{preBussAttrId, job.getShareCenterID().getId().toString(), bussAttrId};
        String sql = "select FIsNotAllowDeal from T_SSC_BussinessAttributeExt where FPREBUSSATTRID=? and FShareCenterId=? and FBussIdID=?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rs.next()) {
                if (rs.getInt(1) == 0) {
                    return true;
                }
                if (rs.getInt(1) == 1) {
                    return false;
                }
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "select FIsNotAllowDeal from T_SSC_BussinessAttribute where FPREBUSSATTRID=? and FShareCenterId=? and fid=? "), (Object[])params)).next()) {
                if (rs.getInt(1) == 0) {
                    return true;
                }
                if (rs.getInt(1) == 1) {
                    return false;
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.error((Object)("\u51fa\u9519\u5566,\u524d\u7f6e\u4efb\u52a1\u7c7b\u578b\u6709\u503c\u65f6,FIsAllowPreBusUser \u4e00\u5b9a\u6709\u503c,sql:" + sql));
        return null;
    }

    public static List<String> getPreBussAttrPermissionUser(Context ctx, List<String> billIds, String bussAttrId, List<String> userIds) throws BOSException, EASBizException {
        String userStr = FormatUtils.list2Sql(userIds);
        ArrayList<String> preBussAttrUser = new ArrayList<String>();
        if (null == billIds || billIds.size() == 0) {
            return preBussAttrUser;
        }
        String billIdsStr = FormatUtils.list2Sql(billIds);
        StringBuffer sb = new StringBuffer();
        sb.append(" select * from (");
        sb.append(" select fpersonnelidid,flastupdatetime from t_ssc_job where FBussAttrIDID=? and FBillId  in " + billIdsStr);
        if (null != userIds && userIds.size() != 0) {
            sb.append(" and fpersonnelidid in" + userStr);
        }
        sb.append(" union all");
        sb.append(" select fpersonnelidid,flastupdatetime from t_ssc_jobhis where FBussAttrIDID=? and FBillId in " + billIdsStr);
        if (null != userIds && userIds.size() != 0) {
            sb.append(" and fpersonnelidid in" + userStr);
        }
        sb.append(" ) m ");
        sb.append(" order by m.flastupdatetime desc");
        Object[] params = new Object[]{bussAttrId, bussAttrId};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            if (rs.next()) {
                preBussAttrUser.add(rs.getString(1));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return preBussAttrUser;
    }

    public static BussinessAttributeInfo getBussAttrInfo(Context ctx, JobInfo job, String bussAttrId) throws BOSException, EASBizException {
        BussinessAttributeInfo bussinessAttributeInfo = BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeInfo("select isNotAllowDeal, billType, preBussAttr.* where id = '" + bussAttrId + "' ");
        BussinessAttributeExtCollection bussinessAttributeExtCollection = BussinessAttributeExtFactory.getLocalInstance(ctx).getBussinessAttributeExtCollection("select isNotAllowDeal, preBussAttr.* where bussId = '" + bussAttrId + "' and shareCenterId = '" + job.getShareCenterID().getId().toString() + "'");
        if (bussinessAttributeExtCollection.size() > 0) {
            bussinessAttributeInfo.setPreBussAttr(bussinessAttributeExtCollection.get(0).getPreBussAttr());
            bussinessAttributeInfo.setIsNotAllowDeal(bussinessAttributeExtCollection.get(0).isIsNotAllowDeal());
        }
        return bussinessAttributeInfo;
    }

    @Deprecated
    public static String getPreBussAttrId(Context ctx, JobInfo job, String bussAttrId) {
        Object[] params = new Object[]{bussAttrId, job.getShareCenterID().getId().toString()};
        try {
            String sql = "select FPreBussAttrID from T_SSC_BussinessAttributeExt where FBussIdID=? and FShareCenterId=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rs.next()) {
                return rs.getString(1);
            }
            sql = "select FPreBussAttrID from T_SSC_BussinessAttribute where FID=? and FShareCenterId=?";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static PackageConfigEntryCollection getPackageAssignRule(Context ctx, JobInfo job) throws BOSException, EASBizException {
        String oql = "where shareCenterId='" + job.getShareCenterID().getId().toString() + "' and bussAttr.id='" + job.getBussAttrID().getId().toString() + "'";
        IObjectPK[] pk = PackageConfigFactory.getLocalInstance(ctx).getPKList(oql);
        if (pk != null && 1 == pk.length) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pk[0].toString()));
            SorterItemCollection sorterItemCollection = new SorterItemCollection();
            sorterItemCollection.add(new SorterItemInfo("priority"));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            view.setSorter(sorterItemCollection);
            return PackageConfigEntryFactory.getLocalInstance(ctx).getPackageConfigEntryCollection(view);
        }
        return null;
    }

    public static String getPackageAssignUser(Context ctx, Map<String, String> rule, int daysAgo, List<String> userIds, String shareCenterId, AssignRuleInfo assignRuleInfo, AssignRuleCollection assignRuleCollection) {
        return JobUtils.getPackageAssignUser(ctx, rule, daysAgo, userIds, shareCenterId, assignRuleInfo, assignRuleCollection, null);
    }

    public static String getPackageAssignUser(Context ctx, Map<String, String> rule, int daysAgo, List<String> userIds, String shareCenterId, AssignRuleInfo assignRuleInfo, AssignRuleCollection assignRuleCollection, String busId) {
        String userId = JobUtils.getPackageAssignUser(ctx, rule, daysAgo, "t_ssc_job", "t_ssc_dynamicvalue", userIds, shareCenterId, assignRuleInfo, assignRuleCollection, busId);
        if (StringUtils.isBlank((String)userId)) {
            userId = JobUtils.getPackageAssignUser(ctx, rule, daysAgo, "t_ssc_jobhis", "t_ssc_dynvaluehis", userIds, shareCenterId, assignRuleInfo, assignRuleCollection, busId);
        }
        return userId;
    }

    private static String getPackageAssignUser(Context ctx, Map<String, String> rule, int daysAgo, String jobTable, String dynTable, List<String> userIds, String shareCenterId, AssignRuleInfo assignRuleInfo, AssignRuleCollection assignRuleCollection, String busId) {
        String userId = null;
        List<String> jobIds = JobUtils.getJobIdsByPackageRule(ctx, rule, jobTable, dynTable, daysAgo, shareCenterId, busId);
        if (null != jobIds && !jobIds.isEmpty()) {
            List<String> tempUserIds = JobUtils.getPackageUserIds(ctx, jobIds, userIds, jobTable);
            if (tempUserIds.isEmpty()) {
                return null;
            }
            if (1 == tempUserIds.size()) {
                return tempUserIds.get(0);
            }
            if (assignRuleInfo == null) {
                return JobUtils.getApprover(ctx, jobIds, jobTable, tempUserIds);
            }
            block2: for (String jobId : jobIds) {
                JobInfo jobInfo = null;
                try {
                    JobCollection jobCollection = JobFactory.getLocalInstance(ctx).getJobCollection("select * where id ='" + jobId + "'");
                    if (jobCollection.isEmpty()) {
                        JobHisCollection jobHisCollection = JobHisFactory.getLocalInstance(ctx).getJobHisCollection("select * where id ='" + jobId + "'");
                        JobHisInfo jobHisInfo = jobHisCollection.get(0);
                        jobInfo = new JobInfo();
                        jobInfo.setId(jobHisInfo.getId());
                        jobInfo.setBussAttrID(jobHisInfo.getBussAttrID());
                        jobInfo.setBillID(jobHisInfo.getBillID());
                        jobInfo.setSscBillID(jobHisInfo.getSscBillID());
                    } else {
                        jobInfo = jobCollection.get(0);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"\u6253\u5305\u5206\u914d\u89c4\u5219\u67e5\u8be2\u5f53\u524d\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
                    break;
                }
                DynamicValueCollection dynamicValueCollection = JobUtils.getCustomerAssignRuleColumn(ctx, jobId);
                for (int j = 0; j < assignRuleCollection.size(); ++j) {
                    AssignRuleInfo temp = assignRuleCollection.get(j);
                    if (!JobUtils.isAssignRuleMatchNew(ctx, temp, dynamicValueCollection, jobInfo)) continue;
                    if (!temp.getId().equals((Object)assignRuleInfo.getId())) continue block2;
                    userId = JobUtils.getApprover(ctx, jobId, jobTable, tempUserIds);
                    if (!StringUtils.isNotBlank((String)userId)) continue;
                    return userId;
                }
            }
        }
        return userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getPackageUserIds(Context ctx, List<String> jobIds, List<String> userIds, String table) {
        String jobIdStr = FormatUtils.list2Sql(jobIds);
        String userIdStr = FormatUtils.list2Sql(userIds);
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct fpersonnelidid");
        sb.append(" from " + table);
        sb.append(" where fpersonnelidid in" + userIdStr);
        sb.append(" and fid in" + jobIdStr);
        ArrayList<String> ids = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)"getUserIdsByJobIds error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
        }
        JobUtils.closeRS(rs);
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getApprover(Context ctx, String jobId, String table, List<String> userIds) {
        IRowSet rs;
        block4: {
            String string;
            String userIdStr = FormatUtils.list2Sql(userIds);
            StringBuffer sb = new StringBuffer();
            sb.append(" select u.fid from ");
            sb.append(table + " j,t_ssc_user u");
            sb.append(" where j.FPERSONNELIDID = u.fid");
            sb.append(" and u.FISENABLED = '1'");
            sb.append(" and j.fid = '" + jobId + "'");
            sb.append(" and u.fid in " + userIdStr);
            sb.append(" order by j.fcreatetime desc");
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (!rs.next()) break block4;
                string = rs.getString(1);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("sql:" + sb.toString()));
                    logger.error((Object)"getApprover error!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    JobUtils.closeRS(rs);
                    throw throwable;
                }
                JobUtils.closeRS(rs);
            }
            JobUtils.closeRS(rs);
            return string;
        }
        JobUtils.closeRS(rs);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getApprover(Context ctx, List<String> jobIds, String table, List<String> userIds) {
        IRowSet rs;
        block4: {
            String string;
            String jobIdStr = FormatUtils.list2Sql(jobIds);
            String userIdStr = FormatUtils.list2Sql(userIds);
            StringBuffer sb = new StringBuffer();
            sb.append(" select u.fid from ");
            sb.append(table + " j,t_ssc_user u");
            sb.append(" where j.FPERSONNELIDID = u.fid");
            sb.append(" and u.FISENABLED = '1'");
            sb.append(" and j.fid in " + jobIdStr);
            sb.append(" and u.fid in " + userIdStr);
            sb.append(" order by j.fcreatetime desc");
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (!rs.next()) break block4;
                string = rs.getString(1);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("sql:" + sb.toString()));
                    logger.error((Object)"getApprover error!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    JobUtils.closeRS(rs);
                    throw throwable;
                }
                JobUtils.closeRS(rs);
            }
            JobUtils.closeRS(rs);
            return string;
        }
        JobUtils.closeRS(rs);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> getJobIdsByPackageRule(Context ctx, Map<String, String> rule, String jobTable, String dynTable, int daysAgo, String shareCenterId, String busId) {
        ArrayList<String> arrayList;
        if (null == rule || rule.isEmpty()) {
            return null;
        }
        int len = rule.size();
        StringBuilder selectSql = new StringBuilder(" select j.FID");
        StringBuilder fromSql = new StringBuilder(" from " + jobTable + " j");
        for (int i = 0; i < len; ++i) {
            fromSql.append("," + dynTable + " dv" + i);
        }
        StringBuilder whereSql = new StringBuilder(" where dv0.FJOBIDID=j.FID");
        int i = 0;
        Object[] params = new Object[2 * len];
        for (String key : rule.keySet()) {
            whereSql.append(" and dv" + i + ".FDYNAMICIDID = ?");
            whereSql.append(" and dv" + i + ".FDINAMICVALUE = ?");
            if (i != 0) {
                whereSql.append(" and dv" + (i - 1) + ".FJOBIDID = dv" + i + ".FJOBIDID");
            }
            params[2 * i] = key;
            params[2 * i + 1] = rule.get(key);
            ++i;
        }
        if (daysAgo != 0) {
            String dateStr = "";
            try {
                dateStr = WorkDateUtil.getInstance(ctx, shareCenterId, false).getDate(new Date(), -daysAgo);
                logger.error((Object)("\u83b7\u53d6" + daysAgo + "\u5929\u524d\u7684\u5de5\u4f5c\u65e5\u5386\u65f6\u95f4\u4e3a:" + dateStr));
            }
            catch (SSCException e1) {
                dateStr = JobUtils.getDate(daysAgo);
                logger.error((Object)("\u83b7\u53d6\u5de5\u4f5c\u65e5\u5386\u65f6\u95f4\u5931\u8d25\uff0c\u83b7\u53d63\u5929\u524d\u81ea\u7136\u65e5:" + dateStr));
            }
            whereSql.append(" and j.FRECEIVETIME > {ts'" + dateStr + "'}");
        }
        if (!StringUtils.isEmpty((String)busId)) {
            whereSql.append(" and j.FBussAttrIDID = '" + busId + "' ");
        }
        StringBuilder orderSql = new StringBuilder(" order by j.FRECEIVETIME desc");
        String sql = selectSql.toString() + fromSql.toString() + whereSql.toString() + orderSql.toString();
        ArrayList<String> jobIds = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            while (rs.next()) {
                jobIds.add(rs.getString(1));
            }
            arrayList = jobIds;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sql));
                logger.error((Object)("parems:" + params));
                logger.error((Object)"getJobIdsByPackageRule error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
            return null;
        }
        JobUtils.closeRS(rs);
        return arrayList;
    }

    private static String getDate(int day) {
        Date temp = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(temp);
        calendar.add(5, -day);
        temp = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(temp);
    }

    public static DynamicValueCollection getCustomerAssignRuleColumn(Context ctx, String jobId) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("jobID.id", (Object)jobId));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("dynamicID.*");
        entityViewInfo.setSelector(selectorItemCollection);
        try {
            int i;
            DynamicValueCollection coll = DynamicValueFactory.getLocalInstance(ctx).getDynamicValueCollection(entityViewInfo);
            int j = coll.size();
            DynamicValueCollection coll2 = new DynamicValueCollection();
            ArrayList<DynamicValueInfo> list = new ArrayList<DynamicValueInfo>(j);
            for (i = 0; i < j; ++i) {
                list.add(coll.get(i));
            }
            Collections.sort(list, new Comparator<DynamicValueInfo>(){

                @Override
                public int compare(DynamicValueInfo paramT1, DynamicValueInfo paramT2) {
                    if (paramT1.getDynamicID().getNumber().length() > paramT2.getDynamicID().getNumber().length()) {
                        return -1;
                    }
                    if (paramT1.getDynamicID().getNumber().length() < paramT2.getDynamicID().getNumber().length()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (i = 0; i < j; ++i) {
                coll2.add((DynamicValueInfo)list.get(i));
            }
            return coll2;
        }
        catch (BOSException e) {
            logger.error((Object)"\u67e5\u8be2\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219\u5b57\u6bb5\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    public static boolean isAssignRuleMatch(String script, DynamicValueCollection dynamicValueCollection) {
        Boolean assignResult = ScriptEngineUtil.isRuleMatch(script, dynamicValueCollection);
        return assignResult;
    }

    public static boolean isDynamicValueNumber(Context ctx, String dynamicId) {
        try {
            DynamicAttributeInfo dynamicAttributeInfo = DynamicAttributeFactory.getLocalInstance(ctx).getDynamicAttributeInfo(H.PK(dynamicId));
            return FieldType.NUMBER.equals((Object)dynamicAttributeInfo.getType());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static String getSSOUrl(Context ctx, ExtendERPInfo extendERPInfo, String url) {
        if (StringUtils.isEmpty((String)url)) {
            return "";
        }
        String ltpaUrl = EASCfgUtil.getValue(ctx, extendERPInfo, "eas.login.ltpa.url");
        String username = JobUtils.getUserNumber(ctx, extendERPInfo);
        String password = EASCfgUtil.getPassword(ctx, extendERPInfo, username);
        return ltpaUrl + JobUtils.encodeUrl(url) + "&username=" + username + "&password=" + password;
    }

    private static String getUserNumber(Context ctx, ExtendERPInfo extendERPInfo) {
        String deployType = EASCfgUtil.getValue(ctx, extendERPInfo, "deployType");
        if ("0".equals(deployType)) {
            return ctx.getUserName();
        }
        return EASCfgUtil.getValue(ctx, extendERPInfo, "userName");
    }

    private static String encodeUrl(String url) {
        String encodeUrl = url;
        try {
            encodeUrl = URLEncoder.encode(encodeUrl, "UTF-8");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return encodeUrl;
    }

    public static CreditFilesNewInfo getCreditFilesByJobHis(Context ctx, JobHisInfo jobhis) throws EASBizException {
        CreditFilesNewInfo info = null;
        String sql = " select FDinamicValue from t_ssc_DynValueHis   where FDynamicIDID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' and FJobIDID='" + jobhis.getId().toString() + "'  ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                info = CreditFilesNewFactory.getLocalInstance(ctx).getCreditFilesNewInfoByUserId(rs.getString("FDinamicValue"));
            }
        }
        catch (BOSException e) {
            logger.error((Object)("BOSException\u6839\u636ejobhis\u83b7\u53d6\u63d0\u5355\u4ebaID\u5931\u8d25  jobhis id\u4e3a\uff1a" + jobhis.getId().toString()), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)("SQLException\u6839\u636ejobhis\u83b7\u53d6\u63d0\u5355\u4ebaID\u5931\u8d25  jobhis id\u4e3a\uff1a" + jobhis.getId().toString()), (Throwable)e);
        }
        return info;
    }

    public static boolean jobIsCurrent(Context ctx, String jobId) throws EASBizException, BOSException {
        return JobFactory.getLocalInstance(ctx).exists(H.PK(jobId));
    }

    public static String getJobState(Context ctx, String jobId) throws EASBizException, BOSException {
        if (JobUtils.jobIsCurrent(ctx, jobId)) {
            JobInfo jobInfo = JobFactory.getLocalInstance(ctx).getJobInfo(H.PK(jobId));
            return jobInfo.getJobState().getValue();
        }
        JobHisInfo jobHisInfo = JobHisFactory.getLocalInstance(ctx).getJobHisInfo(H.PK(jobId));
        if (jobHisInfo != null) {
            return jobHisInfo.getJobState().getValue();
        }
        throw new EASBizException(new NumericExceptionSubItem("1", "\u5171\u4eab\u4efb\u52a1Id\u4e3a[" + jobId + "]\u5728job\u548cjobhis\u91cc\u6ca1\u67e5\u5230\u4efb\u52a1\uff01"));
    }

    private static Date getDate(String day) throws ParseException {
        Calendar dar = Calendar.getInstance();
        dar.set(5, Integer.valueOf(day));
        return dar.getTime();
    }

    private static Date getTime(String time) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date data = new Date();
        String str = sdf.format(data.getTime());
        String startTime = str + " " + time;
        return sdf2.parse(startTime);
    }

    public static boolean isCustomAssignTime(String customAssignTime) {
        if (StringUtils.isBlank((String)customAssignTime)) {
            return true;
        }
        try {
            String[] params = customAssignTime.split(" ");
            String[] days = params[0].split("-");
            String[] times = params[1].split("-");
            Date startDate = JobUtils.getDate(days[0]);
            Date endDate = JobUtils.getDate(days[1]);
            Date now = new Date();
            Date startTime = JobUtils.getTime(times[0]);
            Date endTime = JobUtils.getTime(times[1]);
            return now.compareTo(startDate) >= 0 && now.compareTo(endDate) <= 0 && now.before(endTime) && now.after(startTime);
        }
        catch (ParseException e) {
            logger.error((Object)"\u89e3\u6790\u81ea\u5b9a\u4e49\u5206\u914d\u65f6\u95f4\u9519\u8bef\uff0c\u9ed8\u8ba4\u81ea\u52a8\u5206\u914d\uff01");
            return true;
        }
    }

    public static List<String> user2sscUser(Context ctx, List<String> userList) {
        String taskHandler = userList.get(0);
        ObjectUuidPK uuid = null;
        try {
            if (BOSUuid.isValid((String)taskHandler, (boolean)true)) {
                uuid = new ObjectUuidPK(taskHandler);
            }
        }
        catch (UuidException e) {
            logger.error((Object)("\u91cd\u626b\u4eba\u5458id\u4e0d\u662f\u6709\u6548\u7684uuid:[" + taskHandler + "]"));
        }
        ArrayList<String> sscUserList = new ArrayList<String>();
        try {
            if (uuid == null) {
                return sscUserList;
            }
            if ("80EF7DED".equals(uuid.getObjectType().toString())) {
                String sql = "SELECT fid FROM T_ssc_user WHERE FPERSONNELID in" + FormatUtils.list2Sql(userList);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rs.next()) {
                    sscUserList.add(rs.getString(1));
                }
            } else if ("13B7DE7F".equals(uuid.getObjectType().toString())) {
                String sql = "SELECT fid FROM T_ssc_user WHERE FUSERID in" + FormatUtils.list2Sql(userList);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rs.next()) {
                    sscUserList.add(rs.getString(1));
                }
            } else {
                sscUserList.addAll(userList);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u7528\u6237ID\u8f6c\u6362\u5931\u8d25");
        }
        catch (SQLException e) {
            logger.error((Object)"\u7528\u6237ID\u8f6c\u6362\u5931\u8d25");
        }
        return sscUserList;
    }

    public static void deleteJobRelateData(Context ctx, String jobId) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"delete from t_ssc_dynamicvalue where fjobidid = ? ", (Object[])new Object[]{jobId});
        DbUtil.execute((Context)ctx, (String)"delete from t_ssc_jobmessage where fjobidid = ? ", (Object[])new Object[]{jobId});
        DbUtil.execute((Context)ctx, (String)"delete from t_ssc_jobstatetime where fjobidid = ? ", (Object[])new Object[]{jobId});
        DbUtil.execute((Context)ctx, (String)"delete from t_ssc_ssclog where fjob =? ", (Object[])new Object[]{jobId});
        DbUtil.execute((Context)ctx, (String)" delete from t_ssc_jobExt where fjobid = ? ", (Object[])new Object[]{jobId});
        DbUtil.execute((Context)ctx, (String)"delete from T_SSC_IntelligentAuditOriData WHERE FJobId =? ", (Object[])new Object[]{jobId});
        DbUtil.execute((Context)ctx, (String)"delete from t_ssc_jobcheckdetailbillentry WHERE  FJOBCHECKDETAILID in(SELECT fid FROM t_ssc_jobcheckdetail where FJOBID = ? )", (Object[])new Object[]{jobId});
        DbUtil.execute((Context)ctx, (String)"delete from t_ssc_jobcheckdetail WHERE  FJOBID = ? ", (Object[])new Object[]{jobId});
        DbUtil.execute((Context)ctx, (String)" DELETE FROM T_SSC_IntelligentExecuteRecord WHERE  FJobId =? ", (Object[])new Object[]{jobId});
        DbUtil.execute((Context)ctx, (String)"delete from t_ssc_jobunpassrea where fjobid = ? ", (Object[])new Object[]{jobId});
        DbUtil.execute((Context)ctx, (String)"delete from t_ssc_job where fid =? ", (Object[])new Object[]{jobId});
    }

    public static Map<String, List<Map>> getDecisionsByFunNos(Context ctx, Set<String> funNos, String bussAttrId, String shareCenterId) throws BOSException, EASBizException {
        StringBuffer assignedSQL = new StringBuffer();
        assignedSQL.append("select di.fid, di.fname_l2 name,bfd.fisDefault, di.fvalue,bf.fnumber funNo ").append(" from T_SSC_BussAttrFunction bf left join  T_SSC_BussFunDecision bfd on bf.fid=bfd.FFunctionIdID").append(" left join T_SSC_DecisionItem di on bfd.FDecisionIdID=di.fid").append(" where bf.fnumber in").append(FormatUtils.set2Sql(funNos)).append(" and  bfd.FBussAttridID= ? and di.fid is not null and bfd.fshareCenterId= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)assignedSQL.toString(), (Object[])new Object[]{bussAttrId, shareCenterId});
        HashMap<String, List<Map>> ret = new HashMap<String, List<Map>>();
        for (String funNo : funNos) {
            ret.put(funNo, new ArrayList());
        }
        try {
            while (rs.next()) {
                HashMap<String, String> m = new HashMap<String, String>();
                String id = rs.getString("fid");
                String name = rs.getString("name");
                int value = rs.getInt("fvalue");
                int isDefault = rs.getInt("fisDefault");
                m.put("id", id);
                m.put("name", name);
                m.put("value", String.valueOf(value));
                m.put("pId", "0");
                if (isDefault == 1) {
                    m.put("checked", "true");
                }
                m.put("isDefault", "" + isDefault);
                ((List)ret.get(rs.getString("funNo"))).add(m);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    public static Map getCaConfig(Context ctx, JobInfo jobInfo, BussinessAttributeExtInfo bussextInfo) throws EASBizException, BOSException {
        HashMap<String, Object> tMap = new HashMap<String, Object>();
        CAType caType = jobInfo.getBussAttrID().getCaType();
        String billID = jobInfo.getBillID();
        if (bussextInfo != null) {
            caType = bussextInfo.getCaType();
        }
        if (caType == null) {
            caType = CAType.NONE;
        }
        tMap.put("caType", caType.getValue());
        if (!CAType.NONE.equals((Object)caType)) {
            com.kingdee.eas.base.permission.UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            tMap.put("userName", userInfo.getNumber());
            String checkPassword = ParamManager.getParamValue((Context)ctx, null, (String)"UKCA_CHECKPASSWORD");
            tMap.put("checkPassword", checkPassword);
            BOSObjectType bosType = BOSUuid.read((String)billID).getType();
            logger.error((Object)("_getCaConfigByJobID****bosType:" + bosType));
            IFrameHelperFacade facade = FrameHelperFacadeFactory.getLocalInstance((Context)ctx);
            Map tSignaturConfigMap = facade.getSignatrueConfig();
            SignatureFieldInfo tSignatureFieldInfo = (SignatureFieldInfo)tSignaturConfigMap.get(bosType.toString());
            if (tSignatureFieldInfo != null) {
                Map signatureFieldsMap = tSignatureFieldInfo.getFields();
                String signatureFields = "";
                for (Object key : signatureFieldsMap.keySet()) {
                    if ("".equals(signatureFields)) {
                        signatureFields = signatureFields + key;
                        continue;
                    }
                    signatureFields = signatureFields + ";" + key;
                }
                tMap.put("signatureFields", signatureFields);
                HashMap<String, String> precisionInfo = JobUtils.getEntityInfoByBOSType(ctx, bosType, signatureFieldsMap, tSignatureFieldInfo.getFieldDecimalInfo());
                tMap.put("precisionInfo", precisionInfo);
            }
        }
        return tMap;
    }

    private static HashMap<String, String> getEntityInfoByBOSType(Context ctx, BOSObjectType bosType, Map signatureFieldsMap, Map<String, String> signatureFieldDecimalMap) throws InvalidDAOMetaDataException {
        HashMap<String, String> precisionInfo = new HashMap<String, String>();
        EntityObjectInfo entityInfo = EntityUtility.getBOSEntity((Context)ctx, (BOSObjectType)bosType);
        for (Object key : signatureFieldsMap.keySet()) {
            PropertyInfo fld = entityInfo.getFieldByFullName((String)key);
            if (fld == null) {
                throw new InvalidDAOMetaDataException("field " + key + " can not found");
            }
            ColumnInfo col = fld.getMappingField();
            if (!SQLType.NUMERIC.equals((Object)col.getTypeName())) continue;
            String decimal = signatureFieldDecimalMap.get(key);
            if (decimal == null || decimal.length() <= 0) {
                decimal = "0";
            }
            precisionInfo.put((String)key, decimal);
        }
        return precisionInfo;
    }

    public static boolean isAutoAssign(Context ctx, BussinessAttributeInfo bussinessAttributeInfo, String shareCenterId) {
        String oql = "where bussId.id='" + bussinessAttributeInfo.getId().toString() + "' and shareCenterId = '" + shareCenterId + "'";
        try {
            String customAssignTime;
            AutoAssignTypeEnum autoAssignType;
            if (BussinessAttributeExtFactory.getLocalInstance(ctx).exists(oql)) {
                BussinessAttributeExtInfo info = BussinessAttributeExtFactory.getLocalInstance(ctx).getBussinessAttributeExtInfo(oql);
                autoAssignType = info.getAutoAssignType();
                customAssignTime = info.getCustomAssignTime();
            } else {
                bussinessAttributeInfo = BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeInfo(H.PK(bussinessAttributeInfo.getId()));
                autoAssignType = bussinessAttributeInfo.getAutoAssignType();
                customAssignTime = bussinessAttributeInfo.getCustomAssignTime();
            }
            if ("1".equals(autoAssignType.getValue()) || "2".equals(autoAssignType.getValue()) && JobUtils.isCustomAssignTime(customAssignTime)) {
                return true;
            }
            logger.info((Object)("isAutoAssign--false :\u4efb\u52a1\u7c7b\u578b\u914d\u7f6e\u7684\u5206\u914d\u65b9\u5f0f\u4e3a:[+autoAssignType.getValue()+ customAssignTime:[" + customAssignTime + "] ;]bussinessAttributeId:[" + bussinessAttributeInfo.getId().toString() + "];shareCenterId:[" + shareCenterId + "]"));
            return false;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
    }

    private static HashMap<String, String> getKeyValues(Context ctx, AssignRuleInfo assignRuleInfo, DynamicValueCollection dynamicValueCollection, JobInfo jobInfo) {
        AssignRuleEntryCollection entrys = assignRuleInfo.getEntry();
        HashSet<String> keys = new HashSet<String>();
        for (int i = 0; i < entrys.size(); ++i) {
            String value;
            AssignRuleEntryInfo info = entrys.get(i);
            String field = info.getCompareField();
            if (field.indexOf("{$") == 0) {
                keys.add(field.trim().substring(2, field.length() - 1));
            }
            if ((value = info.getCompareValue()).indexOf("{$") != 0) continue;
            keys.add(value.trim().substring(2, value.length() - 1));
        }
        String bussAttrId = jobInfo.getBussAttrID().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append(" select bt.fbindbillentry");
        sb.append(" from T_ssc_bussinessattribute ba,T_ssc_billtype bt");
        sb.append(" where ba.fid=?");
        sb.append(" and ba.FBILLTYPEID = bt.FID ");
        String sourceBillClass = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{bussAttrId});
            if (rs.next()) {
                sourceBillClass = rs.getString(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        Map<String, String> entityValuesMap = SSCBaseBillUtils.getSourceBillAttributeBySql(ctx, jobInfo, new ArrayList<String>(keys), sourceBillClass, null);
        Set<Map.Entry<String, String>> entries = entityValuesMap.entrySet();
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : entries) {
            keyValueMap.put("{$" + entry.getKey() + "}", entry.getValue());
        }
        for (int i = 0; i < dynamicValueCollection.size(); ++i) {
            DynamicValueInfo dynamicValueInfo = dynamicValueCollection.get(i);
            keyValueMap.put("{@" + dynamicValueInfo.getDynamicID().getNumber() + "}", "1".equals(dynamicValueInfo.getDynamicID().getType().getValue()) ? String.valueOf(dynamicValueInfo.getDigiValue()) : dynamicValueInfo.getDinamicValue());
        }
        return keyValueMap;
    }

    public static boolean isAssignRuleMatchNew(Context ctx, AssignRuleInfo assignRuleInfo, DynamicValueCollection dynamicValueCollection, JobInfo jobInfo) {
        if (assignRuleInfo.getEntry().isEmpty()) {
            return JobUtils.isAssignRuleMatch(assignRuleInfo.getScript(), dynamicValueCollection);
        }
        AssignRuleEntryCollection entrys = assignRuleInfo.getEntry();
        HashMap<String, String> keyValueMap = JobUtils.getKeyValues(ctx, assignRuleInfo, dynamicValueCollection, jobInfo);
        ArrayList<DealInfo> listBool = new ArrayList<DealInfo>();
        for (int i = 0; i < entrys.size(); ++i) {
            AssignRuleEntryInfo entryInfo = entrys.get(i);
            DealInfo dealInfo = new DealInfo();
            String realKey = keyValueMap.containsKey(entryInfo.getCompareField()) ? keyValueMap.get(entryInfo.getCompareField()) : entryInfo.getCompareField();
            String realValue = keyValueMap.containsKey(entryInfo.getCompareValue()) ? keyValueMap.get(entryInfo.getCompareValue()) : entryInfo.getCompareValue();
            boolean b = entryInfo.getEntryExecuteRule() == null || ExecutionRuleConditionEnum.anyonePass.equals((Object)entryInfo.getEntryExecuteRule()) ? SSCCompareUtils.compareKeyAndValue(entryInfo.getCompare(), realKey, realValue) : SSCCompareUtils.compareKeyAndValueAllPass(entryInfo.getCompare(), realKey, realValue);
            dealInfo.setBool(b);
            dealInfo.setLeftBracket(entryInfo.getLeftBracket());
            dealInfo.setRightBracket(entryInfo.getRightBracket());
            dealInfo.setLuogi(entryInfo.getLogic());
            listBool.add(dealInfo);
        }
        boolean endBool = false;
        if (listBool.size() > 0) {
            endBool = SSCCompareUtils.calculateCheckResult(listBool);
        }
        return endBool;
    }
}

