/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.report.RptConstant;
import com.kingdee.eas.base.ssc.tool.DateUtil;
import com.kingdee.eas.base.ssc.tool.ParamCheckUtil;
import com.kingdee.eas.base.ssc.tool.SSCStringUtils;
import com.kingdee.eas.base.ssc.tool.SSCUtil;
import com.kingdee.eas.base.ssc.tool.ShareCenterPermissionOrgUtil;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaskReportUtil {
    public static String getRunkDataSql(Context ctx, Map solutionMap) throws BOSException, SSCException {
        StringBuilder sql = new StringBuilder("select ");
        sql.append(" tt.username,tt.userno,tt.userid,tt.tasksum,tt.timelong from (");
        sql.append(TaskReportUtil.getRunkSelectSql(solutionMap));
        sql.append(TaskReportUtil.getBizFromSql(solutionMap));
        sql.append(TaskReportUtil.getRunkWhereSql(solutionMap, ctx));
        sql.append(TaskReportUtil.getRunkGroupBySql(solutionMap));
        sql.append(")tt where timelong!=0 order by tasksum desc");
        return sql.toString();
    }

    public static String getRunkSelectSql(Map solutionMap) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select tu.fname_l2 username ,tu.fnumber userno,tu.fid userid,count(1) tasksum ,");
        sql.append(" sum(case when (tj.fcostworktime is null or tj.fcostworktime = 0) then (DateDiff(mi,tj.freceivetime,tj.fcompletetme)*60 + second(tj.fcompletetme)-second(tj.freceivetime)-isnull(tj.fwaittime,0)*3600)*1.0/3600 else tj.fcostworktime end) timelong");
        return sql.toString();
    }

    public static String getBizFromSql(Map solutionMap) {
        StringBuilder sql = new StringBuilder(" from t_ssc_jobhis tj ");
        sql.append(" inner join t_ssc_bussinessAttribute tb on tj.fbussattridid = tb.fid");
        sql.append(" inner join T_SSC_BILLTYPE billtype on tb.FBILLTYPEID = billtype.fid");
        sql.append(" inner join T_SSC_SystemAttribute sysattr on sysattr.FID = billtype.FSYSATTRID");
        sql.append(" left join t_ssc_org tg on tj.forgidid = tg.fid");
        sql.append(" inner join t_ssc_user tu on tj.fpersonnelidid = tu.fid");
        return sql.toString();
    }

    public static String getRunkWhereSql(Map solutionMap, Context ctx) throws BOSException, SSCException {
        String extendErpId;
        Map<String, String> filterSqlMap = TaskReportUtil.getBizAttrOrgUser(solutionMap, ctx);
        String bizAttrIdFiler = filterSqlMap.get("bizAttrIds");
        String extendErpIdFilter = filterSqlMap.get("extendErpIds");
        StringBuilder sql = new StringBuilder(" where 1=1 ");
        String bizTypeId = (String)solutionMap.get("bizTypeId");
        if (!StringUtils.isEmpty((String)bizTypeId)) {
            ParamCheckUtil.checkBOSUuids(bizTypeId);
            bizTypeId = "'" + bizTypeId.replaceAll(",", "','") + "'";
            sql.append(" and tb.fid in(").append(bizTypeId).append(")");
        } else {
            sql.append(" and tb.fid in(" + bizAttrIdFiler + ")");
        }
        String orgId = (String)solutionMap.get("orgId");
        if (!StringUtils.isEmpty((String)orgId)) {
            orgId = "'" + orgId.replaceAll(",", "','") + "'";
            sql.append(" and tg.fid in(").append(orgId).append(")");
        } else {
            String shareCenterId = (String)solutionMap.get("shareCenter.id");
            String EASUserId = (String)solutionMap.get("EASUserId");
            String permissionId = (String)solutionMap.get("permissionId");
            if (StringUtils.isEmpty((String)shareCenterId)) {
                sql.append(" and exists ( select forgid from T_SSC_SysAttrOrgSCMap ta where tj.forgidid = ta.forgid and  ta.FShareCenterID IN (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + " ))");
            } else {
                ParamCheckUtil.checkBOSUuid(shareCenterId);
                sql.append(" and exists ( select forgid from T_SSC_SysAttrOrgSCMap ta where tj.forgidid = ta.forgid and  ta.FShareCenterID IN ('" + (String)solutionMap.get("shareCenter.id") + "' ))");
            }
        }
        sql.append(" and tj.FAUTOAPPROVE <> 1 ");
        sql.append(" and tj.fjobstate <> '").append("5").append("'");
        if (!StringUtil.isEmpty((String)((String)solutionMap.get("shareCenter.id")))) {
            sql.append(" and tj.fshareCenterId in ('" + (String)solutionMap.get("shareCenter.id") + "')");
        } else {
            String EASUserId = (String)solutionMap.get("EASUserId");
            String permissionId = (String)solutionMap.get("permissionId");
            sql.append(" and tj.fshareCenterId in (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ")");
        }
        String personId = (String)solutionMap.get("personId");
        if (!StringUtils.isEmpty((String)personId)) {
            personId = "'" + personId.replaceAll(",", "','") + "'";
            sql.append(" and tu.fid in(").append(personId).append(")");
        }
        String startDate = (String)solutionMap.get("startDate");
        String endDate = (String)solutionMap.get("endDate");
        if (!StringUtils.isEmpty((String)startDate)) {
            sql.append(" and tj.fcompletetme >=").append(DateUtil.dateToTsDate(startDate));
            sql.append(" and tj.fcompletetme <=").append(DateUtil.dateToTsDate(endDate));
        }
        if (!StringUtils.isEmpty((String)(extendErpId = (String)solutionMap.get("extendErpId")))) {
            sql.append(extendErpIdFilter);
        }
        return sql.toString();
    }

    public static String getRunkGroupBySql(Map solutionMap) {
        StringBuilder sql = new StringBuilder();
        sql.append(",tu.fname_l2,tu.fnumber,tu.fid");
        if (sql.length() > 0) {
            sql.delete(0, 1);
            sql.insert(0, " group by ");
        }
        return sql.toString();
    }

    public static Map<String, String> getBizAttrOrgUser(Map solutionMap, Context ctx) throws BOSException, SSCException {
        HashMap<String, String> whereSqlMap = new HashMap<String, String>();
        String EASUserId = (String)solutionMap.get("EASUserId");
        String permissionId = (String)solutionMap.get("permissionId");
        String shareCenterId = (String)solutionMap.get("shareCenter.id");
        Boolean isOnlyAuditJob = (Boolean)solutionMap.get("isOnlyAuditJob");
        String extendErpId = (String)solutionMap.get("extendErpId");
        if (isOnlyAuditJob == null) {
            isOnlyAuditJob = false;
        }
        if (!StringUtils.isEmpty((String)extendErpId)) {
            extendErpId = SSCStringUtils.getSQLStrBySplitStr(extendErpId);
        }
        String topShareCenterId = ShareCenterUtils.getTopShareCenter(ctx).getId().toString();
        if (StringUtils.isEmpty((String)shareCenterId)) {
            String bizAttrIdSql = "SELECT DISTINCT FID FROM T_SSC_BUSSINESSATTRIBUTE WHERE FSHARECENTERID IN (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") UNION SELECT DISTINCT FID FROM T_SSC_BUSSINESSATTRIBUTE WHERE FSHARECENTERID IN ('" + topShareCenterId + "')";
            if (isOnlyAuditJob.booleanValue()) {
                bizAttrIdSql = bizAttrIdSql + " AND FJobClassification = 1 ";
            }
            String extendErpIdSql = "";
            if (!StringUtils.isEmpty((String)extendErpId)) {
                extendErpIdSql = " AND SYSATTR.FEXTENDERPID IN (" + extendErpId + ")";
            }
            bizAttrIdSql = "SELECT DISTINCT t4.FID bizAttrId FROM T_SSC_SysAttrOrgSCMap t1 LEFT JOIN T_SSC_SystemAttribute t2 ON t1.FSystemAttributeID = t2.FID LEFT JOIN T_SSC_BILLTYPE t3 ON t3.FSYSATTRID = t2.FID LEFT JOIN T_SSC_BUSSINESSATTRIBUTE t4 ON t4.FBILLTYPEID = t3.FID WHERE t1.FShareCenterID IN (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") AND t4.FID IN (" + bizAttrIdSql + ")";
            String orgIdSql = "SELECT DISTINCT FOrgid FROM T_SSC_SysAttrOrgSCMap WHERE FShareCenterID IN (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ")";
            String userIdSql = "SELECT DISTINCT FID FROM T_SSC_USER WHERE FShareCenterId in (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ")";
            whereSqlMap.put("bizAttrIds", bizAttrIdSql);
            whereSqlMap.put("orgIds", orgIdSql);
            whereSqlMap.put("userIds", userIdSql);
            whereSqlMap.put("extendErpIds", extendErpIdSql);
        } else {
            ParamCheckUtil.checkBOSUuid(shareCenterId);
            String bizAttrIdSql = "SELECT DISTINCT FID FROM T_SSC_BUSSINESSATTRIBUTE WHERE FSHARECENTERID IN ('" + shareCenterId + "') UNION SELECT DISTINCT FID FROM T_SSC_BUSSINESSATTRIBUTE WHERE FSHARECENTERID IN ('" + topShareCenterId + "')";
            if (isOnlyAuditJob.booleanValue()) {
                bizAttrIdSql = bizAttrIdSql + " AND FJobClassification = 1 ";
            }
            String extendErpIdSql = "";
            if (!StringUtils.isEmpty((String)extendErpId)) {
                extendErpIdSql = " AND SYSATTR.FEXTENDERPID IN (" + extendErpId + ")";
            }
            bizAttrIdSql = "SELECT DISTINCT t4.FID bizAttrId FROM T_SSC_SysAttrOrgSCMap t1 LEFT JOIN T_SSC_SystemAttribute t2 ON t1.FSystemAttributeID = t2.FID LEFT JOIN T_SSC_BILLTYPE t3 ON t3.FSYSATTRID = t2.FID LEFT JOIN T_SSC_BUSSINESSATTRIBUTE t4 ON t4.FBILLTYPEID = t3.FID WHERE t1.FShareCenterID IN ('" + shareCenterId + "') AND t4.FID IN (" + bizAttrIdSql + ")";
            String orgIdSql = "SELECT DISTINCT FOrgid FROM T_SSC_SysAttrOrgSCMap WHERE FShareCenterID IN ('" + shareCenterId + "')";
            String userIdSql = "SELECT DISTINCT FID FROM T_SSC_USER WHERE FShareCenterId in ('" + shareCenterId + "')";
            whereSqlMap.put("bizAttrIds", bizAttrIdSql);
            whereSqlMap.put("orgIds", orgIdSql);
            whereSqlMap.put("userIds", userIdSql);
            whereSqlMap.put("extendErpIds", extendErpIdSql);
        }
        return whereSqlMap;
    }

    public static String getCountSql(String sql) {
        if (sql.indexOf("order by") > -1) {
            sql = sql.substring(0, sql.indexOf("order"));
        }
        String countSql = "select count(1) count from (" + sql + ")t";
        return countSql;
    }

    public static String getBizSelectSql(Context ctx, Map solutionMap) {
        StringBuilder sql = new StringBuilder("select ");
        String period = (String)solutionMap.get(RptConstant.PERIOD);
        String _reportType = (String)solutionMap.get(RptConstant.REPORT_TYPE);
        int reportType = Integer.parseInt(_reportType);
        if (reportType == RptConstant.REPORT_TYPE_CHART) {
            if (period.equals(RptConstant.PERIOD_BYDAY)) {
                sql.append("YEAR(tj.fcompletetme) byYear,MONTH(tj.fcompletetme) byMonth,DAYOFMONTH(tj.fcompletetme) byday,");
            }
            if (period.equals(RptConstant.PERIOD_BYMONTH)) {
                sql.append("YEAR(tj.fcompletetme) byYear,MONTH(tj.fcompletetme) byMonth,");
            }
            sql.append("tb.fname_l2 bizType,");
            sql.append("tg.fname_l2 orgname,");
            sql.append("sum(case when (tj.fcostworktime is null or tj.fcostworktime = 0) then ABS((DateDiff(mi,tj.freceivetime,tj.fcompletetme)*60 + second(tj.fcompletetme)-second(tj.freceivetime)-isnull(tj.fwaittime,0)*3600))*1.0/3600 else tj.fcostworktime end) timelong,");
        } else if (reportType == RptConstant.REPORT_TYPE_DETAIL) {
            sql.append("tb.fname_l2 bizType,tb.fid bizTypeId,");
            sql.append("tg.fname_l2 orgname,tg.fid orgId,");
            sql.append("tu.fname_l2 username,tu.fnumber userno,");
        } else {
            String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
            if (stat_dimension.indexOf("showBizType") > -1) {
                sql.append("tb.fname_l2 bizType,tb.fid bizTypeId,");
            }
            if (stat_dimension.indexOf("showOrgName") > -1) {
                sql.append("tg.fname_l2 orgname,tg.fid orgId,");
            }
            if (stat_dimension.indexOf("showDealPerson") > -1) {
                sql.append(" tu.fname_l2 username,tu.fnumber userno,tu.fid,");
            }
        }
        sql.append("sum(case when tj.FEXPIRESTATE = 1 then 1 end) expired,");
        sql.append("sum(case when (tj.FEXPIRESTATE !=1) then 1 end) timely,");
        sql.append("count(1) taskSum");
        return sql.toString();
    }

    public static String getBizWhereSql(Map solutionMap) {
        String bizAdminTypeId;
        String orgId;
        boolean isComplete = false;
        if (solutionMap.get("isComplete") != null) {
            isComplete = (Boolean)solutionMap.get("isComplete");
        }
        String userID = (String)solutionMap.get("userid");
        String roleType = "";
        String biz_role_type = (String)solutionMap.get("bizTypeId");
        ArrayList<String> bizAdminTypeIds = new ArrayList<String>();
        String bizTypeIds = "";
        if (!StringUtils.isEmpty((String)biz_role_type)) {
            List bizTypeList = JSONArray.parseArray((String)biz_role_type, Map.class);
            for (Map map : bizTypeList) {
                String bizTypeId = (String)map.get("key");
                String bizroleType = (String)map.get("value");
                if (bizroleType.equals("F68lZzqpRWC1K1nV8ZYPgS0WZ4A=")) {
                    bizTypeIds = bizTypeIds + "'" + bizTypeId + "',";
                    continue;
                }
                bizAdminTypeIds.add(bizTypeId);
            }
            if (bizTypeIds != "") {
                bizTypeIds = bizTypeIds.substring(0, bizTypeIds.length() - 1);
                roleType = "F68lZzqpRWC1K1nV8ZYPgS0WZ4A=";
            }
            if (bizAdminTypeIds.size() > 0) {
                roleType = "hEw8bwRNR8qPRPajcUdX4C0WZ4A=";
            }
            if (bizTypeIds != "" && bizAdminTypeIds.size() > 0) {
                roleType = RptConstant.Role_TYPE_BIZ_AND_ADMIN;
            }
        }
        StringBuilder sql = new StringBuilder(" where 1=1 ");
        String shareCenterID = (String)solutionMap.get("shareCenter.id");
        if (shareCenterID != null && shareCenterID.trim().length() > 0) {
            sql.append(" and tj.FShareCenterID = '").append(shareCenterID).append("' ");
        }
        if (!isComplete) {
            sql.append(" and tj.fjobstate <> '").append("5").append("'");
        }
        if (!StringUtils.isEmpty((String)(orgId = (String)solutionMap.get("orgId")))) {
            orgId = "'" + orgId.replaceAll(",", "','") + "'";
        }
        if ("F68lZzqpRWC1K1nV8ZYPgS0WZ4A=".equals(roleType)) {
            sql.append(" and tb.fid in (").append(bizTypeIds).append(")");
            sql.append(" and tj.FPersonnelIDID ='").append(userID).append("'");
            if (!StringUtils.isEmpty((String)orgId)) {
                sql.append(" and tg.fid in(").append(orgId).append(")");
            }
        }
        if ("hEw8bwRNR8qPRPajcUdX4C0WZ4A=".equals(roleType)) {
            sql.append(" and(");
            for (int i = 0; i < bizAdminTypeIds.size(); ++i) {
                bizAdminTypeId = (String)bizAdminTypeIds.get(i);
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append("(");
                sql.append(" tb.fid ='").append(bizAdminTypeId).append("'");
                if (!StringUtils.isEmpty((String)orgId)) {
                    sql.append(" and tg.fid in(").append(orgId).append(")");
                }
                sql.append(")");
            }
            sql.append(")");
        }
        if (RptConstant.Role_TYPE_BIZ_AND_ADMIN.equals(roleType)) {
            sql.append(" and (");
            sql.append("(");
            sql.append("tb.fid in (").append(bizTypeIds).append(")");
            sql.append(" and tj.FPersonnelIDID ='").append(userID).append("'");
            if (!StringUtils.isEmpty((String)orgId)) {
                sql.append(" and tg.fid in(").append(orgId).append(")");
            }
            sql.append(")");
            for (int i = 0; i < bizAdminTypeIds.size(); ++i) {
                bizAdminTypeId = (String)bizAdminTypeIds.get(i);
                sql.append(" or ");
                sql.append("(");
                sql.append(" tb.fid ='").append(bizAdminTypeId).append("'");
                if (!StringUtils.isEmpty((String)orgId)) {
                    sql.append(" and tg.fid in(").append(orgId).append(")");
                }
                sql.append(")");
            }
            sql.append(")");
        }
        String startDate = (String)solutionMap.get("startDate");
        String endDate = (String)solutionMap.get("endDate");
        if (!StringUtils.isEmpty((String)startDate)) {
            sql.append(" and tj.fcompletetme >=").append(DateUtil.dateToTsDate(startDate));
            sql.append(" and tj.fcompletetme <=").append(DateUtil.dateToTsDate(endDate));
        }
        sql.append(" and tj.fautoapprove <> 1");
        return sql.toString();
    }

    public static String getBizGroupBySql(Map solutionMap) {
        StringBuilder sql = new StringBuilder();
        String period = (String)solutionMap.get(RptConstant.PERIOD);
        String _reportType = (String)solutionMap.get("reportType");
        int reportType = Integer.parseInt(_reportType);
        if (reportType == RptConstant.REPORT_TYPE_CHART) {
            if (period.equals(RptConstant.PERIOD_BYDAY)) {
                sql.append(",YEAR(tj.fcompletetme),MONTH(tj.fcompletetme),DAYOFMONTH(tj.fcompletetme)");
            }
            if (period.equals("byMonth")) {
                sql.append(",YEAR(tj.fcompletetme),MONTH(tj.fcompletetme)");
            }
            sql.append(",tb.fname_l2");
            sql.append(",tg.fname_l2");
        } else if (reportType == RptConstant.REPORT_TYPE_DETAIL) {
            sql.append(",tb.fname_l2,tb.fid");
            sql.append(",tg.fname_l2,tg.fid");
            sql.append(",tu.fname_l2,tu.fnumber");
        } else {
            String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
            if (stat_dimension.indexOf("showBizType") > -1) {
                sql.append(",tb.fname_l2,tb.fid");
            }
            if (stat_dimension.indexOf("showOrgName") > -1) {
                sql.append(",tg.fname_l2,tg.fid");
            }
            if (stat_dimension.indexOf("showDealPerson") > -1) {
                sql.append(",tu.fname_l2,tu.fnumber,tu.fid");
            }
        }
        if (sql.length() > 0) {
            sql.delete(0, 1);
            sql.insert(0, " group by ");
        }
        return sql.toString();
    }

    public static String getBizOrderbySql(Map solutionMap) {
        StringBuilder sql = new StringBuilder();
        String period = (String)solutionMap.get(RptConstant.PERIOD);
        String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
        if (period.equals(RptConstant.PERIOD_BYDAY)) {
            sql.append(",byYear,byMonth,byday");
        } else if (period.equals(RptConstant.PERIOD_BYMONTH)) {
            sql.append(",byYear,byMonth");
        }
        if (stat_dimension.indexOf("showDealPerson") > -1) {
            sql.append(",username");
        }
        if (stat_dimension.indexOf("showOrgName") > -1) {
            sql.append(",orgname");
        }
        if (stat_dimension.indexOf("showBizType") > -1) {
            sql.append(",bizType");
        }
        if (sql.length() > 0) {
            sql.delete(0, 1);
            sql.insert(0, " order by ");
        }
        return sql.toString();
    }

    public static String getOrderBySql(Map solutionMap) {
        StringBuilder sql = new StringBuilder();
        String _reportType = (String)solutionMap.get(RptConstant.REPORT_TYPE);
        int reportType = Integer.parseInt(_reportType);
        if (reportType == RptConstant.REPORT_TYPE_DETAIL) {
            sql.append(",username,orgname,bizType");
        } else {
            String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
            if (stat_dimension.indexOf("showDealPerson") > -1) {
                sql.append(",username");
            }
            if (stat_dimension.indexOf("showOrgName") > -1) {
                sql.append(",orgname");
            }
            if (stat_dimension.indexOf("showBizType") > -1) {
                sql.append(",bizType");
            }
        }
        if (sql.length() > 0) {
            sql.delete(0, 1);
            sql.insert(0, " order by ");
        }
        return sql.toString();
    }

    public static String getPersonalWhereSql(Map solutionMap, Context ctx) throws BOSException, SSCException {
        String extendErpId;
        Map<String, String> filterSqlMap = TaskReportUtil.getBizAttrOrgUser(solutionMap, ctx);
        String bizAttrIdFiler = filterSqlMap.get("bizAttrIds");
        String userIdFilter = filterSqlMap.get("userIds");
        String extendErpIdFilter = filterSqlMap.get("extendErpIds");
        StringBuilder sql = new StringBuilder(" where 1=1 ");
        sql.append(" and tj.fjobstate <> '").append("5").append("'");
        String orgId = (String)solutionMap.get("orgId");
        if (!StringUtils.isEmpty((String)orgId)) {
            orgId = "'" + orgId.replaceAll(",", "','") + "'";
            sql.append(" and tg.fid in(").append(orgId).append(")");
        } else {
            String shareCenterId = (String)solutionMap.get("shareCenter.id");
            String EASUserId = (String)solutionMap.get("EASUserId");
            String permissionId = (String)solutionMap.get("permissionId");
            if (StringUtils.isEmpty((String)shareCenterId)) {
                sql.append(" and exists ( select forgid from T_SSC_SysAttrOrgSCMap ta where tj.forgidid = ta.forgid and  ta.FShareCenterID IN (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + " ))");
            } else {
                sql.append(" and exists ( select forgid from T_SSC_SysAttrOrgSCMap ta where tj.forgidid = ta.forgid and  ta.FShareCenterID IN ('" + (String)solutionMap.get("shareCenter.id") + "' ))");
            }
        }
        String bizTypeId = (String)solutionMap.get("bizTypeId");
        if (!StringUtils.isEmpty((String)bizTypeId)) {
            bizTypeId = "'" + bizTypeId.replaceAll(",", "','") + "'";
            sql.append(" and tb.fid in(").append(bizTypeId).append(")");
        } else {
            sql.append(" and tb.fid in(" + bizAttrIdFiler + ")");
        }
        String userId = (String)solutionMap.get("userid");
        if (!StringUtils.isEmpty((String)userId)) {
            userId = "'" + userId.replaceAll(",", "','") + "'";
            sql.append(" and tu.fid in(").append(userId).append(")");
        } else {
            sql.append(" and tu.fid in(" + userIdFilter + ")");
        }
        String startDate = (String)solutionMap.get("startDate");
        String endDate = (String)solutionMap.get("endDate");
        if (!StringUtils.isEmpty((String)startDate)) {
            sql.append(" and tj.fcompletetme >=").append(DateUtil.dateToTsDate(startDate));
            sql.append(" and tj.fcompletetme <=").append(DateUtil.dateToTsDate(endDate));
        }
        if (!StringUtils.isEmpty((String)(extendErpId = (String)solutionMap.get("extendErpId")))) {
            sql.append(extendErpIdFilter);
        }
        return sql.toString();
    }

    public static String getPersonalWhereSql(Map solutionMap, List<Map> pageList) {
        String userId;
        String bizTypeId;
        StringBuilder sql = new StringBuilder(" where 1=1 ");
        sql.append(" and tj.fjobstate <> '").append("5").append("'");
        String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
        int size = pageList.size();
        sql.append(" and (");
        for (int i = 0; i < size; ++i) {
            Map rec = pageList.get(i);
            sql.append("(");
            StringBuilder dim = new StringBuilder();
            if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_BIZTYPE) > -1) {
                dim.append(" and tb.fid = '").append(rec.get("bizTypeId")).append("'");
            }
            if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_ORGNAME) > -1) {
                dim.append(" and tg.fid = '").append(rec.get("orgId")).append("'");
            }
            if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_DEALER) > -1) {
                dim.append(" and tu.fid = '").append(rec.get("userId")).append("'");
            }
            sql.append(dim.substring(dim.indexOf("and") + 3));
            sql.append(")");
            if (size <= 1 || i >= size - 1) continue;
            sql.append(" or ");
        }
        sql.append(")");
        String orgId = (String)solutionMap.get("orgId");
        if (!StringUtils.isEmpty((String)orgId)) {
            orgId = "'" + orgId.replaceAll(",", "','") + "'";
            sql.append(" and tg.fid in(").append(orgId).append(")");
        }
        if (!StringUtils.isEmpty((String)(bizTypeId = (String)solutionMap.get("bizTypeId")))) {
            bizTypeId = "'" + bizTypeId.replaceAll(",", "','") + "'";
            sql.append(" and tb.fid in(").append(bizTypeId).append(")");
        }
        if (!StringUtils.isEmpty((String)(userId = (String)solutionMap.get("userid")))) {
            userId = "'" + userId.replaceAll(",", "','") + "'";
            sql.append(" and tu.fid in(").append(userId).append(")");
        }
        String startDate = (String)solutionMap.get("startDate");
        String endDate = (String)solutionMap.get("endDate");
        if (!StringUtils.isEmpty((String)startDate)) {
            sql.append(" and tj.fcompletetme >=").append(DateUtil.dateToTsDate(startDate));
            sql.append(" and tj.fcompletetme <=").append(DateUtil.dateToTsDate(endDate));
        }
        return sql.toString();
    }

    public static String getPersonalGroupBySql(Map solutionMap) {
        StringBuilder sql = new StringBuilder();
        String period = (String)solutionMap.get(RptConstant.PERIOD);
        String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
        sql.append(",YEAR(tj.fcompletetme),MONTH(tj.fcompletetme)");
        if (period.equals(RptConstant.PERIOD_BYDAY)) {
            sql.append(",DAYOFMONTH(tj.fcompletetme)");
        }
        if (stat_dimension.indexOf("showBizType") > -1) {
            sql.append(",tb.fname_l2,tb.fid");
        }
        if (stat_dimension.indexOf("showOrgName") > -1) {
            sql.append(",tg.fname_l2,tg.fid");
        }
        if (stat_dimension.indexOf("showDealPerson") > -1) {
            sql.append(",tu.fname_l2,tu.fnumber,tu.fid");
        }
        if (sql.length() > 0) {
            sql.delete(0, 1);
            sql.insert(0, " group by ");
        }
        return sql.toString();
    }

    public static String getPersonalPageSelectSql(Map solutionMap) {
        String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
        StringBuilder sql = new StringBuilder("select ");
        if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_BIZTYPE) > -1) {
            sql.append("tb.fid bizTypeId,");
        }
        if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_ORGNAME) > -1) {
            sql.append("tg.fid orgId,");
        }
        if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_DEALER) > -1) {
            sql.append("tu.fid userId,");
        }
        sql.delete(sql.length() - 1, sql.length());
        return sql.toString();
    }

    public static String getPersonalPageGroupBySql(Map solutionMap) {
        StringBuilder sql = new StringBuilder();
        String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
        if (stat_dimension.indexOf("showBizType") > -1) {
            sql.append(",tb.fid");
        }
        if (stat_dimension.indexOf("showOrgName") > -1) {
            sql.append(",tg.fid");
        }
        if (stat_dimension.indexOf("showDealPerson") > -1) {
            sql.append(",tu.fid");
        }
        if (sql.length() > 0) {
            sql.delete(0, 1);
            sql.insert(0, " group by ");
        }
        return sql.toString();
    }

    public static String getPersonalDetailSql(Map solutionMap, Context ctx) throws BOSException, SSCException {
        StringBuilder sql = new StringBuilder();
        sql.append(TaskReportUtil.getBizSelectSql(ctx, solutionMap));
        sql.append(TaskReportUtil.getBizFromSql(solutionMap));
        sql.append(TaskReportUtil.getPersonalWhereSql(solutionMap, ctx));
        sql.append(TaskReportUtil.getBizGroupBySql(solutionMap));
        sql.append(TaskReportUtil.getOrderBySql(solutionMap));
        return sql.toString();
    }

    public static String getOrgBizChartSql(Map solutionMap, Context ctx) throws BOSException, SSCException {
        StringBuilder sql = new StringBuilder();
        sql.append("select tb.fname_l2 bizType,tb.fid bizTypeId");
        sql.append(",tg.fname_l2 orgname,tg.fid orgId");
        sql.append(",count(1) tasksum");
        sql.append(",sum(case when tj.FEXPIRESTATE = 1 then 1 end) expired");
        sql.append(",sum(case when (tj.FEXPIRESTATE != 1) then 1 end) timely");
        sql.append(TaskReportUtil.getBizFromSql(solutionMap));
        sql.append(TaskReportUtil.getPersonalWhereSql(solutionMap, ctx));
        sql.append(" group by tb.fname_l2,tb.fid,tg.fname_l2,tg.fid");
        sql.append(" order by orgname,bizType");
        return sql.toString();
    }

    public static String getTaskAnalyzeByPeriod(Map solutionMap, Context ctx) throws BOSException, SSCException {
        StringBuilder sql = new StringBuilder("select ");
        String period = (String)solutionMap.get(RptConstant.PERIOD);
        String groupBy = "";
        if (period.equals(RptConstant.PERIOD_BYDAY)) {
            sql.append("YEAR(tj.fcompletetme) byYear,MONTH(tj.fcompletetme) byMonth ,DAYOFMONTH(tj.fcompletetme) byday");
            groupBy = " YEAR(tj.fcompletetme),MONTH(tj.fcompletetme),DAYOFMONTH(tj.fcompletetme)";
        } else {
            sql.append("YEAR(tj.fcompletetme) byYear,MONTH(tj.fcompletetme) bymonth");
            groupBy = " YEAR(tj.fcompletetme),MONTH(tj.fcompletetme)";
        }
        sql.append(",count(1) tasksum");
        sql.append(",sum(case when tj.FEXPIRESTATE = 1 then 1 end) expired");
        sql.append(",sum(case when (tj.FEXPIRESTATE != 1) then 1 end) timely");
        sql.append(",sum(case when (tj.fcostworktime is null or tj.fcostworktime = 0) then (DateDiff(mi,tj.freceivetime,tj.fcompletetme)*60 + second(tj.fcompletetme)-second(tj.freceivetime)-isnull(tj.fwaittime,0)*3600)*1.0/3600 else tj.fcostworktime end) timelong");
        sql.append(TaskReportUtil.getBizFromSql(solutionMap));
        sql.append(TaskReportUtil.getPersonalWhereSql(solutionMap, ctx));
        sql.append(" group by ").append(groupBy);
        return sql.toString();
    }

    public static String getBizOrgSql(String userId, String roleType) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct o.fid orgid,o.fname_l2 orgname");
        sb.append(" from t_ssc_role r,t_ssc_roleuser ru,t_ssc_roleorg ro,t_ssc_org o");
        sb.append(" where ru.froleidid = r.fid");
        sb.append(" and r.fid = ro.froleidid");
        sb.append(" and o.fid = ro.forgidid");
        sb.append(" and r.froletypeidid = '" + roleType + "'");
        sb.append(" and ru.fuseridid = '" + userId + "'");
        return sb.toString();
    }

    public static String getBizOrgFilterSql(String userId, String roleType) {
        StringBuffer sb = new StringBuffer("id in(");
        sb.append(" select ro.forgidid");
        sb.append(" from t_ssc_role r,t_ssc_roleuser ru,t_ssc_roleorg ro");
        sb.append(" where ru.froleidid = r.fid");
        sb.append(" and r.fid = ro.froleidid");
        sb.append(" and r.froletypeidid = '" + roleType + "'");
        sb.append(" and ru.fuseridid = '" + userId + "'");
        sb.append(" )");
        return sb.toString();
    }

    public static String getBizTypeAndRoleTypeSql(String userid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select tb.fid bizTypeId,tb.fname_l2 bizType,trt.fid roleTypeId from ");
        sql.append(" (select role.fid,role.FRoleTypeIDID,rb.fbussnameid from T_SSC_RoleBussattr rb left join  t_ssc_role role on role.fid= rb.fparentid ) tem ");
        sql.append(" left join t_ssc_roletype trt on tem.froletypeidid=trt.fid ");
        sql.append(" left join t_ssc_roleuser tru on tem.fid = tru.froleidid ");
        sql.append(" left join t_ssc_bussinessAttribute tb on tem.fbussnameid=tb.fid ");
        sql.append(" where trt.fid in('").append("F68lZzqpRWC1K1nV8ZYPgS0WZ4A=").append("','").append("hEw8bwRNR8qPRPajcUdX4C0WZ4A=").append("')").append(" and tru.fuseridid='").append(userid).append("'");
        return sql.toString();
    }

    public static String getRoleTypeSql(String userId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select trt.fid roleTypeId from t_ssc_role tr");
        sql.append(" left join t_ssc_roletype trt on tr.froletypeidid=trt.fid");
        sql.append(" left join t_ssc_roleuser tru on tr.fid = tru.froleidid");
        sql.append(" where trt.fid in('").append("F68lZzqpRWC1K1nV8ZYPgS0WZ4A=");
        sql.append("','").append("hEw8bwRNR8qPRPajcUdX4C0WZ4A=").append("')");
        sql.append(" and tru.fuseridid='").append(userId).append("'");
        sql.append(" group by trt.fid");
        return sql.toString();
    }

    public static String getBizTypeAllSql(String userid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select  distinct tb.fid bizTypeId,tb.fname_l2 bizType from ");
        sql.append(" (select role.fid,role.FRoleTypeIDID,rb.fbussnameid from T_SSC_RoleBussattr rb inner join  t_ssc_role role on role.fid= rb.fparentid ) tem ");
        sql.append(" left join t_ssc_bussinessAttribute tb on tem.fbussnameid=tb.fid ");
        sql.append(" left join t_ssc_roleuser tru on tem.fid = tru.froleidid ");
        sql.append(" where tru.fuseridid='").append(userid).append("'");
        return sql.toString();
    }

    public static String getTaskPersonalSql(Map solutionMap, List<Map> pageList, Context ctx) throws BOSException, SSCException {
        StringBuilder sql = new StringBuilder();
        sql.append(TaskReportUtil.getPersonalSelectSql(solutionMap)).append(TaskReportUtil.getBizFromSql(solutionMap));
        if (pageList != null) {
            sql.append(TaskReportUtil.getPersonalWhereSql(solutionMap, pageList));
        } else {
            sql.append(TaskReportUtil.getPersonalWhereSql(solutionMap, ctx));
        }
        sql.append(TaskReportUtil.getPersonalGroupBySql(solutionMap));
        return sql.toString();
    }

    public static String getTaskPersonalPageSql(Map solutionMap, Context ctx) throws BOSException, SSCException {
        StringBuilder sql = new StringBuilder();
        sql.append(TaskReportUtil.getPersonalPageSelectSql(solutionMap));
        sql.append(TaskReportUtil.getBizFromSql(solutionMap));
        sql.append(TaskReportUtil.getPersonalWhereSql(solutionMap, ctx));
        sql.append(TaskReportUtil.getPersonalPageGroupBySql(solutionMap));
        return sql.toString();
    }

    public static String getPersonalSelectSql(Map solutionMap) {
        String period = (String)solutionMap.get(RptConstant.PERIOD);
        String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
        StringBuilder sql = new StringBuilder("select ");
        sql.append("YEAR(tj.fcompletetme) byYear,MONTH(tj.fcompletetme) byMonth");
        if (period.equals(RptConstant.PERIOD_BYDAY)) {
            sql.append(",DAYOFMONTH(tj.fcompletetme) byday");
        }
        if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_BIZTYPE) > -1) {
            sql.append(",tb.fname_l2 bizType,tb.fid bizTypeId");
        }
        if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_ORGNAME) > -1) {
            sql.append(",tg.fname_l2 orgname,tg.fid orgId");
        }
        if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_DEALER) > -1) {
            sql.append(",tu.fname_l2 username,tu.fnumber userno,tu.fid userId");
        }
        sql.append(",sum(case when (tj.fcostworktime is null or tj.fcostworktime = 0) then (DateDiff(mi,tj.freceivetime,tj.fcompletetme)*60 + second(tj.fcompletetme)-second(tj.freceivetime)-isnull(tj.fwaittime,0)*3600)*1.0/3600 else tj.fcostworktime end) timelong");
        sql.append(",count(1) tasksum");
        return sql.toString();
    }

    public static String getTaskQualitySql(Map param, Context ctx) throws BOSException, SSCException {
        String dynamicfilter = (String)param.get("dynamicfilter");
        StringBuffer sb = new StringBuffer(1000);
        sb.append(TaskReportUtil.getTaskQualitySelectSql(dynamicfilter));
        sb.append(TaskReportUtil.getTaskQualityFromSql(dynamicfilter));
        sb.append(TaskReportUtil.getTaskQualitWhereySql(param, ctx));
        sb.append(TaskReportUtil.getTaskQualityGroupBySql(dynamicfilter));
        return sb.toString();
    }

    public static String getTaskQualityGroupBySql(String dynamicfilter) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(" group by ");
        if (dynamicfilter.contains("bizType")) {
            sb.append("job.fbussAttrIdId, buss.fname_l2,");
        }
        if (dynamicfilter.contains("orgName")) {
            sb.append("job.forgIdId, org.fname_l2,");
        }
        if (dynamicfilter.contains("dealPerson")) {
            sb.append("job.fpersonnelIdId, u.fname_l2,");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String getTaskQualitWhereySql(Map param, Context ctx) throws BOSException, SSCException {
        String result;
        Map<String, String> filterSqlMap = TaskReportUtil.getBizAttrOrgUser(param, ctx);
        String bizAttrIdFiler = filterSqlMap.get("bizAttrIds");
        String userIdFilter = filterSqlMap.get("userIds");
        StringBuffer sb = new StringBuffer(100);
        sb.append(" where 1=1");
        String startDate = (String)param.get("startDate");
        String endDate = (String)param.get("endDate");
        String userIds = (String)param.get("userId");
        String orgIds = (String)param.get("orgId");
        String bizTypeIds = (String)param.get("bizTypeId");
        if (!StringUtils.isEmpty((String)orgIds)) {
            result = SSCUtil.convertObjectToPlaceholder(orgIds);
            sb.append(" and job.forgIdId in(").append(result).append(")");
        } else {
            String shareCenterId = (String)param.get("shareCenter.id");
            String EASUserId = (String)param.get("EASUserId");
            String permissionId = (String)param.get("permissionId");
            if (StringUtils.isEmpty((String)shareCenterId)) {
                String result2 = SSCUtil.convertObjectToPlaceholder(ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId));
                sb.append(" and exists ( select forgid from T_SSC_SysAttrOrgSCMap ta where job.forgidid = ta.forgid and  ta.FShareCenterID IN (" + result2 + "))");
            } else {
                String result3 = SSCUtil.convertObjectToPlaceholder(shareCenterId);
                sb.append(" and exists ( select forgid from T_SSC_SysAttrOrgSCMap ta where job.forgidid = ta.forgid and  ta.FShareCenterID IN (" + result3 + "))");
            }
        }
        if (!StringUtils.isEmpty((String)bizTypeIds)) {
            result = SSCUtil.convertObjectToPlaceholder(bizTypeIds);
            sb.append(" and job.fbussAttrIdId in(").append(result).append(")");
        } else {
            sb.append(" and job.fbussAttrIdId in(" + bizAttrIdFiler + ")");
        }
        if (!StringUtils.isEmpty((String)userIds)) {
            result = SSCUtil.convertObjectToPlaceholder(userIds);
            sb.append(" and job.fpersonnelIdId in(").append(result).append(")");
        } else {
            sb.append(" and job.fpersonnelIdId in(" + userIdFilter + ")");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            sb.append(" and job.fcompletetme >=").append(DateUtil.dateToTsDate(startDate));
            sb.append(" and job.fcompletetme <=").append(DateUtil.dateToTsDate(endDate));
        }
        return sb.toString();
    }

    public static String getTaskQualityFromSql(String dynamicfilter) {
        StringBuffer sb = new StringBuffer(1000);
        sb.append(" from t_ssc_jobhis job").append(" left join (select fjobidid,sum( case when fnewjobstate = '0' then 1 else 0 end) sus, sum(case when fnewjobstate in ('1','13') then 1 else 0 end) as rescan, sum(case when fnewjobstate in ('0','1','13','4') then 1 else 0 end) as exc from t_ssc_jobstatimhis group by fjobidid) as timhis on job.fid=timhis.fjobidid");
        if (dynamicfilter.contains("bizType")) {
            sb.append(" left join t_ssc_bussinessattribute buss on job.fbussAttrIdId=buss.fid");
        }
        if (dynamicfilter.contains("orgName")) {
            sb.append(" left join t_ssc_org org on job.forgidid=org.fid\t");
        }
        if (dynamicfilter.contains("dealPerson")) {
            sb.append(" left join t_ssc_user u on job.fpersonnelidid=u.fid");
        }
        return sb.toString();
    }

    public static String getTaskQualitySelectSql(String dynamicfilter) {
        StringBuffer sb = new StringBuffer(200);
        sb.append("select ");
        if (dynamicfilter.contains("bizType")) {
            sb.append("job.fbussAttrIdId as bizTypeId, buss.fname_l2 as bizType,");
        }
        if (dynamicfilter.contains("orgName")) {
            sb.append("job.forgIdId as orgId, org.fname_l2 as orgname,");
        }
        if (dynamicfilter.contains("dealPerson")) {
            sb.append("job.fpersonnelIdId as userId, u.fname_l2 as username,");
        }
        sb.append("count(1) as dealCount,").append("sum(case job.fjobstate when '4' then 1 else 0 end ) as unpassCount,").append("sum(case  when timhis.sus is null or timhis.sus=0 then 0 else 1 end) as suspendCount,").append("sum(case when timhis.rescan is null or timhis.rescan=0 then 0 else 1 end) as rescanCount,").append("sum(case when timhis.exc is null or timhis.exc=0 then 0 else 1 end) as exceptCount");
        return sb.toString();
    }

    public static Map<String, Object> getTaskQualityDetailSql(Map param, Context ctx) throws BOSException {
        Map<String, Object> whereResult = TaskReportUtil.getTaskQualityDetailWhereSql(param, ctx);
        StringBuffer sb = new StringBuffer();
        sb.append(TaskReportUtil.getTaskQualityDetailSelectSql(param));
        sb.append(TaskReportUtil.getTaskQualityDetailFromSql(param));
        sb.append(whereResult.get("where").toString());
        sb.append(TaskReportUtil.getTaskQualityDetailOrderSql(param));
        whereResult.put("sql", sb.toString());
        return whereResult;
    }

    public static Object getTaskQualityDetailOrderSql(Map param) {
        String sord = (String)param.get("sord");
        String sidx = (String)param.get("sidx");
        if (!StringUtils.isEmpty((String)sidx)) {
            return " order by " + sidx + "  " + sord;
        }
        return "";
    }

    public static Map<String, Object> getTaskQualityDetailWhereSql(Map param, Context ctx) throws BOSException {
        String extendErpId;
        String[] ids;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> params = new ArrayList<String>();
        String startDate = (String)param.get("startDate");
        String endDate = (String)param.get("endDate");
        String userIds = (String)param.get("userId");
        String orgIds = (String)param.get("orgId");
        String bizTypeIds = (String)param.get("bizTypeId");
        String jobState = (String)param.get("jobState");
        String unpassRea = (String)param.get("unpassReaId");
        String shareCenterId = (String)param.get("shareCenter.id");
        String permissionId = (String)param.get("permissionId");
        String EASUserId = (String)param.get("EASUserId");
        StringBuffer sb = new StringBuffer(500);
        sb.append(" where");
        if (jobState != null) {
            if ("1".equals(jobState)) {
                sb.append(" jobstatimhis.FNewJobState in('1','13')");
            } else {
                sb.append(" jobstatimhis.FNewJobState = ?");
                params.add(jobState);
            }
        }
        if (StringUtils.isEmpty((String)shareCenterId)) {
            sb.append(" and job.FShareCenterId in (").append(ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId)).append(")");
        } else {
            sb.append(" and job.FShareCenterId = ?");
            params.add(shareCenterId);
        }
        if (!StringUtils.isEmpty((String)orgIds)) {
            sb.append(" and job.forgIdId in(");
            for (String id : ids = orgIds.split(",")) {
                sb.append("?,");
                params.add(id);
            }
            sb.deleteCharAt(sb.length() - 1).append(")");
        }
        if (!StringUtils.isEmpty((String)bizTypeIds)) {
            sb.append(" and job.fbussAttrIdId in(");
            for (String id : ids = bizTypeIds.split(",")) {
                sb.append("?,");
                params.add(id);
            }
            sb.deleteCharAt(sb.length() - 1).append(")");
        }
        if (!StringUtils.isEmpty((String)userIds)) {
            sb.append(" and jobstatimhis.FOperatorIDID in(");
            for (String id : ids = userIds.split(",")) {
                sb.append("?,");
                params.add(id);
            }
            sb.deleteCharAt(sb.length() - 1).append(")");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            sb.append(" and job.fcompletetme >=").append(DateUtil.dateToTsDate(startDate));
            sb.append(" and job.fcompletetme <=").append(DateUtil.dateToTsDate(endDate));
        }
        if (TaskReportUtil.taskQualityDetailIsShowRea(jobState) && !StringUtils.isEmpty((String)unpassRea)) {
            sb.append(" and r.fid in (");
            for (String id : ids = unpassRea.split(",")) {
                sb.append("?,");
                params.add(id);
            }
            sb.deleteCharAt(sb.length() - 1).append(")");
        }
        if (!StringUtils.isEmpty((String)(extendErpId = (String)param.get("extendErpId")))) {
            String[] extenErpIdArr = extendErpId.split(",");
            extendErpId = "";
            for (int i = 0; i < extenErpIdArr.length; ++i) {
                if (!BOSUuid.isValid((String)extenErpIdArr[i], (boolean)true)) {
                    throw new BOSException("\u65e0\u6548\u7684\u53c2\u6570extendErpId:" + extendErpId);
                }
                extendErpId = extendErpId + ",'" + extenErpIdArr[i].trim() + "'";
            }
            sb.append(" AND SYSATTR.FEXTENDERPID IN (" + extendErpId.substring(1) + ")");
        }
        sb.append(" and job.FAUTOAPPROVE<> 1  ");
        result.put("where", sb.toString());
        int len = params.size();
        Object[] p = new Object[len];
        for (int i = 0; i < len; ++i) {
            p[i] = params.get(i);
        }
        result.put("params", p);
        return result;
    }

    public static Object getTaskQualityDetailFromSql(Map param) {
        StringBuffer sb = new StringBuffer(500);
        String jobState = (String)param.get("jobState");
        sb.append(" from t_ssc_jobstatimhis jobstatimhis ").append(" inner join t_ssc_jobhis job on jobstatimhis.FJobIDId = job.FId").append(" inner join t_ssc_bussinessattribute buss on job.fbussAttrIdId=buss.fid ").append(" inner join T_ssc_billType billType on buss.FBillTypeID =billType.fid").append(" inner join T_SSC_SystemAttribute sysattr on sysattr.FID = billtype.FSYSATTRID").append(" inner join t_ssc_org org on job.forgidid=org.fid").append(" inner join t_ssc_user u on jobstatimhis.FOperatorIDID = u.fid").append(" inner join t_ssc_joblevel l on job.FJoblevelID = l.fid");
        if (TaskReportUtil.taskQualityDetailIsShowRea(jobState)) {
            sb.append(" left join t_ssc_jobunpassrea ju on job.fid=ju.fjobid ").append(" left join t_ssc_unpassreason r on ju.funpassreaid=r.fid ");
        }
        return sb.toString();
    }

    public static String getTaskQualityDetailSelectSql(Map param) {
        StringBuffer sb = new StringBuffer(500);
        String jobState = (String)param.get("jobState");
        sb.append("select job.fbussattridid bizTypeId,buss.fname_l2 bizType, job.forgidid orgId,org.fname_l2 orgname, u.Fid userId, u.fname_l2 username, job.fsubject  subject,job.freceiveTime receiveTime,job.fcompletetme dealTime,isnull(job.FWaitTime,0) waitTime,l.fname_l2 priority");
        sb.append(",jobstatimhis.fmessages messages,job.FCostWorkTime costTime,job.FShareCenterID shareCenterID ");
        if (TaskReportUtil.taskQualityDetailIsShowRea(jobState)) {
            sb.append(",r.fname_l2 unpassRea");
        }
        return sb.toString();
    }

    public static boolean taskQualityDetailIsShowRea(String jobState) {
        return "4".equals(jobState);
    }

    public static String getMutiTaskEfficientGridDataSql(String billTypeIds, Map param, Context ctx) throws BOSException, SSCException {
        String extendErpId;
        Map<String, String> filterSqlMap = TaskReportUtil.getBizAttrOrgUser(param, ctx);
        String extendErpIdFilter = filterSqlMap.get("extendErpIds");
        StringBuffer ret = new StringBuffer(500);
        String orgIds = (String)param.get("orgId");
        String shareCenterId = (String)param.get("shareCenter.id");
        String startDate = (String)param.get("startDate");
        String endDate = (String)param.get("endDate");
        String sord = (String)param.get("sord");
        String sidx = (String)param.get("sidx");
        ret.append("select bt.fid,bt.fname_l2,job.flevel,job.freceivetime,job.fcompletetme,job.FCostWorkTime costTime,job.FShareCenterID shareCenterID");
        ret.append(" from t_ssc_billtype bt left join T_SSC_BussinessAttribute attr on attr.fbillTypeId=bt.fid left join t_ssc_jobhis job on attr.fid=job.fbussattridid").append(" left join T_SSC_SystemAttribute sysAttr on bt.FSYSATTRID=sysAttr.fid").append(" where job.fid is not null and attr.FJobClassification = 1 ");
        ret.append(" and bt.fid in" + billTypeIds);
        if (!StringUtils.isEmpty((String)orgIds)) {
            orgIds = "'" + orgIds.replaceAll(",", "','") + "'";
            ret.append(" and job.fOrgIdId in (" + orgIds + ") ");
            ret.append(" and sysAttr.fid in (SELECT distinct fsystemattributeid FROM T_SSC_SysAttrOrgSCMap WHERE FShareCenterID='" + shareCenterId + "' and ForgID in (" + orgIds + "))");
        } else {
            String EASUserId = (String)param.get("EASUserId");
            String permissionId = (String)param.get("permissionId");
            if (StringUtils.isEmpty((String)shareCenterId)) {
                ret.append(" and exists ( select forgid from T_SSC_SysAttrOrgSCMap ta where job.forgidid = ta.forgid and  ta.FShareCenterID IN (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + " ))");
                ret.append(" and sysAttr.fid in (SELECT distinct tb.fsystemattributeid FROM T_SSC_SysAttrOrgSCMap tb WHERE tb.FShareCenterID=" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + " and exists ( select ta.forgid from T_SSC_SysAttrOrgSCMap ta where tb.forgid = ta.forgid and tb.FShareCenterID = ta.FShareCenterID and tb.FShareCenterID IN (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + " )))");
            } else {
                ret.append(" and exists ( select forgid from T_SSC_SysAttrOrgSCMap ta where job.forgidid = ta.forgid and  ta.FShareCenterID IN ('" + shareCenterId + "' ))");
                ret.append(" and sysAttr.fid in (SELECT distinct tb.fsystemattributeid FROM T_SSC_SysAttrOrgSCMap tb WHERE tb.FShareCenterID='" + shareCenterId + "' and exists ( select ta.forgid from T_SSC_SysAttrOrgSCMap ta where tb.forgid = ta.forgid and tb.FShareCenterID = ta.FShareCenterID and tb.FShareCenterID IN ('" + shareCenterId + "' )))");
            }
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            ret.append(" and job.fcompletetme >=").append(DateUtil.dateToTsDate(startDate));
            ret.append(" and job.fcompletetme <=").append(DateUtil.dateToTsDate(endDate));
        }
        if (!StringUtils.isEmpty((String)(extendErpId = (String)param.get("extendErpId")))) {
            ret.append(extendErpIdFilter);
        }
        if (!StringUtils.isEmpty((String)sidx)) {
            ret.append(" order by bt.fname_l2 ");
            if (!StringUtils.isEmpty((String)sord)) {
                ret.append(sord);
            }
        }
        return ret.toString();
    }

    public static String getMutiTaskEfficientBillListSql(Map param, Context ctx) throws BOSException, SSCException {
        String extendErpId;
        Map<String, String> filterSqlMap = TaskReportUtil.getBizAttrOrgUser(param, ctx);
        String extendErpIdFilter = filterSqlMap.get("extendErpIds");
        StringBuffer ret = new StringBuffer(300);
        String orgIds = (String)param.get("orgId");
        String shareCenterId = (String)param.get("shareCenter.id");
        String startDate = (String)param.get("startDate");
        String endDate = (String)param.get("endDate");
        ret.append("select bt.fid");
        ret.append(" from T_SSC_BussinessAttribute attr left join t_ssc_jobhis job on attr.fid=job.fbussattridid left join t_ssc_billtype bt on attr.fbillTypeId=bt.fid left join T_SSC_SystemAttribute sysAttr on bt.FSYSATTRID=sysAttr.fid ").append(" where job.fid is not null and attr.FJobClassification = 1 ");
        if (!StringUtils.isEmpty((String)orgIds)) {
            orgIds = "'" + orgIds.replaceAll(",", "','") + "'";
            ret.append(" and job.fOrgIdId in (" + orgIds + ") ");
            ret.append(" and sysAttr.fid in (SELECT distinct fsystemattributeid FROM T_SSC_SysAttrOrgSCMap WHERE FShareCenterID='" + shareCenterId + "' and ForgID in (" + orgIds + "))");
        } else {
            String EASUserId = (String)param.get("EASUserId");
            String permissionId = (String)param.get("permissionId");
            if (StringUtils.isEmpty((String)shareCenterId)) {
                ret.append(" and exists ( select forgid from T_SSC_SysAttrOrgSCMap ta where job.forgidid = ta.forgid and  ta.FShareCenterID IN (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + " ))");
                ret.append(" and sysAttr.fid in (SELECT distinct tb.fsystemattributeid FROM T_SSC_SysAttrOrgSCMap tb WHERE tb.FShareCenterID=" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + " and exists ( select ta.forgid from T_SSC_SysAttrOrgSCMap ta where tb.forgid = ta.forgid and tb.FShareCenterID = ta.FShareCenterID and tb.FShareCenterID IN (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + " )))");
            } else {
                ret.append(" and exists ( select forgid from T_SSC_SysAttrOrgSCMap ta where job.forgidid = ta.forgid and  ta.FShareCenterID IN ('" + shareCenterId + "' ))");
                ret.append(" and sysAttr.fid in (SELECT distinct tb.fsystemattributeid FROM T_SSC_SysAttrOrgSCMap tb WHERE tb.FShareCenterID='" + shareCenterId + "' and exists ( select ta.forgid from T_SSC_SysAttrOrgSCMap ta where tb.forgid = ta.forgid and tb.FShareCenterID = ta.FShareCenterID and tb.FShareCenterID IN ('" + shareCenterId + "' )))");
            }
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            ret.append(" and job.fcompletetme >=").append(DateUtil.dateToTsDate(startDate));
            ret.append(" and job.fcompletetme <=").append(DateUtil.dateToTsDate(endDate));
        }
        if (!StringUtils.isEmpty((String)(extendErpId = (String)param.get("extendErpId")))) {
            ret.append(extendErpIdFilter);
        }
        ret.append(" group by bt.fid");
        return ret.toString();
    }

    public static String getMutiTaskEfficientMaxLvlSql(Map param, Context ctx) throws BOSException, SSCException {
        String extendErpId;
        Map<String, String> filterSqlMap = TaskReportUtil.getBizAttrOrgUser(param, ctx);
        String extendErpIdFilter = filterSqlMap.get("extendErpIds");
        String orgIds = (String)param.get("orgId");
        String shareCenterId = (String)param.get("shareCenter.id");
        String startDate = (String)param.get("startDate");
        String endDate = (String)param.get("endDate");
        StringBuffer ret = new StringBuffer(200);
        ret.append("select max(job.flevel) maxLvl ").append("from T_SSC_BussinessAttribute attr left join t_ssc_jobhis job on attr.fid=job.fbussattridid ").append("left join t_ssc_billtype bt on attr.fbillTypeId=bt.fid ").append("left join T_SSC_SystemAttribute sysAttr on bt.FSYSATTRID=sysAttr.fid ").append("where job.fid is not null and attr.FJobClassification = 1 ");
        if (!StringUtils.isEmpty((String)orgIds)) {
            String[] checkOrgs;
            orgIds = "'" + orgIds.replaceAll(",", "','") + "'";
            String checkOrg = orgIds.replaceAll("'", "");
            for (String strorg : checkOrgs = checkOrg.split(",")) {
                if (StringUtils.isEmpty((String)strorg)) continue;
                BOSUuid.read((String)strorg);
            }
            ret.append(" and job.fOrgIdId in (" + orgIds + ") ");
            ret.append(" and sysAttr.fid in (SELECT distinct fsystemattributeid FROM T_SSC_SysAttrOrgSCMap WHERE FShareCenterID='" + shareCenterId + "' and ForgID in (" + orgIds + "))");
        } else {
            String EASUserId = (String)param.get("EASUserId");
            String permissionId = (String)param.get("permissionId");
            if (StringUtils.isEmpty((String)shareCenterId)) {
                ret.append(" and exists ( select forgid from T_SSC_SysAttrOrgSCMap ta where job.forgidid = ta.forgid and  ta.FShareCenterID IN (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + " ))");
                ret.append(" and sysAttr.fid in (SELECT distinct tb.fsystemattributeid FROM T_SSC_SysAttrOrgSCMap tb WHERE tb.FShareCenterID=" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + " and exists ( select ta.forgid from T_SSC_SysAttrOrgSCMap ta where tb.forgid = ta.forgid and tb.FShareCenterID = ta.FShareCenterID and tb.FShareCenterID IN (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + " )))");
            } else {
                ret.append(" and exists ( select forgid from T_SSC_SysAttrOrgSCMap ta where job.forgidid = ta.forgid and  ta.FShareCenterID IN ('" + shareCenterId + "' ))");
                ret.append(" and sysAttr.fid in (SELECT distinct tb.fsystemattributeid FROM T_SSC_SysAttrOrgSCMap tb WHERE tb.FShareCenterID='" + shareCenterId + "' and exists ( select ta.forgid from T_SSC_SysAttrOrgSCMap ta where tb.forgid = ta.forgid and tb.FShareCenterID = ta.FShareCenterID and tb.FShareCenterID IN ('" + shareCenterId + "' )))");
            }
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            ret.append(" and job.fcompletetme >=").append(DateUtil.dateToTsDate(startDate));
            ret.append(" and job.fcompletetme <=").append(DateUtil.dateToTsDate(endDate));
        }
        if (!StringUtils.isEmpty((String)(extendErpId = (String)param.get("extendErpId")))) {
            ret.append(extendErpIdFilter);
        }
        return ret.toString();
    }

    public static String getMutiTaskDataSql(String selectIdSql, String sord, String sidx) {
        StringBuffer sb = new StringBuffer(1300);
        sb.append("select job.fproclnstid,bt.fname_l2 billtype,job.fsubject ,job.fjobstate,job.flevel,job.freceiveTime,job.fcompletetme,u.fname_l2 username,job.flastupdatetime,job.fwaitTime,job.fcreatetime,job.fjobpoolingtype,job.FCostWorkTime costTime,job.FShareCenterID shareCenterID  ").append(" from t_ssc_jobhis job left join t_ssc_bussinessAttribute ba on job.fbussattridid= ba.fid ").append(" left join t_ssc_billtype bt on ba.fbilltypeid=bt.fid ").append(" left join T_SSC_SystemAttribute sysattr on sysattr.FID = bt.FSYSATTRID").append(" left join t_ssc_user u on job.fpersonnelidid=u.fid ").append(" where job.fproclnstid in (" + selectIdSql + ") ").append(" and job.FJobState <> '9' ");
        sb.append(" union all ");
        sb.append(" select job.fproclnstid,bt.fname_l2 billtype,job.fsubject ,job.fjobstate,job.flevel,job.freceiveTime,job.fcompletetme,u.fname_l2 username,job.flastupdatetime,job.fwaitTime,job.fcreatetime,job.fjobpoolingtype,job.FCostWorkTime costTime,job.FShareCenterID shareCenterID  ").append(" from t_ssc_job job left join t_ssc_bussinessAttribute ba on job.fbussattridid= ba.fid ").append(" left join t_ssc_billtype bt on ba.fbilltypeid=bt.fid ").append(" left join T_SSC_SystemAttribute sysattr on sysattr.FID = bt.FSYSATTRID").append(" left join t_ssc_user u on job.fpersonnelidid=u.fid ").append(" where job.fproclnstid in (" + selectIdSql + ") ");
        if (!StringUtils.isEmpty((String)sidx)) {
            sb.append(" order by billtype ");
            if (!StringUtils.isEmpty((String)sord)) {
                sb.append(sord);
            }
        }
        return sb.toString();
    }

    public static String getMutiTaskDetailBillTypeListSql(Map param, Context ctx) throws BOSException {
        String extendErpId;
        String result;
        String startDate = (String)param.get("startDate");
        String endDate = (String)param.get("endDate");
        String billType = (String)param.get("billType");
        String orgId = (String)param.get("orgId");
        String userId = (String)param.get("userId");
        String jobState = (String)param.get("jobState");
        String subject = (String)param.get("subject");
        Boolean isOnlyAuditJob = (Boolean)param.get("isOnlyAuditJob");
        String shareCenterId = (String)param.get("shareCenter.id");
        String inShareCenterIdStr = null;
        if (StringUtils.isEmpty((String)shareCenterId)) {
            String EASUserId = (String)param.get("EASUserId");
            if (!BOSUuid.isValid((String)EASUserId, (boolean)true)) {
                throw new IllegalArgumentException("parameter is[" + EASUserId + "]");
            }
            String permissionId = (String)param.get("permissionId");
            inShareCenterIdStr = ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId);
        } else {
            if (!BOSUuid.isValid((String)shareCenterId, (boolean)false)) {
                throw new BOSException("\u65e0\u6548\u7684shareCenterId:" + shareCenterId);
            }
            inShareCenterIdStr = "'" + shareCenterId + "'";
        }
        if (isOnlyAuditJob == null) {
            isOnlyAuditJob = false;
        }
        StringBuffer sb = new StringBuffer(300);
        sb.append("select distinct job.fproclnstid,billType.fnumber billtype ").append(TaskReportUtil.getMutiTaskDetailCountFromSql(param)).append(" where job.FShareCenterID in (").append(inShareCenterIdStr).append(") ");
        if (isOnlyAuditJob.booleanValue()) {
            sb.append(" and ba.FJobClassification = 1 ");
        }
        if (!StringUtils.isEmpty((String)billType)) {
            result = SSCUtil.convertObjectToPlaceholder(billType);
            sb.append(" and ba.fbilltypeid in(").append(result).append(")");
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            result = SSCUtil.convertObjectToPlaceholder(orgId);
            sb.append(" and job.forgidid in(").append(result).append(")");
        }
        if (!StringUtils.isEmpty((String)userId)) {
            result = SSCUtil.convertObjectToPlaceholder(userId);
            sb.append(" and job.fpersonnelidid in(").append(result).append(")");
        } else if (!jobState.equals("40")) {
            // empty if block
        }
        sb.append(" and job.FJobState <> '9' ");
        if (!"10000".equals(jobState)) {
            if ("30".equals(jobState)) {
                sb.append(" and not exists( select 1 from t_ssc_job t1 where t1.fproclnstid=job.fproclnstid) ").append(" and not exists( select 1 from t_ssc_jobhis t2 where t2.fproclnstid=job.fproclnstid and t2.fjobstate<>'3') ");
            } else if ("20".equals(jobState)) {
                sb.append(" and job.fjobpoolingtype='2' ");
            } else if ("40".equals(jobState)) {
                sb.append(" and job.fjobpoolingtype='1' ");
            } else if ("1".equals(jobState)) {
                sb.append(" and job.fjobstate in('1','13')");
            } else {
                sb.append(" and job.fjobstate=?");
            }
        }
        if (!StringUtils.isEmpty((String)subject)) {
            sb.append(" and job.fsubject like ? ");
        }
        if (!StringUtils.isEmpty((String)(extendErpId = (String)param.get("extendErpId")))) {
            sb.append(" AND SYSATTR.FEXTENDERPID IN (" + SSCStringUtils.getSQLStrBySplitStr(extendErpId) + ")");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            sb.append(" and  job.fcreatetime >=").append(DateUtil.dateToTsDate(startDate)).append(" and job.fcreatetime <=").append(DateUtil.dateToTsDate(endDate));
        }
        return sb.toString();
    }

    public static String getMutiTaskDetailCountFromSql(Map param) throws BOSException {
        String jobState = (String)param.get("jobState");
        StringBuffer sb = new StringBuffer(100);
        sb.append("from ");
        if ("10000".equals(jobState)) {
            sb.append("(select j1.fid,j1.fproclnstid,j1.forgidid,j1.fpersonnelidid,j1.fsubject ,j1.fcreatetime,j1.fjobstate,j1.fbussattridid,j1.flevel,j1.freceiveTime,j1.fcompletetme,").append(" j1.flastupdatetime,j1.fwaitTime,j1.fjobpoolingtype,j1.FCostWorkTime,j1.FShareCenterID").append(" from t_ssc_job j1 ").append(" union all ").append(" select j2.fid,j2.fproclnstid,j2.forgidid,j2.fpersonnelidid,j2.fsubject ,j2.fcreatetime,j2.fjobstate,j2.fbussattridid,j2.flevel,j2.freceiveTime,j2.fcompletetme,").append(" j2.flastupdatetime,j2.fwaitTime,j2.fjobpoolingtype,j2.FCostWorkTime,j2.FShareCenterID").append(" from t_ssc_jobhis j2) as job left join t_ssc_bussinessAttribute ba on job.fbussattridid= ba.fid");
        } else if ("3".equals(jobState) || "30".equals(jobState) || "4".equals(jobState) || "10".equals(jobState)) {
            sb.append("t_ssc_jobhis job left join t_ssc_bussinessAttribute ba on job.fbussattridid= ba.fid ");
        } else if ("1".equals(jobState) || "0".equals(jobState) || "40".equals(jobState) || "20".equals(jobState)) {
            sb.append("t_ssc_job job left join t_ssc_bussinessAttribute ba on job.fbussattridid= ba.fid ");
        } else {
            throw new BOSException("job state is not legal.");
        }
        sb.append(" left join T_ssc_billType billType on ba.FBillTypeID =billType.fid");
        sb.append(" left join T_SSC_SystemAttribute sysattr on sysattr.FID = billtype.FSYSATTRID");
        return sb.toString();
    }

    public static String getJobHisSelectWorkSql(String dateFrom, String dateTo, String groupUserId, String userId, String selectShareCenterId, String extendErpId) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(" select a.attrID attrID,a.userId userId,a.userName userName,a.groupId groupId,a.groupName groupName,sum(a.fstandardCoe) standardNum");
        sb.append(" from(");
        sb.append(" select job.FBussAttrIDID AttrID, job.FpersonnelIDID userId, sscUser.fname_l2 username ,SSCGroup.Fid groupId,SSCGroup.fname_l2 groupName ,job.fstandardCoe");
        sb.append(" from T_SSC_jobHIs job");
        sb.append(" inner join T_ssc_user sscUser on job.FpersonnelIDID = sscUser.FID");
        sb.append(" left join t_ssc_userGroup GroupUser on sscUser.FID = GroupUser.FUserID");
        sb.append(" left join T_ssc_Group SSCGroup on SSCGroup.FID = GroupUser.FGroupID");
        sb.append(" inner join T_ssc_BussinessAttribute attr on attr.fid = job.FBussAttrIDID");
        sb.append(" inner join T_SSC_BILLTYPE billtype on attr.FBILLTYPEID = billtype.fid");
        sb.append(" inner join T_SSC_SystemAttribute sysattr on sysattr.FID = billtype.FSYSATTRID");
        sb.append(" where job.fcompletetme>=" + DateUtil.dateToTsDate(dateFrom) + " and job.fcompletetme<=" + DateUtil.dateToTsDate(dateTo));
        sb.append(" and exists ( select 1 from T_SSC_JOBHIS jobHis where job.fbillId = jobHis.fbillId and ( jobHis.FIsLastLevel ='1' and jobHis.FAutoApprove='0' and  (jobHis.fjobstate ='3' or jobHis.fjobstate ='4' or jobHis.fjobstate ='10')))");
        if (selectShareCenterId != null && selectShareCenterId != "") {
            String[] selectShareCenterIds = selectShareCenterId.split(",");
            for (i = 0; i < selectShareCenterIds.length; ++i) {
                if (BOSUuid.isValid((String)selectShareCenterIds[i].substring(1, selectShareCenterIds[i].length() - 1), (boolean)false)) continue;
                throw new IllegalArgumentException("\u65e0\u6548\u7684selectShareCenterId");
            }
            sb = sb.append(" and job.fshareCenterId in (" + selectShareCenterId + ") ");
        }
        if (groupUserId != null && groupUserId != "") {
            String[] groupUserIds = groupUserId.split(",");
            for (i = 0; i < groupUserIds.length; ++i) {
                if (BOSUuid.isValid((String)groupUserIds[i].substring(1, groupUserIds[i].length() - 1), (boolean)false)) continue;
                throw new IllegalArgumentException("\u65e0\u6548\u7684groupUserId");
            }
            sb = sb.append(" and SSCGroup.fid in(" + groupUserId + ")");
        }
        if (userId != null && userId != "") {
            String[] userIds = userId.split(",");
            for (i = 0; i < userIds.length; ++i) {
                if (BOSUuid.isValid((String)userIds[i].substring(1, userIds[i].length() - 1), (boolean)false)) continue;
                throw new IllegalArgumentException("\u65e0\u6548\u7684userId");
            }
            sb = sb.append(" and sscUser.fid in(" + userId + ")");
        }
        if (!StringUtils.isEmpty((String)extendErpId)) {
            sb.append(" and sysattr.FEXTENDERPID in (" + extendErpId + ")");
        }
        sb.append(" ) a");
        sb.append(" GROUP BY a.attrID,a.userId,a.userName,a.groupId,a.groupName");
        sb.append(" order by a.userid, a.attrID, a.groupId");
        return sb.toString();
    }

    public static String getSampleLibraryQualityTaskSelectWorkSql(String dateFrom, String dateTo, String groupUserId, String userId, String selectShareCenterId, String extendErpId) {
        String sql = "select b.billType,b.standardCoe,b.userid,b.username,b.groupid,b.groupname,sum(case when checkType = 20 then 0 else 1 end) choujian,sum(case when checkType = 10 then 0 else 1 end) zhijian from(select st.fbillId billID,st.FBillTypeID billType,billType.FStandardCoefficient standardCoe ,sscUser.fid userid,sscUser.fname_l2 username,SSCGroup.fid groupid,SSCGroup.fname_l2 groupname,cs.fcheckType checkType from T_SSC_SampleLibraryQualityTask st  inner join t_ssc_samplelibrary sl on sl.fid = st.fparentid inner join t_ssc_checkscheme cs on cs.fid = sl.fcheckschemeid inner join T_ssc_user sscUser on sscUser.FID = st.FExaminerID left join t_ssc_userGroup GroupUser on sscUser.FID = GroupUser.FUserID left join T_ssc_Group SSCGroup on SSCGroup.FID = GroupUser.FGroupID inner join T_ssc_billType billType on st.FBillTypeID =billType.fid inner join T_SSC_SystemAttribute sysattr on sysattr.FID = billtype.FSYSATTRID where st.FTASKSTATE in('3','4') and st.fexaminedate>=" + DateUtil.dateToTsDate(dateFrom) + " and st.fexaminedate<=" + DateUtil.dateToTsDate(dateTo);
        if (selectShareCenterId != null && selectShareCenterId != "") {
            sql = sql + " and cs.fshareCenterId in (" + selectShareCenterId + ") ";
        }
        if (groupUserId != null && groupUserId != "") {
            sql = sql + " and SSCGroup.fid in(" + groupUserId + ")";
        }
        if (userId != null && userId != "") {
            sql = sql + " and sscUser.fid in(" + userId + ")";
        }
        if (!StringUtils.isEmpty((String)extendErpId)) {
            sql = sql + " and sysattr.FEXTENDERPID in (" + extendErpId + ")";
        }
        String GroupSelectEnd = ") b GROUP by  b.billType,b.standardCoe,b.userid,b.username,b.groupid,b.groupname order by b.userid,b.groupid";
        sql = sql + GroupSelectEnd;
        return sql;
    }

    public static String getJobRollBackSelectSql(String dateFrom, String dateTo, String groupUserId, String userId, String selectShareCenterId, String extendErpId) {
        String sql = "select jh.fbillid billid,count(jh.fbillid) billNum,u.fid userid,u.fname_l2 username,u.fid groupid,u.fname_l2 groupname from t_ssc_jobhis jh inner join t_ssc_user u on u.fid = jh.fpersonnelidid left join t_ssc_userGroup ug on u.fid = ug.fuserid left join t_ssc_group g on g.fid = ug.fgroupid where exists (select 1 from (select DISTINCT jh.fbillid,jh.fcompletetme,jh.flevel,jh.FIsLastLevel,jh.FAutoApprove,sysattr.FEXTENDERPID from T_SSC_jobstatimhis jsh inner join t_ssc_jobhis jh on jh.fid = jsh.fjobidid inner join t_ssc_user u on u.fid = jsh.foperatoridid inner join T_ssc_BussinessAttribute attr on attr.fid = jh.FBussAttrIDID inner join T_SSC_BILLTYPE billtype on attr.FBILLTYPEID = billtype.fid inner join T_SSC_SystemAttribute sysattr on sysattr.FID = billtype.FSYSATTRID where jsh.foperation='10' and jh.fbillid in( select fbillId from T_SSC_JOBHIS where (FIsLastLevel ='1' and FAutoApprove='0' and fcompletetme>=" + DateUtil.dateToTsDate(dateFrom) + " and fcompletetme<=" + DateUtil.dateToTsDate(dateTo) + " ) and  (fjobstate ='3' or fjobstate ='4' or fjobstate ='10'))) tmp where jh.fbillid = tmp.fbillid and jh.flevel = tmp.flevel -1 and  jh.fcompletetme<tmp.fcompletetme";
        if (selectShareCenterId != null && selectShareCenterId != "") {
            sql = sql + " and jh.fshareCenterId in(" + selectShareCenterId + ") ";
        }
        if (groupUserId != null && groupUserId != "") {
            sql = sql + " and g.fid in(" + groupUserId + ")";
        }
        if (userId != null && userId != "") {
            sql = sql + " and u.fid in(" + userId + ")";
        }
        if (!StringUtils.isEmpty((String)extendErpId)) {
            sql = sql + " and tmp.FEXTENDERPID in (" + extendErpId + ")";
        }
        String selectEnd = " ) group by jh.fbillid, u.fid,u.fname_l2 order by u.fid";
        sql = sql + selectEnd;
        return sql;
    }

    public static String getCheckschemeUnpassSql(String dateFrom, String dateTo, String groupUserId, String userId, String selectShareCenterId, String extendErpId) {
        String sql = "select tmp.FBILLID as billid,us.fid as userid,us.FNAME_l2 as username,count(tmp.FBILLID) as billNum,ug.fid groupid,ug.fname_l2 groupname from (select jh.FSUBJECT, jh.FBILLID, jh.FPERSONNELIDID, jh.fsharecenterid, jh.FISLASTLEVEL,sysattr.FEXTENDERPID       from t_ssc_jobhis jh  inner join T_ssc_BussinessAttribute attr on attr.fid = jh.FBussAttrIDID inner join T_SSC_BILLTYPE billtype on attr.FBILLTYPEID = billtype.fid inner join T_SSC_SystemAttribute sysattr on sysattr.FID = billtype.FSYSATTRID      where FBILLID in (select FBILLID from T_SSC_SampleLibraryQualityTask where FCheckResult = '0'  and fexaminedate>=" + DateUtil.dateToTsDate(dateFrom) + " and fexaminedate<=" + DateUtil.dateToTsDate(dateTo) + ") and fautoapprove = 0) tmp INNER JOIN T_SSC_USER us on tmp.FPERSONNELIDID = us.FID LEFT JOIN t_ssc_userGroup ug on us.fid = ug.fuserid where tmp.FISLASTLEVEL =1 ";
        if (!StringUtils.isEmpty((String)selectShareCenterId)) {
            sql = sql + " and tmp.fshareCenterId in(" + selectShareCenterId + ") ";
        }
        if (!StringUtils.isEmpty((String)groupUserId)) {
            sql = sql + " and ug.FGROUPID in(" + groupUserId + ")";
        }
        if (!StringUtils.isEmpty((String)userId)) {
            sql = sql + " and us.fid in(" + userId + ")";
        }
        if (!StringUtils.isEmpty((String)extendErpId)) {
            sql = sql + " and tmp.FEXTENDERPID in (" + extendErpId + ")";
        }
        sql = sql + " group by us.fid,us.FNAME_l2,ug.fid,ug.fname_l2,tmp.FBILLID order by tmp.FBILLID,us.fid,ug.fid";
        return sql;
    }

    public static String getBillTypeSql(Map solutionMap, Context ctx) throws BOSException {
        String EASUserId = (String)solutionMap.get("EASUserId");
        String permissionId = (String)solutionMap.get("permissionId");
        String shareCenterId = (String)solutionMap.get("shareCenter.id");
        String result = "";
        result = StringUtils.isEmpty((String)shareCenterId) ? "SELECT DISTINCT T3.FID BILLTYPEID FROM T_SSC_SysAttrOrgSCMap T1 LEFT JOIN T_SSC_SystemAttribute T2 ON T1.FSystemAttributeID = T2.FID LEFT JOIN T_SSC_BILLTYPE T3 ON T3.FSYSATTRID = T2.FID WHERE T1.FSHARECENTERID IN(" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ")" : "SELECT DISTINCT T3.FID BILLTYPEID FROM T_SSC_SysAttrOrgSCMap T1 LEFT JOIN T_SSC_SystemAttribute T2 ON T1.FSystemAttributeID = T2.FID LEFT JOIN T_SSC_BILLTYPE T3 ON T3.FSYSATTRID = T2.FID WHERE T1.FSHARECENTERID IN('" + shareCenterId + "')";
        return result;
    }

    public static Map<String, Object> getOverdueTaskSql(Map param) {
        String[] ids;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> params = new ArrayList<String>();
        String shareCenterId = (String)param.get("shareCenter.id");
        String userGroupId = (String)param.get("userGroupId");
        String userId = (String)param.get("userId");
        String startDate = (String)param.get("startDate");
        String endDate = (String)param.get("endDate");
        String groupTable = (String)param.get("groupTable");
        StringBuilder sb = null;
        sb = StringUtils.isEmpty((String)groupTable) ? new StringBuilder("SELECT grou.FNAME_L2 userGroupName, us.FNAME_L2 userName, count(1) handCount, sum(case when job.FExpireState = 1 then 1 end) overdueCount FROM T_SSC_Group grou") : new StringBuilder("SELECT grou.FNAME_L2 userGroupName, us.FNAME_L2 userName, count(1) handCount, sum(case when job.FExpireState = 1 then 1 end) overdueCount FROM (" + groupTable + ") grou");
        if (StringUtils.isEmpty((String)userId)) {
            if (StringUtils.isEmpty((String)userGroupId)) {
                if (StringUtils.isEmpty((String)groupTable)) {
                    sb.append(" inner join T_SSC_UserGroup userGroup on grou.Fid = userGroup.FGROUPID ");
                } else {
                    sb.append(" inner join T_SSC_UserGroup userGroup on grou.Fid = userGroup.FGROUPID and userGroup.FUSERID = grou.fuserid ");
                }
                sb.append(" inner join T_SSC_User us on userGroup.FUSERID = us.FID");
                sb.append(" inner join T_SSC_JobHis job on us.FID = job.FPERSONNELIDID");
                sb.append(" where ");
                sb.append(" job.FSHARECENTERID in (");
                for (String id : ids = shareCenterId.split(",")) {
                    sb.append("?,");
                    params.add(id.replaceAll("'", ""));
                }
                sb.deleteCharAt(sb.length() - 1).append(")");
            } else {
                if (StringUtils.isEmpty((String)groupTable)) {
                    sb.append(" inner join T_SSC_UserGroup userGroup on grou.Fid = userGroup.FGROUPID ");
                } else {
                    sb.append(" inner join T_SSC_UserGroup userGroup on grou.Fid = userGroup.FGROUPID and userGroup.FUSERID = grou.fuserid ");
                }
                sb.append(" inner join T_SSC_User us on userGroup.FUSERID = us.FID");
                sb.append(" inner join T_SSC_JobHis job on us.FID = job.FPERSONNELIDID");
                sb.append(" where ");
                sb.append(" grou.FID in (");
                for (String id : ids = userGroupId.split(",")) {
                    sb.append("?,");
                    params.add(id.replaceAll("'", ""));
                }
                sb.deleteCharAt(sb.length() - 1).append(")");
            }
        } else {
            if (StringUtils.isEmpty((String)groupTable)) {
                sb.append(" inner join T_SSC_UserGroup userGroup on grou.Fid = userGroup.FGROUPID ");
            } else {
                sb.append(" inner join T_SSC_UserGroup userGroup on grou.Fid = userGroup.FGROUPID and userGroup.FUSERID = grou.fuserid ");
            }
            sb.append(" inner join T_SSC_User us on userGroup.FUSERID = us.FID");
            sb.append(" inner join T_SSC_JobHis job on us.FID = job.FPERSONNELIDID");
            sb.append(" where ");
            sb.append("job.FPERSONNELIDID in (");
            for (String id : ids = userId.split(",")) {
                sb.append("?,");
                params.add(id.replaceAll("'", ""));
            }
            sb.deleteCharAt(sb.length() - 1).append(")");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            sb.append(" and job.fcompletetme >=").append(DateUtil.dateToTsDate(startDate));
            sb.append(" and job.fcompletetme <=").append(DateUtil.dateToTsDate(endDate));
        }
        sb.append(" group by grou.FNAME_L2 ,us.FNAME_L2");
        StringBuilder sbu = new StringBuilder("SELECT TT.*,isnull(TT.overdueCount,0)*100.0/TT.handCount as overduePercent from (");
        sbu.append((CharSequence)sb).append(") as TT order by userGroupName,overduePercent desc");
        result.put("sql", sbu.toString());
        int len = params.size();
        Object[] p = new Object[len];
        for (int i = 0; i < len; ++i) {
            p[i] = params.get(i);
        }
        result.put("params", p);
        return result;
    }
}

