/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool.aopTool.aspect;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.app.checkpointext.RuleEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.DataInfo;
import com.kingdee.eas.base.ssc.tool.JSONUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class CheckPointDataAspect {
    private static final Logger logger = Logger.getLogger(CheckPointDataAspect.class);

    @Pointcut(value="execution(* com.kingdee.eas.base.ssc.app.checkpointext.compare.data.SqlData.getData(..))")
    public void sqlDataAspect() {
    }

    @Pointcut(value="execution(* com.kingdee.eas.base.ssc.app.checkpointext.compare.data.EntityData.getData(..))")
    public void entityDataAspect() {
    }

    @Pointcut(value="execution(* com.kingdee.eas.base.ssc.app.checkpointext.compare.data.DynamicAttributeData.getData(..))")
    public void DynamicDataAspect() {
    }

    @Before(value="sqlDataAspect()")
    public void beforeSqlData(JoinPoint pointParam) {
        this.beforeGetData(pointParam);
    }

    @Before(value="entityDataAspect()")
    public void beforeEntityData(JoinPoint pointParam) {
        this.beforeGetData(pointParam);
    }

    @Before(value="DynamicDataAspect()")
    public void beforeDynamicDataData(JoinPoint pointParam) {
        this.beforeGetData(pointParam);
    }

    public void beforeGetData(JoinPoint pointParam) {
        try {
            Object[] args = pointParam.getArgs();
            Context ctx = (Context)args[0];
            String methodName = (String)args[args.length - 1];
            methodName = methodName + " is before";
            Timestamp createTime = new Timestamp(new Date().getTime());
            Map extendParams = (Map)args[args.length - 2];
            String expr = "";
            if (extendParams != null) {
                expr = (String)extendParams.get("expr");
            }
            if (args[1] != null) {
                RuleEntryInfo ruleEntryInfo = (RuleEntryInfo)args[1];
                String dataSetId = ruleEntryInfo.getDataSetInfo() != null ? ruleEntryInfo.getDataSetInfo().getId().toString() : "";
                String entryId = ruleEntryInfo.getEntryInfo() == null ? "" : ruleEntryInfo.getEntryInfo().getId().toString();
                String jobid = ruleEntryInfo.getJobInfo().getId().toString();
                int result = ruleEntryInfo.isResult() ? 1 : 0;
                String sql = "INSERT INTO T_SSC_IntelligentExecuteRecord (FdataSetId,FexecuteRuleId,Fresult,Fjobid,FCreateTime,FmethodName,Fexpression ) VALUES (?,?,?,?,?,?,?)";
                try {
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{dataSetId, entryId, result, jobid, createTime, methodName, expr});
                }
                catch (BOSException e) {
                    logger.error((Object)("after fail sql is'" + sql + "',dataSetId:" + dataSetId + ",entryId:" + entryId + ",result:" + result + ",jobid:" + jobid + ",createTime:" + createTime + ",methodName:" + methodName + ",expr:" + expr), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"before proxy method get param wrong", (Throwable)e);
        }
    }

    @AfterReturning(returning="rvt", value="sqlDataAspect()")
    public void afterReturningSqlData(JoinPoint pointParam, Object rvt) {
        this.afterGetDataReturn(pointParam, rvt);
    }

    @AfterReturning(returning="rvt", value="entityDataAspect()")
    public void afterReturningEntityData(JoinPoint pointParam, Object rvt) {
        this.afterGetDataReturn(pointParam, rvt);
    }

    @AfterReturning(returning="rvt", value="DynamicDataAspect()")
    public void afterReturningDynamicDataData(JoinPoint pointParam, Object rvt) {
        this.afterGetDataReturn(pointParam, rvt);
    }

    public void afterGetDataReturn(JoinPoint pointParam, Object rvt) {
        try {
            Object[] args = pointParam.getArgs();
            Context ctx = (Context)args[0];
            String methodName = (String)args[args.length - 1];
            methodName = methodName + " is after";
            Timestamp createTime = new Timestamp(new Date().getTime());
            if (args[1] != null) {
                RuleEntryInfo ruleEntryInfo = (RuleEntryInfo)args[1];
                String dataSetId = ruleEntryInfo.getDataSetInfo() != null ? ruleEntryInfo.getDataSetInfo().getId().toString() : "";
                String executeRuldId = ruleEntryInfo.getEntryInfo() == null ? "" : ruleEntryInfo.getEntryInfo().getId().toString();
                String jobId = ruleEntryInfo.getJobInfo().getId().toString();
                if (rvt != null && rvt instanceof String) {
                    String excetionMessage = (String)rvt;
                    if (excetionMessage.length() > 500) {
                        excetionMessage.substring(0, 500);
                    }
                    String sql = "insert into T_SSC_IntelligentExecuteRecord(FexcetionMessage,FCreateTime,FmethodName,Fjobid,FexecuteRuleId,FdataSetId) VALUES(?,?,?,?,?,?)";
                    try {
                        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{excetionMessage, createTime, methodName, jobId, executeRuldId, dataSetId});
                    }
                    catch (BOSException e) {
                        logger.error((Object)"after exception fail");
                    }
                } else if (rvt != null) {
                    DataInfo ob = (DataInfo)rvt;
                    String expr = ob.getExpr();
                    HashMap originalData = new HashMap();
                    String originalDataString = JSONUtil.map2json(originalData);
                    String sql = "INSERT INTO T_SSC_IntelligentExecuteRecord (Fexpression,ForiginalData,FCreateTime,FmethodName,Fjobid,FexecuteRuleId,FdataSetId ) VALUES (?,?,?,?,?,?,?)";
                    try {
                        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{expr, originalDataString, createTime, methodName, jobId, executeRuldId, dataSetId});
                    }
                    catch (BOSException e) {
                        logger.error((Object)("after fail sql is'" + sql + "',expr:" + expr + ",originalDataString:" + originalDataString + ",createTime:" + createTime + ",methodName:" + methodName + ",jobId:" + jobId + ",executeRuldId:" + executeRuldId + ",dataSetId:" + dataSetId));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"after proxy method get param wrong", (Throwable)e);
        }
    }
}

