/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool.checkpointext;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.BussinessAttributeExtCollection;
import com.kingdee.eas.base.ssc.BussinessAttributeExtFactory;
import com.kingdee.eas.base.ssc.IntelligentAuditCheckpointCollection;
import com.kingdee.eas.base.ssc.IntelligentAuditCheckpointInfo;
import com.kingdee.eas.base.ssc.IntelligentAuditExecuteRuleEntryCollection;
import com.kingdee.eas.base.ssc.IntelligentAuditExecuteRuleEntryInfo;
import com.kingdee.eas.base.ssc.JobFactory;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointEntryFilterCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointEntryFilterInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDSCFiledSeqEntryCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDSCFiledSeqEntryFactory;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDSCFiledSeqEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgFactory;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgFieldEntryCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgFieldEntryFactory;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgFieldEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgRelationEntryCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgRelationEntryFactory;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgRelationEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.RuleEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.CompareManager;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.function.CustomerFunction;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.DataInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.FieldModelInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.ModelTypeEnum;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.TableModelInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.SQLInfo;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.SSCCompareUtils;
import com.kingdee.eas.base.ssc.tool.checkpointext.Constant;
import com.kingdee.eas.base.ssc.tool.checkpointext.DataSetUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CheckPointUtils {
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointUtils");
    static final Pattern pattern = Pattern.compile("^(\\-|\\+)?\\d+(\\.\\d+)?$");
    static Pattern p = Pattern.compile("[\u4e00-\u9fa5|\\\uff01|\\\uff0c|\\\u3002|\\\uff08|\\\uff09|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\uff1f|\\\uff1a|\\\uff1b|\\\u3010|\\\u3011]");
    private static final int[] li_SecPosValue = new int[]{1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086, 4390, 4558, 4684, 4925, 5249, 5590};
    private static final String[] lc_FirstLetter = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "W", "X", "Y", "Z"};
    private static final String ls_SecondSecTable = "CJWGNSPGCGNE[Y[BTYYZDXYKYGT[JNNJQMBSGZSCYJSYY[PGKBZGY[YWJKGKLJYWKPJQHY[W[DZLSGMRYPYWWCCKZNKYYGTTNJJNYKKZYTCJNMCYLQLYPYQFQRPZSLWBTGKJFYXJWZLTBNCXJJJJTXDTTSQZYCDXXHGCK[PHFFSS[YBGXLPPBYLL[HLXS[ZM[JHSOJNGHDZQYKLGJHSGQZHXQGKEZZWYSCSCJXYEYXADZPMDSSMZJZQJYZC[J[WQJBYZPXGZNZCPWHKXHQKMWFBPBYDTJZZKQHYLYGXFPTYJYYZPSZLFCHMQSHGMXXSXJ[[DCSBBQBEFSJYHXWGZKPYLQBGLDLCCTNMAYDDKSSNGYCSGXLYZAYBNPTSDKDYLHGYMYLCXPY[JNDQJWXQXFYYFJLEJPZRXCCQWQQSBNKYMGPLBMJRQCFLNYMYQMSQYRBCJTHZTQFRXQHXMJJCJLXQGJMSHZKBSWYEMYLTXFSYDSWLYCJQXSJNQBSCTYHBFTDCYZDJWYGHQFRXWCKQKXEBPTLPXJZSRMEBWHJLBJSLYYSMDXLCLQKXLHXJRZJMFQHXHWYWSBHTRXXGLHQHFNM[YKLDYXZPYLGG[MTCFPAJJZYLJTYANJGBJPLQGDZYQYAXBKYSECJSZNSLYZHSXLZCGHPXZHZNYTDSBCJKDLZAYFMYDLEBBGQYZKXGLDNDNYSKJSHDLYXBCGHXYPKDJMMZNGMMCLGWZSZXZJFZNMLZZTHCSYDBDLLSCDDNLKJYKJSYCJLKWHQASDKNHCSGANHDAASHTCPLCPQYBSDMPJLPZJOQLCDHJJYSPRCHN[NNLHLYYQYHWZPTCZGWWMZFFJQQQQYXACLBHKDJXDGMMYDJXZLLSYGXGKJRYWZWYCLZMSSJZLDBYD[FCXYHLXCHYZJQ[[QAGMNYXPFRKSSBJLYXYSYGLNSCMHZWWMNZJJLXXHCHSY[[TTXRYCYXBYHCSMXJSZNPWGPXXTAYBGAJCXLY[DCCWZOCWKCCSBNHCPDYZNFCYYTYCKXKYBSQKKYTQQXFCWCHCYKELZQBSQYJQCCLMTHSYWHMKTLKJLYCXWHEQQHTQH[PQ[QSCFYMNDMGBWHWLGSLLYSDLMLXPTHMJHWLJZYHZJXHTXJLHXRSWLWZJCBXMHZQXSDZPMGFCSGLSXYMJSHXPJXWMYQKSMYPLRTHBXFTPMHYXLCHLHLZYLXGSSSSTCLSLDCLRPBHZHXYYFHB[GDMYCNQQWLQHJJ[YWJZYEJJDHPBLQXTQKWHLCHQXAGTLXLJXMSL[HTZKZJECXJCJNMFBY[SFYWYBJZGNYSDZSQYRSLJPCLPWXSDWEJBJCBCNAYTWGMPAPCLYQPCLZXSBNMSGGFNZJJBZSFZYNDXHPLQKZCZWALSBCCJX[YZGWKYPSGXFZFCDKHJGXDLQFSGDSLQWZKXTMHSBGZMJZRGLYJBPMLMSXLZJQQHZYJCZYDJWBMYKLDDPMJEGXYHYLXHLQYQHKYCWCJMYYXNATJHYCCXZPCQLBZWWYTWBQCMLPMYRJCCCXFPZNZZLJPLXXYZTZLGDLDCKLYRZZGQTGJHHGJLJAXFGFJZSLCFDQZLCLGJDJCSNZLLJPJQDCCLCJXMYZFTSXGCGSBRZXJQQCTZHGYQTJQQLZXJYLYLBCYAMCSTYLPDJBYREGKLZYZHLYSZQLZNWCZCLLWJQJJJKDGJZOLBBZPPGLGHTGZXYGHZMYCNQSYCYHBHGXKAMTXYXNBSKYZZGJZLQJDFCJXDYGJQJJPMGWGJJJPKQSBGBMMCJSSCLPQPDXCDYYKY[CJDDYYGYWRHJRTGZNYQLDKLJSZZGZQZJGDYKSHPZMTLCPWNJAFYZDJCNMWESCYGLBTZCGMSSLLYXQSXSBSJSBBSGGHFJLYPMZJNLYYWDQSHZXTYYWHMZYHYWDBXBTLMSYYYFSXJC[DXXLHJHF[SXZQHFZMZCZTQCXZXRTTDJHNNYZQQMNQDMMG[YDXMJGDHCDYZBFFALLZTDLTFXMXQZDNGWQDBDCZJDXBZGSQQDDJCMBKZFFXMKDMDSYYSZCMLJDSYNSBRSKMKMPCKLGDBQTFZSWTFGGLYPLLJZHGJ[GYPZLTCSMCNBTJBQFKTHBYZGKPBBYMTDSSXTBNPDKLEYCJNYDDYKZDDHQHSDZSCTARLLTKZLGECLLKJLQJAQNBDKKGHPJTZQKSECSHALQFMMGJNLYJBBTMLYZXDCJPLDLPCQDHZYCBZSCZBZMSLJFLKRZJSNFRGJHXPDHYJYBZGDLQCSEZGXLBLGYXTWMABCHECMWYJYZLLJJYHLG[DJLSLYGKDZPZXJYYZLWCXSZFGWYYDLYHCLJSCMBJHBLYZLYCBLYDPDQYSXQZBYTDKYXJY[CNRJMPDJGKLCLJBCTBJDDBBLBLCZQRPPXJCJLZCSHLTOLJNMDDDLNGKAQHQHJGYKHEZNMSHRP[QQJCHGMFPRXHJGDYCHGHLYRZQLCYQJNZSQTKQJYMSZSWLCFQQQXYFGGYPTQWLMCRNFKKFSYYLQBMQAMMMYXCTPSHCPTXXZZSMPHPSHMCLMLDQFYQXSZYYDYJZZHQPDSZGLSTJBCKBXYQZJSGPSXQZQZRQTBDKYXZKHHGFLBCSMDLDGDZDBLZYYCXNNCSYBZBFGLZZXSWMSCCMQNJQSBDQSJTXXMBLTXZCLZSHZCXRQJGJYLXZFJPHYMZQQYDFQJJLZZNZJCDGZYGCTXMZYSCTLKPHTXHTLBJXJLXSCDQXCBBTJFQZFSLTJBTKQBXXJJLJCHCZDBZJDCZJDCPRNPQCJPFCZLCLZXZDMXMPHJSGZGSZZQLYLWTJPFSYASMCJBTZKYCWMYTCSJJLJCQLWZMALBXYFBPNLSFHTGJWEJJXXGLLJSTGSHJQLZFKCGNNNSZFDEQFHBSAQTGYLBXMMYGSZLDYDQMJJRGBJTKGDHGKBLQKBDMBYLXWCXYTTYBKMRTJZXQJBHLMHMJJZMQASLDCYXYQDLQCAFYWYXQHZ";

    public static String spiltString(String string) {
        string = string.trim();
        return string.substring(string.indexOf(".{") + 3, string.length() - 1);
    }

    public static Map<Integer, String> dealExprFormula(String key) {
        String str = key;
        String[] arr1 = str.split("\\+");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < arr1.length; ++i) {
            String[] arr2 = arr1[i].split("\\-");
            for (int j = 0; j < arr2.length; ++j) {
                String[] arr3 = arr2[j].split("\\*");
                for (int k = 0; k < arr3.length; ++k) {
                    String[] arr4 = arr3[k].split("\\/");
                    for (int l = 0; l < arr4.length; ++l) {
                        list.add(arr4[l]);
                        if (l == arr4.length - 1) continue;
                        list.add("/");
                    }
                    if (k == arr3.length - 1) continue;
                    list.add("*");
                }
                if (j == arr2.length - 1) continue;
                list.add("-");
            }
            if (i == arr1.length - 1) continue;
            list.add("+");
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i = 0; i < list.size(); ++i) {
            String s = CheckPointUtils.removeInvalidBrackets((String)list.get(i));
            map.put(i, s);
        }
        return map;
    }

    public static String removeInvalidBrackets(String s) {
        Stack<Integer> stack = new Stack<Integer>();
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (index < s.length()) {
            char c;
            if ((c = s.charAt(index++)) == '(') {
                builder.append(c);
                stack.push(builder.length() - 1);
                continue;
            }
            if (c == ')') {
                if (stack.isEmpty()) continue;
                builder.append(c);
                stack.pop();
                continue;
            }
            builder.append(c);
        }
        while (!stack.isEmpty()) {
            builder.deleteCharAt((Integer)stack.pop());
        }
        return builder.toString();
    }

    public static List<String> dealFunction(String key) {
        ArrayList<String> result = new ArrayList<String>();
        if (CheckPointUtils.hasFunction(key)) {
            String[] split;
            String s = key.substring(key.indexOf("(") + 1, key.lastIndexOf(")"));
            for (String s1 : split = s.split(",")) {
                if (CheckPointUtils.isNumeric(s1)) continue;
                result.add(s1);
            }
        }
        return result;
    }

    public static boolean isNumeric(String str) {
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean hasFunction(String expr) {
        boolean hasFun = false;
        for (String functionName : CustomerFunction.funtionReg.keySet()) {
            if (!expr.toLowerCase().contains(functionName.toLowerCase() + "(")) continue;
            hasFun = true;
            break;
        }
        return hasFun;
    }

    public static List<BigDecimal> getListForCalculate(DataInfo args, String columnNames) {
        if (args == null) {
            return null;
        }
        ArrayList<BigDecimal> newList = new ArrayList<BigDecimal>();
        List<TableModelInfo> data = null;
        if (ModelTypeEnum.Table.equals((Object)args.getType())) {
            data = args.getTableModels();
        }
        if (data != null) {
            int len = data.size();
            for (int i = 0; i < len; ++i) {
                TableModelInfo info = data.get(i);
                Map<String, Object> cv = info.getCv();
                if (!cv.containsKey(columnNames) || !CheckPointUtils.isNumeric(String.valueOf(cv.get(columnNames)))) continue;
                newList.add(new BigDecimal(String.valueOf(cv.get(columnNames))));
            }
        } else {
            List<FieldModelInfo> fieldModels = args.getFieldModels();
            for (int i = 0; i < fieldModels.size(); ++i) {
                FieldModelInfo info = fieldModels.get(i);
                if (!info.getF().equals(columnNames)) continue;
                if (!CheckPointUtils.isNumeric(String.valueOf(info.getV()))) break;
                newList.add(new BigDecimal(String.valueOf(info.getV())));
                break;
            }
        }
        return newList;
    }

    public static boolean isSmartWorkMode(Context ctx, String jobId) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)jobId, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("shareCenterID.id");
        selector.add("bussAttrID.id");
        selector.add("bussAttrID.isSmartWorkMode");
        JobInfo jobInfo = JobFactory.getLocalInstance(ctx).getJobInfo(H.PK(jobId), selector);
        FilterInfo extFilter = new FilterInfo();
        extFilter.getFilterItems().add(new FilterItemInfo("bussId.id", (Object)jobInfo.getBussAttrID().getId().toString(), CompareType.EQUALS));
        extFilter.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)jobInfo.getShareCenterID().getId().toString(), CompareType.EQUALS));
        if (BussinessAttributeExtFactory.getLocalInstance(ctx).exists(extFilter)) {
            EntityViewInfo extViewInfo = new EntityViewInfo();
            extViewInfo.setFilter(extFilter);
            BussinessAttributeExtCollection bussExtColl = BussinessAttributeExtFactory.getLocalInstance(ctx).getBussinessAttributeExtCollection(extViewInfo);
            return bussExtColl.get(0).isIsSmartWorkMode();
        }
        return jobInfo.getBussAttrID().isIsSmartWorkMode();
    }

    public static DataInfo genFieldModelDataInfo(String field, Object value) {
        DataInfo info = new DataInfo();
        FieldModelInfo f1 = new FieldModelInfo();
        f1.setF(field);
        f1.setV(value);
        ArrayList<FieldModelInfo> fieldModelInfos = new ArrayList<FieldModelInfo>();
        fieldModelInfos.add(f1);
        info.setFieldModels(fieldModelInfos);
        info.setType(ModelTypeEnum.Field);
        info.setExpr(field);
        return info;
    }

    public static int compareObject(Object o1, Object o2) {
        if (CheckPointUtils.isNumeric(String.valueOf(o1)) && CheckPointUtils.isNumeric(String.valueOf(o2))) {
            return CheckPointUtils.compareBigDecimal(new BigDecimal(String.valueOf(o1)), new BigDecimal(String.valueOf(o2)));
        }
        if (SSCCompareUtils.isDataNumber(String.valueOf(o1)) || SSCCompareUtils.isDataNumber(String.valueOf(o2))) {
            return CheckPointUtils.compareLong(CheckPointUtils.parseStringToLong(String.valueOf(o1)), CheckPointUtils.parseStringToLong(String.valueOf(o2)));
        }
        String o11 = "";
        o11 = CheckPointUtils.isNumeric(String.valueOf(o1)) ? new BigDecimal(String.valueOf(o1)).stripTrailingZeros().toPlainString() : String.valueOf(o1);
        String o21 = "";
        o21 = CheckPointUtils.isNumeric(String.valueOf(o2)) ? new BigDecimal(String.valueOf(o2)).stripTrailingZeros().toPlainString() : String.valueOf(o2);
        return CheckPointUtils.compareString(o11, o21);
    }

    private static int compareString(String s1, String s2) {
        return s1.compareTo(s2);
    }

    private static int compareBigDecimal(BigDecimal b1, BigDecimal b2) {
        return b1.compareTo(b2);
    }

    private static int compareLong(Long b1, Long b2) {
        return b1.compareTo(b2);
    }

    private static long parseStringToLong(String dateStr) {
        if ((dateStr = dateStr.trim()).length() == 10) {
            try {
                Calendar cal = Calendar.getInstance();
                cal.set(Integer.parseInt(dateStr.substring(0, 4)), Integer.parseInt(dateStr.substring(5, 7)) - 1, Integer.parseInt(dateStr.substring(8, 10)), 0, 0, 0);
                cal.set(14, 0);
                return cal.getTime().getTime();
            }
            catch (Exception e) {
                return 0L;
            }
        }
        if (dateStr.length() > 10) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                return sdf.parse(dateStr).getTime();
            }
            catch (Exception e) {
                logger.error((Object)("\u89e3\u6790\u65e5\u671f\u683c\u5f0f\u6709\u95ee\u9898\uff1a" + dateStr));
                return 0L;
            }
        }
        try {
            return Long.parseLong(dateStr);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static Map<String, IntelligentDataShowCfgFieldEntryCollection> getIntelligentDataShowCfgFieldEntryCollection(Context ctx, IntelligentDataShowCfgCollection iapColl, boolean forWeb) throws BOSException {
        HashMap<String, IntelligentDataShowCfgFieldEntryCollection> fieldEntryCollectionMap = new HashMap<String, IntelligentDataShowCfgFieldEntryCollection>();
        if (iapColl == null || iapColl.isEmpty()) {
            return fieldEntryCollectionMap;
        }
        IntelligentDataShowCfgFieldEntryCollection fieldEntryCollection = IntelligentDataShowCfgFieldEntryFactory.getLocalInstance(ctx).getIntelligentDataShowCfgFieldEntryCollection("select entryName,displayName,fieldAlias,filed,seq,showType,parentID.id,parentID.tableTitle,id where parentID in " + FormatUtils.coreBaseCollection2Sql((IObjectCollection)iapColl, "id") + " ");
        IntelligentDSCFiledSeqEntryCollection seqEntryCollection = IntelligentDSCFiledSeqEntryFactory.getLocalInstance(ctx).getIntelligentDSCFiledSeqEntryCollection("select entryName,showType,seq,parentID.id,displayName,fieldAlias,id where parentID in " + FormatUtils.coreBaseCollection2Sql((IObjectCollection)iapColl, "id") + " order by seq");
        HashMap<String, Integer> columnSeq = new HashMap<String, Integer>(seqEntryCollection.size());
        int len = seqEntryCollection.size();
        for (int i = 0; i < len; ++i) {
            IntelligentDSCFiledSeqEntryInfo seqEntryInfo = seqEntryCollection.get(i);
            columnSeq.put(seqEntryInfo.getParentID().getId().toString() + seqEntryInfo.getEntryName() + seqEntryInfo.getFieldAlias(), seqEntryInfo.getSeq());
        }
        int len1 = fieldEntryCollection.size();
        for (int j = 0; j < len1; ++j) {
            int i;
            String[] fields;
            String columnNames;
            IntelligentDataShowCfgFieldEntryInfo fieldEntryInfo = fieldEntryCollection.get(j);
            String key = fieldEntryInfo.getParentID().getId().toString();
            if (!fieldEntryCollectionMap.containsKey(key)) {
                fieldEntryCollectionMap.put(key, new IntelligentDataShowCfgFieldEntryCollection());
            }
            String fieldAlias = fieldEntryInfo.getFieldAlias();
            if (forWeb && CheckPointUtils.hasFunction(fieldAlias)) {
                columnNames = fieldAlias.substring(fieldAlias.indexOf("(") + 1, fieldAlias.lastIndexOf(")"));
                fields = columnNames.split(",");
                String[] names = fieldEntryInfo.getDisplayName().split(",");
                for (i = 0; i < fields.length; ++i) {
                    IntelligentDataShowCfgFieldEntryInfo new_fieldEntryInfo = (IntelligentDataShowCfgFieldEntryInfo)fieldEntryInfo.clone();
                    new_fieldEntryInfo.setSeq(columnSeq.get(key + fieldEntryInfo.getEntryName() + fields[i]) == null ? 9999 : (Integer)columnSeq.get(key + fieldEntryInfo.getEntryName() + fields[i]));
                    new_fieldEntryInfo.setDisplayName(names.length > i ? names[i] : "");
                    new_fieldEntryInfo.setFieldAlias(fields[i]);
                    new_fieldEntryInfo.put("oldFieldAlias-app", fieldAlias);
                    new_fieldEntryInfo.put("t-app", fieldEntryInfo.getParentID().getTableTitle());
                    new_fieldEntryInfo.setId(BOSUuid.create((String)"149720C3"));
                    ((IntelligentDataShowCfgFieldEntryCollection)((Object)fieldEntryCollectionMap.get(key))).add(new_fieldEntryInfo);
                }
                continue;
            }
            if (CheckPointUtils.hasFunction(fieldAlias)) {
                columnNames = fieldAlias.substring(fieldAlias.indexOf("(") + 1, fieldAlias.lastIndexOf(")"));
                fields = new String[]{fieldAlias};
                for (int k = 0; k < Constant.SEQFUNCNAMES.length; ++k) {
                    if (fieldAlias.indexOf(Constant.SEQFUNCNAMES[k]) <= -1) continue;
                    fields = columnNames.split(",");
                    break;
                }
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < fields.length; ++i) {
                    sb.append(columnSeq.get(key + fieldEntryInfo.getEntryName() + fields[i]) == null ? Integer.valueOf(9999) : columnSeq.get(key + fieldEntryInfo.getEntryName() + fields[i]) + ",");
                }
                sb.setCharAt(sb.length() - 1, ' ');
                fieldEntryInfo.put("s-app", sb.toString());
            } else {
                fieldEntryInfo.setSeq(columnSeq.get(key + fieldEntryInfo.getEntryName() + fieldAlias) == null ? 9999 : (Integer)columnSeq.get(key + fieldEntryInfo.getEntryName() + fieldAlias));
            }
            fieldEntryInfo.put("oldFieldAlias-app", fieldAlias);
            fieldEntryInfo.put("t-app", fieldEntryInfo.getParentID().getTableTitle());
            ((IntelligentDataShowCfgFieldEntryCollection)((Object)fieldEntryCollectionMap.get(key))).add(fieldEntryInfo);
        }
        for (Map.Entry entry : fieldEntryCollectionMap.entrySet()) {
            IntelligentDataShowCfgFieldEntryCollection value = (IntelligentDataShowCfgFieldEntryCollection)((Object)entry.getValue());
            if (value.size() > 0) {
                value.sort("seq");
            }
            fieldEntryCollectionMap.put((String)entry.getKey(), value);
        }
        return fieldEntryCollectionMap;
    }

    public static Map<String, IntelligentDataShowCfgRelationEntryCollection> getIntelligentDataShowCfgRelationEntryCollection(Context ctx, IntelligentDataShowCfgCollection iapColl) throws BOSException {
        HashMap<String, IntelligentDataShowCfgRelationEntryCollection> relationEntryCollectionMap = new HashMap<String, IntelligentDataShowCfgRelationEntryCollection>();
        if (iapColl == null || iapColl.isEmpty()) {
            return relationEntryCollectionMap;
        }
        IntelligentDataShowCfgRelationEntryCollection relationEntryCollection = IntelligentDataShowCfgRelationEntryFactory.getLocalInstance(ctx).getIntelligentDataShowCfgRelationEntryCollection("select * where parentID in " + FormatUtils.coreBaseCollection2Sql((IObjectCollection)iapColl, "id") + "");
        int len = relationEntryCollection.size();
        for (int i = 0; i < len; ++i) {
            IntelligentDataShowCfgRelationEntryInfo relationEntryInfo = relationEntryCollection.get(i);
            String key = relationEntryInfo.getParentID().getId().toString();
            if (!relationEntryCollectionMap.containsKey(key)) {
                relationEntryCollectionMap.put(key, new IntelligentDataShowCfgRelationEntryCollection());
            }
            ((IntelligentDataShowCfgRelationEntryCollection)((Object)relationEntryCollectionMap.get(key))).add(relationEntryInfo);
        }
        return relationEntryCollectionMap;
    }

    public static IObjectValue filterObjectValueEntry(Context ctx, IObjectValue billValue, CheckpointEntryFilterCollection entryFilters) {
        if (entryFilters == null || billValue == null) {
            return billValue;
        }
        IObjectValue billValue_new = null;
        try {
            billValue_new = (IObjectValue)ObjectUtils.createCopy((Object)billValue);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (billValue_new == null) {
            return billValue;
        }
        HashMap<String, StringBuilder> entryFilterMap = new HashMap<String, StringBuilder>();
        HashMap<String, List> entryColumnMap = new HashMap<String, List>();
        int len = entryFilters.size();
        for (int i = 0; i < len; ++i) {
            CheckpointEntryFilterInfo entryFilterInfo = entryFilters.get(i);
            Matcher matcher = CompareManager.pattern1.matcher(entryFilterInfo.getCompareField());
            if (!matcher.find()) continue;
            String column = matcher.group(1);
            String key = column.substring(0, column.indexOf("."));
            if (!entryFilterMap.containsKey(key)) {
                entryFilterMap.put(key, new StringBuilder());
                entryColumnMap.put(key, new ArrayList());
            }
            StringBuilder expr = (StringBuilder)entryFilterMap.get(key);
            expr.append((org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entryFilterInfo.getLeftBracket()) ? "" : entryFilterInfo.getLeftBracket()) + " " + CheckPointUtils.formatAviatorByCompareType(entryFilterInfo.getCompareField().replace(".", "").replace("{$", "").replace("}", ""), entryFilterInfo.getCompare(), entryFilterInfo.getCompareValue()) + " " + (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entryFilterInfo.getLogic()) ? "" : entryFilterInfo.getLogic()) + " " + (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entryFilterInfo.getRightBracket()) ? "" : entryFilterInfo.getRightBracket()));
            entryFilterMap.put(key, expr);
            List columnList = (List)entryColumnMap.get(key);
            columnList.add(entryFilterInfo.getCompareField());
            entryColumnMap.put(key, columnList);
        }
        Expression compile = null;
        for (Map.Entry entry : entryFilterMap.entrySet()) {
            String expr = ((StringBuilder)entry.getValue()).toString();
            compile = AviatorEvaluator.compile((String)expr);
            Object objectValue = billValue_new.get((String)entry.getKey());
            List<Map<String, Object>> collectionValue = CheckPointUtils.getCollectionValue(ctx, objectValue, (List)entryColumnMap.get(entry.getKey()));
            ArrayList<String> ids = new ArrayList<String>();
            for (int i = 0; i < collectionValue.size(); ++i) {
                Boolean result = (Boolean)compile.execute(collectionValue.get(i));
                if (!result.booleanValue()) continue;
                ids.add(collectionValue.get(i).get("id").toString());
            }
            if (!(objectValue instanceof IObjectCollection)) continue;
            IObjectCollection coll = (IObjectCollection)objectValue;
            for (int j = coll.size() - 1; j >= 0; --j) {
                IObjectValue objValue = coll.getObject(j);
                if (ids.contains(objValue.get("id").toString())) continue;
                coll.removeObject(j);
            }
        }
        return billValue_new;
    }

    public static void filterSqlEntry(Context ctx, RuleEntryInfo ruleEntryInfo) throws BOSException {
        CheckpointEntryFilterCollection entryFilters = ruleEntryInfo.getCheckpointInfo().getEntryFilters();
        if (entryFilters == null) {
            return;
        }
        SQLInfo sqlInfo = ruleEntryInfo.getSqlInfo();
        List<String> joinList = sqlInfo.getJoinList();
        StringBuilder entryFilterItem = sqlInfo.getEntryFilterItem();
        Map<String, Boolean> entryHasData = sqlInfo.getEntryHasData();
        Map<String, StringBuilder> checkpointEntryFilterSql = CheckPointUtils.getCheckpointEntryFilterSql(ctx, ruleEntryInfo, entryFilters);
        for (Map.Entry<String, StringBuilder> sqlItem : checkpointEntryFilterSql.entrySet()) {
            String tableAlias = sqlItem.getKey();
            String fidColumn = "";
            String tableName = ruleEntryInfo.getAliasTableName().get(tableAlias).trim();
            HashSet<String> allTableAlias = new HashSet<String>();
            allTableAlias.add(tableAlias);
            StringBuilder entrySql = new StringBuilder("select distinct " + tableAlias + "." + "FID" + " from " + tableName + " " + tableAlias + " ");
            block1: for (String joinSql : joinList) {
                if (!CheckPointUtils.isIncludeSql(joinSql, allTableAlias)) continue;
                String[] joinSqls = joinSql.split(" on ");
                String[] tables = joinSqls[0].split(" ");
                String entryTableAlias = tables[tables.length - 1];
                if (entryTableAlias.equals(tableAlias)) {
                    String[] columns;
                    for (String column : columns = joinSqls[1].split("=")) {
                        if (!column.contains(entryTableAlias + ".")) continue;
                        fidColumn = column + " = '" + (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ruleEntryInfo.getJobInfo().getSscBillID()) ? ruleEntryInfo.getJobInfo().getBillID() : ruleEntryInfo.getJobInfo().getSscBillID()) + "'";
                        continue block1;
                    }
                    continue;
                }
                entrySql.append(joinSql).append(" ");
                allTableAlias.add(entryTableAlias);
            }
            entrySql.append("where ");
            entrySql.append(fidColumn).append(" and ");
            entrySql.append((CharSequence)sqlItem.getValue());
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)entrySql.toString());
            entryHasData.put(tableAlias, false);
            if (iRowSet.size() <= 0) continue;
            entryHasData.put(tableAlias, true);
            entryFilterItem.append(entryFilterItem.length() > 0 ? "or " : "").append(tableAlias).append(".").append("FID").append(" in (").append((CharSequence)entrySql).append(") ");
        }
    }

    private static boolean isIncludeSql(String sql, Set<String> name) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sql)) {
            return false;
        }
        for (String s : name) {
            if (!sql.contains(s)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static IRowSet filterRowSetEntry(Context ctx, IRowSet rowSet, RuleEntryInfo ruleEntryInfo) {
        JdbcRowSet newRowSet;
        CheckpointEntryFilterCollection entryFilters = ruleEntryInfo.getCheckpointInfo().getEntryFilters();
        if (entryFilters == null) {
            return rowSet;
        }
        Map<String, StringBuilder> checkpointEntryFilterSql = CheckPointUtils.getCheckpointEntryFilterSql(ctx, ruleEntryInfo, entryFilters);
        StringBuilder exprBuilder = new StringBuilder();
        for (Map.Entry<String, StringBuilder> sql : checkpointEntryFilterSql.entrySet()) {
            exprBuilder.append(" ( " + sql.getValue() + " ) or");
        }
        String expr = exprBuilder.substring(0, exprBuilder.length() - 2);
        Map<String, String> formulaColumn = ruleEntryInfo.getFormulaColumn();
        HashSet<String> columns = new HashSet<String>();
        int len = entryFilters.size();
        for (int i = 0; i < len; ++i) {
            CheckpointEntryFilterInfo filterInfo = entryFilters.get(i);
            String column = formulaColumn.get(filterInfo.getCompareFieldAlias());
            columns.add(column);
        }
        SQLInfo sqlInfo = ruleEntryInfo.getSqlInfo();
        StringBuilder selectItem = sqlInfo.getSelectItem();
        String[] selects = selectItem.toString().split(",");
        try {
            newRowSet = new JdbcRowSet();
            Expression compile = null;
            while (rowSet.next()) {
                HashMap<String, Object> exprParam = new HashMap<String, Object>();
                block5: for (String column : columns) {
                    for (int i = 0; i < selects.length; ++i) {
                        if (!selects[i].trim().equals(column.trim())) continue;
                        exprParam.put(column.replace(".", ""), rowSet.getObject(++i));
                        continue block5;
                    }
                }
                compile = AviatorEvaluator.compile((String)expr);
                Boolean result = (Boolean)compile.execute(exprParam);
                if (!result.booleanValue()) continue;
                newRowSet.populate((ResultSet)rowSet);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return rowSet;
        }
        return newRowSet;
    }

    public static List<Map<String, Object>> getCollectionValue(Context ctx, Object dyValue, List<String> columns) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (dyValue instanceof IObjectCollection) {
            IObjectCollection coll = (IObjectCollection)dyValue;
            for (int j = 0; j < coll.size(); ++j) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                IObjectValue objValue = coll.getObject(j);
                for (String column : columns) {
                    dyValue = CheckPointUtils.getValue(ctx, objValue, CheckPointUtils.removeStringArrFrist(column.replace("{$", "").replace("}", "").split("\\.")));
                    map.put(column.replace(".", "").replace("{$", "").replace("}", ""), dyValue);
                }
                map.put("id", objValue.get("id").toString());
                result.add(map);
            }
        }
        return result;
    }

    public static String formatAviatorByCompareType(String field, String comparetype, String value) {
        boolean isDate = SSCCompareUtils.isDataNumber(value);
        StringBuilder result = new StringBuilder();
        if ("is_null".equals(comparetype)) {
            result.append(" " + field + " == nil ");
            return result.toString();
        }
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        if ("==".equals(comparetype)) {
            result.append(" " + field + " == '" + value + "'");
        } else if ("!=".equals(comparetype)) {
            result.append(" " + field + " != '" + value + "'");
        } else if (">".equals(comparetype)) {
            if (isDate) {
                result.append(" " + field + " > '" + value + "'");
            } else {
                result.append(" " + field + " > " + value);
            }
        } else if ("<".equals(comparetype)) {
            if (isDate) {
                result.append(" " + field + " < '" + value + "'");
            } else {
                result.append(" " + field + " < " + value);
            }
        } else if (">=".equals(comparetype)) {
            result.append(" " + field + " >= " + value);
        } else if ("<=".equals(comparetype)) {
            result.append(" " + field + " <= " + value);
        } else if ("like".equals(comparetype)) {
            result.append(" string.contains(" + field + ", '" + value + "') ");
        } else if ("not_like".equals(comparetype) || "not_like".equals(comparetype)) {
            result.append(" !string.contains(" + field + ", '" + value + "') ");
        } else if ("leftLike".equals(comparetype)) {
            result.append(" string.startsWith(" + field + ", '" + value + "') ");
        } else if ("not_leftLike".equals(comparetype)) {
            result.append(" !string.startsWith(" + field + ", '" + value + "') ");
        } else if ("rightLike".equals(comparetype)) {
            result.append(" string.endsWith(" + field + ", '" + value + "') ");
        } else if ("is_not_null".equals(comparetype)) {
            result.append(" " + field + " != nil ");
        }
        result.append(" ");
        return result.toString();
    }

    public static Object getValue(Context ctx, Object dyValue, String[] keys) {
        String key = keys[0];
        try {
            Class<?> cls = dyValue.getClass();
            Method method = cls.getMethod("get", String.class);
            dyValue = method.invoke(dyValue, key);
            if (dyValue instanceof Enum) {
                cls = dyValue.getClass();
                method = cls.getMethod("getValue", new Class[0]);
                dyValue = method.invoke(dyValue, new Object[0]);
            } else {
                if (dyValue instanceof Timestamp) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    return format.format(dyValue);
                }
                if (dyValue instanceof Date) {
                    long time = ((Date)dyValue).getTime();
                    java.util.Date date = new java.util.Date();
                    date.setTime(time);
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    return format.format(dyValue);
                }
                if (dyValue instanceof IObjectCollection) {
                    IObjectCollection coll = (IObjectCollection)dyValue;
                    String[] strArr = CheckPointUtils.removeStringArrFrist(keys);
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    for (int j = 0; j < coll.size(); ++j) {
                        IObjectValue objValue = coll.getObject(j);
                        dyValue = CheckPointUtils.getValue(ctx, objValue, strArr);
                        map.put(null == objValue.get("id") ? Integer.valueOf(j) : objValue.get("id").toString(), dyValue);
                    }
                    return map;
                }
                if (dyValue instanceof IObjectValue) {
                    String[] strArr = CheckPointUtils.removeStringArrFrist(keys);
                    dyValue = CheckPointUtils.getValue(ctx, dyValue, strArr);
                } else if (dyValue instanceof BigDecimal) {
                    dyValue = ((BigDecimal)dyValue).stripTrailingZeros();
                } else if (dyValue instanceof Long) {
                    dyValue = new BigDecimal((Long)dyValue).stripTrailingZeros();
                } else if (dyValue instanceof Double) {
                    dyValue = new BigDecimal(Double.toString((Double)dyValue)).stripTrailingZeros();
                } else if (dyValue instanceof String) {
                    dyValue = ((String)dyValue).trim();
                }
            }
        }
        catch (Exception e) {
            dyValue = null;
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return dyValue;
    }

    private static String[] removeStringArrFrist(String[] keys) {
        String[] arrNew = new String[keys.length - 1];
        for (int i = 1; i < keys.length; ++i) {
            arrNew[i - 1] = keys[i];
        }
        return arrNew;
    }

    public static Map<String, StringBuilder> getCheckpointEntryFilterSql(Context ctx, RuleEntryInfo ruleEntryInfo, CheckpointEntryFilterCollection entryFilters) {
        HashMap<String, StringBuilder> result = new HashMap<String, StringBuilder>();
        if (entryFilters == null || entryFilters.size() == 0) {
            return result;
        }
        Map<String, String> formulaColumn = ruleEntryInfo.getFormulaColumn();
        int len = entryFilters.size();
        for (int i = 0; i < len; ++i) {
            CheckpointEntryFilterInfo filterInfo = entryFilters.get(i);
            String column = formulaColumn.get(filterInfo.getCompareFieldAlias());
            String[] columns = column.split("\\.");
            String alias = columns[0].substring(0, columns[0].indexOf("XX") + 2);
            if (!result.containsKey(alias)) {
                result.put(alias, new StringBuilder());
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)filterInfo.getLeftBracket())) {
                ((StringBuilder)result.get(alias)).append(" " + filterInfo.getLeftBracket());
            }
            ((StringBuilder)result.get(alias)).append(" " + column);
            ((StringBuilder)result.get(alias)).append(" " + DataSetUtils.formatWhereSqlByCompareType(filterInfo.getCompare(), filterInfo.getCompareValue()));
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)filterInfo.getRightBracket())) {
                ((StringBuilder)result.get(alias)).append(" " + filterInfo.getRightBracket());
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)filterInfo.getLogic())) {
                if ("||".equals(filterInfo.getLogic().trim())) {
                    ((StringBuilder)result.get(alias)).append("  or ");
                } else {
                    ((StringBuilder)result.get(alias)).append("  and ");
                }
            }
            ((StringBuilder)result.get(alias)).append(" ");
        }
        return result;
    }

    public static boolean inArray(String[] arr, String value) {
        if (arr == null || value == null) {
            return false;
        }
        for (String s : arr) {
            if (!s.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, IntelligentDataShowCfgCollection> getIntelligentDataShowCfgCollectionByCheckpointId(Context ctx, List<String> checkPointIds) throws BOSException {
        return CheckPointUtils.getIntelligentDataShowCfgCollectionByCheckpointId(ctx, checkPointIds, false);
    }

    public static Map<String, IntelligentDataShowCfgCollection> getIntelligentDataShowCfgCollectionByCheckpointId(Context ctx, List<String> checkPointIds, boolean forWeb) throws BOSException {
        HashMap<String, IntelligentDataShowCfgCollection> checkDetail_dataShowCfg_Map = new HashMap<String, IntelligentDataShowCfgCollection>(checkPointIds.size());
        IntelligentDataShowCfgCollection showCfgCollections = IntelligentDataShowCfgFactory.getLocalInstance(ctx).getIntelligentDataShowCfgCollection("select id,tableTitle,seq,parentID.id where parentID.id in " + FormatUtils.list2Sql(checkPointIds) + " order by seq");
        Map<String, IntelligentDataShowCfgFieldEntryCollection> fieldEntryCollection = CheckPointUtils.getIntelligentDataShowCfgFieldEntryCollection(ctx, showCfgCollections, forWeb);
        Map<String, IntelligentDataShowCfgRelationEntryCollection> relationEntryCollection = CheckPointUtils.getIntelligentDataShowCfgRelationEntryCollection(ctx, showCfgCollections);
        int len2 = showCfgCollections.size();
        for (int k = 0; k < len2; ++k) {
            IntelligentDataShowCfgInfo dataShowCfgInfo = showCfgCollections.get(k);
            dataShowCfgInfo.put("filedentry-app", (Object)fieldEntryCollection.get(dataShowCfgInfo.getId().toString()));
            dataShowCfgInfo.put("relationentry-app", (Object)relationEntryCollection.get(dataShowCfgInfo.getId().toString()));
            String checkPointId = dataShowCfgInfo.getParentID().getId().toString();
            if (!checkDetail_dataShowCfg_Map.containsKey(checkPointId)) {
                checkDetail_dataShowCfg_Map.put(checkPointId, new IntelligentDataShowCfgCollection());
            }
            ((IntelligentDataShowCfgCollection)((Object)checkDetail_dataShowCfg_Map.get(checkPointId))).add(dataShowCfgInfo);
        }
        return checkDetail_dataShowCfg_Map;
    }

    public static IObjectValue getBillValue(Context ctx, IntelligentAuditCheckpointCollection colls, JobInfo jobInfo) throws BOSException {
        if (colls == null) {
            return null;
        }
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        String billID = jobInfo.getBillID() != null ? jobInfo.getBillID() : jobInfo.getSscBillID();
        ObjectUuidPK uuidPK = new ObjectUuidPK(billID);
        String bosType = uuidPK.getObjectType().toString();
        BOSObjectType type = BOSObjectType.create((String)bosType);
        int len1 = colls.size();
        for (int k = 0; k < len1; ++k) {
            CheckpointEntryFilterCollection entryFilters;
            IntelligentDataShowCfgCollection showCfgCollection;
            String entityColumn;
            Matcher matcher;
            IntelligentAuditCheckpointInfo info = colls.get(k);
            IntelligentAuditExecuteRuleEntryCollection executeRuleEntryCollection = info.getExecuteRule();
            if (executeRuleEntryCollection != null && executeRuleEntryCollection.size() > 0) {
                int len = executeRuleEntryCollection.size();
                for (int i = 0; i < len; ++i) {
                    String value;
                    IntelligentAuditExecuteRuleEntryInfo executeRuleEntryInfo = executeRuleEntryCollection.get(i);
                    String field = executeRuleEntryInfo.getCompareFieldEntity();
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)field) && field.contains("{$")) {
                        matcher = CompareManager.pattern1.matcher(field);
                        while (matcher.find()) {
                            String entityColumn2 = matcher.group(1);
                            selectorItemCollection.add(entityColumn2);
                        }
                    }
                    if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(value = executeRuleEntryInfo.getCompareValueEntity())) || !value.contains("{$") || !(matcher = CompareManager.pattern1.matcher(value)).find()) continue;
                    entityColumn = matcher.group(1);
                    selectorItemCollection.add(entityColumn);
                }
            }
            if ((showCfgCollection = info.getShowCfgEntrys()) != null && showCfgCollection.size() > 0) {
                for (int i = 0; i < showCfgCollection.size(); ++i) {
                    IntelligentDataShowCfgInfo entryInfo = showCfgCollection.get(i);
                    IntelligentDataShowCfgFieldEntryCollection showCfgFieldEntry = (IntelligentDataShowCfgFieldEntryCollection)((Object)entryInfo.get("filedentry-app"));
                    for (int j = 0; j < showCfgFieldEntry.size(); ++j) {
                        IntelligentDataShowCfgFieldEntryInfo fieldEntryInfo = showCfgFieldEntry.get(j);
                        if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fieldEntryInfo.getFieldAlias()) || !fieldEntryInfo.getFieldAlias().contains("{$") || !(matcher = CompareManager.pattern1.matcher(fieldEntryInfo.getFieldAlias())).find()) continue;
                        String entityColumn3 = matcher.group(1);
                        selectorItemCollection.add(entityColumn3);
                    }
                }
            }
            if ((entryFilters = info.getEntryFilters()) == null || entryFilters.size() <= 0) continue;
            int len = entryFilters.size();
            for (int i = 0; i < len; ++i) {
                CheckpointEntryFilterInfo filterInfo = entryFilters.get(i);
                matcher = CompareManager.pattern1.matcher(filterInfo.getCompareField());
                if (!matcher.find()) continue;
                entityColumn = matcher.group(1);
                selectorItemCollection.add(entityColumn);
            }
        }
        IObjectValue billValue = null;
        if (DynamicObjectFactory.getLocalInstance((Context)ctx).exists(type, (IObjectPK)uuidPK)) {
            billValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)new ObjectUuidPK(billID), selectorItemCollection);
        }
        return billValue;
    }

    public static boolean isContainChinese(String str) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static String getAllFirstLetter(String str) {
        if (str == null || str.trim().length() == 0) {
            return "";
        }
        String _str = "";
        for (int i = 0; i < str.length(); ++i) {
            _str = _str + CheckPointUtils.getFirstLetter(str.substring(i, i + 1));
        }
        return _str;
    }

    private static String conversionStr(String str, String charsetName, String toCharsetName) {
        try {
            str = new String(str.getBytes(charsetName), toCharsetName);
        }
        catch (Exception ex) {
            System.out.println("\u5b57\u7b26\u4e32\u7f16\u7801\u8f6c\u6362\u5f02\u5e38\uff1a" + ex.getMessage());
        }
        return str;
    }

    private static String getFirstLetter(String chinese) {
        String sreturn = "";
        if (chinese == null || chinese.trim().length() == 0) {
            return "";
        }
        if ((chinese = CheckPointUtils.conversionStr(chinese, "GB2312", "ISO8859-1")).length() > 1) {
            char li_PositionCode_s;
            int li_PositionCode;
            char li_SectorCode_s = chinese.charAt(0);
            int li_SectorCode = li_SectorCode_s - 160;
            int li_SecPosCode = li_SectorCode * 100 + (li_PositionCode = (li_PositionCode_s = chinese.charAt(1)) - 160);
            if (li_SecPosCode > 1600 && li_SecPosCode < 5590) {
                for (int i = 0; i < 23; ++i) {
                    if (li_SecPosCode < li_SecPosValue[i] || li_SecPosCode >= li_SecPosValue[i + 1]) continue;
                    sreturn = lc_FirstLetter[i];
                    break;
                }
            } else {
                int ioffset = (li_SectorCode - 56) * 94 + li_PositionCode - 1;
                if (ioffset >= 0 && ioffset <= 3007) {
                    sreturn = ls_SecondSecTable.substring(ioffset, ioffset + 1);
                }
            }
        } else {
            sreturn = chinese;
        }
        return sreturn;
    }
}

