/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssccommon.utils.httputils;

import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpGetUtil {
    private static Logger logger = Logger.getLogger(HttpGetUtil.class);

    public static String getInterface(String url, boolean outPutLog) throws Exception {
        return HttpGetUtil.getInterface(url, null, outPutLog);
    }

    public static String getInterface(String url, Map<String, String> header, boolean outPutLog) throws Exception {
        if (outPutLog) {
            logger.error((Object)("url[" + url + "]--header[" + header + "]"));
        } else {
            logger.debug((Object)("url[" + url + "]--header[" + header + "]"));
        }
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Accept", "application/json");
        httpGet.setHeader("Content-Type", "application/json");
        if (header != null) {
            for (String key : header.keySet()) {
                httpGet.setHeader(key, header.get(key));
            }
        }
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpGet);
            StatusLine status = response.getStatusLine();
            int state = status.getStatusCode();
            if (state == 200) {
                HttpEntity responseEntity = response.getEntity();
                String jsonString = EntityUtils.toString((HttpEntity)responseEntity);
                if (outPutLog) {
                    logger.error((Object)("response--state:" + state + ",response--jsonString:" + jsonString));
                } else {
                    logger.debug((Object)("response--state:" + state + ",response--jsonString:" + jsonString));
                }
                String string = jsonString;
                return string;
            }
            try {
                throw new Exception("URL:" + url + ";HttpStatusCode:" + status.toString());
            }
            catch (IOException e) {
                throw new Exception(e);
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }
}

