/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.shrssc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.base.shrssc.ShrTaskOperation;
import com.kingdee.eas.base.shrssc.ShrTaskOperationException;
import com.kingdee.eas.base.shrssc.ShrTaskOperationFactory;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.base.ssc.tool.XMLUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShrTaskOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ShrTaskOperationHandler.class);

    public String operation(Context ctx, String action, Map<String, Object> params) throws BOSException, EASBizException {
        String userId;
        String retStr = null;
        if (params == null) {
            throw new ShrTaskOperationException(ShrTaskOperationException.PARAMS_IS_NULL);
        }
        if (params != null && !StringUtils.isEmpty((String)((String)params.get("userNumber")))) {
            try {
                this.paramsConvert(ctx, params);
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage());
            }
        }
        String string = userId = params.get("userId") == null ? null : (String)params.get("userId");
        if (!StringUtils.isEmpty((String)userId)) {
            String shareCenterId = params.get("shareCenterId") == null ? null : (String)params.get("shareCenterId");
            userId = ShareCenterUtils.getUserIdByErpUserId((Context)ctx, (String)userId);
            try {
                shareCenterId = ShareCenterUtils.getShareCenterIdBySSCUserId((Context)ctx, (String)userId);
            }
            catch (Exception e) {
                logger.error("*******\u6839\u636euserId\u83b7\u53d6shareCenterId\u5931\u8d25*******");
            }
            params.put("userId", userId);
            params.put("shareCenterId", shareCenterId);
        }
        if (!StringUtils.isEmpty((String)userId)) {
            try {
                UserFactory.getLocalInstance((Context)ctx).onTheJob(JSONUtils.convertObjectToJson((Context)ctx, params));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            action = action.toUpperCase();
            ShrTaskOperation taskOperation = ShrTaskOperationFactory.getInstance(action);
            Object retObj = taskOperation.operation(ctx, params);
            if (retObj == null) {
                retStr = XMLUtils.SUCCESS((String)"");
            } else if (retObj instanceof Boolean) {
                retStr = ((Boolean)retObj).booleanValue() ? XMLUtils.SUCCESS((String)"true") : XMLUtils.SUCCESS((String)"false");
            } else if (retObj instanceof Map) {
                Map retMap = (Map)retObj;
                Object suObj = retMap.get("success");
                if (suObj == null) {
                    retStr = XMLUtils.SUCCESS((String)JSONUtils.convertObjectToJson((Context)ctx, (Object)retObj));
                } else if ("false".equalsIgnoreCase(suObj.toString())) {
                    logger.error("==== com.kingdee.eas.base.shrssc.ShrTaskOperationHandler error 1: " + suObj.toString());
                    retStr = XMLUtils.ERROR((String)JSONUtils.convertObjectToJson((Context)ctx, (Object)retObj));
                } else {
                    retStr = XMLUtils.SUCCESS((String)JSONUtils.convertObjectToJson((Context)ctx, (Object)retObj));
                }
            } else {
                retStr = XMLUtils.SUCCESS((String)JSONUtils.convertObjectToJson((Context)ctx, (Object)retObj));
            }
        }
        catch (Exception e) {
            logger.error("==== com.kingdee.eas.base.shrssc.ShrTaskOperationHandler error 2: " + e.getMessage(), (Throwable)e);
            retStr = XMLUtils.ERROR((String)e.getMessage());
        }
        return retStr;
    }

    protected void paramsConvert(Context ctx, Map<String, Object> params) throws EASBizException, BOSException, SQLException {
        if (!StringUtils.isEmpty((String)((String)params.get("userId")))) {
            return;
        }
        String userNumber = (String)params.get("userNumber");
        String sql = "SELECT FID ,FUSERID ,FEASUSERID FROM t_ssc_user where FISENABLED = 1 AND FNUMBER =? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userNumber});
        String userId = "";
        if (!rs.next()) {
            throw new ShrTaskOperationException(ShrTaskOperationException.USER_NOT_FOUND, new Object[]{userNumber});
        }
        userId = rs.getString(1);
        params.put("userId", userId);
    }
}

