/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.shrssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.shrssc.app.AbstractSHRTaskReportFacadeControllerBean;
import com.kingdee.eas.base.ssc.tool.DateUtil;
import com.kingdee.eas.base.ssc.tool.SSCDbUtil;
import com.kingdee.eas.base.ssc.tool.TaskReportUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHRTaskReportFacadeControllerBean
extends AbstractSHRTaskReportFacadeControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.eas.base.shrssc.app.SHRTaskReportFacadeControllerBean");

    @Override
    protected Map _getOverdueTaskReport(Context ctx, Map param) throws BOSException, EASBizException {
        String shareCenterId = (String)param.get("shareCenter.id");
        if (!shareCenterId.contains("'")) {
            shareCenterId = "'" + shareCenterId + "'";
        }
        String strStartIndex = (String)param.get("startIndex");
        String strRowCount = (String)param.get("rowCount");
        int iStartIndex = 0;
        int iRowCount = 0;
        if (!StringUtils.isEmpty((String)strStartIndex) && !StringUtils.isEmpty((String)strRowCount)) {
            iStartIndex = Integer.parseInt(strStartIndex);
            iRowCount = Integer.parseInt(strRowCount);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList bizList = new ArrayList();
        Object _isAll = param.get("isAll");
        boolean isAll = false;
        if (_isAll != null) {
            isAll = (Boolean)_isAll;
        }
        if (isAll) {
            iStartIndex = 0;
            iRowCount = Integer.MAX_VALUE;
        }
        Map<String, Object> sqlMap = this.getOverdueTaskSql(param);
        String sql = sqlMap.get("sql").toString();
        IRowSet rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql, (Object[])((Object[])sqlMap.get("params")), (int)iStartIndex, (int)iRowCount);
        IRowSet rowSetCount = SSCDbUtil.executeQuery((Context)ctx, (String)TaskReportUtil.getCountSql((String)sql), (Object[])((Object[])sqlMap.get("params")));
        int totalCount = 0;
        try {
            DecimalFormat df = new DecimalFormat("##.00");
            while (rowSet.next()) {
                HashMap<String, String> rec = new HashMap<String, String>();
                rec.put("userName", rowSet.getString("userName"));
                rec.put("handCount", rowSet.getString("handCount"));
                rec.put("overdueCount", null == rowSet.getString("overdueCount") ? "0" : rowSet.getString("overdueCount"));
                rec.put("overduePercent", (null == rowSet.getString("overdueCount") ? "0" : df.format(rowSet.getDouble("overduePercent"))) + "%");
                bizList.add(rec);
            }
            if (rowSetCount != null) {
                while (rowSetCount.next()) {
                    totalCount = rowSetCount.getInt("count");
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        result.put("records", String.valueOf(totalCount));
        result.put("rows", bizList);
        return result;
    }

    private Map<String, Object> getOverdueTaskSql(Map param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> params = new ArrayList<String>();
        String shareCenterId = (String)param.get("shareCenter.id");
        String userId = (String)param.get("userId");
        String startDate = (String)param.get("startDate");
        String endDate = (String)param.get("endDate");
        StringBuilder sb = new StringBuilder("SELECT us.FNAME_L2 userName, count(1) handCount, sum(case when job.FExpireState = 1 then 1 end) overdueCount FROM T_SSC_JobHis job");
        sb.append(" inner join T_SSC_User us on job.FPERSONNELIDID = us.FID");
        if (!StringUtils.isEmpty((String)userId) || !StringUtils.isEmpty((String)shareCenterId)) {
            String[] ids;
            sb.append(" where ");
            boolean isAppendOther = false;
            if (!StringUtils.isEmpty((String)userId)) {
                sb.append("job.FPERSONNELIDID in (");
                for (String id : ids = userId.split(",")) {
                    sb.append("?,");
                    params.add(id.replaceAll("'", ""));
                }
                sb.deleteCharAt(sb.length() - 1).append(")");
                isAppendOther = true;
            }
            if (!StringUtils.isEmpty((String)shareCenterId)) {
                if (isAppendOther) {
                    sb.append(" and ");
                }
                sb.append(" job.FSHARECENTERID in (");
                for (String id : ids = shareCenterId.split(",")) {
                    sb.append("?,");
                    params.add(id.replaceAll("'", ""));
                }
                sb.deleteCharAt(sb.length() - 1).append(")");
            }
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            sb.append(" and job.fcompletetme >=").append(DateUtil.dateToTsDate((String)startDate));
            sb.append(" and job.fcompletetme <=").append(DateUtil.dateToTsDate((String)endDate));
        }
        sb.append(" group by us.FNAME_L2");
        StringBuilder sbu = new StringBuilder("SELECT TT.*,isnull(TT.overdueCount,0)*100.0/TT.handCount as overduePercent from (");
        sbu.append((CharSequence)sb).append(") as TT order by overduePercent desc");
        result.put("sql", sbu.toString());
        int len = params.size();
        Object[] p = new Object[len];
        for (int i = 0; i < len; ++i) {
            p[i] = params.get(i);
        }
        result.put("params", p);
        return result;
    }
}

