/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.shrssc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShrTaskOperationUtil {
    private static final Logger logger = LoggerFactory.getLogger(ShrTaskOperationUtil.class);
    private static final long ONE_DAY_MILLIS = 86400000L;

    public static boolean isManageOrgControl(Context ctx) throws EASBizException, BOSException {
        boolean isManageOrgControl = false;
        String isManageOrgControlStr = ParamManager.getParamValue((Context)ctx, null, (String)"SSC_ManagerOrgControl");
        isManageOrgControl = isManageOrgControlStr.equals("true");
        return isManageOrgControl;
    }

    public static String genTimeSql(String timeStr, boolean isDayBegin) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)timeStr)) {
            return null;
        }
        try {
            Date date = DateTimeUtils.parseDate((String)timeStr, (String)"yyyy-MM-dd");
            String dateStr = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
            if (isDayBegin) {
                return "{ts'" + dateStr + " 00:00:00'}";
            }
            return "{ts'" + dateStr + " 23:59:59'}";
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    public static String genTimeSql(Date time, boolean isDayBegin) {
        if (null == time) {
            return null;
        }
        String dateStr = DateTimeUtils.format((Date)time, (String)"yyyy-MM-dd");
        if (isDayBegin) {
            return "{ts'" + dateStr + " 00:00:00'}";
        }
        return "{ts'" + dateStr + " 23:59:59'}";
    }

    public static String getStrFromArray(String[] strs) {
        StringBuffer sb = new StringBuffer();
        if (strs == null || strs.length == 0) {
            return "('')";
        }
        sb.append("(");
        int size = strs.length;
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append(strs[i]);
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append(strs[i]);
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append(strs[i]);
            sb.append("')");
        }
        return sb.toString();
    }

    public static Date getTimesWeekBegin() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(7, 2);
        return cal.getTime();
    }

    public static Date getTimesWeekEnd() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(ShrTaskOperationUtil.getTimesWeekBegin());
        cal.add(7, 7);
        return cal.getTime();
    }

    public static Date getTimesMonthBegin() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    public static Date getTimesMonthEnd() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 24);
        return cal.getTime();
    }

    public static Date getLastYear(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(1, -1);
        return cal.getTime();
    }

    public static Date getLastWeek(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(5, -7);
        return cal.getTime();
    }

    public static Date getLastMonth(Date d) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String nowDate = sdf.format(d);
        String[] dateArray = nowDate.split("-");
        int day = Integer.parseInt(dateArray[2]);
        int month = Integer.parseInt(dateArray[1]);
        int lastDay = 0;
        lastDay = month == 1 ? 31 : ShrTaskOperationUtil.getLastDay(sdf.parse(dateArray[0] + "-" + (month - 1) + "-01"));
        if (day > lastDay) {
            return null;
        }
        if (month == 1) {
            int year = Integer.parseInt(dateArray[0]);
            return sdf.parse(year - 1 + "-" + 12 + "-" + day);
        }
        return sdf.parse(dateArray[0] + "-" + (month - 1) + "-" + day);
    }

    public static Date addOneDay(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static String formatDate(Context ctx, Date d) throws EASBizException, BOSException {
        HashMap nantionalMap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ctx.getLocale().getDisplayName().toUpperCase());
        SimpleDateFormat format = (SimpleDateFormat)nantionalMap.get("dateFormat");
        TimeZoneInfo timezoneInfo = (TimeZoneInfo)nantionalMap.get("timezoneInfo");
        String timeDiff = ShrTaskOperationUtil.getTimeZoneDiffStringValue(timezoneInfo.getTimeDiff().getValue());
        TimeZone timeZone = TimeZone.getTimeZone(MessageFormat.format("{0}{1}", "GMT", timeDiff));
        SimpleDateFormat sdf = new SimpleDateFormat(format.toPattern());
        String fmt = ((SimpleDateFormat)nantionalMap.get("dateFormat")).toPattern();
        return DateTimeUtils.format((Date)d, (String)fmt, (TimeZone)timeZone, (Locale)ctx.getLocale());
    }

    public static String formatDate(Context ctx, String d, int index) throws EASBizException, BOSException, ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (index == 1) {
            return ShrTaskOperationUtil.getWeek(sdf.parse(d), ctx.getLocale());
        }
        if (index == 2) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(sdf.parse(d));
            return cal.get(5) + "";
        }
        sdf = new SimpleDateFormat("yyyy-MM");
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdf.parse(d));
        return cal.get(2) + 1 + "";
    }

    public static void assembleDateAxis(int index, List<String> list) {
        block9: {
            int year;
            block10: {
                LocalDate localDate;
                block8: {
                    localDate = LocalDate.now();
                    year = localDate.getYear();
                    if (index != 1) break block8;
                    LocalDate lastDayOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
                    int lastDayofMonth = lastDayOfMonth.getDayOfMonth();
                    int month = localDate.getMonthValue();
                    int day = localDate.getDayOfMonth();
                    for (int i = 1; i <= 7; ++i) {
                        String d;
                        String m;
                        if (day > lastDayofMonth) {
                            day = 1;
                            if (++month > 12) {
                                month = 1;
                                m = null;
                                d = null;
                                m = month < 10 ? "0" + month : "" + month;
                                d = day < 10 ? "0" + day : "" + day;
                                list.add(++year + "-" + m + "-" + d);
                            } else {
                                m = null;
                                d = null;
                                m = month < 10 ? "0" + month : "" + month;
                                d = day < 10 ? "0" + day : "" + day;
                                list.add(year + "-" + m + "-" + d);
                            }
                        } else {
                            m = null;
                            d = null;
                            m = month < 10 ? "0" + month : "" + month;
                            d = day < 10 ? "0" + day : "" + day;
                            list.add(year + "-" + m + "-" + d);
                        }
                        ++day;
                    }
                    break block9;
                }
                if (index != 2) break block10;
                LocalDate lastDayOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
                int day = lastDayOfMonth.getDayOfMonth();
                int month = localDate.getMonthValue();
                String m = null;
                m = month < 10 ? "0" + month : "" + month;
                for (int i = 1; i <= day; ++i) {
                    String d = "";
                    d = i < 10 ? "0" + i : "" + i;
                    list.add(year + "-" + m + "-" + d);
                }
                break block9;
            }
            if (index != 3) break block9;
            for (int i = 1; i <= 12; ++i) {
                if (i < 10) {
                    list.add(year + "-0" + i);
                    continue;
                }
                list.add(year + "-" + i);
            }
        }
    }

    public static String getWeek(Date date, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE", locale);
        String week = sdf.format(date);
        return week;
    }

    public static String getTimeZoneDiffStringValue(double diff) {
        String diffValue = String.valueOf(diff);
        if (diffValue.indexOf(".0") != -1) {
            diffValue = diffValue.substring(0, diffValue.indexOf(".0"));
        }
        diffValue = diffValue.replace("-", "");
        if (diff >= 0.0) {
            diffValue = MessageFormat.format("{0}{1}", "+", diffValue);
        } else if (diff < 0.0) {
            diffValue = MessageFormat.format("{0}{1}", "-", diffValue);
        }
        return diffValue;
    }

    public static String getCurPlusDate(int index) {
        Date curPlusDate = new Date(System.currentTimeMillis() - (long)index * 86400000L);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(curPlusDate);
    }

    public static int getLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (null != date) {
            calendar.setTime(date);
        }
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = 0;
        switch (month) {
            case 1: {
                day = 31;
                break;
            }
            case 2: {
                day = year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 29 : 28;
                break;
            }
            case 3: {
                day = 31;
                break;
            }
            case 4: {
                day = 30;
                break;
            }
            case 5: {
                day = 31;
                break;
            }
            case 6: {
                day = 30;
                break;
            }
            case 7: {
                day = 31;
                break;
            }
            case 8: {
                day = 31;
                break;
            }
            case 9: {
                day = 30;
                break;
            }
            case 10: {
                day = 31;
                break;
            }
            case 11: {
                day = 30;
                break;
            }
            case 12: {
                day = 31;
            }
        }
        return day;
    }
}

