/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe;

import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EASCloudEnv {
    private static Logger logger = Logger.getLogger(EASCloudEnv.class);
    private static String EASCLOUD_ENV = "EASCLoudEnv.properties";
    private static volatile EASCloudEnv easCloudEnv = null;
    private boolean isRequireHttps = false;
    private boolean isUseTest = false;

    private EASCloudEnv() {
        this.initEASCLoudEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EASCloudEnv getInstance(boolean refresh) {
        if (easCloudEnv == null) {
            Class<EASCloudEnv> clazz = EASCloudEnv.class;
            synchronized (EASCloudEnv.class) {
                if (easCloudEnv == null) {
                    easCloudEnv = new EASCloudEnv();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else if (refresh) {
            easCloudEnv.initEASCLoudEnv();
        }
        return easCloudEnv;
    }

    public void initEASCLoudEnv() {
        FileInputStream fileInputStream = null;
        try {
            Properties envPro = new Properties();
            fileInputStream = new FileInputStream(EASCloudEnv.getFilePath());
            envPro.load(fileInputStream);
            this.isUseTest = "true".equals((String)envPro.get("isTestEnv"));
            this.isRequireHttps = "true".equals((String)envPro.get("isRequireHttps"));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private static String getFilePath() {
        String filePath = System.getProperty("EAS_HOME");
        if (!StringUtils.isEmpty((String)filePath)) {
            File file = new File(filePath);
            filePath = file.getAbsolutePath() + File.separator + "server" + File.separator + "properties" + File.separator + EASCLOUD_ENV;
        } else {
            filePath = "W:" + File.separator + "eas" + File.separator + "Server" + File.separator + "server" + File.separator + "properties" + File.separator + EASCLOUD_ENV;
        }
        File file2 = new File(filePath);
        if (!file2.exists()) {
            filePath = System.getProperty("easclient.root") + File.separator + "config" + File.separator + EASCLOUD_ENV;
        }
        return filePath;
    }

    public boolean isUseTest() {
        return this.isUseTest;
    }

    public boolean isRequireHttps() {
        return this.isRequireHttps;
    }

    public static void main(String[] args) {
        System.out.println(EasCloud.CLOUD_URL);
    }
}

