/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe;

import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class KsmHelper
implements Serializable {
    private static KsmHelper instance = null;
    private static final String filePath;
    private static final String rootName = "ksm";
    private static final String attrName = "attribute";
    private static final String attrKey = "key";
    private static final String attrValue = "value";
    private static final String attrKsmSuffixName = "urlSuffix";
    private static final String attrKsmUrlName = "url";
    private static final String defaultKsmUrl = "http://easksm.kingdee.com/ksm4eas.action";
    private static final String defaultKsmSuffix = "/ksm4eas.action";
    public static final String ksmUrlKey = "ksmUrl";
    public static final String ksmUrlSuffixKey = "ksmSuffix";
    private Map param;

    private KsmHelper() throws MalformedURLException, DocumentException {
        this.initParam();
    }

    private void initParam() throws MalformedURLException, DocumentException {
        this.param = new HashMap();
        File ksmXmlFile = new File(filePath);
        if (!ksmXmlFile.exists()) {
            this.initDefaultParam();
            return;
        }
        this.getKsmInfoFromXmlFile(ksmXmlFile);
    }

    private void getKsmInfoFromXmlFile(File ksmXmlFile) throws MalformedURLException, DocumentException {
        SAXReader ksmXmlReader = new SAXReader();
        Document ksmDoc = ksmXmlReader.read(ksmXmlFile);
        Element root = ksmDoc.getRootElement();
        Iterator elementIterator = root.elementIterator();
        Element subElement = null;
        String subElementName = null;
        Attribute subElementAttr = null;
        while (elementIterator.hasNext()) {
            subElement = (Element)elementIterator.next();
            subElementAttr = subElement.attribute("name");
            subElementName = subElementAttr.getValue();
            if (!rootName.equals(subElementName)) continue;
            this.parseInfoFromElement(subElement);
            break;
        }
    }

    private void parseInfoFromElement(Element subElement) {
        Iterator subAttrElementIter = subElement.elementIterator(attrName);
        if (subAttrElementIter == null) {
            this.initDefaultParam();
            return;
        }
        Element subAttrElement = null;
        Attribute attrKey = null;
        Attribute attrValue = null;
        while (subAttrElementIter.hasNext()) {
            subAttrElement = (Element)subAttrElementIter.next();
            attrKey = subAttrElement.attribute(attrKey);
            attrValue = subAttrElement.attribute(attrValue);
            if (attrKey == null) continue;
            if (attrKsmSuffixName.equals(attrKey.getValue())) {
                this.param.put(ksmUrlSuffixKey, attrValue.getValue());
                continue;
            }
            if (!attrKsmUrlName.equals(attrKey.getValue())) continue;
            this.param.put(ksmUrlKey, attrValue.getValue());
        }
    }

    private void initDefaultParam() {
        this.param.put(ksmUrlKey, defaultKsmUrl);
        this.param.put(ksmUrlSuffixKey, defaultKsmSuffix);
    }

    public static KsmHelper getInstance() throws MalformedURLException, DocumentException {
        if (instance == null) {
            KsmHelper.createInstance();
        }
        return instance;
    }

    private static synchronized void createInstance() throws MalformedURLException, DocumentException {
        if (instance == null) {
            instance = new KsmHelper();
        }
    }

    public String getKsmAllUrl() {
        return (String)this.param.get(ksmUrlKey);
    }

    static {
        String easPropertiesDir = System.getProperty("eas.properties.dir");
        if (StringUtils.isEmpty((String)easPropertiesDir)) {
            filePath = "";
        } else {
            StringBuffer filePathBuffer = new StringBuffer();
            filePathBuffer.append(easPropertiesDir).append(File.separator).append("ksm.xml");
            filePath = filePathBuffer.toString();
        }
    }
}

