/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.CnToSpell;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class MainMenuGeneratorPinYinHelper {
    protected static Logger logger = Logger.getLogger(MainMenuGeneratorPinYinHelper.class);

    public static void generatePinYin(Connection con) throws BOSException, EASBizException {
        long start = System.currentTimeMillis();
        PreparedStatement querySt = null;
        ResultSet queryRs = null;
        MainMenuItemInfo info = null;
        ArrayList<MainMenuItemInfo> menuList = new ArrayList<MainMenuItemInfo>();
        try {
            String sql = "update t_pm_mainmenuitem set FPinYin = null, FShortPinYin = null";
            querySt = con.prepareStatement(sql);
            querySt.execute();
            sql = "select FName_l2,FId from t_pm_mainmenuitem ";
            querySt = con.prepareStatement(sql);
            queryRs = querySt.executeQuery();
            while (queryRs.next()) {
                info = new MainMenuItemInfo();
                info.setId(BOSUuid.read((String)queryRs.getString("FId")));
                info.setName(queryRs.getString("FName_l2"));
                menuList.add(info);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            SQLUtils.cleanup(queryRs, (Statement)querySt, (Connection)con);
            throw new BOSException((Throwable)e);
        }
        PreparedStatement st = null;
        String tempTable = null;
        try {
            tempTable = MainMenuGeneratorPinYinHelper.getTempTableName("GeneratePinYin");
            String createSql = "create table " + tempTable + " (FId varchar(44),FName NVarchar(255),FPinYin varchar(255),FShortPinYin varchar(255))";
            MainMenuGeneratorPinYinHelper.createTable(con, createSql);
            String insertSql = "insert into " + tempTable + "(FId,FName,FPinYin,FShortPinYin) values(?,?,?,?)";
            st = con.prepareStatement(insertSql);
            String pinYin = "";
            String shortPinYin = "";
            MainMenuItemInfo menu = null;
            String name = "";
            int size = menuList.size();
            for (int i = 0; i < size; ++i) {
                menu = (MainMenuItemInfo)menuList.get(i);
                name = menu.getName();
                pinYin = CnToSpell.getSpell((String)name, (boolean)false);
                shortPinYin = CnToSpell.getSpell((String)name, (boolean)true);
                st.setString(1, menu.getId().toString());
                st.setString(2, name);
                st.setString(3, pinYin);
                st.setString(4, shortPinYin);
                st.addBatch();
                if (i % 2000 != 0) continue;
                st.executeBatch();
            }
            st.executeBatch();
            logger.info((Object)("$$$$$$$$$$$$$$$$$generate pinyin cost:" + (System.currentTimeMillis() - start)));
            start = System.currentTimeMillis();
            String updateSql = "update t_pm_mainmenuitem mmi set FPinYin = ( select FPinYin from " + tempTable + " where FId = mmi.FId) ,FShortPinYin = (select FShortPinYin from " + tempTable + " where FId=mmi.FId)";
            st = con.prepareStatement(updateSql);
            st.execute();
            logger.info((Object)("$$$$$$$$$$$$$$$$$update pinyin cost:" + (System.currentTimeMillis() - start)));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            SQLUtils.cleanup(st, (Connection)con);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tempTable != null) {
                MainMenuGeneratorPinYinHelper.releaseTable(con, tempTable);
            }
        }
    }

    private static String getTempTableName(String name) {
        return name + System.currentTimeMillis();
    }

    private static void createTable(Connection con, String sql) throws BOSException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            ps.execute();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            SQLUtils.cleanup((Statement)ps, (Connection)con);
            throw new BOSException((Throwable)e);
        }
    }

    private static void releaseTable(Connection con, String tableName) throws BOSException {
        String releaseSql = "drop table " + tableName;
        PreparedStatement st = null;
        try {
            st = con.prepareStatement(releaseSql);
            st.execute();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

