/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.MenuCacheInfo;
import com.kingdee.eas.base.uiframe.app.AbstractMenuCacheControllerBean;
import com.kingdee.eas.base.uiframe.utils.DbTransactionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MenuCacheControllerBean
extends AbstractMenuCacheControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uiframe.app.MenuCacheControllerBean");

    @Override
    protected boolean _updateMenuCacheByUserID(Context ctx, String userId) throws BOSException {
        String cachetime = Long.toString(System.currentTimeMillis());
        if (this.isExistsUserMenuCache(ctx, userId)) {
            String updateMenuSql = "update T_BAS_MenuCache set FMenuCaheTime='" + cachetime + "'  where FUser='" + userId + "'";
            DbUtil.execute((Context)ctx, (String)updateMenuSql);
        } else {
            MenuCacheInfo info = new MenuCacheInfo();
            String insertSql = "insert into T_BAS_MenuCache(FID,FUser,FMenuCaheTime,FIsChange) values(?,?,?,?) ";
            Object[] params = new Object[]{BOSUuid.create((BOSObjectType)info.getBOSType()).toString(), userId, cachetime, new Integer(0)};
            DbUtil.execute((Context)ctx, (String)insertSql, (Object[])params);
        }
        return false;
    }

    @Override
    protected void _updateAllMenuCache(Context ctx) throws BOSException {
        try {
            DbTransactionUtil.tryTruncateTableNo(ctx, "T_BAS_MenuCache");
        }
        catch (Exception e) {
            logger.error((Object)e);
            String cleanMenuSql = "delete from T_BAS_MenuCache";
            DbUtil.execute((Context)ctx, (String)cleanMenuSql);
        }
    }

    @Override
    protected boolean _resetMenuCacheByUserID(Context ctx, String userid) throws BOSException, EASBizException {
        String updateMenuSql = "update T_BAS_MenuCache set FIsChange=0  where FUser='" + userid + "'";
        try {
            DbUtil.execute((Context)ctx, (String)updateMenuSql);
        }
        catch (BOSException e) {
            logger.error((Object)("update menu cache status error:" + e.getMessage()));
        }
        return false;
    }

    @Override
    protected boolean _getCacheIsChange(Context ctx, String userId) throws BOSException {
        Object[] rootParams = new Object[]{userId};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)"select FIsChange from T_BAS_MenuCache where FUser = ? ", (Object[])rootParams);
        try {
            if (rowset.next()) {
                boolean isChange = rowset.getBoolean("FIsChange");
                return isChange;
            }
            MenuCacheInfo info = new MenuCacheInfo();
            String insertSql = "insert into T_BAS_MenuCache(FID,FUser,FIsChange) values(?,?,?) ";
            Object[] params = new Object[]{BOSUuid.create((BOSObjectType)info.getBOSType()).toString(), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), new Integer(0)};
            DbUtil.execute((Context)ctx, (String)insertSql, (Object[])params);
            return false;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
    }

    @Override
    protected String _getCacheTimeByUserid(Context ctx, String userid) throws BOSException {
        Object[] rootParams = new Object[]{userid};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)"select FMenuCaheTime from T_BAS_MenuCache where FUser = ? ", (Object[])rootParams);
        String cachetime = null;
        try {
            if (rowset.next()) {
                cachetime = rowset.getString("FMenuCaheTime");
                if (null == cachetime || "".equals(cachetime)) {
                    cachetime = Long.toString(System.currentTimeMillis());
                    String updateMenuSql = "update T_BAS_MenuCache set FMenuCaheTime='" + cachetime + "'  where FUser='" + userid + "'";
                    DbUtil.execute((Context)ctx, (String)updateMenuSql);
                }
                return cachetime;
            }
            cachetime = Long.toString(System.currentTimeMillis());
            MenuCacheInfo info = new MenuCacheInfo();
            String insertSql = "insert into T_BAS_MenuCache(FID,FUser,FMenuCaheTime,FIsChange) values(?,?,?,?) ";
            Object[] params = new Object[]{BOSUuid.create((BOSObjectType)info.getBOSType()).toString(), userid, cachetime, new Integer(0)};
            DbUtil.execute((Context)ctx, (String)insertSql, (Object[])params);
            return cachetime;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            cachetime = null;
            return cachetime;
        }
    }

    private boolean isExistsUserMenuCache(Context ctx, String userId) throws BOSException {
        boolean flag = false;
        Object[] rootParams = new Object[]{userId};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)"select FMenuCaheTime from T_BAS_MenuCache where FUser = ? ", (Object[])rootParams);
        try {
            if (rowset.next()) {
                flag = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    private boolean isExistComFuncMenuCache(Context ctx, String userId) throws BOSException {
        boolean flag = false;
        Object[] rootParams = new Object[]{userId};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)"select FMenuCacheTime from T_BAS_ComFuncMenuCache where FUserId = ? ", (Object[])rootParams);
        try {
            if (rowset.next()) {
                flag = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    @Override
    protected String _getComFuncMenuCache(Context ctx, String userid) throws BOSException {
        Object[] rootParams = new Object[]{userid};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)"select FMenuCacheTime from T_BAS_ComFuncMenuCache where FUserId = ? ", (Object[])rootParams);
        String cachetime = null;
        try {
            if (rowset.next()) {
                cachetime = rowset.getString("FMenuCacheTime");
                if (null == cachetime || "".equals(cachetime)) {
                    cachetime = Long.toString(System.currentTimeMillis());
                    String updateMenuSql = "update T_BAS_ComFuncMenuCache set FMenuCacheTime='" + cachetime + "'  where FUserId='" + userid + "'";
                    DbUtil.execute((Context)ctx, (String)updateMenuSql);
                }
                return cachetime;
            }
            cachetime = Long.toString(System.currentTimeMillis());
            MenuCacheInfo info = new MenuCacheInfo();
            String insertSql = "insert into T_BAS_ComFuncMenuCache(FID,FUserId,FMenuCacheTime,FIsChange) values(?,?,?,?) ";
            Object[] params = new Object[]{BOSUuid.create((BOSObjectType)info.getBOSType()).toString(), userid, cachetime, new Integer(0)};
            DbUtil.execute((Context)ctx, (String)insertSql, (Object[])params);
            return cachetime;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            cachetime = null;
            return cachetime;
        }
    }

    @Override
    protected boolean _updateComMenuCacheByUserId(Context ctx, String userId) throws BOSException {
        HashSet<String> userIdSet = new HashSet<String>();
        userIdSet.add(userId);
        try {
            return this._updateComMenuCacheByUserIds(ctx, userIdSet);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getServerCacheTimes(Context ctx, String userId) throws BOSException, EASBizException {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("menuCacheTime", this.getCacheTimeByUserid(ctx, userId));
        ret.put("comFunctionMenuCatcheTime", this.getComFuncMenuCache(ctx, userId));
        return ret;
    }

    @Override
    protected boolean _updateComMenuCacheByUserIds(Context ctx, Set userIdSet) throws BOSException, EASBizException {
        String existSql = "select FUserId from T_BAS_ComFuncMenuCache where FUserId in (" + ToolUtils.aryToStr((Collection)userIdSet) + ")";
        HashSet<String> existUserIdSet = new HashSet<String>();
        String cachetime = Long.toString(System.currentTimeMillis());
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)existSql);
            while (rs.next()) {
                existUserIdSet.add(rs.getString("FUserId"));
            }
            String updateMenuSql = "update T_BAS_ComFuncMenuCache set FMenuCacheTime='" + cachetime + "'  where FUserId in (" + ToolUtils.aryToStr(existUserIdSet) + ")";
            DbUtil.execute((Context)ctx, (String)updateMenuSql);
            userIdSet.removeAll(existUserIdSet);
            String insertSql = "insert into T_BAS_ComFuncMenuCache(FID,FUserId,FMenuCacheTime,FIsChange) values(?,?,?,?) ";
            Iterator userIdItr = userIdSet.iterator();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (userIdItr.hasNext()) {
                String userId = (String)userIdItr.next();
                Object[] params = new Object[]{BOSUuid.create((BOSObjectType)this.getBOSType()).toString(), userId, cachetime, new Integer(0)};
                paramsList.add(params);
            }
            DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }
}

