/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.SMSValidataException;
import com.kingdee.eas.base.uiframe.app.AbstractSMSValidataCodeFacadeControllerBean;
import com.kingdee.eas.common.CodeTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.MobileCodeException;
import com.kingdee.eas.common.MobileCodeFacadeFactory;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class SMSValidataCodeFacadeControllerBean
extends AbstractSMSValidataCodeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uiframe.app.SMSValidataCodeFacadeControllerBean");
    private static final int CELL = 0;
    private static final int EMAIL = 1;

    @Override
    protected int _sendCode(Context ctx, String userNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)userNumber)) {
            throw new SMSValidataException(SMSValidataException.USERNUMBER_IS_NULL);
        }
        String sql = "SELECT FID,FCELL,FEMAIL FROM T_PM_USER WHERE LOWER(FNUMBER)=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userNumber.toLowerCase()});
        String cell = null;
        String email = null;
        try {
            if (rs.next()) {
                cell = rs.getString("FCELL");
                email = rs.getString("FEMAIL");
            }
        }
        catch (SQLException e1) {
            logger.error((Object)"\u67e5\u8be2\u5931\u8d25");
            throw new SMSValidataException(SMSValidataException.SEND_ERROR);
        }
        if (StringUtils.isEmpty(cell) && StringUtils.isEmpty(email)) {
            throw new SMSValidataException(SMSValidataException.CELL_EMAIL_IS_NULL);
        }
        try {
            boolean result = false;
            int type = -1;
            if (StringUtils.isEmpty((String)cell)) {
                result = MobileCodeFacadeFactory.getLocalInstance((Context)ctx).generateSmscode(email, "\u767b\u5f55", 5L, CodeTypeEnum.EMAIL);
                type = 1;
            } else {
                result = MobileCodeFacadeFactory.getLocalInstance((Context)ctx).generateSmscode(cell, "\u767b\u5f55", 5L, CodeTypeEnum.SMS);
                type = 0;
            }
            if (result) {
                return type;
            }
            throw new SMSValidataException(SMSValidataException.SEND_ERROR);
        }
        catch (Exception e) {
            if (e instanceof MobileCodeException) {
                throw (MobileCodeException)e;
            }
            if (e instanceof MobileException) {
                throw (MobileException)e;
            }
            logger.error((Object)"\u8c03\u7528\u53d1\u9001\u63a5\u53e3\u5931\u8d25\uff01", (Throwable)e);
            throw new SMSValidataException(SMSValidataException.SEND_ERROR);
        }
    }

    @Override
    public boolean checkCode(Context ctx, String userNumber, String code) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)code)) {
            throw new SMSValidataException(SMSValidataException.CODE_IS_NULL);
        }
        if (StringUtils.isEmpty((String)userNumber)) {
            throw new SMSValidataException(SMSValidataException.USERNUMBER_IS_NULL);
        }
        String sql = "SELECT FCELL,FEMAIL FROM T_PM_USER WHERE LOWER(FNUMBER)=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userNumber.toLowerCase()});
        String cell = null;
        String email = null;
        try {
            if (rs.next()) {
                cell = rs.getString("FCELL");
                email = rs.getString("FEMAIL");
            }
        }
        catch (SQLException e1) {
            logger.error((Object)"\u67e5\u8be2\u5931\u8d25");
            throw new SMSValidataException(SMSValidataException.CHECK_ERROR);
        }
        if (StringUtils.isEmpty(cell) && StringUtils.isEmpty(email)) {
            throw new SMSValidataException(SMSValidataException.CELL_EMAIL_IS_NULL);
        }
        try {
            boolean result = false;
            result = StringUtils.isEmpty((String)cell) ? MobileCodeFacadeFactory.getLocalInstance((Context)ctx).checkSmscode(email, code, CodeTypeEnum.EMAIL) : MobileCodeFacadeFactory.getLocalInstance((Context)ctx).checkSmscode(cell, code, CodeTypeEnum.SMS);
            if (result) {
                return true;
            }
            throw new SMSValidataException(SMSValidataException.CHECK_ERROR);
        }
        catch (Exception e) {
            logger.error((Object)"\u8c03\u7528\u53d1\u9001\u63a5\u53e3\u5931\u8d25\uff01", (Throwable)e);
            throw new SMSValidataException(SMSValidataException.CHECK_ERROR);
        }
    }
}

