/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.gzh.util;

import com.kingdee.eas.util.BASE64Encoder;
import java.net.URLEncoder;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HashHmacCrypto {
    public static String sign(String method, String url, TreeMap<String, String> params, TreeMap<String, String> headers, String key) throws Exception {
        String source = method + "\n";
        source = source + URLEncoder.encode(url, "utf-8") + "\n";
        StringBuilder sb = new StringBuilder();
        for (String var : params.keySet()) {
            String value;
            String string = value = params.get(var) == null ? "" : params.get(var);
            if (value.contains("*")) {
                String value2 = URLEncoder.encode(value, "utf-8");
                value = value2.replaceAll("\\*", "%2A");
                sb.append(URLEncoder.encode(var, "utf-8")).append('=').append(URLEncoder.encode(value, "utf-8")).append('&');
                continue;
            }
            sb.append(URLEncoder.encode(var, "utf-8")).append('=').append(URLEncoder.encode(URLEncoder.encode(value, "utf-8"), "utf-8")).append('&');
        }
        String paramsString = sb.toString();
        if (paramsString.length() > 0) {
            paramsString = paramsString.substring(0, paramsString.length() - 1);
            source = source + paramsString + "\n";
        }
        sb = new StringBuilder();
        for (String header : headers.keySet()) {
            sb.append(header.toLowerCase()).append(":").append(headers.get(header).trim()).append("\n");
        }
        source = source + sb.toString();
        return HashHmacCrypto.hmac(source, key);
    }

    private static String bytesToHex(byte[] hashInBytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hashInBytes.length; ++i) {
            String hex = Integer.toHexString(hashInBytes[i] & 0xFF);
            if (hex.length() < 2) {
                hex = "0" + hex;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String hmac(String source, String key) throws Exception {
        byte[] keyBytes = key.getBytes();
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(source.getBytes());
        return new BASE64Encoder().encode(HashHmacCrypto.bytesToHex(rawHmac).getBytes());
    }
}

