/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.ssoyzj;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.uiframe.ssoyzj.ISSOToYZJService;
import com.kingdee.eas.base.uiframe.ssoyzj.SSOToYZJConfigInfo;
import com.kingdee.eas.base.uiframe.ssoyzj.helper.SSOToYZJHelper;
import com.kingdee.eas.base.uiframe.ssoyzj.util.Ajax;
import com.kingdee.eas.base.uiframe.ssoyzj.util.AjaxException;
import com.kingdee.eas.base.uiframe.ssoyzj.util.AuthorizationUtil;
import com.kingdee.eas.base.uiframe.ssoyzj.util.DESUtils;
import com.kingdee.eas.base.uiframe.ssoyzj.util.HttpUtil;
import com.kingdee.eas.common.EASBizException;
import java.io.IOException;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOToYZJService
implements ISSOToYZJService {
    private static Logger logger = LoggerFactory.getLogger(SSOToYZJService.class);
    private static SecureRandom RAND = new SecureRandom();
    private SSOToYZJConfigInfo param = null;

    public SSOToYZJService(Context ctx) throws EASBizException, BOSException {
        this.param = SSOToYZJHelper.getConfigParam(ctx);
    }

    @Override
    public JSONObject getAcqCode(String eid, String openId) throws BOSException {
        JSONObject data = new JSONObject();
        data.put("eid", (Object)eid);
        data.put("oid", (Object)openId);
        String key = eid + "$kingdeeonline";
        data.put("resGroupSecret", (Object)this.param.getSecret());
        data.put("timestamp", (Object)System.currentTimeMillis());
        try {
            String encryptBody = new String(Base64.encodeBase64((byte[])DESUtils.encrypt(data.toJSONString().getBytes(), key)));
            JSONObject sendData = new JSONObject();
            sendData.put("eid", (Object)eid);
            sendData.put("encryptBody", (Object)encryptBody);
            return HttpUtil.doPost(this.param.getCodeUrl(), sendData);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6code\u5931\u8d25\uff01");
            logger.error("url=" + this.param.getCodeUrl() + ";\u53c2\u6570=" + data.toJSONString());
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public JSONObject getAcqssoInfo(String eid, String openId, String code) throws BOSException {
        JSONObject sendData = new JSONObject();
        sendData.put("eid", (Object)eid);
        sendData.put("oid", (Object)openId);
        sendData.put("code", (Object)code);
        sendData.put("clientId", (Object)this.param.getClientId());
        try {
            return HttpUtil.doPost(this.param.getSsoUserInfoUrl(), sendData);
        }
        catch (IOException e) {
            logger.error("\u8bbf\u95ee\u4e91\u4e4b\u5bb6\u767b\u5f55\u4eba\u5458\u4fe1\u606f\u63a5\u53e3\u5931\u8d25!");
            logger.error("\u8bf7\u6c42\u53c2\u6570:" + sendData.toJSONString());
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public JSONObject getWebLoginToken(String oauth_token, String oauth_secret) throws BOSException {
        String oauth_signature_method = "HMAC-SHA1";
        long oauth_timestamp = System.currentTimeMillis();
        String oauth_nonce = String.valueOf(oauth_timestamp + (long)RAND.nextInt());
        float oauth_version = 1.0f;
        String oauth_signature = null;
        try {
            oauth_signature = AuthorizationUtil.generateAuthorizationHeader(this.param.getConsumerKey(), this.param.getConsumerSecret(), oauth_signature_method, oauth_timestamp, oauth_nonce, oauth_version, oauth_token, oauth_secret, null, this.param.getLoginTokenUrl(), null, "GET");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HttpGet method = new HttpGet(this.param.getLoginTokenUrl());
        method.setHeader("Authorization", oauth_signature);
        try {
            return JSON.parseObject((String)Ajax.exceuteRequest((HttpRequestBase)method, "utf-8"));
        }
        catch (AjaxException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public SSOToYZJConfigInfo getConfig() {
        return this.param;
    }
}

