/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.BizTypeEnum;
import com.kingdee.eas.base.uiframe.IndustryEnum;
import com.kingdee.eas.base.uiframe.MenuEditException;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.SysMenuItemInfo;
import com.kingdee.eas.base.uiframe.app.MainMenuGeneratorPinYinHelper;
import com.kingdee.eas.base.uiframe.utils.DbTransactionUtil;
import com.kingdee.eas.base.uiframe.utils.MenuDbUtil;
import com.kingdee.eas.base.uiframe.utils.UnAutoUpdateAssistInfo;
import com.kingdee.eas.base.uiframe.utils.UnAutoUpdateMenus;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class CustMenuAutoUpdateForDB {
    private static final Logger logger = Logger.getLogger(CustMenuAutoUpdateForDB.class);
    public static ThreadLocal dbType = new ThreadLocal();

    public static UnAutoUpdateMenus autoUpdate(Connection conn, String industryType) throws BOSException, EASBizException {
        CustMenuAutoUpdateForDB.correctCreatorAndUpdateUser(conn);
        CustMenuAutoUpdateForDB.correctSysIdOfSameMenu(conn);
        CustMenuAutoUpdateForDB.resetCustomModifyOnDrag(conn);
        CustMenuAutoUpdateForDB.updateSysMenuLeafState(conn);
        UnAutoUpdateMenus unUpdateMenu = CustMenuAutoUpdateForDB.checkNewSysMenuDup(conn, industryType);
        if (unUpdateMenu.hasWarningMsg()) {
            return unUpdateMenu;
        }
        CustMenuAutoUpdateForDB.handleCustomMainMenu(conn, industryType);
        CustMenuAutoUpdateForDB.updateModifiedMainMenu(conn);
        CustMenuAutoUpdateForDB.updateUnModifiedMainMenu(conn, industryType);
        CustMenuAutoUpdateForDB.handleNewMainMenu(conn, industryType);
        CustMenuAutoUpdateForDB.deleteUselessMainMenu(conn, industryType);
        CustMenuAutoUpdateForDB.updateMainMenuLeafState(conn);
        CustMenuAutoUpdateForDB.updateAllUserComMenuCach(conn);
        CustMenuAutoUpdateForDB.updateNoMenuStatus(conn);
        MainMenuGeneratorPinYinHelper.generatePinYin(conn);
        return null;
    }

    private static void correctCreatorAndUpdateUser(Connection conn) throws BOSException {
        String[] sqls = new String[]{"update t_pm_mainmenuitem set fcreatorid = '00000000-0000-0000-0000-00000000000013B7DE7F' where fcreatorid is null", "update t_pm_mainmenuitem set flastupdateuserid = '00000000-0000-0000-0000-00000000000013B7DE7F' where flastupdateuserid is null", "update t_bas_sysmenuitem set flastupdateuserid = '00000000-0000-0000-0000-00000000000013B7DE7F' where flastupdateuserid is null", "update t_bas_sysmenuitem set fcreatorid = '00000000-0000-0000-0000-00000000000013B7DE7F' where fcreatorid is null"};
        MenuDbUtil.executeBatch(conn, sqls);
    }

    private static void correctSysIdOfSameMenu(Connection conn) throws BOSException {
        String sql = "if exists (select 1 from t_pm_mainmenuitem a join t_bas_sysmenuitem b on a.flongnumber=b.flongnumber where a.fid<>b.fid or a.fsysmenuid<>b.fid)  update  t_pm_mainmenuitem   set fsysmenuid =  (select top 1 fid from t_bas_sysmenuitem where flongnumber = t_pm_mainmenuitem.flongnumber) ,fid=(select top 1 fid from t_bas_sysmenuitem where flongnumber = t_pm_mainmenuitem.flongnumber)  where exists (select 1 from t_bas_sysmenuitem where flongnumber=t_pm_mainmenuitem.flongnumber and  (fid<>t_pm_mainmenuitem.fid or fid<>t_pm_mainmenuitem.fsysmenuid)  and not exists (select 1 from t_pm_mainmenuitem where fid=t_bas_sysmenuitem.fid)) ";
        MenuDbUtil.execute(conn, sql);
    }

    private static void resetCustomModifyOnDrag(Connection conn) throws BOSException {
        StringBuffer sql = new StringBuffer().append("delete from T_PM_MenuModifyField where fmainmenu in ").append("(").append("\tselect main.fid from t_pm_mainmenuitem main where main.fparent in ").append("\t\t(").append("\t\t\tselect fid from t_pm_mainmenuitem where fsysmenuid is not null and not exists").append("\t\t\t\t(").append("\t\t\t\t\tselect 1 from t_bas_sysmenuitem sysitem where sysitem.fid = fsysmenuid ").append("\t\t\t\t)").append("\t\t)").append("\tand main.fsysmenuid is not null and exists").append("\t\t(").append("\t\t\tselect 1 from t_bas_sysmenuitem sysitem where sysitem.fid = main.fsysmenuid").append("\t\t)").append("\tand main.fismodified = 1").append(")").append(" and ffieldname in ('FParent','FLevel','FLongNumber','FDisplayName_L1','FDisplayName_L2','FDisplayName_L3')");
        MenuDbUtil.execute(conn, sql.toString());
    }

    public static void updateSysMenuLeafState(Connection conn) throws BOSException {
        String updateLeafSql = "update T_BAS_SysMenuItem t1 set fisleaf = 1 where not exists (select 1 from T_BAS_SysMenuItem t2 where t2.fparent = t1.fid) and fisleaf = 0";
        MenuDbUtil.execute(conn, updateLeafSql);
        updateLeafSql = "update T_BAS_SysMenuItem t1 set fisleaf = 0 where exists (select 1 from T_BAS_SysMenuItem t2 where t2.fparent = t1.fid) and fisleaf = 1";
        MenuDbUtil.execute(conn, updateLeafSql);
    }

    private static UnAutoUpdateMenus checkNewSysMenuDup(Connection conn, String industryType) throws BOSException {
        UnAutoUpdateMenus warningMsg = new UnAutoUpdateMenus();
        try {
            String sql = CustMenuAutoUpdateForDB.replaceConstantInDupSQL(industryType, "fnumber");
            IRowSet rs = MenuDbUtil.executeQuery(conn, sql);
            while (rs.next()) {
                warningMsg.add(CustMenuAutoUpdateForDB.createUnAutoUpdateAssistInfo("number_duplicate", rs));
            }
            sql = CustMenuAutoUpdateForDB.replaceConstantInDupSQL(industryType, "fshortcutcode");
            rs = MenuDbUtil.executeQuery(conn, sql);
            while (rs.next()) {
                warningMsg.add(CustMenuAutoUpdateForDB.createUnAutoUpdateAssistInfo("shortcutcode_duplicate", rs));
            }
            sql = "select main2.fname_l2,sys.fname_l2,sys.fdisplayname_l2 from t_bas_sysmenuitem sys inner join t_pm_mainmenuitem main  on main.fsysmenuid = sys.fid inner join t_pm_mainmenuitem main2  on  main2.fnumber = sys.fnumber where  main.fnumber <> sys.fnumber";
            rs = MenuDbUtil.executeQuery(conn, sql);
            while (rs.next()) {
                warningMsg.add(CustMenuAutoUpdateForDB.createUnAutoUpdateAssistInfo("number_duplicate", rs));
            }
            sql = "select main2.fname_l2,sys.fname_l2,sys.fdisplayname_l2 from t_bas_sysmenuitem sys inner join t_pm_mainmenuitem main  on main.fsysmenuid = sys.fid inner join t_pm_mainmenuitem main2  on  main2.fshortcutcode = sys.fshortcutcode where  main.fshortcutcode <> sys.fshortcutcode";
            rs = MenuDbUtil.executeQuery(conn, sql);
            while (rs.next()) {
                warningMsg.add(CustMenuAutoUpdateForDB.createUnAutoUpdateAssistInfo("shortcutcode_duplicate", rs));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return warningMsg;
    }

    private static void handleCustomMainMenu(Connection conn, String industryType) throws BOSException, EASBizException {
        String industrySQL = "";
        if (!StringUtils.isEmpty((String)industryType)) {
            industrySQL = " and (" + CustMenuAutoUpdateForDB.getIndustrySql(industryType, "q1.") + ")";
        }
        BOSObjectType bosType = new MainMenuItemInfo().getBOSType();
        String topCustomMenuID = null;
        String topCustomMenuNum = null;
        String sql = "select fid, fnumber from t_pm_mainmenuitem where fname_l2 = '\u5ba2\u6237\u5316\u83dc\u5355'";
        IRowSet rs = MenuDbUtil.executeQuery(conn, sql);
        HashMap<String, String> oldNumber2newId = new HashMap<String, String>();
        HashMap<String, String> oldNumber2newLN = new HashMap<String, String>();
        try {
            if (rs.next()) {
                topCustomMenuID = rs.getString(1);
                topCustomMenuNum = rs.getString(2);
                sql = "select fsimplename, fid, flongnumber from t_pm_mainmenuitem where flongnumber like '" + topCustomMenuNum + "!%'";
                IRowSet customRowset = MenuDbUtil.executeQuery(conn, sql);
                while (customRowset.next()) {
                    oldNumber2newId.put(customRowset.getString(1), customRowset.getString(2));
                    oldNumber2newLN.put(customRowset.getString(1), customRowset.getString(3));
                }
            } else {
                topCustomMenuID = BOSUuid.create((BOSObjectType)bosType).toString();
                topCustomMenuNum = "zzzzzzzz";
                CustMenuAutoUpdateForDB.createCustomMenu(conn, topCustomMenuID, topCustomMenuNum);
            }
            String selectSql = "select p1.fnumber,p1.flongnumber,p1.fid from t_pm_mainmenuitem p1 where p1.fsysmenuid is null and not exists (select 1 from t_bas_sysmenuitem q1 where q1.fid = p1.fparent " + industrySQL + ")  and not exists ( select 1 from t_pm_mainmenuitem mmi where mmi.fid=p1.fparent and mmi.fsysmenuid is null) and p1.FLevel > 1  and p1.flongnumber||'!' not like '" + topCustomMenuNum + "!%' order by p1.flongnumber";
            IRowSet rowset = MenuDbUtil.executeQuery(conn, selectSql);
            HashMap<String, String> num2LongNumber = new HashMap<String, String>();
            HashMap<String, String> num2ID = new HashMap<String, String>();
            String[] splitNumbers = null;
            String customNumber = null;
            String parentID = topCustomMenuID;
            String parentLN = topCustomMenuNum;
            String currentID = null;
            String currentNum = null;
            Object[] params = null;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String datetime = formatter.format(new Date());
            ArrayList<Object[]> insertParamList = new ArrayList<Object[]>();
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
            while (rowset.next()) {
                customNumber = rowset.getString(1);
                splitNumbers = rowset.getString(2).split("!");
                for (int i = 0; i < splitNumbers.length; ++i) {
                    if (num2LongNumber.containsKey(splitNumbers[i])) {
                        parentLN = (String)num2LongNumber.get(splitNumbers[i]);
                        parentID = (String)num2ID.get(splitNumbers[i]);
                        continue;
                    }
                    if (oldNumber2newId.containsKey(splitNumbers[i])) {
                        parentLN = (String)oldNumber2newLN.get(splitNumbers[i]);
                        parentID = (String)oldNumber2newId.get(splitNumbers[i]);
                        continue;
                    }
                    if (splitNumbers[i].equals(customNumber)) {
                        if (0 == i) {
                            parentLN = topCustomMenuNum;
                            parentID = topCustomMenuID;
                        }
                        params = new Object[]{parentLN + "!" + splitNumbers[i], parentID, datetime, splitNumbers[i]};
                        updateParamList.add(params);
                        parentID = rowset.getString(3);
                        parentLN = parentLN + "!" + splitNumbers[i];
                    } else {
                        currentID = BOSUuid.create((BOSObjectType)bosType).toString();
                        currentNum = Uuid.create().toString().substring(0, 8);
                        if (0 == i) {
                            params = new Object[]{currentID, currentNum, topCustomMenuNum + "!" + currentNum, topCustomMenuID, datetime, splitNumbers[i]};
                            insertParamList.add(params);
                        } else {
                            params = new Object[]{currentID, currentNum, parentLN + "!" + currentNum, parentID, datetime, splitNumbers[i]};
                            insertParamList.add(params);
                        }
                        parentID = currentID;
                        parentLN = parentLN + "!" + currentNum;
                    }
                    num2LongNumber.put(splitNumbers[i], parentLN);
                    num2ID.put(splitNumbers[i], parentID);
                }
            }
            if (insertParamList.size() > 0) {
                MenuDbUtil.executeBatch(conn, CustMenuAutoUpdateForDB.getInsertSQL(), insertParamList);
            }
            if (updateParamList.size() > 0) {
                MenuDbUtil.executeBatch(conn, CustMenuAutoUpdateForDB.getUpdateSQL(), updateParamList);
            }
            if ((rowset = MenuDbUtil.executeQuery(conn, sql = "select count(fid) from t_pm_mainmenuitem where flongnumber like '" + topCustomMenuNum + "!%'")).next() && rowset.getInt(1) == 0) {
                sql = "delete from t_pm_mainmenuitem where fnumber = '" + topCustomMenuNum + "'";
                MenuDbUtil.execute(conn, sql);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static void updateModifiedMainMenu(Connection conn) throws BOSException, EASBizException {
        String modifyMenuSql = "select p.FID,p.FSysMenuID from T_PM_MainMenuItem p,T_BAS_SysMenuItem t where  p.FSysMenuID = t.FID and p.FIsModified = 1";
        IRowSet modifyRowSet = MenuDbUtil.executeQuery(conn, modifyMenuSql);
        Statement st = null;
        try {
            st = conn.createStatement();
        }
        catch (SQLException e1) {
            logger.error((Object)("DataBase Connection ERROR:" + e1.getMessage()));
        }
        if (st == null) {
            return;
        }
        if (null != modifyRowSet && st != null) {
            try {
                while (modifyRowSet.next()) {
                    HashMap map = CustMenuAutoUpdateForDB.getAllFieldName();
                    String fid = modifyRowSet.getString("FID");
                    String fsysMenuID = modifyRowSet.getString("FSysMenuID");
                    String selectFieldSql = "select FFieldName from T_PM_MenuModifyField where FMainMenu=?";
                    Object[] param = new Object[]{fid};
                    IRowSet fieldRs = MenuDbUtil.executeQuery(conn, selectFieldSql, param);
                    if (null != fieldRs) {
                        while (fieldRs.next()) {
                            String fieldName = fieldRs.getString("FFieldName");
                            if (!map.containsKey(fieldName)) continue;
                            map.remove(fieldName);
                        }
                    }
                    String[] updateFieldName = CustMenuAutoUpdateForDB.getUpdateFieldNameStr(map);
                    String updateSql = "update T_PM_MainMenuItem  set (" + updateFieldName[0] + ") = (select " + updateFieldName[1] + " from T_BAS_SysMenuItem t where FSysMenuID = t.FID and FSysMenuID='" + fsysMenuID + "')";
                    st.addBatch(updateSql);
                }
                st.executeBatch();
            }
            catch (SQLException e) {
                logger.error((Object)("DataBase opreation exception: " + e.getMessage()));
                throw new MenuEditException(MenuEditException.AUTOUPDATEMENUEXCEPTION, e);
            }
            finally {
                SQLUtils.cleanup((Statement)st);
            }
        }
    }

    private static void updateUnModifiedMainMenu(Connection conn, String industryType) throws BOSException {
        String industrySQL = "";
        if (!StringUtils.isEmpty((String)industryType)) {
            industrySQL = " and (" + CustMenuAutoUpdateForDB.getIndustrySql(industryType, "t.") + ")";
        }
        String noUpdateSql = "update T_PM_MainMenuItem set (FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FName_L1,FName_L2,FName_L3,FNumber,FDescription_L1,FDescription_L2,FDescription_L3,FSimpleName,FIsLeaf,FLevel,FLongNumber,FDisplayName_L1,FDisplayName_L2,FDisplayName_L3,FOrder,FImagePath,FVisible,FEnabled,FUiClassName,FUiClassParam,FUiOprt,FOpenMethod,FShortcutCode,FIsReport,FParent,FFunction,FMenutype,FIndustry,FNosuit) = (select t.FCreatorID,t.FCreateTime,t.FLastUpdateUserID,t.FLastUpdateTime,t.FControlUnitID,t.FName_L1,t.FName_L2,t.FName_L3,t.FNumber,t.FDescription_L1,t.FDescription_L2,t.FDescription_L3,t.FSimpleName,t.FIsLeaf,t.FLevel,t.FLongNumber,t.FDisplayName_L1,t.FDisplayName_L2,t.FDisplayName_L3,t.FOrder,t.FImagePath,t.FVisible,t.FEnabled,t.FUiClassName,t.FUiClassParam,t.FUiOprt,t.FOpenMethod,t.FShortcutCode,t.FIsReport,t.FParent,t.FFunction,t.FMenutype,t.FIndustry,t.FNosuit from T_BAS_SysMenuItem t where FSysMenuID = t.FID and (FIsModified = 0 or FIsModified is null)" + industrySQL + ")";
        MenuDbUtil.execute(conn, noUpdateSql);
    }

    private static void handleNewMainMenu(Connection conn, String industryType) throws BOSException, EASBizException {
        String industrySQL = "";
        if (!StringUtils.isEmpty((String)industryType)) {
            industrySQL = " and (" + CustMenuAutoUpdateForDB.getIndustrySql(industryType, null) + ")";
        }
        StringBuffer selectSql = new StringBuffer(CustMenuAutoUpdateForDB.getSysMenuItemCols());
        selectSql.append(" where FID not in(select t.FID from T_BAS_SysMenuItem t,T_PM_MainMenuItem t1 where t.FID = t1.FSysMenuID) ").append(" and fid not in (select fid from T_PM_MainMenuItem ) ").append(industrySQL).append(" order by FLongNumber,FOrder ");
        IRowSet rowSet = MenuDbUtil.executeQuery(conn, selectSql.toString());
        try {
            List menuList = CustMenuAutoUpdateForDB.getAllUnImportedMenu(rowSet);
            if (menuList.size() > 0) {
                StringBuffer addSql = new StringBuffer(100);
                addSql.append("insert into T_PM_MAINMENUITEM(").append(CustMenuAutoUpdateForDB.getQueryFields()).append(",FSimpleName,FCreateTime,FLastupdateTime,FSysmenuID) values(?,?,?,?,?,?,?,?,?,?,?,?").append(",?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                SysMenuItemInfo sysMenuInfo = null;
                MainMenuItemInfo parentMenu = null;
                MainMenuItemInfo newMenu = null;
                Object[] params = new Object[36];
                int menuListSize = menuList.size();
                for (int i = 0; i < menuListSize; ++i) {
                    sysMenuInfo = (SysMenuItemInfo)menuList.get(i);
                    if (null != sysMenuInfo.getParent()) {
                        parentMenu = CustMenuAutoUpdateForDB.findImportedParent(conn, sysMenuInfo.getParent().getId().toString());
                        newMenu = CustMenuAutoUpdateForDB.sysInfo2CustInfo(sysMenuInfo, parentMenu);
                    } else {
                        newMenu = CustMenuAutoUpdateForDB.sysInfo2CustInfo(sysMenuInfo, null);
                    }
                    params = CustMenuAutoUpdateForDB.getMainMenuItemParamList(newMenu);
                    MenuDbUtil.execute(conn, addSql.toString(), params);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static void deleteUselessMainMenu(Connection conn, String industryType) throws BOSException {
        String industrySQL = "";
        if (!StringUtils.isEmpty((String)industryType)) {
            industrySQL = CustMenuAutoUpdateForDB.getDeleteIndustrySql(industryType);
        }
        String selectSql = "delete from t_pm_mainmenuitem where fid not in (select t.FID from T_PM_MainMenuItem t,T_BAS_SysMenuItem t1 where t.FSysMenuID = t1.FID) and FSysMenuID is not NULL" + industrySQL;
        MenuDbUtil.execute(conn, selectSql);
    }

    public static void updateMainMenuLeafState(Connection conn) throws BOSException {
        String updateLeafSql = "update T_PM_MainMenuItem t1 set fisleaf = 1 where not exists (select 1 from T_PM_MainMenuItem t2 where t2.fparent = t1.fid) and fisleaf = 0";
        MenuDbUtil.execute(conn, updateLeafSql);
        updateLeafSql = "update T_PM_MainMenuItem t1 set fisleaf = 0 where exists (select 1 from T_PM_MainMenuItem t2 where t2.fparent = t1.fid) and fisleaf = 1";
        MenuDbUtil.execute(conn, updateLeafSql);
    }

    public static void updateAllUserComMenuCach(Connection conn) throws BOSException, EASBizException {
        try {
            DbTransactionUtil.tryTruncateTableNo(null, "t_bas_comfuncmenucache");
        }
        catch (Exception e) {
            logger.error((Object)e);
            String cleanSql = "delete from t_bas_comfuncmenucache";
            MenuDbUtil.execute(conn, cleanSql);
        }
        try {
            DbTransactionUtil.tryTruncateTableNo(null, "T_BAS_MenuCache");
        }
        catch (Exception e) {
            logger.error((Object)e);
            String cleanMenuSql = "delete from T_BAS_MenuCache";
            MenuDbUtil.execute(conn, cleanMenuSql);
        }
    }

    public static void updateNoMenuStatus(Connection conn) {
        String updateMenuSql = "update T_BAS_MenuUpdate set FIsUpdate=1 ,FIndustryStatus='all' where FID='menuUpdate'";
        try {
            MenuDbUtil.execute(conn, updateMenuSql);
        }
        catch (BOSException e) {
            logger.error((Object)("update menu status error:" + e.getMessage()));
        }
    }

    private static String replaceConstantInDupSQL(String industryType, String replaceItem) {
        String dupSql = CustMenuAutoUpdateForDB.buildCheckDupSQL(industryType);
        return dupSql.replaceAll("REPLACEITEM", replaceItem);
    }

    private static UnAutoUpdateAssistInfo createUnAutoUpdateAssistInfo(String dupType, IRowSet rs) throws SQLException {
        UnAutoUpdateAssistInfo info = new UnAutoUpdateAssistInfo();
        info.setCustomMenuName(rs.getString(1));
        info.setSysMenuName(rs.getString(2));
        info.setSysMenuDisplayName(rs.getString(3));
        info.setDupType(dupType);
        return info;
    }

    public static String getIndustrySql(String industryType, String prefix) {
        String prefixStr = "";
        if (!StringUtils.isEmpty((String)prefix)) {
            prefixStr = prefix;
        }
        String[] industryArray = industryType.split(";");
        StringBuffer bf = new StringBuffer();
        if (industryArray != null && industryArray.length >= 1) {
            for (int i = 0; i < industryArray.length; ++i) {
                if (i > 0) {
                    bf.append(" or ");
                }
                if (industryArray[i].equals("0")) {
                    bf.append("(").append(prefixStr).append("FIndustry = 0 )");
                    continue;
                }
                bf.append("((").append(prefixStr).append("FIndustry=").append(industryArray[i]).append(")").append("or").append("(").append(prefixStr).append("FIndustry=0 and ( ").append(prefixStr).append("FNoSuit not like '%").append(industryArray[i]).append("%'").append(" or ").append(prefixStr).append("FNoSuit is null )))");
            }
        }
        return bf.toString();
    }

    private static void createCustomMenu(Connection conn, String topCustomMenuID, String topCustomMenuNum) throws BOSException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String datetime = formatter.format(new Date());
        String sql = "insert into t_pm_mainmenuitem (fid, fname_l1, fname_l2, fname_l3, fnumber, fisleaf, flevel, flongnumber, forder, fvisible, fenabled, fopenmethod, fparent, fcontrolunitid, findustry, fcreatetime) values( '" + topCustomMenuID + "', 'customItem', '\u5ba2\u6237\u5316\u83dc\u5355', '\u5ba2\u6236\u5316\u83dc\u55ae', '" + topCustomMenuNum + "', 0, 1, '" + topCustomMenuNum + "','999', 1, 1, 0, null, '" + "00000000-0000-0000-0000-000000000000CCE7AED4" + "', 0, to_date('" + datetime + "'))";
        MenuDbUtil.execute(conn, sql);
    }

    private static String getInsertSQL() {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into t_pm_mainmenuitem (").append("fid, fname_l1, fname_l2, fname_l3, fnumber, fisleaf, flevel, flongnumber, ").append("forder, fvisible, fenabled, fopenmethod, fparent, fcontrolunitid, findustry, fnosuit, fcreatetime, fsimplename) ").append("select ").append("?,fname_l1, fname_l2, fname_l3,?,fisleaf,flevel + 1, ?, ").append("'255',1,1,0,?,fcontrolunitid,0,null,to_date(?), fnumber ").append("from t_pm_mainmenuitem where fnumber = ? ");
        return insertSql.toString();
    }

    private static String getUpdateSQL() {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update t_pm_mainmenuitem set flevel = flevel + 1, flongnumber = ?, ").append("fparent = ?, flastupdatetime = to_date(?) where fnumber = ?");
        return updateSql.toString();
    }

    private static HashMap getAllFieldName() {
        String[] fieldNameColl = new String[]{"FCreatorID", "FCreateTime", "FLastUpdateUserID", "FLastUpdateTime", "FControlUnitID", "FName_L1", "FName_L2", "FName_L3", "FNumber", "FDescription_L1", "FDescription_L2", "FDescription_L3", "FSimpleName", "FIsLeaf", "FLevel", "FLongNumber", "FDisplayName_L1", "FDisplayName_L2", "FDisplayName_L3", "FOrder", "FImagePath", "FVisible", "FEnabled", "FUiClassName", "FUiClassParam", "FUiOprt", "FOpenMethod", "FShortcutCode", "FIsReport", "FParent", "FFunction", "FIndustry", "FNoSuit"};
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < fieldNameColl.length; ++i) {
            map.put(fieldNameColl[i], fieldNameColl[i]);
        }
        return map;
    }

    private static String[] getUpdateFieldNameStr(HashMap map) {
        String[] field = new String[2];
        StringBuffer pmField = new StringBuffer();
        StringBuffer syField = new StringBuffer();
        if (map != null && map.size() >= 1) {
            for (String fieldName : map.keySet()) {
                pmField.append(fieldName);
                pmField.append(",");
                syField.append("t.");
                syField.append(fieldName);
                syField.append(",");
            }
        }
        field[0] = pmField.substring(0, pmField.length() - 1);
        field[1] = syField.substring(0, syField.length() - 1);
        return field;
    }

    public static String getSysMenuItemCols() {
        StringBuffer sysMenuItemCols = new StringBuffer();
        sysMenuItemCols.append("select ").append(CustMenuAutoUpdateForDB.getQueryFields()).append(" from T_BAS_SysMenuItem ");
        return sysMenuItemCols.toString();
    }

    public static List getAllUnImportedMenu(IRowSet rowSet) throws SQLException {
        PermItemInfo pemission = null;
        SysMenuItemInfo menuItemInfo = null;
        ArrayList<SysMenuItemInfo> menuList = new ArrayList<SysMenuItemInfo>();
        SysMenuItemInfo parentItemInfo = null;
        int pos = 0;
        while (rowSet.next()) {
            menuItemInfo = new SysMenuItemInfo();
            menuItemInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
            CustMenuAutoUpdateForDB.setMultiLangValue(menuItemInfo, rowSet);
            menuItemInfo.setNumber(rowSet.getString("FNumber"));
            menuItemInfo.setLongNumber(rowSet.getString("FLongNumber"));
            if (rowSet.getString("FParent") != null) {
                parentItemInfo = new SysMenuItemInfo();
                parentItemInfo.setId(BOSUuid.read((String)rowSet.getString("FParent")));
                menuItemInfo.setParent(parentItemInfo);
            } else {
                menuItemInfo.setParent(null);
            }
            menuItemInfo.setLevel(rowSet.getInt("FLevel"));
            menuItemInfo.setIsLeaf(rowSet.getInt("FIsLeaf") != 0);
            menuItemInfo.setOrder(rowSet.getString("FOrder"));
            menuItemInfo.setImagePath(rowSet.getString("FImagePath"));
            menuItemInfo.setEnabled(rowSet.getInt("FEnabled") != 0);
            menuItemInfo.setVisible(rowSet.getInt("FVisible") != 0);
            menuItemInfo.setIsReport(rowSet.getInt("FIsReport") != 0);
            menuItemInfo.setUiClassName(rowSet.getString("FUiClassName"));
            menuItemInfo.setUiClassParam(rowSet.getString("FUiClassParam"));
            menuItemInfo.setUiOprt(rowSet.getString("FUiOprt"));
            menuItemInfo.setOpenMethod(OpenMethod.getEnum(rowSet.getInt("FOpenMethod")));
            menuItemInfo.setShortcutCode(rowSet.getString("FShortcutCode"));
            if (rowSet.getString("FFunction") != null && rowSet.getString("FFunction").trim().length() > 0) {
                pemission = new PermItemInfo();
                pemission.setId(BOSUuid.read((String)rowSet.getString("FFunction")));
                menuItemInfo.setFunction(pemission);
            }
            menuItemInfo.setIndustry(IndustryEnum.getEnum(rowSet.getInt("FIndustry")));
            menuItemInfo.setNoSuit(rowSet.getString("FNoSuit"));
            String menutype = rowSet.getString("FMenutype");
            if (null == menutype || "".equals(menutype)) {
                menuItemInfo.setMenutype(BizTypeEnum.guimenu);
            } else {
                menuItemInfo.setMenutype(BizTypeEnum.getEnum(menutype));
            }
            UserInfo creatorUserInfo = new UserInfo();
            creatorUserInfo.setId(BOSUuid.read((String)rowSet.getString("FCreatorID")));
            menuItemInfo.setCreator(creatorUserInfo);
            UserInfo updateUserInfo = new UserInfo();
            updateUserInfo.setId(BOSUuid.read((String)rowSet.getString("FLastUpdateUserID")));
            menuItemInfo.setLastUpdateUser(updateUserInfo);
            if (!StringUtils.isEmpty((String)rowSet.getString("FControlUnitID"))) {
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)rowSet.getString("FControlUnitID")));
                menuItemInfo.setCU(cu);
            }
            menuList.add(pos, menuItemInfo);
            ++pos;
        }
        return menuList;
    }

    private static MainMenuItemInfo sysInfo2CustInfo(SysMenuItemInfo sysMenuInfo, MainMenuItemInfo parentCMMenu) {
        MainMenuItemInfo custItemInfo = new MainMenuItemInfo();
        custItemInfo.setId(sysMenuInfo.getId());
        int j = BOSLocaleUtil.EAS_LOCALES.length;
        for (int i = 0; i < j; ++i) {
            custItemInfo.setName(sysMenuInfo.getName(BOSLocaleUtil.EAS_LOCALES[i]), BOSLocaleUtil.EAS_LOCALES[i]);
            custItemInfo.setDescription(sysMenuInfo.getDescription(BOSLocaleUtil.EAS_LOCALES[i]), BOSLocaleUtil.EAS_LOCALES[i]);
            custItemInfo.setDisplayName(sysMenuInfo.getDisplayName(BOSLocaleUtil.EAS_LOCALES[i]), BOSLocaleUtil.EAS_LOCALES[i]);
        }
        custItemInfo.setNumber(sysMenuInfo.getNumber());
        String theLongNum = null;
        theLongNum = null == parentCMMenu || null == parentCMMenu.getLongNumber() || parentCMMenu.getLongNumber().trim().length() == 0 ? sysMenuInfo.getNumber() : parentCMMenu.getLongNumber() + "!" + sysMenuInfo.getNumber();
        custItemInfo.setLongNumber(theLongNum);
        if (null == parentCMMenu) {
            custItemInfo.setLevel(1);
        } else {
            custItemInfo.setLevel(parentCMMenu.getLevel() + 1);
        }
        custItemInfo.setOrder(sysMenuInfo.getOrder());
        custItemInfo.setImagePath(sysMenuInfo.getImagePath());
        custItemInfo.setEnabled(sysMenuInfo.isEnabled());
        custItemInfo.setVisible(sysMenuInfo.isVisible());
        custItemInfo.setIsReport(sysMenuInfo.isIsReport());
        custItemInfo.setUiClassName(sysMenuInfo.getUiClassName());
        custItemInfo.setUiClassParam(sysMenuInfo.getUiClassParam());
        custItemInfo.setUiOprt(sysMenuInfo.getUiOprt());
        custItemInfo.setOpenMethod(sysMenuInfo.getOpenMethod());
        custItemInfo.setShortcutCode(sysMenuInfo.getShortcutCode());
        custItemInfo.setFunction(sysMenuInfo.getFunction());
        custItemInfo.setIsLeaf(sysMenuInfo.isIsLeaf());
        custItemInfo.setCU(sysMenuInfo.getCU());
        custItemInfo.setIndustry(sysMenuInfo.getIndustry());
        custItemInfo.setNoSuit(sysMenuInfo.getNoSuit());
        custItemInfo.setMenutype(sysMenuInfo.getMenutype());
        if (null != parentCMMenu && null != parentCMMenu.getId() && parentCMMenu.getId().toString().trim().length() > 0) {
            custItemInfo.setParent(parentCMMenu);
        } else {
            custItemInfo.setParent(null);
        }
        custItemInfo.setCreator(sysMenuInfo.getCreator());
        custItemInfo.setLastUpdateUser(sysMenuInfo.getLastUpdateUser());
        custItemInfo.setSysMenu(sysMenuInfo);
        return custItemInfo;
    }

    public static MainMenuItemInfo findImportedParent(Connection conn, String parentID) throws SQLException, BOSException {
        Object[] param;
        MainMenuItemInfo parentMenu = new MainMenuItemInfo();
        String selectSql = CustMenuAutoUpdateForDB.getMainMenuItemCols() + " where FSysMenuID = ?";
        IRowSet rowSet = MenuDbUtil.executeQuery(conn, selectSql, param = new Object[]{parentID});
        if (null != rowSet && rowSet.next()) {
            parentMenu.setId(BOSUuid.read((String)rowSet.getString("FID")));
            CustMenuAutoUpdateForDB.setMultiLangValue((TreeBaseInfo)parentMenu, rowSet);
            parentMenu.setNumber(rowSet.getString("FNumber"));
            parentMenu.setLongNumber(rowSet.getString("FLongNumber"));
            parentMenu.setParent(null);
            parentMenu.setLevel(rowSet.getInt("FLevel"));
            parentMenu.setIsLeaf(rowSet.getInt("FIsLeaf") != 0);
            parentMenu.setOrder(rowSet.getString("FOrder"));
            parentMenu.setImagePath(rowSet.getString("FImagePath"));
            parentMenu.setEnabled(rowSet.getInt("FEnabled") != 0);
            parentMenu.setVisible(rowSet.getInt("FVisible") != 0);
            parentMenu.setIsReport(rowSet.getInt("FIsReport") != 0);
            parentMenu.setUiClassName(rowSet.getString("FUiClassName"));
            parentMenu.setUiClassParam(rowSet.getString("FUiClassParam"));
            parentMenu.setUiOprt(rowSet.getString("FUiOprt"));
            parentMenu.setOpenMethod(OpenMethod.getEnum(rowSet.getInt("FOpenMethod")));
            parentMenu.setShortcutCode(rowSet.getString("FShortcutCode"));
            parentMenu.setIndustry(IndustryEnum.getEnum(rowSet.getInt("FIndustry")));
            parentMenu.setNoSuit(rowSet.getString("FNoSuit"));
            if (rowSet.getString("FFunction") != null && rowSet.getString("FFunction").trim().length() > 0) {
                PermItemInfo pemission = new PermItemInfo();
                pemission.setId(BOSUuid.read((String)rowSet.getString("FFunction")));
                parentMenu.setFunction(pemission);
            }
            UserInfo creatorUserInfo = new UserInfo();
            creatorUserInfo.setId(BOSUuid.read((String)rowSet.getString("FCreatorID")));
            parentMenu.setCreator(creatorUserInfo);
            UserInfo updateUserInfo = new UserInfo();
            updateUserInfo.setId(BOSUuid.read((String)rowSet.getString("FLastUpdateUserID")));
            parentMenu.setLastUpdateUser(updateUserInfo);
        }
        return parentMenu;
    }

    public static String getDeleteIndustrySql(String industryType) {
        StringBuffer bf = new StringBuffer();
        bf.append(" or ( FID not in(select FID from T_PM_MainMenuItem where ");
        bf.append(CustMenuAutoUpdateForDB.getIndustrySql(industryType, null) + "))");
        return bf.toString();
    }

    private static String buildCheckDupSQL(String industryType) {
        Object theDbType = dbType.get();
        String industrySQL = "";
        if (!StringUtils.isEmpty((String)industryType)) {
            industrySQL = "and (" + CustMenuAutoUpdateForDB.getIndustrySql(industryType, "p2.") + ")";
        }
        StringBuffer selectDupNumberSQL = new StringBuffer();
        selectDupNumberSQL.append("select mainmenuitem.fname_l2,").append("sysmenuitem.fname_l2,").append("sysmenuitem.fdisplayname_l2 ").append("from t_pm_mainmenuitem mainmenuitem, t_bas_sysmenuitem sysmenuitem ").append("where exists ").append(" (select 1 ").append("from t_bas_sysmenuitem p2 ").append("where (p2.REPLACEITEM is not null and p2.REPLACEITEM <> ' ' ");
        if (theDbType != null && theDbType.toString().equalsIgnoreCase("postgresql")) {
            selectDupNumberSQL.append("and p2.REPLACEITEM <> '' ");
        }
        selectDupNumberSQL.append("and mainmenuitem.REPLACEITEM = p2.REPLACEITEM) ").append("and sysmenuitem.fid = p2.fid ").append("and not exists ").append("(select 1 ").append("from T_BAS_SysMenuItem p1, T_PM_MainMenuItem q1 ").append("where p1.FID = q1.FSysMenuID ").append("and p1.FID = p2.fid) ").append("and not exists ").append("(select 1 from T_PM_MainMenuItem q2 where q2.fid = p2.fid)").append(industrySQL).append(")");
        return selectDupNumberSQL.toString();
    }

    public static void setMultiLangValue(TreeBaseInfo menuItem, IRowSet rowset) throws SQLException {
        int j = BOSLocaleUtil.EAS_LOCALES.length;
        for (int i = 0; i < j; ++i) {
            String name = rowset.getString("FName_" + BOSLocaleUtil.EAS_LOCALES[i].getLanguage());
            menuItem.setName(name, BOSLocaleUtil.EAS_LOCALES[i]);
            String description = rowset.getString("FDescription_" + BOSLocaleUtil.EAS_LOCALES[i].getLanguage());
            menuItem.setDescription(description, BOSLocaleUtil.EAS_LOCALES[i]);
            String displayName = rowset.getString("FDisplayName_" + BOSLocaleUtil.EAS_LOCALES[i].getLanguage());
            menuItem.setDisplayName(displayName, BOSLocaleUtil.EAS_LOCALES[i]);
        }
    }

    private static String getMainMenuItemCols() {
        StringBuffer mainMenuItemCols = new StringBuffer();
        mainMenuItemCols.append("select ").append(CustMenuAutoUpdateForDB.getQueryFields()).append(" from T_PM_MainMenuItem ");
        return mainMenuItemCols.toString();
    }

    private static StringBuffer getQueryFields() {
        StringBuffer queryFields = new StringBuffer();
        queryFields.append(" FID, ");
        int j = BOSLocaleUtil.EAS_LOCALES.length;
        for (int i = 0; i < j; ++i) {
            queryFields.append("FName_" + BOSLocaleUtil.EAS_LOCALES[i].getLanguage()).append(",");
            queryFields.append("FDescription_" + BOSLocaleUtil.EAS_LOCALES[i].getLanguage()).append(",");
            queryFields.append("FDisplayName_" + BOSLocaleUtil.EAS_LOCALES[i].getLanguage()).append(",");
        }
        queryFields.append("FNumber,FLongNumber,FParent,FLevel,FIsLeaf,FOrder,FImagePath,FEnabled,FVisible,FIsReport,").append("FUiClassName,FUiClassParam,FUiOprt,FOpenMethod,FShortcutCode,FFunction,FIndustry,FNoSuit,FMenutype,FCreatorID,FLastUpdateUserID,FControlUnitID ");
        return queryFields;
    }

    private static Object[] getMainMenuItemParamList(MainMenuItemInfo newMenu) throws SQLException, BOSException {
        Object[] valueList = new Object[36];
        int n = 0;
        valueList[n++] = newMenu.getId().toString();
        int j = BOSLocaleUtil.EAS_LOCALES.length;
        for (int i = 0; i < j; ++i) {
            valueList[n++] = newMenu.getName(BOSLocaleUtil.EAS_LOCALES[i]);
            valueList[n++] = newMenu.getDescription(BOSLocaleUtil.EAS_LOCALES[i]);
            valueList[n++] = newMenu.getDisplayName(BOSLocaleUtil.EAS_LOCALES[i]);
        }
        valueList[n++] = newMenu.getNumber();
        valueList[n++] = newMenu.getLongNumber();
        valueList[n++] = null != newMenu.getParent() ? newMenu.getParent().getId().toString() : null;
        valueList[n++] = newMenu.getLevel();
        valueList[n++] = newMenu.isIsLeaf() ? 1 : 0;
        valueList[n++] = newMenu.getOrder();
        valueList[n++] = newMenu.getImagePath();
        valueList[n++] = newMenu.isEnabled() ? 1 : 0;
        valueList[n++] = newMenu.isVisible() ? 1 : 0;
        valueList[n++] = newMenu.isIsReport() ? 1 : 0;
        valueList[n++] = newMenu.getUiClassName();
        valueList[n++] = newMenu.getUiClassParam();
        valueList[n++] = newMenu.getUiOprt();
        valueList[n++] = newMenu.getOpenMethod().getValue();
        valueList[n++] = newMenu.getShortcutCode();
        String permItemId = null;
        if (newMenu.getFunction() != null) {
            permItemId = newMenu.getFunction().getId().toString();
        }
        valueList[n++] = permItemId;
        valueList[n++] = newMenu.getIndustry().getValue();
        valueList[n++] = newMenu.getNoSuit();
        valueList[n++] = newMenu.getMenutype().getValue();
        String createUserId = null;
        if (newMenu.getCreator() != null) {
            createUserId = newMenu.getCreator().getId().toString();
        }
        valueList[n++] = createUserId;
        String updateUserId = null;
        if (newMenu.getLastUpdateUser() != null) {
            updateUserId = newMenu.getLastUpdateUser().getId().toString();
        }
        valueList[n++] = updateUserId;
        valueList[n++] = newMenu.getCU() != null ? newMenu.getCU().getId().toString() : "11111111-1111-1111-1111-111111111111CCE7AED4";
        valueList[n++] = newMenu.getSimpleName();
        Timestamp createtime = new Timestamp(new Date().getTime());
        valueList[n++] = createtime;
        valueList[n++] = createtime;
        String sysMenuId = null;
        if (newMenu.getSysMenu() != null) {
            sysMenuId = newMenu.getSysMenu().getId().toString();
        }
        valueList[n++] = sysMenuId;
        return valueList;
    }
}

