/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.kingdee.eas.base.uiframe.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FileProcessUtil {
    private static final Logger logger = Logger.getLogger(FileProcessUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readProperties(String filePath) {
        Properties prop = new Properties();
        InputStream in = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            in = new BufferedInputStream(new FileInputStream(filePath));
            prop.load(in);
            for (String key : prop.stringPropertyNames()) {
                map.put(key, prop.getProperty(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProperties(String path, Map<String, String> map) {
        FileInputStream fileInputStream = null;
        OutputStream fos = null;
        try {
            fileInputStream = new FileInputStream(path);
            Properties prop = new Properties();
            prop.load(fileInputStream);
            fos = new FileOutputStream(path);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                prop.setProperty(entry.getKey(), entry.getValue());
            }
            prop.store(fos, "");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
    }

    public static String processData(String data, String message) {
        String processData = data;
        try {
            String[] params = data.trim().split("/");
            String[] msg = message.trim().split("/");
            long time = 0L;
            int count = Integer.valueOf(params[3]);
            long maxNum = Long.valueOf(params[6]);
            long allTime = Long.valueOf(params[5]);
            long minNum = Long.valueOf(params[7]);
            if (msg.length == 2) {
                time = Long.valueOf(msg[1]);
                if (time > maxNum) {
                    params[6] = String.valueOf(time);
                } else if (time < minNum) {
                    params[7] = String.valueOf(time);
                }
                params[5] = String.valueOf(allTime += time);
                ++count;
            }
            if (msg.length == 4) {
                long minTime = Long.valueOf(msg[1]);
                long maxTime = Long.valueOf(msg[0]);
                if (maxTime > maxNum) {
                    params[6] = String.valueOf(maxTime);
                }
                if (minTime < minNum) {
                    params[7] = String.valueOf(minTime);
                }
                count += Integer.valueOf(msg[2]).intValue();
                params[5] = String.valueOf(allTime += Long.valueOf(msg[3]).longValue());
            }
            params[3] = String.valueOf(count);
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < params.length; ++i) {
                buffer.append(params[i]);
                if (i == params.length - 1) continue;
                buffer.append("/");
            }
            processData = buffer.toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return processData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePropertiesByStream(InputStream ins, String path) {
        FileOutputStream fos = null;
        try {
            Properties prop = new Properties();
            prop.load(ins);
            fos = new FileOutputStream(path);
            prop.store(fos, "");
        }
        catch (Exception exception) {
            StreamUtils.closeStream(fos);
        }
        catch (Throwable throwable) {
            StreamUtils.closeStream(fos);
            throw throwable;
        }
        StreamUtils.closeStream(fos);
    }

    public static Map<String, String> readPropertiesByStream(InputStream ins) {
        Properties prop = new Properties();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            prop.load(ins);
            for (String key : prop.stringPropertyNames()) {
                map.put(key, prop.getProperty(key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public static void main(String[] args) {
        HashMap<String, String> clientMap = new HashMap<String, String>();
        clientMap.put("eas\\hr\\base\\client\\AgeSegmentEditUI_ActionSubmit", "LL-20170825-0052/%E9%87%91%E8%9D%B6EASV8.2.0/256c221a-0106-1000-e000-10d7c0a813f413B7DE7F/3/eas\\hr\\base\\client\\AgeSegmentEditUI_ActionSubmit/3677/2345/677/2017-11-08");
        HashMap<String, String> serverMap = new HashMap<String, String>();
        serverMap.put("eas\\hr\\base\\client\\AgeSegmentEditUI_ActionSubmit", "LL-20170825-0052/%E9%87%91%E8%9D%B6EASV8.2.0/256c221a-0106-1000-e000-10d7c0a813f413B7DE7F/3/eas\\hr\\base\\client\\AgeSegmentEditUI_ActionSubmit/3677/1345/577/2017-11-08");
        Map<String, String> map = FileProcessUtil.processDataBatch(clientMap, serverMap);
        System.out.println(map.get("eas\\hr\\base\\client\\AgeSegmentEditUI_ActionSubmit"));
    }

    public static Map<String, String> processDataBatch(Map<String, String> clientMap, Map<String, String> serverMap) {
        HashMap<String, String> updateMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : clientMap.entrySet()) {
            if (serverMap.containsKey(entry.getKey())) {
                String[] params = entry.getValue().split("/");
                StringBuffer buffer = new StringBuffer();
                buffer.append(params[params.length - 3]);
                buffer.append("/");
                buffer.append(params[params.length - 2]);
                buffer.append("/");
                buffer.append(params[params.length - 6]);
                buffer.append("/");
                buffer.append(params[params.length - 4]);
                String realData = FileProcessUtil.processData(serverMap.get(entry.getKey()), buffer.toString());
                updateMap.put(entry.getKey(), realData);
                continue;
            }
            updateMap.put(entry.getKey(), entry.getValue());
        }
        return updateMap;
    }
}

