/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseController;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.LicenseRegisterCenter;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.MD5;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.client.MenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.ui.web20.statistics.StatisticsUtil;
import com.kingdee.eas.base.uiframe.utils.MDEncodeUtil;
import com.kingdee.eas.base.uiframe.utils.XMLElement;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPath;

public class KingdeeServiceUtil {
    private static final Logger logger = Logger.getLogger(KingdeeServiceUtil.class);
    private static String productNo;
    public static final String EASROOT = "easclient.root";
    private static final String DEFAULTROOTDIR = "C:/kingdee/eas";
    private static XMLConfiguration ksmconfiguration;
    public static final String KSMCONFIGFILE = "client/deploy/client/ksm.xml";
    private static final String FProductID = "FProductID";
    private static final String FProductVer = "FProductVer";
    private static final String FProductRegNO = "FProductRegNO";
    private static final String FAdditionalInfo = "FAdditionalInfo";
    private static final String FServerAdditionalInfo = "FServerAdditionalInfo";
    private static final String FCustName = "FCustName";
    private static final String FAccountID = "FAccountID";
    private static final String FUserId = "FUserId";
    private static final String FUserName = "FUserName";
    private static final String FRole = "FRole";
    private static final String FHash = "FHash";
    private static final String FGroupName = "FGroupName";
    private static final String FEmail = "FEmail";
    private static final String FTelephone = "FTelephone";
    private static final String FMobile = "FMobile";
    private static final String PRODUCT_ID = "S3S001S001";
    private static final String PRIMARY_KEY = "kisplat20120420-ywjtsplxhds-zhxlsy-hswcw-2342cb602bc8";

    public static void loadKSMSetControlFile() {
        String localDirName = System.getProperty("EAS_HOME");
        logger.debug((Object)("System.getProperty(EAS_HOME)=" + localDirName));
        String fileName = org.apache.commons.lang.StringUtils.isEmpty((String)localDirName) ? "C:/kingdee/eas/client/deploy/client/ksm.xml" : localDirName.trim() + "/" + KSMCONFIGFILE;
        logger.debug((Object)("loadKSMSetControlFile.fileName=" + fileName));
        File cfgFile = new File(fileName);
        if (cfgFile.exists()) {
            try {
                ksmconfiguration = XMLConfiguration.getInstance((File)cfgFile);
            }
            catch (Throwable e) {
                ksmconfiguration = null;
                logger.error((Object)("load file ksm.xml  fail" + fileName));
            }
        } else {
            logger.error((Object)"cann't find the config file ksm.xml!");
        }
    }

    public static void init() {
        if (null == ksmconfiguration) {
            KingdeeServiceUtil.loadKSMSetControlFile();
        }
    }

    public static String getKSMURLClient() {
        String url = "";
        KingdeeServiceUtil.init();
        ConfigurationItem configItem = null;
        if (null != ksmconfiguration) {
            configItem = ksmconfiguration.getConfigItem("ksm");
            url = configItem.getProperty("url");
        }
        logger.debug((Object)("getKSMURLClient.url=" + url));
        if (org.apache.commons.lang.StringUtils.isEmpty((String)url)) {
            String msgInfo = EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFrameResource", (String)"KSM_URL_MSG");
            MsgBox.showInfo((String)msgInfo);
            return url;
        }
        try {
            IUIObject uiObject = SystemEntry.instance.getMainUIObject().getSelectedUIObject();
            String menu = uiObject.getMetaDataPK().toString().replace("\\", ".");
            logger.info((Object)(" \n the menu is " + menu + "\n"));
            String pageUrl = KingdeeServiceUtil._linkToFeedbackPage(menu);
            logger.debug((Object)("getKSMURLClient.textJson=" + pageUrl));
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)pageUrl)) {
                url = url + "?text=" + pageUrl;
            }
        }
        catch (BOSException e) {
            logger.error((Object)("BOSException url = " + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return url;
    }

    public static String getRealSitUrl() {
        return KingdeeServiceUtil.getRealSitUrl(false);
    }

    public static String getRealSitUrlFromServer() {
        return KingdeeServiceUtil.getRealSitUrl(true);
    }

    private static String getRealSitUrl(boolean isServer) {
        String patchServiceIpOrName = "service.kingdee.com";
        String url = "http://" + patchServiceIpOrName + "/csso/customer/productLogin.action";
        try {
            String productNo = isServer ? KingdeeServiceUtil.getProductNumberFromServer() : KingdeeServiceUtil.getProductNumberFromClient();
            String productno = "productno=" + productNo;
            SimpleDateFormat myFmt = new SimpleDateFormat("yyyy-MM-dd");
            Date date = new Date(System.currentTimeMillis());
            String sDate = myFmt.format(date);
            String clientIP = "";
            String clientIPUrl = "http://" + patchServiceIpOrName + "/csso/customer/getClientIP.action";
            URL resource = new URL(clientIPUrl);
            URLConnection cn = resource.openConnection();
            InputStream in = cn.getInputStream();
            XMLElement ele = new XMLElement();
            InputStreamReader reader = new InputStreamReader(in);
            ele.parseFromReader(reader);
            reader.close();
            clientIP = ele.getContent();
            String hash = "&hash=" + MDEncodeUtil.MD5Encode(productNo + sDate + clientIP);
            url = isServer ? url + "?" + productno + hash : url + "?" + productno + "^" + hash;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return url;
    }

    private static String getProductNumberFromClient() {
        if (productNo != null) {
            return productNo;
        }
        try {
            String no;
            productNo = no = LicenseController.getInstance().getProductNo();
            return productNo;
        }
        catch (LicenseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getProductNumberFromServer() {
        try {
            LicenseRegisterCenter licenseCenter = LicenseRegisterCenter.getInstance();
            licenseCenter.initialInstance();
            return licenseCenter.getProductNo();
        }
        catch (LicenseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String _linkToFeedbackPage(String menuPath) throws BOSException {
        String newMenuCacheXML = MenuVisitorHelper.getCacheDir() + "newMenuCache.xml";
        String locale = SysContext.getSysContext().getLocale().toString();
        try {
            HashMap<String, String> modeMap = new HashMap<String, String>();
            Document doc = KingdeeServiceUtil.analyzFile2Doc(newMenuCacheXML);
            Element rootEle = doc.getRootElement();
            Element currentMenu = (Element)XPath.selectSingleNode((Object)rootEle, (String)("//PARENT/MENU[uiclassname='" + menuPath + "']"));
            if (currentMenu == null) {
                if (menuPath.equals("com.kingdee.eas.base.uiframe.client.NewMainFunctionMenuUI")) {
                    KingdeeServiceUtil.getSubMenuOfMainUI(locale, modeMap, rootEle);
                } else {
                    KingdeeServiceUtil.getSubMenuOfCurrentUI(locale, modeMap, menuPath);
                }
            } else {
                String[] longNumber = currentMenu.getChildText("longnumber").split("!");
                Element menu = (Element)XPath.selectSingleNode((Object)rootEle, (String)("//PARENT/MENU[longnumber='" + longNumber[0] + "']"));
                String menuId = menu.getChildText("id");
                Element parentEle = (Element)XPath.selectSingleNode((Object)rootEle, (String)("//PARENT[@id='" + menuId + "']"));
                List allSubEle = parentEle.getChildren();
                for (int j = 0; j < allSubEle.size() && j <= 9; ++j) {
                    Element subEle = (Element)allSubEle.get(j);
                    modeMap.put(subEle.getChildText("number"), subEle.getChildText("name_" + locale));
                }
            }
            String menuParam = KingdeeServiceUtil.getMenuParam(modeMap);
            return menuParam;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getMenuParam(Map modeMap) throws Exception {
        String paramJson = KingdeeServiceUtil.constructJosnPara();
        String modsJson = null;
        if (modeMap.size() != 0) {
            modsJson = KingdeeServiceUtil.getJSONForMode(modeMap);
        }
        String param = null;
        if (modsJson != null) {
            param = paramJson.subSequence(0, paramJson.length() - 1) + ",\"FMods\":[" + modsJson + "]}";
        }
        String realParam = "";
        if (!StringUtils.isEmpty(param)) {
            realParam = param.replace("null", "");
        }
        return realParam;
    }

    public static String constructJosnPara() {
        try {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            JSONObject textJson = new JSONObject();
            textJson.accumulate(FProductID, (Object)PRODUCT_ID);
            textJson.accumulate(FProductVer, (Object)baseInfo.getVersion().toString());
            String productRegNO = baseInfo.getSerialNum();
            textJson.accumulate(FProductRegNO, (Object)URLEncoder.encode(productRegNO, "UTF-8"));
            String additionalInfo = baseInfo.getMechineCode();
            textJson.accumulate(FAdditionalInfo, (Object)additionalInfo);
            String serverAdditionalInfo = baseInfo.getUser();
            textJson.accumulate(FServerAdditionalInfo, (Object)URLEncoder.encode(serverAdditionalInfo, "UTF-8"));
            String cusName = baseInfo.getLicenseTo();
            textJson.accumulate(FCustName, (Object)URLEncoder.encode(cusName, "UTF-8"));
            String accountId = SysContext.getSysContext().getDCNumber();
            textJson.accumulate(FAccountID, (Object)accountId);
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            textJson.accumulate(FUserId, (Object)userId);
            String userName = SysContext.getSysContext().getUserName();
            textJson.accumulate(FUserName, (Object)userName);
            String userRole = StatisticsUtil.getUserRoleInputStream();
            textJson.accumulate(FRole, (Object)userRole);
            String md5Str = productRegNO + ":" + additionalInfo + ":" + accountId + ":" + userId + ":" + PRIMARY_KEY;
            String hash = MD5.md5Hash(md5Str.replace("null", "")).toUpperCase();
            textJson.accumulate(FHash, (Object)hash);
            String orgName = SysContext.getSysContext().getCurrentUserInfo().getDefOrgUnit().getName();
            textJson.accumulate(FGroupName, (Object)orgName);
            String email = SysContext.getSysContext().getCurrentUserInfo().getEmail();
            textJson.accumulate(FEmail, (Object)email);
            String telephone = SysContext.getSysContext().getCurrentUserInfo().getOfficePhone();
            textJson.accumulate(FTelephone, (Object)telephone);
            String mobile = SysContext.getSysContext().getCurrentUserInfo().getCell();
            textJson.accumulate(FMobile, (Object)mobile);
            return textJson.toString();
        }
        catch (Exception e) {
            logger.info((Object)"\u6784\u9020\u4e91\u8bc4\u4ef7\u63a5\u53e3\u53c2\u6570\u5f02\u5e38!", (Throwable)e);
            return null;
        }
    }

    private static String getJSONForMode(Map jsonStr) throws Exception {
        Object key = null;
        Object val = null;
        String newVal = null;
        StringBuffer bf = new StringBuffer();
        for (Map.Entry entry : jsonStr.entrySet()) {
            key = entry.getKey();
            val = entry.getValue();
            if (val != null) {
                newVal = URLEncoder.encode(val.toString(), "UTF-8");
            }
            bf.append("{\"FCode\":\"").append((Object)key).append("\",\"FDesc\":\"").append((Object)newVal).append("\"},");
        }
        return bf.subSequence(0, bf.length() - 1).toString();
    }

    private static void getSubMenuOfMainUI(String locale, HashMap modeMap, Element rootEle) throws JDOMException, BOSException, EASBizException, SQLException {
        Element tomMenu = (Element)XPath.selectSingleNode((Object)rootEle, (String)"//PARENT[@id='topMenu']");
        List parentEleList = tomMenu.getChildren();
        if (parentEleList == null || parentEleList.size() == 0) {
            return;
        }
        block0: for (Element parentEle : parentEleList) {
            String parentId = parentEle.getChildText("id");
            Element menuEle = (Element)XPath.selectSingleNode((Object)rootEle, (String)("//PARENT[@id='" + parentId + "']"));
            if (modeMap.size() >= 10) break;
            if (menuEle == null) {
                Map subMenu = MainFunctionMenuFactory.getRemoteInstance().getChildMenuByParent(parentId);
                if (subMenu == null || subMenu.size() == 0) continue;
                List subList = (List)subMenu.get(parentId);
                for (MainMenuItemInfo menu : subList) {
                    if (modeMap.size() >= 10) continue block0;
                    modeMap.put(menu.get("number"), menu.get("name_" + locale));
                }
                continue;
            }
            List menuList = menuEle.getChildren();
            if (menuList == null || menuList.size() == 0) continue;
            for (Element menu : menuList) {
                if (modeMap.size() >= 10) continue block0;
                modeMap.put(menu.getChildText("number"), menu.getChildText("name_" + locale));
            }
        }
    }

    private static void getSubMenuOfCurrentUI(String locale, HashMap modeMap, String menuPath) {
        try {
            CoreBaseCollection collection = MainMenuItemFactory.getRemoteInstance().getCollection("select * where uiclassname = '" + menuPath + "'");
            if (collection == null || collection.size() == 0) {
                return;
            }
            CoreBaseInfo longNumber = collection.get(0);
            String firstLongNumber = longNumber.getString("longnumber").split("!")[0];
            CoreBaseInfo parientMenu = MainMenuItemFactory.getRemoteInstance().getValue("select * where longnumber = '" + firstLongNumber + "'");
            String parientMenuId = parientMenu.getString("id");
            Map subMenu = MainFunctionMenuFactory.getRemoteInstance().getChildMenuByParent(parientMenuId);
            if (subMenu == null || subMenu.size() == 0) {
                return;
            }
            List subList = (List)subMenu.get(parientMenuId);
            for (MainMenuItemInfo menu : subList) {
                if (modeMap.size() < 10) {
                    modeMap.put(menu.get("number"), menu.get("name_" + locale));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u53d6\u5f53\u524dUI\u5bf9\u5e94\u4e00\u7ea7\u83dc\u5355\u5f02\u5e38\uff0c\u5f53\u524dUI:" + menuPath), (Throwable)e);
            return;
        }
    }

    private static Document analyzFile2Doc(String filePath) throws Exception {
        SAXBuilder sax = new SAXBuilder();
        Document doc = new Document();
        doc = sax.build("file:\\" + filePath);
        return doc;
    }
}

