/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.MenuModifyFieldCollection;
import com.kingdee.eas.base.permission.MenuModifyFieldInfo;
import com.kingdee.eas.base.uiframe.utils.MenuUpdateManager;
import com.kingdee.eas.framework.TreeBaseInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MainMenuUpdateManager
implements MenuUpdateManager {
    private DefaultKingdeeTreeNode olderNode = null;
    private MainMenuItemInfo newInfo = null;
    private MainMenuItemInfo updatedInfo = null;
    private boolean isNameChanaged = false;
    private boolean isNumberChanged = false;
    private boolean isUpdate = false;
    private Map<String, TreeBaseInfo> changedNodeInfos = new HashMap<String, TreeBaseInfo>();
    private boolean isVisibleChanged = false;
    private boolean isVisible = true;

    public MainMenuUpdateManager(DefaultKingdeeTreeNode olderNode, MainMenuItemInfo newInfo) {
        this.olderNode = olderNode;
        this.newInfo = newInfo;
    }

    public MainMenuItemInfo getComparedInfo() {
        return this.updatedInfo;
    }

    @Override
    public void doCompare() {
        this.compare();
        if (this.isNumberChanged) {
            this.updateSubNodeLongNumber(this.olderNode);
        }
        if (this.isVisibleChanged) {
            this.updateSubNodeVisible(this.olderNode);
        } else if (this.isUpdate && !this.isNumberChanged && !this.isVisibleChanged) {
            this.changedNodeInfos.put(this.updatedInfo.getId().toString(), (TreeBaseInfo)this.updatedInfo);
        }
    }

    private void updateSubNodeVisible(DefaultKingdeeTreeNode kdTreeNode) {
        MainMenuItemInfo menuInfo = (MainMenuItemInfo)kdTreeNode.getUserObject();
        menuInfo.setVisible(this.isVisible);
        menuInfo.setIsModified(true);
        if (!this.isFieldNameExists("FVisible", menuInfo)) {
            MenuModifyFieldInfo modifyInfo = new MenuModifyFieldInfo();
            modifyInfo.setMainMenu(menuInfo);
            modifyInfo.setFieldName("FVisible");
            menuInfo.getModifyFields().add(modifyInfo);
        }
        kdTreeNode.setUserObject((Object)menuInfo);
        if (this.changedNodeInfos.get(menuInfo.getId().toString()) == null) {
            this.changedNodeInfos.put(menuInfo.getId().toString(), (TreeBaseInfo)menuInfo);
        }
        if (kdTreeNode.getChildCount() > 0) {
            MainMenuItemInfo subNodeInfo = null;
            int j = kdTreeNode.getChildCount();
            for (int i = 0; i < j; ++i) {
                subNodeInfo = (MainMenuItemInfo)((DefaultKingdeeTreeNode)kdTreeNode.getChildAt(i)).getUserObject();
                subNodeInfo.setVisible(this.isVisible);
                this.updateSubNodeVisible((DefaultKingdeeTreeNode)kdTreeNode.getChildAt(i));
            }
        }
    }

    private boolean isFieldNameExists(String fieldName, MainMenuItemInfo menuInfo) {
        MenuModifyFieldCollection coll = menuInfo.getModifyFields();
        if (coll == null && coll.size() == 0) {
            return false;
        }
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            MenuModifyFieldInfo info = coll.get(i);
            if (!fieldName.equals(info.getFieldName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public TreeBaseInfo getUpdateInfo() {
        return this.updatedInfo;
    }

    @Override
    public Map<String, TreeBaseInfo> getChangedCollection() {
        return this.changedNodeInfos;
    }

    @Override
    public boolean isNeedUpdateUITree() {
        return this.isNameChanaged;
    }

    @Override
    public boolean isInfoUpdate() {
        return this.isUpdate;
    }

    private void updateSubNodeLongNumber(DefaultKingdeeTreeNode kdTreeNode) {
        MainMenuItemInfo menuInfo = (MainMenuItemInfo)kdTreeNode.getUserObject();
        menuInfo.setLongNumber(this.changeLongNumber(menuInfo.getLongNumber(), menuInfo.getNumber()));
        menuInfo.setIsModified(true);
        if (!this.isFieldNameExists("FLongNumber", menuInfo)) {
            MenuModifyFieldInfo modifyInfo = new MenuModifyFieldInfo();
            modifyInfo.setMainMenu(menuInfo);
            modifyInfo.setFieldName("FLongNumber");
            menuInfo.getModifyFields().add(modifyInfo);
        }
        kdTreeNode.setUserObject((Object)menuInfo);
        this.changedNodeInfos.put(menuInfo.getId().toString(), (TreeBaseInfo)menuInfo);
        if (kdTreeNode.getChildCount() > 0) {
            MainMenuItemInfo subNodeInfo = null;
            int j = kdTreeNode.getChildCount();
            for (int i = 0; i < j; ++i) {
                subNodeInfo = (MainMenuItemInfo)((DefaultKingdeeTreeNode)kdTreeNode.getChildAt(i)).getUserObject();
                subNodeInfo.setLongNumber(menuInfo.getLongNumber() + "!" + subNodeInfo.getNumber());
                this.updateSubNodeLongNumber((DefaultKingdeeTreeNode)kdTreeNode.getChildAt(i));
            }
        }
    }

    private void compare() {
        MenuModifyFieldInfo info;
        MainMenuItemInfo olderInfo = (MainMenuItemInfo)this.olderNode.getUserObject();
        this.updatedInfo = (MainMenuItemInfo)this.olderNode.getUserObject();
        boolean propChangedTag = false;
        MenuModifyFieldCollection modifyColl = new MenuModifyFieldCollection();
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo currentLang2 = null;
        while (iter.hasNext()) {
            currentLang2 = (LanguageInfo)iter.next();
            propChangedTag = !this.isSameString(olderInfo.getName(currentLang2.getLocale()), this.newInfo.getName(currentLang2.getLocale()));
            this.isNameChanaged = propChangedTag | this.isNameChanaged;
            this.isUpdate |= propChangedTag;
            if (!propChangedTag) continue;
            this.updatedInfo.setName(this.newInfo.getName(currentLang2.getLocale()), currentLang2.getLocale());
            info = new MenuModifyFieldInfo();
            info.setMainMenu(this.updatedInfo);
            if (currentLang2.getLocale() != null) {
                info.setFieldName("FName_" + currentLang2.getLocale().toString().toUpperCase());
            } else {
                info.setFieldName("FName_L2");
            }
            modifyColl.add(info);
        }
        this.isNumberChanged = propChangedTag = !this.isSameString(olderInfo.getNumber(), this.newInfo.getNumber());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setNumber(this.newInfo.getNumber());
            info = new MenuModifyFieldInfo();
            info.setMainMenu(this.updatedInfo);
            info.setFieldName("FNumber");
            modifyColl.add(info);
        }
        propChangedTag = !this.isSameString(olderInfo.getImagePath(), this.newInfo.getImagePath());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setImagePath(this.newInfo.getImagePath());
            info = new MenuModifyFieldInfo();
            info.setMainMenu(this.updatedInfo);
            info.setFieldName("FImagePath");
            modifyColl.add(info);
        }
        propChangedTag = !this.isSameString(olderInfo.getUiClassName(), this.newInfo.getUiClassName());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setUiClassName(this.newInfo.getUiClassName());
            info = new MenuModifyFieldInfo();
            info.setMainMenu(this.updatedInfo);
            info.setFieldName("FUiClassName");
            modifyColl.add(info);
        }
        propChangedTag = null == olderInfo.getOpenMethod() && null != this.newInfo.getOpenMethod() || null != olderInfo.getOpenMethod() && null == this.newInfo.getOpenMethod() ? true : (null == olderInfo.getOpenMethod() && null == this.newInfo.getOpenMethod() ? false : olderInfo.getOpenMethod().getValue() != this.newInfo.getOpenMethod().getValue());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setOpenMethod(this.newInfo.getOpenMethod());
            info = new MenuModifyFieldInfo();
            info.setMainMenu(this.updatedInfo);
            info.setFieldName("FOpenMethod");
            modifyColl.add(info);
        }
        propChangedTag = !this.isSameString(olderInfo.getShortcutCode(), this.newInfo.getShortcutCode());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setShortcutCode(this.newInfo.getShortcutCode());
            info = new MenuModifyFieldInfo();
            info.setMainMenu(this.updatedInfo);
            info.setFieldName("FShortcutCode");
            modifyColl.add(info);
        }
        propChangedTag = null == olderInfo.getFunction() && null != this.newInfo.getFunction() || null != olderInfo.getFunction() && null == this.newInfo.getFunction() ? true : (null == olderInfo.getFunction() && null == this.newInfo.getFunction() ? false : !olderInfo.getFunction().getId().toString().trim().equals(this.newInfo.getFunction().getId().toString().trim()));
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setFunction(this.newInfo.getFunction());
            info = new MenuModifyFieldInfo();
            info.setMainMenu(this.updatedInfo);
            info.setFieldName("FFunction");
            modifyColl.add(info);
        }
        langList = KDBizMultiLangBox.getLanguageList();
        for (LanguageInfo currentLang2 : langList) {
            propChangedTag = !this.isSameString(olderInfo.getDescription(currentLang2.getLocale()), this.newInfo.getDescription(currentLang2.getLocale()));
            this.isUpdate |= propChangedTag;
            if (!propChangedTag) continue;
            this.updatedInfo.setDescription(this.newInfo.getDescription(currentLang2.getLocale()), currentLang2.getLocale());
            info = new MenuModifyFieldInfo();
            info.setMainMenu(this.updatedInfo);
            if (currentLang2.getLocale() != null) {
                info.setFieldName("FDescription_" + currentLang2.getLocale().toString().toUpperCase());
            } else {
                info.setFieldName("FDescription_L2");
            }
            modifyColl.add(info);
        }
        propChangedTag = !this.isSameString(olderInfo.getUiClassParam(), this.newInfo.getUiClassParam());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setUiClassParam(this.newInfo.getUiClassParam());
            info = new MenuModifyFieldInfo();
            info.setMainMenu(this.updatedInfo);
            info.setFieldName("FUiClassParam");
            modifyColl.add(info);
        }
        propChangedTag = !this.isSameString(olderInfo.getUiOprt(), this.newInfo.getUiOprt());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setUiOprt(this.newInfo.getUiOprt());
            info = new MenuModifyFieldInfo();
            info.setMainMenu(this.updatedInfo);
            info.setFieldName("FUiOprt");
            modifyColl.add(info);
        }
        propChangedTag = olderInfo.isEnabled() != this.newInfo.isEnabled();
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setEnabled(this.newInfo.isEnabled());
            info = new MenuModifyFieldInfo();
            info.setMainMenu(this.updatedInfo);
            info.setFieldName("FEnabled");
            modifyColl.add(info);
        }
        propChangedTag = olderInfo.isVisible() != this.newInfo.isVisible();
        this.isVisibleChanged = propChangedTag;
        this.isUpdate |= propChangedTag;
        this.isVisible = this.newInfo.isVisible();
        if (propChangedTag) {
            this.updatedInfo.setVisible(this.newInfo.isVisible());
            info = new MenuModifyFieldInfo();
            info.setMainMenu(this.updatedInfo);
            info.setFieldName("FVisible");
            modifyColl.add(info);
        }
        if (this.isUpdate) {
            this.updatedInfo.setIsModified(true);
            MenuModifyFieldCollection colls = this.updatedInfo.getModifyFields();
            MenuModifyFieldInfo info2 = null;
            for (int j = 0; j < modifyColl.size(); ++j) {
                info2 = modifyColl.get(j);
                if (this.isFieldNameExist(info2.getFieldName(), colls)) continue;
                colls.add(info2);
            }
        }
    }

    private boolean isFieldNameExist(String fieldName, MenuModifyFieldCollection colls) {
        boolean isExist = false;
        for (int i = 0; i < colls.size(); ++i) {
            if (!fieldName.equalsIgnoreCase(colls.get(i).getFieldName())) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    private String changeLongNumber(String olderLongNum, String newNum) {
        String newLongNum = null;
        String[] numberArray = olderLongNum.split("!");
        int len = numberArray.length;
        if (len == 1) {
            newLongNum = newNum;
        } else {
            numberArray[numberArray.length - 1] = newNum;
            StringBuffer longNumBuff = new StringBuffer();
            int j = numberArray.length;
            for (int i = 0; i < j; ++i) {
                if (i != 0) {
                    longNumBuff.append("!");
                }
                longNumBuff.append(numberArray[i]);
            }
            newLongNum = longNumBuff.toString();
        }
        return newLongNum;
    }

    private boolean isSameString(String theString, String toString) {
        boolean sameTag = true;
        if (this.isStringEmpty(theString) && !this.isStringEmpty(toString) || !this.isStringEmpty(theString) && this.isStringEmpty(toString)) {
            sameTag = false;
        } else if (this.isStringEmpty(theString) && this.isStringEmpty(toString)) {
            sameTag = theString.trim().equalsIgnoreCase(toString.trim());
        }
        return sameTag;
    }

    private boolean isStringEmpty(String theString) {
        boolean emptyTag = false;
        if (null != theString && theString.trim().length() > 0) {
            emptyTag = true;
        }
        return emptyTag;
    }
}

