/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.license.server.LicenseMemoryPool;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.usermonitor.KickoutFacadeFactory;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.app.UserMonitorRegistryManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserMonitorThread
extends Thread {
    private static Logger log = Logger.getLogger((String)UserMonitorThread.class.getName());
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.base.usermonitor.UserMonitorServerResource";
    private Context ctx;
    private volatile boolean stop;
    private static final long sleepTimeInMinutes = 3L;
    private LicenseMemoryPool memoryPool = LicenseMemoryPool.getInstance();

    public UserMonitorThread() {
        super("UserMonitorThread");
    }

    public void stopThread() {
        this.stop = true;
    }

    public boolean isStopped() {
        return this.stop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.stop = false;
        while (!this.stop) {
            try {
                long sleepTime = 180000L;
                Thread.sleep(sleepTime);
                Class<UserMonitorThread> clazz = UserMonitorThread.class;
                // MONITORENTER : com.kingdee.eas.base.usermonitor.app.UserMonitorThread.class
                List<UMRegistryInfo> umRegistryInfos = UserMonitorRegistryManager.getInstance().getSessionsIdleTooLong();
                for (UMRegistryInfo umRegistryInfo : umRegistryInfos) {
                    if (!umRegistryInfo.isSendMsg()) {
                        umRegistryInfo.setSendMsg(true);
                        this.sendTickoutMessage(umRegistryInfo);
                        continue;
                    }
                    this.deleteSessionAndUserMonitorInfo(umRegistryInfo);
                }
                // MONITOREXIT : clazz
            }
            catch (Throwable e) {
                log.error((Object)e.getMessage(), e);
                log.info((Object)"in UserMonitorThread.run exception cause UserMonitorThread stoped");
                this.stop = true;
            }
        }
    }

    private void deleteSessionAndUserMonitorInfo(UMRegistryInfo umRegistryInfo) {
        try {
            Context ctx = new Context((IObjectPK)new ObjectUuidPK(umRegistryInfo.getUserId()), "eas", umRegistryInfo.getDataCenterName(), new Locale("l2"));
            KickoutFacadeFactory.getLocalInstance(ctx).interruptSession(umRegistryInfo.getUserName());
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        try {
            UserMonitorRegistryManager manager = UserMonitorRegistryManager.getInstance();
            String userMonitorId = umRegistryInfo.getId();
            manager.deleteSessionAndUserMonitorInfo(userMonitorId, null);
            Set moduleSet = this.memoryPool.getModuleNameBySessionID(userMonitorId);
            for (String module : moduleSet) {
                this.memoryPool.releaseLicenseByMonitorMode(module, userMonitorId);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while trying to delete user monitor info!", (Throwable)e);
        }
    }

    private void sendTickoutMessage(UMRegistryInfo umRegistryInfo) {
        try {
            UserMonitorRegistryManager manager = UserMonitorRegistryManager.getInstance();
            if (!manager.isGUIOrPortalLoginType(umRegistryInfo)) {
                return;
            }
            Context ctx = new Context((IObjectPK)new ObjectUuidPK(umRegistryInfo.getUserId()), "eas", umRegistryInfo.getDataCenterName(), new Locale("l2"));
            boolean needSendTickoutMessages = manager.needSendTickoutMessage(ctx);
            if (!needSendTickoutMessages) {
                return;
            }
            String userName = umRegistryInfo.getUserName();
            String umRegistryId = umRegistryInfo.getId();
            HashMap<Locale, String> serverMap = new HashMap<Locale, String>();
            HashMap<Locale, String> kickOutMap = new HashMap<Locale, String>();
            HashMap<Locale, String> idleTooLongMap = new HashMap<Locale, String>();
            LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
            for (int i = 0; i < allLanguage.length; ++i) {
                Locale curLocal = allLanguage[i].getLocale();
                serverMap.put(curLocal, StringUtils.cnulls((String)ResourceBase.getString((String)RESOURCE_FULLNAME, (String)"server", (Locale)curLocal)));
                kickOutMap.put(curLocal, StringUtils.cnulls((String)ResourceBase.getString((String)RESOURCE_FULLNAME, (String)"kickOut", (Locale)curLocal)));
                idleTooLongMap.put(curLocal, StringUtils.cnulls((String)ResourceBase.getString((String)RESOURCE_FULLNAME, (String)"idleTooLong", (Locale)curLocal)));
            }
            log.debug((Object)("in UserMonitorThread prepare sending message to " + userName));
            manager.sendMessageToUser(ctx, umRegistryId, serverMap, kickOutMap, idleTooLongMap);
            log.debug((Object)("in UserMonitorThread setSendMsg(true) to " + userName));
        }
        catch (Exception e) {
            log.error((Object)"Failed to send kickout message!", (Throwable)e);
        }
    }
}

