/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.usermonitor.UMRegistryCollection;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.util.StatusDBUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ClusterServiceFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.app.IClusterService;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class UserRegistryDBUtil {
    private static Logger logger = Logger.getLogger((String)UserRegistryDBUtil.class.getName());
    private static Context ctx;

    public void addNew(UMRegistryInfo info) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        String boid = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
        boolean isPortalUser = false;
        if (info.getGUIUserId() != null) {
            isPortalUser = true;
        }
        sql.append("insert into T_UM_UserRegistry(fid,FSessionID,FDataCenterName,FUserID,FUserName,FUserRealName,FUserType,FUserCUName,FCurrentMainBizUnitName,FCurrentCtrlUnitId,FClientIPAddress,FLoginTime,FLastOperateTime,FWindowTitle,FActionName,FActionDesc,FIsFinished,FIsSendMsg,FNODE,FLoginAppServerUrl,FLoginType");
        if (isPortalUser) {
            sql.append(",FGUIUSERID");
        }
        sql.append(") values( '").append(boid).append("','").append(info.getId()).append("','").append(info.getDataCenterName()).append("','").append(info.getUserId()).append("','").append(info.getUserName()).append("','").append(info.getUserRealName()).append("',").append(info.getUserType()).append(",'").append(info.getUserCUName()).append("','").append(info.getCurrentMainBizUnitName()).append("','").append(info.getCurrentCtrlUnitId()).append("','").append(info.getClientIPAddress()).append("',").append(this.getSqlDateStr(info.getLoginTime())).append(",").append(this.getSqlDateStr(info.getLastOperateTime())).append(",").append(this.getStr(info.getOpenWindowTitle())).append(",").append(this.getStr(info.getActionName())).append(",").append(this.getStr(info.getActionDescription())).append(",").append(info.isFinished() ? 0 : 1).append(",").append(info.isSendMsg() ? 1 : 0).append(",'").append(this.getNodeStr()).append("','").append(info.getLoginServerURL()).append("','").append(info.getLoginType());
        if (isPortalUser) {
            sql.append("','").append(info.getGUIUserId());
        }
        sql.append("')");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private String getStr(String name) {
        return name == null ? null : "'" + name + "'";
    }

    private String getSqlDateStr(java.util.Date d) {
        String s = BOSLocaleUtil.getDateTimeFormat().format(d);
        return "TO_DATE('" + s + "')";
    }

    public UMRegistryCollection getUMRegistryCollection() throws EASBizException {
        UMRegistryCollection coll = new UMRegistryCollection();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select * from T_UM_UserRegistry");
            while (rs.next()) {
                coll.add(this.getUMRegistryInfo(rs));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return coll;
    }

    private UMRegistryInfo getUMRegistryInfo(IRowSet rs) {
        UMRegistryInfo info = new UMRegistryInfo();
        try {
            info.setId(rs.getString("fsessionid"));
            info.setDataCenterName(rs.getString("fdatacentername"));
            info.setUserId(rs.getString("fuserid"));
            info.setUserName(rs.getString("fusername"));
            info.setUserRealName(rs.getString("fuserrealname"));
            info.setUserType(rs.getInt("fusertype"));
            info.setUserCUName(rs.getString("fusercuname"));
            info.setCurrentMainBizUnitName(rs.getString("fcurrentmainbizunitname"));
            info.setCurrentCtrlUnitId(rs.getString("fcurrentctrlunitid"));
            info.setClientIPAddress(rs.getString("fclientipaddress"));
            info.setLoginTime(rs.getDate("flogintime"));
            info.setLastOperateTime(rs.getDate("flastoperatetime"));
            info.setOpenWindowTitle(rs.getString("FWindowTitle"));
            info.setActionName(rs.getString("factionname"));
            info.setActionDescription(rs.getString("FActionDesc"));
            info.setFinished(rs.getInt("FIsFinished") == 0);
            info.setSendMsg(rs.getInt("FisSendMsg") == 1);
            info.setLoginServerURL(rs.getString("FLoginAppServerUrl"));
            info.setGUIUserId(rs.getString("FGUIUserId"));
            info.setLoginType(rs.getInt("FLoginType"));
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return info;
    }

    public UMRegistryCollection getCollectionByDataCenter(String dataCenterName) throws EASBizException {
        UMRegistryCollection coll = new UMRegistryCollection();
        StringBuffer sb = new StringBuffer("select * from T_UM_UserRegistry where FDataCenterName= ? ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{dataCenterName});
            while (rs.next()) {
                coll.add(this.getUMRegistryInfo(rs));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return coll;
    }

    public UMRegistryCollection getCollectionByOrgRange(String dataCenterName, List orgList) throws EASBizException {
        UMRegistryCollection coll;
        StringBuffer rangeSQL = new StringBuffer();
        if (orgList != null && orgList.size() > 0) {
            for (int i = 0; i < orgList.size(); ++i) {
                if (i == orgList.size() - 1) {
                    rangeSQL.append("'").append(orgList.get(i)).append("'");
                    continue;
                }
                rangeSQL.append("'").append(orgList.get(i)).append("',");
            }
        }
        if ((coll = this.getRegistryInfosByOrgRange(dataCenterName, rangeSQL.toString())) == null) {
            coll = new UMRegistryCollection();
        }
        return coll;
    }

    private UMRegistryCollection getRegistryInfosByOrgRange(String dataCenterName, String rangeSQL) {
        UMRegistryCollection coll = new UMRegistryCollection();
        if (StringUtils.isEmpty((String)rangeSQL) || StringUtils.isEmpty((String)dataCenterName)) {
            return coll;
        }
        StringBuffer sb = new StringBuffer("select * from T_UM_UserRegistry where FDataCenterName= ? and FCurrentCtrlUnitId in (").append(rangeSQL).append(")");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{dataCenterName});
            while (rs.next()) {
                coll.add(this.getUMRegistryInfo(rs));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return coll;
    }

    public void deleteBySessionid(String sessionid) throws EASBizException {
        StringBuffer sb = new StringBuffer(" delete from T_UM_UserRegistry where FSessionid=? ");
        try {
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{sessionid});
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public void deleteByNodeStr(String nodeStr) throws EASBizException {
        StringBuffer sb = new StringBuffer("delete from T_UM_UserRegistry where FNODE=?");
        try {
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new String[]{nodeStr});
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public void updateByNodeStr(String nodeStr, String url, String sessionId) throws EASBizException {
        if (url == null) {
            url = "";
        }
        String sql = "update  T_UM_UserRegistry set FNODE=? , FLoginAppServerUrl = ?  where FSessionid = ?";
        Object[] params = new String[]{nodeStr, url, sessionId};
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public boolean exists(String sessionid) throws EASBizException {
        StringBuffer sb = new StringBuffer("select count(fid) as accountfid from T_UM_UserRegistry where FSessionid=?");
        try {
            int count;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{sessionid});
            if (rs.next() && (count = rs.getInt("accountfid")) > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return false;
    }

    public void update(UMRegistryInfo info) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_UM_UserRegistry set ").append(" FSessionID='").append(info.getId()).append("', FDataCenterName='").append(info.getDataCenterName()).append("', FUserID='").append(info.getUserId()).append("', FUserName='").append(info.getUserName()).append("',FUserRealName='").append(info.getUserRealName()).append("',FUserType=").append(info.getUserType()).append(",FUserCUName='").append(info.getUserCUName()).append("',FCurrentMainBizUnitName='").append(info.getCurrentMainBizUnitName()).append("',FCurrentCtrlUnitId='").append(info.getCurrentCtrlUnitId()).append("',FClientIPAddress='").append(info.getClientIPAddress()).append("',FLoginTime=").append(this.getSqlDateStr(info.getLoginTime())).append(",FLastOperateTime=").append(this.getSqlDateStr(info.getLastOperateTime())).append(",FWindowTitle=").append(this.getStr(info.getOpenWindowTitle())).append(",FActionName=").append(this.getStr(info.getActionName())).append(",FActionDesc=").append(this.getStr(info.getActionDescription())).append(",FIsFinished=").append(info.isFinished() ? 0 : 1).append(",FisSendMsg=").append(info.isSendMsg() ? 1 : 0).append(",FLoginAppServerUrl='").append(info.getLoginServerURL()).append("'").append(",FLoginType='").append(info.getLoginType()).append("'").append(" where FSessionID='").append(info.getId()).append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public void updateLastOperate(UMRegistryInfo info, java.util.Date date) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_UM_UserRegistry set  FLastOperateTime=").append(this.getSqlDateStr(date)).append(",FCurrentMainBizUnitName='").append(info.getCurrentMainBizUnitName()).append("',FCurrentCtrlUnitId='").append(info.getCurrentCtrlUnitId()).append("',FWindowTitle=").append(this.getStr(info.getOpenWindowTitle())).append(",FActionName=").append(this.getStr(info.getActionName())).append(",FActionDesc=").append(this.getStr(info.getActionDescription())).append(",FIsFinished=").append(info.isFinished() ? 0 : 1).append(" where FSessionID='").append(info.getId()).append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public void updateLastOperateTime(String id, java.util.Date date) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_UM_UserRegistry set  FLastOperateTime=").append(this.getSqlDateStr(date)).append(" where FSessionID=?");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{id});
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public UMRegistryInfo getValue(String sessionid) throws EASBizException {
        StringBuffer sb = new StringBuffer("select * from T_UM_UserRegistry where FSessionid=?");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{sessionid});
            if (rs.next()) {
                return this.getUMRegistryInfo(rs);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return null;
    }

    public UMRegistryInfo getPortalValue(String sessionid) throws EASBizException {
        StringBuffer sb = new StringBuffer("select * from T_UM_UserRegistry where FGUIUserId=?");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{sessionid});
            if (rs.next()) {
                return this.getUMRegistryInfo(rs);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return null;
    }

    public List getCollection(String dcName, String userName) throws EASBizException {
        ArrayList<UMRegistryInfo> coll = new ArrayList<UMRegistryInfo>();
        StringBuffer sb = new StringBuffer("select * from T_UM_UserRegistry where FDataCenterName=? and FUserName = ? ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{dcName, userName});
            while (rs.next()) {
                coll.add(this.getUMRegistryInfo(rs));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return coll;
    }

    public List getIdleCollection(long maxIdleTimeInMinutes) throws EASBizException {
        ArrayList<UMRegistryInfo> coll = new ArrayList<UMRegistryInfo>();
        StringBuffer sb = new StringBuffer("select * from T_UM_UserRegistry");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            long curTime = System.currentTimeMillis();
            while (rs.next()) {
                Date lastDate = rs.getDate("FLastOperateTime");
                if (lastDate == null || curTime - lastDate.getTime() <= 60000L * maxIdleTimeInMinutes) continue;
                coll.add(this.getUMRegistryInfo(rs));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return coll;
    }

    public int getCount() {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select count(fid) as acc from T_UM_UserRegistry");
            if (rs.next()) {
                int count = rs.getInt("acc");
                return count;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return 0;
    }

    public List getIdList() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            IRowSet rs = StatusDBUtil.executeQuery("select distinct sessionid  from T_UM_UserRegistry");
            while (rs.next()) {
                String sessionid = rs.getString("sessionid");
                result.add(sessionid);
            }
            return result;
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    private String getNodeStr() {
        IClusterService iC = ClusterServiceFactory.getLocalInstance();
        if (iC.isCluster()) {
            return iC.getServerName() + iC.getNodeName();
        }
        return "";
    }

    public IObjectCollection getCollectionUsingOrgRange(Context ctx, UserInfo userInfo, String dataCenterName) {
        UMRegistryCollection coll = new UMRegistryCollection();
        if (userInfo == null || StringUtils.isEmpty((String)dataCenterName)) {
            return coll;
        }
        StringBuffer range = new StringBuffer();
        range.append("select forgid from t_pm_orgrange range where fuserid = '").append(userInfo.getId()).append("' and ftype = ").append(10);
        coll = this.getRegistryInfosByOrgRange(dataCenterName, range.toString());
        return coll;
    }

    public static Context getCtx() {
        return ctx;
    }

    public static void setCtx(Context ctx) {
        UserRegistryDBUtil.ctx = ctx;
    }
}

