/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class SavedSearch
extends WeiboResponse {
    private Date createdAt;
    private String query;
    private int position;
    private String name;
    private int id;
    private static final long serialVersionUID = 3083819860391598212L;

    SavedSearch(Response res) throws WeiboException {
        super(res);
        this.init(res.asJSONObject());
    }

    SavedSearch(Response res, JSONObject json) throws WeiboException {
        super(res);
        this.init(json);
    }

    SavedSearch(JSONObject savedSearch) throws WeiboException {
        this.init(savedSearch);
    }

    static List<SavedSearch> constructSavedSearches(Response res) throws WeiboException {
        JSONArray json = res.asJSONArray();
        try {
            ArrayList<SavedSearch> savedSearches = new ArrayList<SavedSearch>(json.length());
            for (int i = 0; i < json.length(); ++i) {
                savedSearches.add(new SavedSearch(res, json.getJSONObject(i)));
            }
            return savedSearches;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone.getMessage() + ":" + res.asString(), jsone);
        }
    }

    private void init(JSONObject savedSearch) throws WeiboException {
        try {
            this.createdAt = SavedSearch.parseDate(savedSearch.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.query = SavedSearch.getString("query", savedSearch, true);
            this.position = SavedSearch.getInt("position", savedSearch);
            this.name = SavedSearch.getString("name", savedSearch, true);
            this.id = SavedSearch.getInt("id", savedSearch);
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone.getMessage() + ":" + savedSearch.toString(), jsone);
        }
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getQuery() {
        return this.query;
    }

    public int getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SavedSearch)) {
            return false;
        }
        SavedSearch that = (SavedSearch)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.position != that.position) {
            return false;
        }
        if (!this.createdAt.equals(that.createdAt)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.query.equals(that.query);
    }

    public int hashCode() {
        int result = this.createdAt.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + this.position;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.id;
        return result;
    }

    public String toString() {
        return "SavedSearch{createdAt=" + this.createdAt + ", query='" + this.query + '\'' + ", position=" + this.position + ", name='" + this.name + '\'' + ", id=" + this.id + '}';
    }
}

