/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weibo4j.Attachment;
import weibo4j.Picture;
import weibo4j.RetweetDetails;
import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Status
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 1608000492860584608L;
    private Date createdAt;
    private String id;
    private String text;
    private String source;
    private boolean isTruncated;
    private String inReplyToStatusId;
    private String inReplyToUserId;
    private boolean isFavorited;
    private String inReplyToScreenName;
    private double latitude = -1.0;
    private double longitude = -1.0;
    private String thumbnail_pic;
    private String bmiddle_pic;
    private String original_pic;
    private RetweetDetails retweetDetails;
    private User user = null;
    private List<Attachment> attachmentList = new ArrayList<Attachment>();
    public List<Picture> pictures = new ArrayList<Picture>();

    Status(Response res, Weibo weibo) throws WeiboException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        this.init(res, elem, weibo);
    }

    Status(Response res, Element elem, Weibo weibo) throws WeiboException {
        super(res);
        this.init(res, elem, weibo);
    }

    Status(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.id = json.getString("id");
            this.text = json.getString("text");
            this.source = json.getString("source");
            this.createdAt = Status.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.inReplyToStatusId = json.getString("in_reply_to_status_id");
            this.inReplyToUserId = json.getString("in_reply_to_user_id");
            this.isFavorited = Status.getBoolean("favorited", json);
            this.thumbnail_pic = json.getString("thumbnail_pic");
            this.bmiddle_pic = json.getString("bmiddle_pic");
            this.original_pic = json.getString("original_pic");
            if (!json.isNull("user")) {
                this.user = new User(json.getJSONObject("user"));
            }
            this.inReplyToScreenName = json.getString("inReplyToScreenName");
            if (!json.isNull("retweeted_status")) {
                this.retweetDetails = new RetweetDetails(json.getJSONObject("retweeted_status"));
            }
            this.setPictures(json);
            this.setAttachments(json);
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + json.toString(), je);
        }
    }

    public Status(JSONObject json) throws WeiboException, JSONException {
        this.id = json.getString("id");
        this.text = json.getString("text");
        this.source = json.getString("source");
        this.createdAt = Status.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        this.isFavorited = Status.getBoolean("favorited", json);
        this.isTruncated = Status.getBoolean("truncated", json);
        this.inReplyToStatusId = json.getString("in_reply_to_status_id");
        this.inReplyToUserId = json.getString("in_reply_to_user_id");
        this.inReplyToScreenName = json.getString("in_reply_to_screen_name");
        this.thumbnail_pic = json.getString("thumbnail_pic");
        this.bmiddle_pic = json.getString("bmiddle_pic");
        this.original_pic = json.getString("original_pic");
        this.user = new User(json.getJSONObject("user"));
        if (!json.isNull("retweeted_status")) {
            this.retweetDetails = new RetweetDetails(json.getJSONObject("retweeted_status"));
        }
        this.setPictures(json);
        this.setAttachments(json);
    }

    public Status(String str) throws WeiboException, JSONException {
        JSONObject json = new JSONObject(str);
        this.id = json.getString("id");
        this.text = json.getString("text");
        this.source = json.getString("source");
        this.createdAt = Status.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        this.inReplyToStatusId = json.getString("in_reply_to_status_id");
        this.inReplyToUserId = json.getString("in_reply_to_user_id");
        this.isFavorited = Status.getBoolean("favorited", json);
        this.thumbnail_pic = json.getString("thumbnail_pic");
        this.bmiddle_pic = json.getString("bmiddle_pic");
        this.original_pic = json.getString("original_pic");
        this.user = new User(json.getJSONObject("user"));
        if (!json.isNull("retweeted_status")) {
            this.retweetDetails = new RetweetDetails(json.getJSONObject("retweeted_status"));
        }
        this.setPictures(json);
        this.setAttachments(json);
    }

    private void setPictures(JSONObject json) throws WeiboException, JSONException {
        JSONArray pics = null;
        try {
            pics = json.getJSONArray("pictures");
        }
        catch (Exception e) {
            pics = null;
        }
        if (pics != null) {
            int size = pics.length();
            Picture pic = null;
            for (int i = 0; i < size; ++i) {
                pic = new Picture(pics.getJSONObject(i));
                this.pictures.add(pic);
            }
        }
    }

    private void setAttachments(JSONObject json) throws WeiboException, JSONException {
        JSONArray atm = null;
        try {
            atm = json.getJSONArray("attachment");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (atm != null) {
            int size = atm.length();
            Attachment attam = null;
            for (int i = 0; i < size; ++i) {
                attam = new Attachment(atm.getJSONObject(i));
                this.attachmentList.add(attam);
            }
        }
    }

    private void init(Response res, Element elem, Weibo weibo) throws WeiboException {
        NodeList retweetDetailsNode;
        Status.ensureRootNodeNameIs("status", elem);
        this.user = new User(res, (Element)elem.getElementsByTagName("user").item(0), weibo);
        this.id = Status.getChildText("id", elem);
        this.text = Status.getChildText("text", elem);
        this.source = Status.getChildText("source", elem);
        this.createdAt = Status.getChildDate("created_at", elem);
        this.isTruncated = Status.getChildBoolean("truncated", elem);
        this.inReplyToStatusId = Status.getChildText("in_reply_to_status_id", elem);
        this.inReplyToUserId = Status.getChildText("in_reply_to_user_id", elem);
        this.isFavorited = Status.getChildBoolean("favorited", elem);
        this.inReplyToScreenName = Status.getChildText("in_reply_to_screen_name", elem);
        NodeList georssPoint = elem.getElementsByTagName("georss:point");
        if (1 == georssPoint.getLength()) {
            String[] point = georssPoint.item(0).getFirstChild().getNodeValue().split(" ");
            if (!"null".equals(point[0])) {
                this.latitude = Double.parseDouble(point[0]);
            }
            if (!"null".equals(point[1])) {
                this.longitude = Double.parseDouble(point[1]);
            }
        }
        if (1 == (retweetDetailsNode = elem.getElementsByTagName("retweet_details")).getLength()) {
            this.retweetDetails = new RetweetDetails(res, (Element)retweetDetailsNode.item(0), weibo);
        }
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public String getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public String getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean isFavorited() {
        return this.isFavorited;
    }

    public String getThumbnail_pic() {
        return this.thumbnail_pic;
    }

    public String getBmiddle_pic() {
        return this.bmiddle_pic;
    }

    public String getOriginal_pic() {
        return this.original_pic;
    }

    public User getUser() {
        return this.user;
    }

    public void setAttachmentList(List<Attachment> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public List<Attachment> getAttachmentList() {
        return this.attachmentList;
    }

    public boolean isRetweet() {
        return null != this.retweetDetails;
    }

    public RetweetDetails getRetweetDetails() {
        return this.retweetDetails;
    }

    static List<Status> constructStatuses(Response res, Weibo weibo) throws WeiboException {
        Document doc = res.asDocument();
        if (Status.isRootNodeNilClasses(doc)) {
            return new ArrayList<Status>(0);
        }
        try {
            Status.ensureRootNodeNameIs("statuses", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("status");
            int size = list.getLength();
            ArrayList<Status> statuses = new ArrayList<Status>(size);
            for (int i = 0; i < size; ++i) {
                Element status = (Element)list.item(i);
                statuses.add(new Status(res, status, weibo));
            }
            return statuses;
        }
        catch (WeiboException te) {
            Status.ensureRootNodeNameIs("nil-classes", doc);
            return new ArrayList<Status>(0);
        }
    }

    static List<Status> constructStatuses(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<Status> statuses = new ArrayList<Status>(size);
            for (int i = 0; i < size; ++i) {
                statuses.add(new Status(list.getJSONObject(i)));
            }
            return statuses;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Status && ((Status)obj).id == this.id;
    }

    public String toString() {
        return "Status{createdAt=" + this.createdAt + ", id=" + this.id + ", text='" + this.text + '\'' + ", source='" + this.source + '\'' + ", isTruncated=" + this.isTruncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isFavorited=" + this.isFavorited + ", thumbnail_pic=" + this.thumbnail_pic + ", bmiddle_pic=" + this.bmiddle_pic + ", original_pic=" + this.original_pic + ", inReplyToScreenName='" + this.inReplyToScreenName + '\'' + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", retweetDetails=" + this.retweetDetails + ", user=" + this.user + '}';
    }
}

