/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app.trd.webservice.image.params;

import com.kingdee.eas.base.wssc.app.trd.webservice.image.params.LockedBillcodeWrap;
import com.siit.image.wscommon.obj.BillFlowPath;
import com.siit.image.wscommon.obj.CreateImagePath;
import com.siit.image.wscommon.obj.LockedBillcode;
import com.siit.image.wscommon.obj.base.Params;
import com.siit.image.wscommon.obj.base.Safety;
import com.siit.image.wscommon.obj.base.Serverbody;
import com.siit.image.wscommon.obj.base.Service;
import com.siit.image.wscommon.tools.Encryptions;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GuosenParamsHelper {
    public Params buildCreateImagePathParams(String barcode, boolean canRescan, String viewUser) {
        Params params = new Params();
        params.setSafety(this.buildSafetySiit());
        params.setServerbody(this.buildServerBody("createImagePath", (Service)this.buildCreateImagePath(barcode, canRescan, viewUser)));
        return params;
    }

    private Serverbody buildServerBody(String methodName, Service service) {
        Serverbody serverbody = new Serverbody();
        serverbody.setServername(methodName);
        serverbody.setServertype("1");
        serverbody.setServices(this.buildServices(service));
        return serverbody;
    }

    private List<Service> buildServices(Service service) {
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(service);
        return services;
    }

    private Serverbody buildBatchServerBody(String methodName, List<Service> services) {
        Serverbody serverbody = new Serverbody();
        serverbody.setServername(methodName);
        serverbody.setServertype("1");
        serverbody.setServices(services);
        return serverbody;
    }

    private CreateImagePath buildCreateImagePath(String barcode, boolean canRescan, String viewUser) {
        CreateImagePath createImagePath = new CreateImagePath();
        createImagePath.serviceid = "1";
        createImagePath.barcode = barcode;
        createImagePath.type = "1";
        createImagePath.evaluation = canRescan ? "1" : "0";
        createImagePath.candownprint = "1";
        createImagePath.commenttype = "1";
        createImagePath.imageop = "0";
        createImagePath.userid = StringUtils.isNotBlank((CharSequence)viewUser) ? viewUser : "zhangsan";
        createImagePath.accountdate = "2014-01-01";
        createImagePath.showother = "1";
        return createImagePath;
    }

    private Safety buildSafetySiit() {
        Safety safety = new Safety();
        safety.setClientcode("FK");
        safety.setServicecode("ImageCenter");
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = df.format(new Date());
        String key = "KINGDEE";
        safety.setTicket(Encryptions.getMD5str((String)(time + "ImageCenterFK" + key)));
        safety.setTime(time);
        return safety;
    }

    public Params buildLockedBillcodeParams(String barcode, String voucherNumber, String year, String branch, String date) {
        Params params = new Params();
        params.setSafety(this.buildSafetySiit());
        params.setServerbody(this.buildServerBody("lockedBillcode", (Service)this.buildLockedBillcode(barcode, voucherNumber, year, branch, date)));
        return params;
    }

    private LockedBillcode buildLockedBillcode(String barcode, String voucherNumber, String year, String branch, String date) {
        return this.buildLockedBillcode("1", barcode, voucherNumber, year, branch, date);
    }

    private LockedBillcode buildLockedBillcode(String serviceid, String barcode, String voucherNumber, String year, String branch, String date) {
        LockedBillcode lockedBillcode = new LockedBillcode();
        lockedBillcode.setServiceid(serviceid);
        lockedBillcode.setBarcode(barcode);
        lockedBillcode.setBilltype("1");
        lockedBillcode.setBustype("FK");
        lockedBillcode.setOptype("2");
        lockedBillcode.setVoucher(voucherNumber);
        lockedBillcode.setYear(year);
        lockedBillcode.setBranch(branch);
        lockedBillcode.setDate(date);
        return lockedBillcode;
    }

    public Params buildBillFlowPathParams(String barcode, String userNumber) {
        Params params = new Params();
        params.setSafety(this.buildSafetySiit());
        params.setServerbody(this.buildServerBody("billFlowPath", this.buildBillFlowPath(barcode, userNumber)));
        return params;
    }

    private Service buildBillFlowPath(String barcode, String userNumber) {
        BillFlowPath billFlowPath = new BillFlowPath();
        billFlowPath.setServiceid("1");
        billFlowPath.setBarcode(barcode);
        billFlowPath.setType("1");
        billFlowPath.setUserid(userNumber);
        return billFlowPath;
    }

    public Params buildBatchLockedBillcodeParams(List<LockedBillcodeWrap> lockedBillcodeWrapList) {
        Params params = new Params();
        params.setSafety(this.buildSafetySiit());
        int idx = 0;
        ArrayList<Service> services = new ArrayList<Service>();
        for (LockedBillcodeWrap lockedBillcodeWrap : lockedBillcodeWrapList) {
            lockedBillcodeWrap.setServiceid(idx + "");
            LockedBillcode buildLockedBillcode = this.buildLockedBillcode(lockedBillcodeWrap.getServiceid(), lockedBillcodeWrap.getBarcode(), lockedBillcodeWrap.getVoucherNumber(), lockedBillcodeWrap.getYear(), lockedBillcodeWrap.getBranch(), lockedBillcodeWrap.getDate());
            services.add((Service)buildLockedBillcode);
            ++idx;
        }
        params.setServerbody(this.buildBatchServerBody("lockedBillcode", services));
        return params;
    }
}

