/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.safety;

import com.kingdee.bos.Context;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;

public class OutSysAccessWhiteList {
    public static final String FILE_NAME = "ExternalSystemWhiteList.properties";

    public static String getWhiteList(Context ctx, String key) {
        Properties properties = OutSysAccessWhiteList.loadProperties(ctx);
        if (!properties.isEmpty()) {
            return properties.getProperty(key);
        }
        return "";
    }

    private static Properties loadProperties(Context ctx) {
        Properties properties = null;
        String tmp = System.getProperty("java.security.auth.login.config");
        if (tmp == null) {
            properties = new Properties();
            return properties;
        }
        int i = tmp.lastIndexOf("/");
        if (i < 0) {
            properties = new Properties();
            return properties;
        }
        Properties prop = new Properties();
        String path = tmp.substring(0, i) + File.separator;
        String file = path + FILE_NAME;
        OutSysAccessWhiteList.loadPropertie(file, prop);
        return prop;
    }

    private static void loadPropertie(String file, Properties map) {
        File f = new File(file);
        if (!f.exists()) {
            return;
        }
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(file);){
            properties.load(fis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Enumeration<Object> em = properties.keys();
        while (em.hasMoreElements()) {
            Object key = em.nextElement();
            Object value = properties.get(key);
            if (!(value instanceof String) || value == null || value.toString().matches("[\u4e00-\u9fa5]+")) continue;
            try {
                key = new String(((String)key).getBytes("ISO8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            try {
                value = new String(((String)value).getBytes("ISO8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                value = properties.get(key);
            }
        }
    }
}

