/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.app;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.xtsync.EasXtException;
import com.kingdee.eas.base.xtsync.EasXtHighItemType;
import com.kingdee.eas.base.xtsync.EasXtSyncItemType;
import com.kingdee.eas.base.xtsync.EasXtSyncType;
import com.kingdee.eas.base.xtsync.app.AbstractEasXtSyncFacadeControllerBean;
import com.kingdee.eas.base.xtsync.web.EasXtSyncServiceFactory;
import com.kingdee.eas.base.xtsync.web.ExceptionLogInfo;
import com.kingdee.eas.base.xtsync.web.ExceptionLogService;
import com.kingdee.eas.base.xtsync.web.IEasXtSync;
import com.kingdee.eas.base.xtsync.xtutil.EasXtCommonUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncLogUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtViewDataUtil;
import com.kingdee.eas.base.xtsync.xtutil.OrgBean;
import com.kingdee.eas.base.xtsync.xtutil.PageResult;
import com.kingdee.eas.base.xtsync.xtutil.PrivacyProtectUtil;
import com.kingdee.eas.base.xtsync.xtutil.StringUtil;
import com.kingdee.eas.base.xtsync.xtutil.XtCommunicateUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class EasXtSyncFacadeControllerBean
extends AbstractEasXtSyncFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.xtsync.app.EasXtSyncFacadeControllerBean");

    @Override
    protected boolean _onLineSyncKey(Context ctx, String eid, String key) throws BOSException {
        boolean flag = false;
        try {
            flag = XtCommunicateUtil.saveStringKeyToFile(eid, key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        return flag;
    }

    @Override
    protected String _beforeSync(Context ctx, EasXtHighItemType syncHightType, EasXtSyncType syncType) throws BOSException, EASBizException {
        IEasXtSync syncService = EasXtSyncServiceFactory.getInstance(ctx, syncHightType);
        return syncService.beforeSync(syncType);
    }

    @Override
    protected String _afterSync(Context ctx, EasXtHighItemType syncHightType, EasXtSyncType syncType) throws BOSException, EASBizException {
        IEasXtSync syncService = EasXtSyncServiceFactory.getInstance(ctx, syncHightType);
        return syncService.afterSync(syncType);
    }

    @Override
    protected String _check(Context ctx, EasXtSyncType syncType) throws BOSException {
        PrivacyProtectUtil.checkPrivacyBefore(ctx, "xt");
        this.clearExceptionInMidTable(ctx);
        Map xtConfig = null;
        try {
            xtConfig = this._getXtConfig(ctx);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (null != xtConfig && "1".equals(xtConfig.get("isAutoUpdateCell"))) {
            this.updateXtCellUpdateRecords(ctx, syncType);
        }
        EasXtCommonUtils.insertsynchTime(ctx);
        return null;
    }

    private void updateXtCellUpdateRecords(Context ctx, EasXtSyncType syncType) throws BOSException {
        String lastCheckTime = "1900-01-01 01:01:01";
        if (EasXtSyncType.Incre.equals((Object)syncType)) {
            lastCheckTime = EasXtCommonUtils.getLastCheckTime(ctx);
        }
        int start = 0;
        int length = 1000;
        JSONArray array = new JSONArray();
        JSONArray totalArray = new JSONArray();
        String checkTime = null;
        int size = 0;
        try {
            while (true) {
                com.alibaba.fastjson.JSONObject response;
                if (!(response = XtCommunicateUtil.getInstance(ctx).getCellUpdateAfterCheckTime(lastCheckTime, start, length)).getBooleanValue("success")) {
                    if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                        throw new EasXtException(EasXtException.OPENCLOUD);
                    }
                    throw new BOSException(response.getString("error"));
                }
                array = response.getJSONArray("data");
                checkTime = (String)response.get((Object)"curTime");
                if (array != null && array.size() != 0) {
                    logger.error((Object)("*******\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u96c6\u5408\u5927\u5c0f\uff1a" + array.size()));
                    totalArray.addAll((Collection)array);
                    if (size <= 29) {
                        ++size;
                        start += length;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        if (EasXtSyncUtil.getInstance(ctx).isFirstCheck(lastCheckTime)) {
            this.clearCellUpdateDatas(ctx);
            this.insertIntoCellUpdateTable(ctx, totalArray);
        } else {
            this.clearCellUpdateDatas(ctx, totalArray);
            this.insertIntoCellUpdateTable(ctx, totalArray);
        }
    }

    private void clearCellUpdateDatas(Context ctx) throws BOSException {
        String sql = "truncate table T_XT_CellUpdateRecords";
        EasXtSyncUtil.execute(ctx, sql);
    }

    private void clearCellUpdateDatas(Context ctx, JSONArray totalArray) throws BOSException {
        if (totalArray == null || totalArray.size() == 0) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < totalArray.size(); ++i) {
            com.alibaba.fastjson.JSONObject json = totalArray.getJSONObject(i);
            if (StringUtils.isEmpty((String)json.getString("openId"))) continue;
            String openId = json.getString("openId");
            ids.add(openId);
            if (ids.size() <= 444) continue;
            this.deleteCellUpdate(ctx, ids);
            ids = new ArrayList();
        }
        if (ids.size() > 0) {
            this.deleteCellUpdate(ctx, ids);
            ids = null;
        }
    }

    private void deleteCellUpdate(Context ctx, List ids) throws BOSException {
        String sql = "delete from T_XT_CellUpdateRecords where fid in ";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.size(); ++i) {
            sb.append("'").append(ids.get(i)).append("',");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        EasXtSyncUtil.execute(ctx, new StringBuffer(sql).append("(").append(sb).append(")").toString());
    }

    protected void insertIntoCellUpdateTable(Context ctx, JSONArray totalArray) throws BOSException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("insertIntoCellUpdateRecordsTable");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = null;
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < totalArray.size(); ++i) {
            String createTime;
            com.alibaba.fastjson.JSONObject json = totalArray.getJSONObject(i);
            String openId = json.getString("openId");
            if (StringUtils.isEmpty((String)openId) || ids.contains((createTime = json.getString("createTime")) + openId)) continue;
            ids.add(createTime + openId);
            Timestamp ctime = null;
            try {
                ctime = Timestamp.valueOf(createTime);
            }
            catch (IllegalArgumentException e) {
                ctime = new Timestamp(new Date().getTime());
            }
            param = new ArrayList<Object>();
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            param.add(ctime);
            param.add(json.getString("newPhone"));
            param.add(json.getString("oldPhone"));
            param.add(json.getString("eid"));
            param.add(openId);
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u6279\u91cf\u63d2\u5165\u624b\u673a\u53d8\u66f4\u8bb0\u5f55\u8868----------");
        EasXtSyncUtil.executeBatch(ctx, sql, params);
        logger.error((Object)sql);
        logger.error((Object)"---------\u6279\u91cf\u63d2\u5165\u624b\u673a\u53d8\u66f4\u8bb0\u5f55\u8868\u6210\u529f----------");
    }

    private String checkForUpdate(Context ctx, EasXtSyncType syncType) throws BOSException {
        this.clearExceptionInMidTable(ctx);
        Map xtConfig = null;
        try {
            xtConfig = this._getXtConfig(ctx);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (null != xtConfig && "1".equals(xtConfig.get("isAutoUpdateCell"))) {
            this.updateXtCellUpdateRecords(ctx, syncType);
        }
        IEasXtSync syncService = EasXtSyncServiceFactory.getInstance(ctx, EasXtHighItemType.Person);
        try {
            syncService.checkForUpdate(ctx, syncType);
        }
        catch (EASBizException e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("checkForUpdate", e, null, null);
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            e.printStackTrace();
        }
        return "true";
    }

    protected void clearExceptionInMidTable(Context ctx) {
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String sql = "";
        try {
            sql = easXtSyncUtil.getValue("deleteDeletedOrgInfo");
            EasXtSyncUtil.execute(ctx, sql);
            sql = easXtSyncUtil.getValue("updateDelPartMap");
            EasXtSyncUtil.execute(ctx, sql);
            sql = easXtSyncUtil.getValue("updateDelRelationsMap");
            EasXtSyncUtil.execute(ctx, sql);
        }
        catch (Exception e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("_bind-->clearExceptionInMidTable", e, null, null);
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            logger.error((Object)"\u6e05\u9664\u5f02\u5e38\u6570\u636e\u51fa\u9519\uff0c\u9519\u8bef\u8be6\u60c5\uff1a");
            e.printStackTrace();
        }
    }

    @Override
    protected void _unBindWithXt(Context ctx, String personID) throws BOSException {
    }

    @Override
    protected boolean _saveXtConfig(Context ctx, Map config, boolean isInit) throws BOSException, EASBizException {
        boolean flag;
        if (isInit) {
            this.init(ctx);
        }
        if (flag = EasXtSyncUtil.getInstance(ctx).writeXtConfig(ctx, config)) {
            XtCommunicateUtil.getInstance(ctx).resetURL();
        }
        return flag;
    }

    @Override
    protected Map _getXtConfig(Context ctx) throws BOSException, EASBizException {
        return EasXtSyncUtil.getInstance(ctx).getXtConfig(ctx);
    }

    @Override
    protected Map _getCpConfig(Context ctx) throws BOSException, EASBizException {
        return EasXtSyncUtil.getInstance(ctx).getCpConfig(ctx);
    }

    @Override
    protected boolean _init(Context ctx) throws BOSException, EASBizException {
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add("truncate table T_PM_EASXTUSERMAP");
        sqlList.add("truncate table T_XT_USER");
        sqlList.add("truncate table T_TM_TMP");
        sqlList.add("truncate table T_XT_SYNCHTIME");
        sqlList.add("truncate table T_XT_CHECKTIME");
        sqlList.add("truncate table T_xt_log");
        sqlList.add("truncate table T_PM_EASXTORGMAP");
        sqlList.add("truncate table T_PM_EASXTPARTMAP");
        sqlList.add("truncate table T_PM_EASXTRELATIONSMAP");
        sqlList.add("truncate table T_XT_ORG");
        sqlList.add("truncate table T_PM_EASXTORGLEADER");
        sqlList.add("truncate table T_XT_ORGLEADER");
        sqlList.add("truncate table T_XT_PART");
        sqlList.add("truncate table T_XT_PERSONRELATIONS");
        sqlList.add("truncate table T_XT_SYNCPERSONLOG");
        sqlList.add("truncate table T_XT_SYNCDEPTLOG");
        sqlList.add("truncate table T_XT_SYNCORGLEADERLOG");
        sqlList.add("truncate table T_XT_SYNCPARTLOG");
        sqlList.add("truncate table T_XT_SYNCRELATIONSLOG");
        sqlList.add("truncate table T_XT_ORGLEADERTMP");
        sqlList.add("truncate table T_XT_SaveSetting");
        for (int i = 0; i < sqlList.size(); ++i) {
            EasXtSyncUtil.execute(ctx, sqlList.get(i) + "");
        }
        boolean flag = EasXtSyncUtil.getInstance(ctx).writeInitXtConfig();
        XtCommunicateUtil.clearKey();
        IEasXtSync syncService = EasXtSyncServiceFactory.getInstance(ctx, EasXtHighItemType.Person);
        try {
            syncService.init(ctx);
        }
        catch (EASBizException e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("_init", e, null, null);
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            e.printStackTrace();
        }
        return flag;
    }

    @Override
    protected byte[] _download(Context ctx) throws BOSException {
        return null;
    }

    @Override
    protected boolean _handDownloadXtData(Context ctx) throws BOSException {
        this.checkForUpdate(ctx, EasXtSyncType.Full);
        return true;
    }

    @Override
    protected String _getAllEasDatas(Context ctx, String condition, String queryType, EasXtHighItemType highItemType) throws BOSException {
        if (StringUtils.isEmpty((String)condition)) {
            throw new BOSException("\u53c2\u6570\u4f20\u9012\u9519\u8bef\uff0ccondition\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (EasXtHighItemType.Dept.equals((Object)highItemType)) {
            com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
            String subAction = o.getString("subAction");
            if ("orgTree".equalsIgnoreCase(subAction)) {
                return this.getEasOrgTree(ctx, condition, queryType, highItemType);
            }
            if ("orgLeader".equalsIgnoreCase(subAction)) {
                return this.getOrgLeaderByOrgName(ctx, condition, queryType, highItemType);
            }
            return this.getEasDeptDatas(ctx, condition, queryType, highItemType);
        }
        if (EasXtHighItemType.Person.equals((Object)highItemType)) {
            com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
            String subAction = o.getString("subAction");
            if ("userDetail".equalsIgnoreCase(subAction)) {
                return this.getEasXtUserDetail(ctx, condition, queryType, highItemType);
            }
            if (o.getInteger("type") == 0) {
                return this.getEasPersonDatas(ctx, condition, queryType, highItemType);
            }
            return this.getEasPersonByPosition(ctx, condition, queryType, highItemType);
        }
        if (EasXtHighItemType.DeptLeader.equals((Object)highItemType)) {
            return this.getEasDeptLeaderDatas(ctx, condition, queryType, highItemType);
        }
        if (EasXtHighItemType.PartJob.equals((Object)highItemType)) {
            return null;
        }
        throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)highItemType));
    }

    @Override
    protected String _getAllXtDatas(Context ctx, String condition, String queryType, EasXtHighItemType highItemType) throws BOSException {
        if (EasXtHighItemType.Dept.equals((Object)highItemType)) {
            return this.getXtDeptDatas(ctx, condition, queryType, highItemType);
        }
        if (EasXtHighItemType.Person.equals((Object)highItemType)) {
            return this.getXtPersonDatas(ctx, condition, queryType, highItemType);
        }
        if (EasXtHighItemType.DeptLeader.equals((Object)highItemType)) {
            return this.getXtDeptLeaderDatas(ctx, condition, queryType, highItemType);
        }
        if (EasXtHighItemType.PartJob.equals((Object)highItemType)) {
            return null;
        }
        throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)highItemType));
    }

    @Override
    protected void _clearSyncLogData(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _clearMapTable(Context ctx) throws BOSException {
    }

    @Override
    protected void _clearXTTable(Context ctx) throws BOSException {
    }

    @Override
    protected int _checkCellExcPersons(Context ctx, EasXtSyncItemType itemType) throws BOSException {
        if (EasXtSyncItemType.NoCellUserPerson.equals((Object)itemType)) {
            return this.getNoCellPersonsCount(ctx);
        }
        if (EasXtSyncItemType.SameCellUserPerson.equals((Object)itemType)) {
            return this.getSameCellPersonsCount(ctx);
        }
        if (EasXtSyncItemType.SameEmailUserPerson.equals((Object)itemType)) {
            return this.getSameEmailPersonsCount(ctx);
        }
        if (EasXtSyncItemType.SameCellAndEmailPerson.equals((Object)itemType)) {
            return this.getSameCellAndEmailPersonsCount(ctx);
        }
        throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)itemType));
    }

    @Override
    protected String _syncDept(Context ctx, EasXtSyncItemType itemType) throws BOSException, EASBizException {
        IEasXtSync syncService = EasXtSyncServiceFactory.getInstance(ctx, EasXtHighItemType.Dept);
        return syncService.sync(itemType);
    }

    @Override
    protected String _syncPerson(Context ctx, EasXtSyncItemType itemType) throws BOSException, EASBizException {
        IEasXtSync syncService = EasXtSyncServiceFactory.getInstance(ctx, EasXtHighItemType.Person);
        return syncService.sync(itemType);
    }

    @Override
    protected String _syncDeptLeader(Context ctx, EasXtSyncItemType itemType) throws BOSException, EASBizException {
        IEasXtSync syncService = EasXtSyncServiceFactory.getInstance(ctx, EasXtHighItemType.DeptLeader);
        return syncService.sync(itemType);
    }

    @Override
    protected String _syncPartJob(Context ctx, EasXtSyncItemType itemType) throws BOSException, EASBizException {
        IEasXtSync syncService = EasXtSyncServiceFactory.getInstance(ctx, EasXtHighItemType.PartJob);
        return syncService.sync(itemType);
    }

    @Override
    protected String _syncRelations(Context ctx, EasXtSyncItemType itemType) throws BOSException, EASBizException {
        IEasXtSync syncService = EasXtSyncServiceFactory.getInstance(ctx, EasXtHighItemType.Relations);
        return syncService.sync(itemType);
    }

    @Override
    protected void _syncOther(Context ctx, String syncType4Other) throws BOSException, EASBizException {
    }

    @Override
    protected String _getCellExcPersons(Context ctx, String condition, String queryType, EasXtSyncItemType itemType) throws BOSException {
        if (EasXtSyncItemType.NoCellUserPerson.equals((Object)itemType)) {
            return this.getNoCellPersons(ctx, condition, queryType);
        }
        if (EasXtSyncItemType.SameCellUserPerson.equals((Object)itemType)) {
            return this.getSameCellPersons(ctx, condition, queryType);
        }
        if (EasXtSyncItemType.SameEmailUserPerson.equals((Object)itemType)) {
            return this.getSameEmailPersons(ctx, condition, queryType);
        }
        if (EasXtSyncItemType.SameCellAndEmailPerson.equals((Object)itemType)) {
            return this.getSameCellAndEmailPersons(ctx, condition, queryType);
        }
        throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)itemType));
    }

    @Override
    protected String _getSyncDeptLogs(Context ctx, String condition, EasXtSyncItemType itemType, String queryType, boolean success, String syncTimeId) throws BOSException {
        return EasXtSyncLogUtils.getSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
    }

    @Override
    protected String _getSyncPersonLogs(Context ctx, String condition, EasXtSyncItemType itemType, String queryType, boolean success, String syncTimeId) throws BOSException {
        return EasXtSyncLogUtils.getSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
    }

    @Override
    protected String _getSyncDeptLeaderLogs(Context ctx, String condition, EasXtSyncItemType itemType, String queryType, boolean success, String syncTimeId) throws BOSException {
        return EasXtSyncLogUtils.getSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
    }

    @Override
    protected String _getSyncPartJobLogs(Context ctx, String condition, EasXtSyncItemType itemType, String queryType, boolean success, String syncTimeId) throws BOSException {
        return EasXtSyncLogUtils.getSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
    }

    @Override
    protected String _getSyncRelationsLogs(Context ctx, String condition, EasXtSyncItemType itemType, String queryType, boolean success, String syncTimeId) throws BOSException {
        return EasXtSyncLogUtils.getSyncLog(ctx, itemType, queryType, condition, syncTimeId, success);
    }

    @Override
    protected void _getSyncDeptLogsCount(Context ctx, EasXtSyncItemType itemType, String filterSql, boolean success, String syncTimeId) throws BOSException {
    }

    @Override
    protected void _getSyncPersonLogsCount(Context ctx, EasXtSyncItemType itemType, String filterSql, boolean success, String syncTimeId) throws BOSException {
    }

    @Override
    protected void _getSyncDeptLeaderLogsCount(Context ctx, EasXtSyncItemType itemType, String filterSql, boolean success, String syncTimeId) throws BOSException {
    }

    @Override
    protected void _getSyncPartJobLogsCount(Context ctx, EasXtSyncItemType itemType, String filterSql, boolean success, String syncTimeId) throws BOSException {
    }

    @Override
    protected String _bind(Context ctx, EasXtSyncType syncType) throws BOSException, EASBizException {
        this.clearExceptionInMidTable(ctx);
        PrivacyProtectUtil.checkPrivacyAfter(ctx, "xt");
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getLastUCTime(Context ctx) throws BOSException {
        String sql = "select max(fchecktime) from t_xt_checktime ";
        String sql1 = "select max(fsynchtime) from T_XT_SYNCHTIME ";
        IRowSet rs = EasXtSyncUtil.executeQuery(ctx, sql);
        IRowSet rs1 = EasXtSyncUtil.executeQuery(ctx, sql1);
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        try {
            while (rs.next()) {
                Timestamp checkTime = rs.getTimestamp(1);
                if (checkTime == null) {
                    tmpMap.put("checkTime", "1900-01-01 01:01:01");
                    continue;
                }
                tmpMap.put("checkTime", EasXtCommonUtils.formLongTimeString(checkTime));
            }
            while (rs1.next()) {
                Timestamp syncTime = rs1.getTimestamp(1);
                if (syncTime == null) {
                    tmpMap.put("syncTime", "1900-01-01 01:01:01");
                    continue;
                }
                tmpMap.put("syncTime", EasXtCommonUtils.formLongTimeString(syncTime));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs1 != null) {
                try {
                    rs1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.fromObject(tmpMap).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getSyncRecords(Context ctx, String condition) throws BOSException {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String sql = "select fid, fsynchtime from t_xt_synchtime ";
        IRowSet rsCount = EasXtSyncUtil.executeQuery(ctx, "select count(0) from (" + sql + ") synctime");
        sql = sql + "order by fsynchtime desc";
        IRowSet rs = EasXtSyncUtil.executeQuery(ctx, sql, (page - 1) * rowCount, rowCount);
        ArrayList list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int index = 1;
        int total = 0;
        try {
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            while (rs.next()) {
                map = new HashMap();
                Timestamp synchtime = rs.getTimestamp("fsynchtime");
                map.put("index", index);
                map.put("id", rs.getString("fid"));
                map.put("synchtime", EasXtCommonUtils.formLongTimeString(synchtime));
                map.put("btnmore", "<a href='javascript:void(0);' class='btn-more' onclick=''>\u5c55\u5f00\u8be6\u60c5</a>");
                list.add(map);
                ++index;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rsCount != null) {
                try {
                    rsCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    @Override
    protected String _getAllSyncRecordsCount(Context ctx, String syncTimeId) throws BOSException {
        if (StringUtils.isEmpty((String)syncTimeId)) {
            syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List itemList = EasXtSyncItemType.getEnumList();
        for (int i = 0; i < itemList.size(); ++i) {
            EasXtSyncItemType syncItemType = (EasXtSyncItemType)((Object)itemList.get(i));
            map.put(syncItemType.getName(), EasXtSyncLogUtils.getSyncLogCount(ctx, syncItemType, null, syncTimeId, true));
            map.put(syncItemType.getName() + "1", EasXtSyncLogUtils.getSyncLogCount(ctx, syncItemType, null, syncTimeId, false));
        }
        return JSONObject.fromObject(map).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNoCellPersons(Context ctx, String condition, String queryType) throws BOSException {
        String filter;
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String string = filter = o.getString("filter") == null ? null : o.getString("filter").trim();
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String getNormalUser = EasXtSyncUtil.getInstance(ctx).getValue("getNormalUser");
        StringBuilder sbSql = new StringBuilder();
        sbSql.append("SELECT * FROM t_pm_easxtusermap where  (fcell is null or fcell = '') and (FEmail = '' or FEmail is null)");
        if (!StringUtils.isEmpty((String)filter)) {
            sbSql.append(" and (FOrgLongName like '%" + filter + "%' or FCell like '%" + filter + "%' or fpersonname like '%" + filter + "%' or fposition like '%" + filter + "%' or femail like '%" + filter + "%')");
        }
        IRowSet rowSetCount = EasXtSyncUtil.executeQuery(ctx, "select count(0) from (" + sbSql.toString() + ") countt");
        sbSql.append(" order by FUserNumber");
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        int total = 0;
        IRowSet rowSet1 = null;
        try {
            if (rowSetCount.next()) {
                total = rowSetCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rowSet1 = EasXtSyncUtil.executeQuery(ctx, sbSql.toString(), (page - 1) * rowCount, rowCount);
            while (rowSet1.next()) {
                map = new HashMap();
                map.put("fuserId", rowSet1.getString("fuserId"));
                map.put("funumber", rowSet1.getString("fusernumber"));
                map.put("fpersonId", rowSet1.getString("fpersonId"));
                map.put("fname", rowSet1.getString("fpersonname"));
                map.put("fcell", rowSet1.getString("fcell"));
                map.put("femail", rowSet1.getString("femail"));
                map.put("fposition", rowSet1.getString("FPosition"));
                map.put("forglongname", "\\".equals(rowSet1.getString("FOrgLongName")) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rowSet1.getString("FOrgLongName"));
                list.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSetCount != null) {
                try {
                    rowSetCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSameCellPersons(Context ctx, String condition, String queryType) throws BOSException {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String getNormalUser = EasXtSyncUtil.getInstance(ctx).getValue("getNormalUser");
        StringBuilder sbSql = new StringBuilder();
        String dbType = (String)ctx.get((Object)"dbType");
        if ("Oracle".equals(dbType)) {
            sbSql.append("SELECT * FROM t_pm_easxtusermap where fcell in (select fcell FROM t_pm_easxtusermap group by FCell having count(FCell) >= 2 and FCell is not null)");
        } else {
            sbSql.append("SELECT * FROM t_pm_easxtusermap where fcell in (select fcell FROM t_pm_easxtusermap group by FCell having count(FCell) >= 2 and FCell is not null and FCell != '')");
        }
        if (!StringUtils.isEmpty((String)filter)) {
            sbSql.append(" and (FOrgLongName like '%" + filter + "%' or FCell like '%" + filter + "%' or fpersonname like '%" + filter + "%' or fposition like '%" + filter + "%' or femail like '%" + filter + "%')");
        }
        IRowSet rowSetCount = EasXtSyncUtil.executeQuery(ctx, "select count(0) from (" + sbSql.toString() + ") countt");
        sbSql.append(" order by FUserNumber");
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        int total = 0;
        IRowSet rowSet1 = null;
        try {
            if (rowSetCount.next()) {
                total = rowSetCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rowSet1 = EasXtSyncUtil.executeQuery(ctx, sbSql.toString(), (page - 1) * rowCount, rowCount);
            while (rowSet1.next()) {
                map = new HashMap();
                map.put("fuserId", rowSet1.getString("fuserId"));
                map.put("funumber", rowSet1.getString("fusernumber"));
                map.put("fpersonId", rowSet1.getString("fpersonId"));
                map.put("fname", rowSet1.getString("fpersonname"));
                map.put("fcell", rowSet1.getString("fcell"));
                map.put("femail", rowSet1.getString("femail"));
                map.put("fposition", rowSet1.getString("FPosition"));
                map.put("forglongname", "\\".equals(rowSet1.getString("FOrgLongName")) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rowSet1.getString("FOrgLongName"));
                list.add(map);
            }
        }
        catch (SQLException e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("getSameCellPersons", e, null, null);
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            e.printStackTrace();
        }
        finally {
            if (rowSetCount != null) {
                try {
                    rowSetCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSameEmailPersons(Context ctx, String condition, String queryType) throws BOSException {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        StringBuilder sbSql = new StringBuilder();
        String dbType = (String)ctx.get((Object)"dbType");
        if ("Oracle".equals(dbType)) {
            sbSql.append("SELECT * FROM t_pm_easxtusermap where FEmail in (select FEmail FROM t_pm_easxtusermap group by FEmail having count(FEmail) >= 2 and FEmail is not null)");
        } else {
            sbSql.append("SELECT * FROM t_pm_easxtusermap where FEmail in (select FEmail FROM t_pm_easxtusermap group by FEmail having count(FEmail) >= 2 and FEmail is not null and FEmail != '')");
        }
        if (!StringUtils.isEmpty((String)filter)) {
            sbSql.append(" and (FOrgLongName like '%" + filter + "%' or FCell like '%" + filter + "%' or fpersonname like '%" + filter + "%' or fposition like '%" + filter + "%' or femail like '%" + filter + "%')");
        }
        IRowSet rowSetCount = EasXtSyncUtil.executeQuery(ctx, "select count(0) from (" + sbSql.toString() + ") countt");
        sbSql.append(" order by FUserNumber");
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        int total = 0;
        IRowSet rowSet1 = null;
        try {
            if (rowSetCount.next()) {
                total = rowSetCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rowSet1 = EasXtSyncUtil.executeQuery(ctx, sbSql.toString(), (page - 1) * rowCount, rowCount);
            while (rowSet1.next()) {
                map = new HashMap();
                map.put("fuserId", rowSet1.getString("fuserId"));
                map.put("funumber", rowSet1.getString("fusernumber"));
                map.put("fpersonId", rowSet1.getString("fpersonId"));
                map.put("fname", rowSet1.getString("fpersonname"));
                map.put("fcell", rowSet1.getString("fcell"));
                map.put("femail", rowSet1.getString("femail"));
                map.put("fposition", rowSet1.getString("FPosition"));
                map.put("forglongname", "\\".equals(rowSet1.getString("FOrgLongName")) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rowSet1.getString("FOrgLongName"));
                list.add(map);
            }
        }
        catch (SQLException e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("getSameEmailPersons", e, null, null);
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            e.printStackTrace();
        }
        finally {
            if (rowSetCount != null) {
                try {
                    rowSetCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSameCellAndEmailPersons(Context ctx, String condition, String queryType) throws BOSException {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        StringBuilder sbSql = new StringBuilder();
        String dbType = (String)ctx.get((Object)"dbType");
        if ("Oracle".equals(dbType)) {
            sbSql.append("select * from (SELECT * FROM t_pm_easxtusermap where FEmail in (select FEmail FROM t_pm_easxtusermap group by FEmail having count(FEmail) >= 2 and FEmail is not null) union SELECT * FROM t_pm_easxtusermap where FCell in (select fcell FROM t_pm_easxtusermap group by FCell having count(FCell) >= 2 and FCell is not null)) tt");
        } else {
            sbSql.append("select * from (SELECT * FROM t_pm_easxtusermap where FEmail in (select FEmail FROM t_pm_easxtusermap group by FEmail having count(FEmail) >= 2 and FEmail is not null and FEmail != '') union SELECT * FROM t_pm_easxtusermap where FCell in (select fcell FROM t_pm_easxtusermap group by FCell having count(FCell) >= 2 and FCell is not null and FCell != '')) tt");
        }
        if (!StringUtils.isEmpty((String)filter)) {
            sbSql.append(" where (FOrgLongName like '%" + filter + "%' or FCell like '%" + filter + "%' or fpersonname like '%" + filter + "%' or fposition like '%" + filter + "%' or femail like '%" + filter + "%')");
        }
        IRowSet rowSetCount = EasXtSyncUtil.executeQuery(ctx, "select count(0) from (" + sbSql.toString() + ") countt");
        sbSql.append(" order by Fcell,FEmail");
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        int total = 0;
        IRowSet rowSet1 = null;
        try {
            if (rowSetCount.next()) {
                total = rowSetCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rowSet1 = EasXtSyncUtil.executeQuery(ctx, sbSql.toString(), (page - 1) * rowCount, rowCount);
            while (rowSet1.next()) {
                map = new HashMap();
                map.put("fuserId", rowSet1.getString("fuserId"));
                map.put("funumber", rowSet1.getString("fusernumber"));
                map.put("fpersonId", rowSet1.getString("fpersonId"));
                map.put("fname", rowSet1.getString("fpersonname"));
                map.put("fcell", rowSet1.getString("fcell"));
                map.put("femail", rowSet1.getString("femail"));
                map.put("fposition", rowSet1.getString("FPosition"));
                map.put("forglongname", "\\".equals(rowSet1.getString("FOrgLongName")) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rowSet1.getString("FOrgLongName"));
                list.add(map);
            }
        }
        catch (SQLException e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("getSameCellAndEmailPersons", e, null, null);
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            e.printStackTrace();
        }
        finally {
            if (rowSetCount != null) {
                try {
                    rowSetCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNoCellPersonsCount(Context ctx) throws BOSException {
        String latestSyncTime = JSONObject.fromObject((Object)this._getLastUCTime(ctx)).getString("syncTime");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date syncDate = formatter.parse(latestSyncTime);
            if ((new Date().getTime() - syncDate.getTime()) / 60000L > 5L) {
                IEasXtSync syncService = EasXtSyncServiceFactory.getInstance(ctx, EasXtHighItemType.PartJob);
                syncService.init(ctx);
            }
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        StringBuilder sbSql = new StringBuilder();
        sbSql.append("SELECT count(0) FROM t_pm_easxtusermap where  (fcell is null or fcell = '') and (FEmail = '' or FEmail is null)");
        IRowSet rowSet1 = EasXtSyncUtil.executeQuery(ctx, sbSql.toString());
        int count = 0;
        try {
            if (rowSet1.next()) {
                count = rowSet1.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSameCellPersonsCount(Context ctx) throws BOSException {
        String getNormalUserCount = EasXtSyncUtil.getInstance(ctx).getValue("getNormalUserCount");
        StringBuilder sbSql = new StringBuilder();
        String dbType = (String)ctx.get((Object)"dbType");
        if ("Oracle".equals(dbType)) {
            sbSql.append("SELECT count(0) FROM t_pm_easxtusermap where fcell in (select fcell FROM t_pm_easxtusermap group by FCell having count(FCell) >= 2 and FCell is not null)");
        } else {
            sbSql.append("SELECT count(0) FROM t_pm_easxtusermap where fcell in (select fcell FROM t_pm_easxtusermap group by FCell having count(FCell) >= 2 and FCell is not null and FCell != '')");
        }
        IRowSet rowSet1 = EasXtSyncUtil.executeQuery(ctx, sbSql.toString());
        int count = 0;
        try {
            if (rowSet1.next()) {
                count = rowSet1.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSameEmailPersonsCount(Context ctx) throws BOSException {
        String getNormalUserCount = EasXtSyncUtil.getInstance(ctx).getValue("getNormalUserCount");
        StringBuilder sbSql = new StringBuilder();
        String dbType = (String)ctx.get((Object)"dbType");
        if ("Oracle".equals(dbType)) {
            sbSql.append("SELECT count(0) FROM t_pm_easxtusermap where (FEmail in (select FEmail FROM t_pm_easxtusermap group by FEmail having count(FEmail) >= 2 and FEmail is not null))");
        } else {
            sbSql.append("SELECT count(0) FROM t_pm_easxtusermap where (FEmail in (select FEmail FROM t_pm_easxtusermap group by FEmail having count(FEmail) >= 2 and FEmail is not null and FEmail != ''))");
        }
        IRowSet rowSet1 = EasXtSyncUtil.executeQuery(ctx, sbSql.toString());
        int count = 0;
        try {
            if (rowSet1.next()) {
                count = rowSet1.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSameCellAndEmailPersonsCount(Context ctx) throws BOSException {
        String getNormalUserCount = EasXtSyncUtil.getInstance(ctx).getValue("getNormalUserCount");
        StringBuilder sbSql = new StringBuilder();
        String dbType = (String)ctx.get((Object)"dbType");
        if ("Oracle".equals(dbType)) {
            sbSql.append("SELECT count(0) from (SELECT fid FROM t_pm_easxtusermap where FEmail in (select FEmail FROM t_pm_easxtusermap group by FEmail having count(FEmail) >= 2 and FEmail is not null) union SELECT fid FROM t_pm_easxtusermap where FCell in (select fcell FROM t_pm_easxtusermap group by FCell having count(FCell) >= 2 and FCell is not null)) tt");
        } else {
            sbSql.append("SELECT count(0) from (SELECT fid FROM t_pm_easxtusermap where FEmail in (select FEmail FROM t_pm_easxtusermap group by FEmail having count(FEmail) >= 2 and FEmail is not null and FEmail != '') union SELECT fid FROM t_pm_easxtusermap where FCell in (select fcell FROM t_pm_easxtusermap group by FCell having count(FCell) >= 2 and FCell is not null and FCell != '')) tt");
        }
        IRowSet rowSet1 = EasXtSyncUtil.executeQuery(ctx, sbSql.toString());
        int count = 0;
        try {
            if (rowSet1.next()) {
                count = rowSet1.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return count;
    }

    private void bindOrgLeaderByOrgLongName(Context ctx) throws BOSException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("bindOrgLeaderByOrgLongName");
        EasXtSyncUtil.execute(ctx, sql);
    }

    private void clearTemp(Context ctx) throws BOSException {
        String sql = "truncate table t_tm_tmp";
        EasXtSyncUtil.execute(ctx, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEasOrgTree(Context ctx, String condition, String queryType, EasXtHighItemType highItemType) throws BOSException {
        String sql = "select fid,fparentid,fname_l2 from t_org_admin where fisSealup = 0 order by flongnumber asc, fsortcode asc";
        IRowSet rowSet1 = EasXtSyncUtil.executeQuery(ctx, sql);
        String sql2 = "SELECT p.FID,p.FNAME_l2,p.FADMINORGUNITID FROM T_ORG_POSITION  p inner join T_ORG_ADMIN  a on p.FADMINORGUNITID = a.FID and a.fisSealup = 0 and (p.FDELETEDSTATUS = 1 or p.FDELETEDSTATUS is null)";
        IRowSet rowSet2 = EasXtSyncUtil.executeQuery(ctx, sql2);
        String sql3 = "SELECT DISTINCT(FPOSITIONID) FROM T_XT_NOSYNCPERSON WHERE FPOSITIONID IS NOT NULL";
        IRowSet rowSet3 = EasXtSyncUtil.executeQuery(ctx, sql3);
        ArrayList<String> noSyncPositionIds = new ArrayList<String>();
        OrgBean org = null;
        ArrayList<OrgBean> list = new ArrayList<OrgBean>();
        try {
            while (rowSet3.next()) {
                noSyncPositionIds.add(rowSet3.getString("fpositionid"));
            }
            while (rowSet2.next()) {
                org = new OrgBean();
                org.setId(rowSet2.getString("fid"));
                org.setName(rowSet2.getString("fname_l2"));
                org.setPId(rowSet2.getString("FADMINORGUNITID"));
                org.setType(1);
                if (noSyncPositionIds.size() > 0 && noSyncPositionIds.contains(org.getId())) {
                    org.setSync(true);
                }
                list.add(org);
            }
            while (rowSet1.next()) {
                org = new OrgBean();
                org.setId(rowSet1.getString("fid"));
                org.setName(rowSet1.getString("fname_l2"));
                org.setType(0);
                if (!StringUtils.isEmpty((String)rowSet1.getString("fparentid"))) {
                    org.setPId(rowSet1.getString("fparentid"));
                } else {
                    org.setOpen(true);
                }
                list.add(org);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONArray.toJSONString(list);
    }

    private String getEasDeptDatas(Context ctx, String condition, String queryType, EasXtHighItemType highItemType) {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = o.getString("filter");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String orgId = o.getString("orgId");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEasPersonDatas(Context ctx, String condition, String queryType, EasXtHighItemType highItemType) throws BOSException {
        String filter;
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String string = filter = o.getString("filter") == null ? null : o.getString("filter").trim();
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        Boolean includeNotInMiddle = o.getBoolean("includeNotInMiddle");
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String orgId = o.getString("orgId");
        boolean showSub = "true".equals(o.getString("showSub"));
        orgId = orgId == null ? "" : orgId.replaceAll(" ", "+");
        AdminOrgUnitInfo adminInfo = null;
        try {
            adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        if (adminInfo == null) {
            return "";
        }
        String orgLongName = adminInfo.getDisplayName();
        StringBuilder sql = new StringBuilder();
        sql.append(EasXtSyncUtil.getInstance(ctx).getValue("getEasAllPersons"));
        if (!includeNotInMiddle.booleanValue()) {
            sql.append(" and t1.mapstatus is not null ");
        }
        if (!StringUtils.isEmpty((String)filter)) {
            sql.append(" and (t1.forglongname like '%").append(filter).append("%'").append(" or t1.ucell like '%").append(filter).append("%'").append(" or t1.pcell like '%").append(filter).append("%'").append(" or t1.umail like '%").append(filter).append("%'").append(" or t1.pmail like '%").append(filter).append("%'").append(" or t1.fusernumber like '%").append(filter).append("%'").append(" or t1.personnumber like '%").append(filter).append("%'").append(" or t1.fpersonname like '%").append(filter).append("%'").append(" or t1.fposition like '%").append(filter).append("%'");
            if ("\u4e0d\u4e0a\u4f20".equals(filter)) {
                sql.append(" or t1.noSyncPersonId is not null ");
            } else if ("\u4e0a\u4f20".equals(filter)) {
                sql.append(" or t1.noSyncPersonId is null ");
            }
            if ("\u5b58\u5728".equals(filter)) {
                sql.append(" or t1.mapstatus is not null ");
            } else if ("\u4e0d\u5b58\u5728".equals(filter)) {
                sql.append(" or t1.mapstatus is null ");
            }
            if ("\u5df2\u7ed1\u5b9a".equals(filter)) {
                sql.append(" or t1.fxtid is not null ");
            } else if ("\u672a\u7ed1\u5b9a".equals(filter)) {
                sql.append(" or t1.fxtid is null ");
            }
            sql.append(" or t1.femail like '%").append(filter).append("%') ");
        } else if (orgLongName.indexOf("_") < 0) {
            if (!showSub) {
                sql.append(" and (t1.orgparentid = '' or t1.orgparentid is null)");
            }
        } else if (orgLongName.indexOf("_") > 0) {
            if (showSub) {
                String dbType = (String)ctx.get((Object)"dbType");
                String tmpOrgLongName = orgLongName;
                sql.append(" and t1.forglongname like '").append(tmpOrgLongName).append("%'");
            } else {
                sql.append(" and t1.forglongname = '").append(orgLongName).append("'");
            }
        }
        IRowSet rowSetCount = EasXtSyncUtil.executeQuery(ctx, "select count(0) from (" + sql.toString() + ") countt");
        sql.append(" order by Flongnumber");
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        int total = 0;
        IRowSet rowSet1 = null;
        try {
            if (rowSetCount.next()) {
                total = rowSetCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rowSet1 = EasXtSyncUtil.executeQuery(ctx, sql.toString(), (page - 1) * rowCount, rowCount);
            while (rowSet1.next()) {
                map = new HashMap();
                String longName = rowSet1.getString("FOrgLongName");
                longName = "\\".equals(longName) ? adminInfo.getName() : longName;
                String xtid = rowSet1.getString("fxtid");
                map.put("fxtid", xtid);
                map.put("fuserid", rowSet1.getString("fuserId"));
                map.put("fpersonid", rowSet1.getString("fpersonId"));
                map.put("fname", rowSet1.getString("fpersonname"));
                map.put("fcell", rowSet1.getString("fcell"));
                map.put("femail", rowSet1.getString("femail"));
                map.put("fposition", rowSet1.getString("FPosition"));
                map.put("forglongname", longName);
                int inService = rowSet1.getInt("FinService");
                String status = "";
                switch (inService) {
                    case 1: {
                        status = "\u5728\u804c";
                        break;
                    }
                    case 0: {
                        status = "\u4e0d\u5728\u804c";
                        break;
                    }
                    case 2: {
                        status = "\u79bb\u804c";
                        break;
                    }
                    case 3: {
                        status = "\u79bb\u9000\u4f11";
                        break;
                    }
                    case 4: {
                        status = "\u8fd4\u8058";
                        break;
                    }
                    default: {
                        status = "\u804c\u5458\u72b6\u6001\u5f02\u5e38";
                    }
                }
                map.put("finservice", status);
                map.put("fisbindsucc", StringUtils.isEmpty((String)xtid) ? "0" : "1");
                map.put("fnosync", StringUtils.isEmpty((String)rowSet1.getString("noSyncPersonId")) ? "0" : "1");
                map.put("fnotinmiddle", StringUtils.isEmpty((String)rowSet1.getString("mapstatus")) ? "0" : "1");
                map.put("fmapstatus", StringUtils.isEmpty((String)rowSet1.getString("mapstatus")) ? "none" : rowSet1.getString("mapstatus"));
                map.put("fdescription", rowSet1.getString("fdescription"));
                map.put("fusernumber", StringUtils.isEmpty((String)rowSet1.getString("usernumber")) ? "" : rowSet1.getString("usernumber"));
                map.put("personnumber", StringUtils.isEmpty((String)rowSet1.getString("personnumber")) ? "" : rowSet1.getString("personnumber"));
                list.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSetCount != null) {
                try {
                    rowSetCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEasPersonByPosition(Context ctx, String condition, String queryType, EasXtHighItemType highItemType) throws BOSException {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        String positionId = o.getString("orgId");
        String filter = o.getString("filter");
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        Boolean includeNotInMiddle = o.getBoolean("includeNotInMiddle");
        StringBuilder sql = new StringBuilder();
        sql.append(EasXtSyncUtil.getInstance(ctx).getValue("getEasAllPersons"));
        if (!includeNotInMiddle.booleanValue()) {
            sql.append(" and t1.mapstatus is not null ");
        }
        if (o.getInteger("type") == 1) {
            BOSUuid.read((String)positionId);
            sql.append(" and t1.positionId = '" + positionId + "' and t1.FISPRIMARY = 1");
        }
        if (!StringUtils.isEmpty((String)filter)) {
            sql.append(" and (t1.forglongname like '%").append(filter).append("%'").append(" or t1.ucell like '%").append(filter).append("%'").append(" or t1.pcell like '%").append(filter).append("%'").append(" or t1.umail like '%").append(filter).append("%'").append(" or t1.pmail like '%").append(filter).append("%'").append(" or t1.fusernumber like '%").append(filter).append("%'").append(" or t1.personnumber like '%").append(filter).append("%'").append(" or t1.fpersonname like '%").append(filter).append("%'").append(" or t1.fposition like '%").append(filter).append("%'");
            if ("\u4e0d\u4e0a\u4f20".equals(filter)) {
                sql.append(" or t1.noSyncPersonId is not null ");
            } else if ("\u4e0a\u4f20".equals(filter)) {
                sql.append(" or t1.noSyncPersonId is null ");
            }
            if ("\u5b58\u5728".equals(filter)) {
                sql.append(" or t1.mapstatus is not null ");
            } else if ("\u4e0d\u5b58\u5728".equals(filter)) {
                sql.append(" or t1.mapstatus is null ");
            }
            if ("\u5df2\u7ed1\u5b9a".equals(filter)) {
                sql.append(" or t1.fxtid is not null ");
            } else if ("\u672a\u7ed1\u5b9a".equals(filter)) {
                sql.append(" or t1.fxtid is null ");
            }
            sql.append(" or t1.femail like '%").append(filter).append("%') ");
        }
        IRowSet rowSetCount = EasXtSyncUtil.executeQuery(ctx, "select count(0) from (" + sql.toString() + ") countt");
        sql.append(" order by Flongnumber");
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        int total = 0;
        IRowSet rowSet1 = null;
        try {
            if (rowSetCount.next()) {
                total = rowSetCount.getInt(1);
            }
            if (total < (page - 1) * rowCount) {
                page = 1;
            }
            rowSet1 = EasXtSyncUtil.executeQuery(ctx, sql.toString(), (page - 1) * rowCount, rowCount);
            while (rowSet1.next()) {
                map = new HashMap();
                String longName = rowSet1.getString("FOrgLongName");
                String xtid = rowSet1.getString("fxtid");
                map.put("fxtid", xtid);
                map.put("fuserid", rowSet1.getString("fuserId"));
                map.put("fpersonid", rowSet1.getString("fpersonId"));
                map.put("fname", rowSet1.getString("fpersonname"));
                map.put("fcell", rowSet1.getString("fcell"));
                map.put("femail", rowSet1.getString("femail"));
                map.put("fposition", rowSet1.getString("FPosition"));
                map.put("forglongname", longName);
                int inService = rowSet1.getInt("FinService");
                String status = "";
                switch (inService) {
                    case 1: {
                        status = "\u5728\u804c";
                        break;
                    }
                    case 0: {
                        status = "\u4e0d\u5728\u804c";
                        break;
                    }
                    case 2: {
                        status = "\u79bb\u804c";
                        break;
                    }
                    case 3: {
                        status = "\u79bb\u9000\u4f11";
                        break;
                    }
                    case 4: {
                        status = "\u8fd4\u8058";
                        break;
                    }
                    default: {
                        status = "\u804c\u5458\u72b6\u6001\u5f02\u5e38";
                    }
                }
                map.put("finservice", status);
                map.put("fisbindsucc", StringUtils.isEmpty((String)xtid) ? "0" : "1");
                map.put("fnosync", StringUtils.isEmpty((String)rowSet1.getString("noSyncPersonId")) ? "0" : "1");
                map.put("fnotinmiddle", StringUtils.isEmpty((String)rowSet1.getString("mapstatus")) ? "0" : "1");
                map.put("fmapstatus", StringUtils.isEmpty((String)rowSet1.getString("mapstatus")) ? "none" : rowSet1.getString("mapstatus"));
                map.put("fdescription", rowSet1.getString("fdescription"));
                map.put("fusernumber", StringUtils.isEmpty((String)rowSet1.getString("usernumber")) ? "" : rowSet1.getString("usernumber"));
                map.put("personnumber", StringUtils.isEmpty((String)rowSet1.getString("personnumber")) ? "" : rowSet1.getString("personnumber"));
                list.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSetCount != null) {
                try {
                    rowSetCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    private String getEasDeptLeaderDatas(Context ctx, String condition, String queryType, EasXtHighItemType highItemType) {
        return null;
    }

    private String getXtDeptDatas(Context ctx, String condition, String queryType, EasXtHighItemType highItemType) {
        return null;
    }

    private String getXtPersonDatas(Context ctx, String condition, String queryType, EasXtHighItemType highItemType) {
        return null;
    }

    private String getXtDeptLeaderDatas(Context ctx, String condition, String queryType, EasXtHighItemType highItemType) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrgLeaderByOrgName(Context ctx, String condition, String queryType, EasXtHighItemType highItemType) throws BOSException {
        String isSyncStr;
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String orgId = o.getString("orgId");
        AdminOrgUnitInfo adminInfo = null;
        try {
            adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        if (adminInfo == null) {
            return "";
        }
        String orgLongName = adminInfo.getDisplayName();
        String getEasOrgLeader = EasXtSyncUtil.getInstance(ctx).getValue("getEasOrgLeader");
        String getXtOrgLeader = EasXtSyncUtil.getInstance(ctx).getValue("getXtOrgLeader");
        if (orgLongName.indexOf("_") < 0) {
            getEasOrgLeader = getEasOrgLeader + " and (case when CHARINDEX('_',org.fdisplayname_l2) > 0 then to_char(REPLACE (SUBSTRING(org.fdisplayname_l2,CHARINDEX('_',org.fdisplayname_l2)+1,length(org.fdisplayname_l2)), '_', '\\')) else to_char('\\') end) = to_char('\\')";
            getXtOrgLeader = getXtOrgLeader + " and (xtorg.fparentid = '' or xtorg.fparentid is null)";
        } else if (orgLongName.indexOf("_") > 0) {
            orgLongName = orgLongName.substring(orgLongName.indexOf("_") + 1);
            orgLongName = orgLongName.replaceAll("_", "\\\\");
            getEasOrgLeader = getEasOrgLeader + " and (case when CHARINDEX('_',org.fdisplayname_l2) > 0 then to_char(REPLACE (SUBSTRING(org.fdisplayname_l2,CHARINDEX('_',org.fdisplayname_l2)+1,length(org.fdisplayname_l2)), '_', '\\')) else to_char('\\') end) = to_char('" + orgLongName + "')";
            getXtOrgLeader = getXtOrgLeader + " and xtuser.forglongname = '" + orgLongName + "'";
        }
        IRowSet rs = EasXtSyncUtil.executeQuery(ctx, getEasOrgLeader);
        IRowSet rs1 = EasXtSyncUtil.executeQuery(ctx, getXtOrgLeader);
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        StringBuilder easLeaderName = new StringBuilder();
        StringBuilder xtLeaderName = new StringBuilder();
        try {
            while (rs.next()) {
                if (StringUtils.isEmpty((String)rs.getString("leaderName"))) continue;
                easLeaderName.append(rs.getString("leaderName")).append(",");
            }
            while (rs1.next()) {
                if (StringUtils.isEmpty((String)rs1.getString("leaderName"))) continue;
                xtLeaderName.append(rs1.getString("leaderName")).append(",");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs1 != null) {
                try {
                    rs1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        if (StringUtils.isEmpty((String)easLeaderName.toString())) {
            tmpMap.put("easLeaderName", "\u6682\u65e0\u8d1f\u8d23\u4eba");
        } else {
            tmpMap.put("easLeaderName", easLeaderName.toString().substring(0, easLeaderName.lastIndexOf(",")));
        }
        if (StringUtils.isEmpty((String)xtLeaderName.toString())) {
            tmpMap.put("xtLeaderName", "\u6682\u65e0\u8d1f\u8d23\u4eba");
        } else {
            tmpMap.put("xtLeaderName", xtLeaderName.toString().substring(0, xtLeaderName.lastIndexOf(",")));
        }
        com.alibaba.fastjson.JSONObject cond = new com.alibaba.fastjson.JSONObject();
        cond.put("easorgid", (Object)orgId);
        cond.put("orglongname", (Object)orgLongName);
        String xtOrgNameMapStr = EasXtViewDataUtil.getXtOrg(ctx, cond.toString());
        com.alibaba.fastjson.JSONObject jo = com.alibaba.fastjson.JSONObject.parseObject((String)xtOrgNameMapStr);
        StringBuilder noBindReason = new StringBuilder();
        String easOrgName = adminInfo.getName();
        boolean isSync = EasXtViewDataUtil.getOrgSyncStatus(ctx, orgId);
        String string = isSyncStr = !isSync ? "" : "<span style='color:red;'>(\u4e0d\u4e0a\u4f20)</spam>";
        if (adminInfo.get("isSealup").equals("1")) {
            noBindReason.append("EAS\u7ec4\u7ec7\u5df2\u5c01\u5b58\uff1b");
        }
        if (easOrgName.contains("\\")) {
            noBindReason.append("EAS\u90e8\u95e8\u5b58\u5728\"\\\"\uff0c\u540c\u6b65\u540e\u4f1a\u5bfc\u81f4\u4e91\u4e4b\u5bb6\u7ec4\u7ec7\u5c42\u6b21\u9519\u4e71\uff1b");
        }
        if (easOrgName.contains("_")) {
            noBindReason.append("EAS\u90e8\u95e8\u5b58\u5728\"_\"\uff0c\u540c\u6b65\u540e\u4f1a\u5bfc\u81f4\u4e91\u4e4b\u5bb6\u7ec4\u7ec7\u5c42\u6b21\u9519\u4e71\uff1b");
        }
        if (jo == null) {
            tmpMap.put("xtOrgName", "<span style='color:red;'>\u672a\u67e5\u8be2\u5230\u6570\u636e</span>");
            tmpMap.put("isbind", "<span style='color:red;'>\u672a\u7ed1\u5b9a</span>");
            noBindReason.append("\u4e91\u4e4b\u5bb6\u8868\u4e0d\u5b58\u5728\u8be5\u90e8\u95e8\uff1b");
        } else {
            String xtOrgName = jo.get((Object)"forgname").toString();
            String isBind = jo.getString("fisbind");
            if (StringUtils.isEmpty((String)xtOrgName)) {
                tmpMap.put("isbind", "<span style='color:red;'>\u672a\u7ed1\u5b9a</span>");
                tmpMap.put("xtOrgName", "<span style='color:red;'>\u672a\u67e5\u8be2\u5230\u6570\u636e</span>");
                noBindReason.append("\u4e91\u4e4b\u5bb6\u8868\u4e0d\u5b58\u5728\u8be5\u90e8\u95e8\uff1b");
            } else {
                tmpMap.put("xtOrgName", xtOrgName);
                if ("1".equals(isBind)) {
                    tmpMap.put("isbind", "\u5df2\u7ed1\u5b9a");
                } else {
                    tmpMap.put("isbind", "<span style='color:red;'>\u672a\u7ed1\u5b9a</span>");
                    noBindReason.append("\u5176\u4ed6\u539f\u56e0\u672a\u7ed1\u5b9a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u6790\u3002");
                }
            }
        }
        tmpMap.put("easOrgName", easOrgName + isSyncStr);
        tmpMap.put("noBindReason", noBindReason.toString());
        return JSONObject.fromObject(tmpMap).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEasXtUserDetail(Context ctx, String condition, String queryType, EasXtHighItemType highItemType) throws BOSException {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String xtid = null;
        String userid = o.getString("userid") == null ? null : o.getString("userid").trim();
        String personid = o.getString("personid") == null ? null : o.getString("personid").trim();
        ArrayList<String> param = new ArrayList<String>();
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String getEasPersonDetail = easXtSyncUtil.getValue("getEasPersonDetail");
        String getXtPersonDetail = easXtSyncUtil.getValue("getXtPersonDetail");
        String getXtIdFromUMap = "select fxtid from t_pm_easxtusermap umap where 1 = 1 ";
        if (!StringUtils.isEmpty((String)userid) && !"null".equalsIgnoreCase(userid)) {
            getEasPersonDetail = getEasPersonDetail + " and opm.FISPRIMARY=1 and u.fid = ?";
            getXtIdFromUMap = getXtIdFromUMap + " and umap.fuserid = ?";
            param.add(userid);
        } else {
            getEasPersonDetail = getEasPersonDetail + " and opm.FISPRIMARY=1 and p.fid = ?";
            getXtIdFromUMap = getXtIdFromUMap + " and umap.fpersonid = ?";
            param.add(personid);
        }
        IRowSet rs0 = EasXtSyncUtil.executeQuery(ctx, getXtIdFromUMap, param.toArray());
        try {
            if (rs0.next()) {
                xtid = rs0.getString("fxtid");
                getXtPersonDetail = getXtPersonDetail + " and u.fid = '" + xtid + "'";
            } else {
                getXtPersonDetail = getXtPersonDetail + " and 1=2";
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs0 != null) {
                try {
                    rs0.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        IRowSet rs = EasXtSyncUtil.executeQuery(ctx, getEasPersonDetail, param.toArray());
        IRowSet rs1 = EasXtSyncUtil.executeQuery(ctx, getXtPersonDetail);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> tmpMap = new HashMap<String, HashMap<String, String>>();
        try {
            boolean sensitiveDef = PrivacyProtectUtil.isSensitiveDef();
            if (rs.next()) {
                String orgLongName;
                map = new HashMap();
                map.put("fname", rs.getString("fpersonname"));
                map.put("fcell", sensitiveDef ? PrivacyProtectUtil.hidePhoneInfo(rs.getString("fcell")) : rs.getString("fcell"));
                map.put("femail", sensitiveDef ? PrivacyProtectUtil.hideEmailInfo(rs.getString("femail")) : rs.getString("femail"));
                map.put("fposition", rs.getString("FPosition"));
                String string = orgLongName = rs.getString("FOrgLongName") == null ? "" : rs.getString("FOrgLongName");
                if (orgLongName.indexOf("_") > 0) {
                    orgLongName = orgLongName.substring(orgLongName.indexOf("_") + 1).replaceAll("_", "\\\\");
                    map.put("orgtop", "false");
                } else {
                    map.put("orgtop", "true");
                }
                map.put("forglongname", orgLongName);
                String userDelete = rs.getString("FIsDelete");
                int personInService = rs.getInt("FinService");
                String deletedStatus = rs.getString("fdeletedStatus");
                String status = "";
                switch (personInService) {
                    case 1: {
                        status = "\u5728\u804c";
                        break;
                    }
                    case 0: {
                        status = "\u4e0d\u5728\u804c";
                        break;
                    }
                    case 2: {
                        status = "\u79bb\u804c";
                        break;
                    }
                    case 3: {
                        status = "\u79bb\u9000\u4f11";
                        break;
                    }
                    case 4: {
                        status = "\u8fd4\u8058";
                        break;
                    }
                    default: {
                        status = "\u804c\u5458\u72b6\u6001\u5f02\u5e38";
                    }
                }
                if (!"1".equals(userDelete) && !"2".equals(deletedStatus)) {
                    map.put("fstatus", status);
                } else {
                    map.put("fstatus", "\u7528\u6237\u5df2\u5220\u9664");
                }
                map.put("fgender", Genders.getEnum((int)rs.getInt("FGender")) == null ? "\u4e0d\u786e\u5b9a" : Genders.getEnum((int)rs.getInt("FGender")).getAlias());
                map.put("fbirthday", rs.getString("FBirthday"));
                map.put("fhiredate", rs.getString("FHireDate"));
                map.put("fofficePhone1", sensitiveDef ? PrivacyProtectUtil.hidePhoneInfo(rs.getString("fofficePhone1")) : rs.getString("fofficePhone1"));
                map.put("fofficePhone2", sensitiveDef ? PrivacyProtectUtil.hidePhoneInfo(rs.getString("fofficePhone2")) : rs.getString("fofficePhone2"));
                map.put("fpersonnumber", rs.getString("personnumber"));
                map.put("fcontact", "");
                Map easLeaderAndJob = this.getLeaderAndJob(ctx, "EAS", rs.getString("fcell"));
                map.put("leaderName", (String)easLeaderAndJob.get("leaderName"));
                map.put("leaderPosition", (String)easLeaderAndJob.get("leaderPosition"));
                map.put("partJob", (String)easLeaderAndJob.get("partJob"));
                tmpMap.put("easPerson", map);
            } else {
                map = new HashMap();
                map.put("fname", "");
                map.put("fcell", "");
                map.put("femail", "");
                map.put("fposition", "");
                map.put("forglongname", "");
                map.put("orgtop", "true");
                map.put("fstatus", "");
                map.put("fgender", "");
                map.put("fbirthday", "");
                map.put("fhiredate", "");
                map.put("fofficePhone1", "");
                map.put("fofficePhone2", "");
                map.put("fcontact", "");
                map.put("leaderName", "");
                map.put("leaderPosition", "");
                map.put("partJob", "");
                map.put("fpersonnumber", "");
                tmpMap.put("easPerson", map);
            }
            if (rs1.next()) {
                map = new HashMap();
                map.put("fname", rs1.getString("fpersonname"));
                map.put("fcell", sensitiveDef ? PrivacyProtectUtil.hidePhoneInfo(rs.getString("fcell")) : rs1.getString("fcell"));
                map.put("femail", sensitiveDef ? PrivacyProtectUtil.hideEmailInfo(rs.getString("femail")) : rs1.getString("femail"));
                map.put("fposition", rs1.getString("FPosition"));
                map.put("forglongname", rs1.getString("FOrgLongName"));
                map.put("orgtop", StringUtils.isEmpty((String)rs1.getString("FParentId")) ? "true" : "false");
                String status = rs1.getString("FStatus");
                status = "0".equals(status) ? "\u79bb\u804c" : ("1".equals(status) ? "\u5728\u804c" : "\u7981\u7528");
                map.put("fstatus", status);
                map.put("fgender", Genders.getEnum((int)rs1.getInt("FGender")) == null ? "\u4e0d\u786e\u5b9a" : Genders.getEnum((int)rs1.getInt("FGender")).getAlias());
                map.put("fbirthday", StringUtils.isEmpty((String)rs1.getString("FBirthday2")) ? "" : rs1.getString("FBirthday"));
                map.put("fhiredate", rs1.getString("FHireDate") == null ? "" : rs1.getString("FHireDate"));
                map.put("fofficePhone1", "");
                map.put("fofficePhone2", "");
                map.put("fcontact", "");
                map.put("fpersonnumber", rs1.getString("fpersonnumber"));
                Map easLeaderAndJob = this.getLeaderAndJob(ctx, "XT", rs1.getString("fid"));
                map.put("leaderName", (String)easLeaderAndJob.get("leaderName"));
                map.put("leaderPosition", (String)easLeaderAndJob.get("leaderPosition"));
                map.put("partJob", (String)easLeaderAndJob.get("partJob"));
                tmpMap.put("xtPerson", map);
            } else {
                map = new HashMap();
                map.put("fname", "");
                map.put("fcell", "");
                map.put("femail", "");
                map.put("fposition", "");
                map.put("forglongname", "");
                map.put("orgtop", "true");
                map.put("fstatus", "");
                map.put("fgender", "");
                map.put("fbirthday", "");
                map.put("fhiredate", "");
                map.put("fofficePhone1", "");
                map.put("fofficePhone2", "");
                map.put("fcontact", "");
                map.put("leaderName", "");
                map.put("leaderPosition", "");
                map.put("partJob", "");
                map.put("fpersonnumber", "");
                tmpMap.put("xtPerson", map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs1 != null) {
                try {
                    rs1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.fromObject(tmpMap).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getLeaderAndJob(Context ctx, String type, String openIdOrCell) {
        String partJobSql = "";
        String leaderSql = "";
        EasXtSyncUtil exsu = EasXtSyncUtil.getInstance(ctx);
        try {
            if ("EAS".equals(type)) {
                partJobSql = exsu.getValue("getEASJianzhiWithAdmin") + " and (case when(u.FID is null or u.FID = '') then p.FCELL else u.FCELL end) = '" + openIdOrCell + "'";
                leaderSql = exsu.getValue("getEASShangjiWithAdmin") + " and (case when(u.FID is null or u.FID = '') then p.FCELL else u.FCELL end) = '" + openIdOrCell + "' ";
                if (!EasXtSyncUtil.getInstance(ctx).isItemUpdate("isUpdatePartSuperiorsMsg")) {
                    leaderSql = leaderSql + " and pm.FISPRIMARY = 1 ";
                }
            } else if ("XT".equals(type)) {
                partJobSql = exsu.getValue("getYZJJianzhiWithAdmin") + " where p.fxtid = '" + openIdOrCell + "'";
                leaderSql = exsu.getValue("getYZJShangjiWithAdmin") + " where r.FXtId= '" + openIdOrCell + "'";
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        IRowSet rowSet = null;
        IRowSet rowSet1 = null;
        HashMap<String, String> leaderAndJob = new HashMap<String, String>();
        try {
            rowSet = EasXtSyncUtil.executeQuery(ctx, partJobSql.toString());
            StringBuilder jobStr = new StringBuilder();
            while (rowSet.next()) {
                String orgLongName = "\\".equals(rowSet.getString("orgLongName")) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rowSet.getString("orgLongName");
                orgLongName = StringUtils.isEmpty((String)orgLongName) ? "" : "\u3010" + orgLongName + "\u3011";
                jobStr.append(rowSet.getString("jobTitle") + orgLongName + "\uff1b");
            }
            leaderAndJob.put("partJob", jobStr.toString().lastIndexOf("\uff1b") > 1 ? jobStr.substring(0, jobStr.lastIndexOf("\uff1b")) : jobStr.toString());
            rowSet1 = EasXtSyncUtil.executeQuery(ctx, leaderSql.toString());
            StringBuilder leaserNameStr = new StringBuilder();
            StringBuilder leaserPositionStr = new StringBuilder();
            while (rowSet1.next()) {
                if (!StringUtils.isEmpty((String)rowSet1.getString("leaderName"))) {
                    leaserNameStr.append(rowSet1.getString("leaderName"));
                }
                if (StringUtils.isEmpty((String)rowSet1.getString("leaderPosition"))) continue;
                leaserNameStr.append("\u3010" + rowSet1.getString("leaderPosition") + "\u3011\uff1b");
            }
            leaderAndJob.put("leaderName", leaserNameStr.lastIndexOf("\uff1b") > 1 ? leaserNameStr.substring(0, leaserNameStr.lastIndexOf("\uff1b")) : leaserNameStr.toString());
            leaderAndJob.put("leaderPosition", leaserPositionStr.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return leaderAndJob;
    }

    @Override
    protected String _autoSync(Context ctx) throws BOSException {
        return this.autoSyncReal(ctx, null);
    }

    @Override
    protected String _autoSyncNew(Context ctx, EasXtSyncType syncType) throws BOSException, EASBizException {
        return this.autoSyncReal(ctx, syncType);
    }

    private String autoSyncReal(Context ctx, EasXtSyncType syncType) throws BOSException {
        block26: {
            if (null == syncType) {
                syncType = EasXtSyncType.Full;
            }
            try {
                this.check(ctx, syncType);
                Map xtConfig = null;
                try {
                    xtConfig = this._getXtConfig(ctx);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                if (null != xtConfig) {
                    IEasXtSync syncService = EasXtSyncServiceFactory.getInstance(ctx, EasXtHighItemType.Dept);
                    syncService.beforeSync(syncType);
                    if ("1".equals(xtConfig.get("isUpdateOrgName"))) {
                        syncService.sync(EasXtSyncItemType.UpdateOrgName);
                    }
                    if ("1".equals(xtConfig.get("isMoveOrg"))) {
                        syncService.sync(EasXtSyncItemType.MoveOrg);
                    }
                    if ("1".equals(xtConfig.get("isUpdateOrg"))) {
                        syncService.sync(EasXtSyncItemType.AddNewOrg);
                    }
                    if ("1".equals(xtConfig.get("isDeleteOrg"))) {
                        syncService.sync(EasXtSyncItemType.DeleteOrg);
                    }
                    if ("1".equals(xtConfig.get("isUpdateOrgWeights"))) {
                        syncService.sync(EasXtSyncItemType.SetOrgWeights);
                    }
                    syncService.afterSync(syncType);
                    if ("1".equals(xtConfig.get("isAutoUpdateCell"))) {
                        this.updateXtCellUpdateRecords(ctx, syncType);
                        EasXtViewDataUtil.bindUpdateCellToMap(ctx, null, null);
                    }
                    syncService = EasXtSyncServiceFactory.getInstance(ctx, EasXtHighItemType.Person);
                    syncService.beforeSync(syncType);
                    if ("1".equals(xtConfig.get("isUpdateMobile"))) {
                        syncService.sync(EasXtSyncItemType.UpdatePersonCell);
                    }
                    if ("1".equals(xtConfig.get("isUpdatePersonOrg"))) {
                        syncService.sync(EasXtSyncItemType.UpdatePersonOrg);
                    }
                    if ("1".equals(xtConfig.get("isUpdatePersonName"))) {
                        syncService.sync(EasXtSyncItemType.UpdatePersonName);
                    }
                    if ("1".equals(xtConfig.get("isUpdatePersonNumber"))) {
                        syncService.sync(EasXtSyncItemType.UpdatePersonNumber);
                    }
                    if ("1".equals(xtConfig.get("isUpdatePersonGender"))) {
                        syncService.sync(EasXtSyncItemType.UpdatePersonGender);
                    }
                    if ("1".equals(xtConfig.get("isUpdatePersonPosition"))) {
                        syncService.sync(EasXtSyncItemType.UpdatePersonPosition);
                    }
                    if ("1".equals(xtConfig.get("isUpdatePersonWeights"))) {
                        syncService.sync(EasXtSyncItemType.UpdatePersonWeights);
                    }
                    if ("1".equals(xtConfig.get("isUpdatePersonCustom"))) {
                        syncService.sync(EasXtSyncItemType.UpdatePersonCustom);
                    }
                    if ("1".equals(xtConfig.get("isDeletePerson"))) {
                        syncService.sync(EasXtSyncItemType.DeletePerson);
                    }
                    if ("1".equals(xtConfig.get("isUpdatePerson"))) {
                        syncService.sync(EasXtSyncItemType.AddNewPerson);
                    }
                    if ("1".equals(xtConfig.get("isUpdatePersonEmail"))) {
                        syncService.sync(EasXtSyncItemType.UpdatePersonEmail);
                    }
                    syncService.afterSync(syncType);
                    syncService = EasXtSyncServiceFactory.getInstance(ctx, EasXtHighItemType.DeptLeader);
                    syncService.beforeSync(syncType);
                    if ("1".equals(xtConfig.get("isUpdateDepartmentPerson"))) {
                        syncService.sync(EasXtSyncItemType.BatchDeleteOrgLeader);
                        syncService.sync(EasXtSyncItemType.BatchSetOrgLeader);
                    }
                    syncService.afterSync(syncType);
                    syncService = EasXtSyncServiceFactory.getInstance(ctx, EasXtHighItemType.PartJob);
                    syncService.beforeSync(syncType);
                    if ("1".equals(xtConfig.get("isUpdatePluralityMsg"))) {
                        syncService.sync(EasXtSyncItemType.BatchDeletePartJob);
                        syncService.sync(EasXtSyncItemType.BatchSetPartJob);
                    }
                    syncService.afterSync(syncType);
                    syncService = EasXtSyncServiceFactory.getInstance(ctx, EasXtHighItemType.Relations);
                    syncService.beforeSync(syncType);
                    if ("1".equals(xtConfig.get("isUpdateSuperiorsMsg"))) {
                        syncService.sync(EasXtSyncItemType.BatchDeleteRelations);
                        syncService.sync(EasXtSyncItemType.BatchSetRelations);
                    }
                    syncService.afterSync(syncType);
                }
                this.bind(ctx, syncType);
                this.sendSyncResultMsg(ctx);
            }
            catch (Exception e) {
                ExceptionLogInfo excepInfo = new ExceptionLogInfo("autoSyncReal", e, null, null);
                ExceptionLogService.getInstance(ctx).addException(excepInfo);
                e.printStackTrace();
                if (!(e instanceof BOSException)) break block26;
                throw (BOSException)((Object)e);
            }
        }
        return null;
    }

    protected void sendSyncResultMsg(Context ctx) {
        StringBuilder sb = new StringBuilder("");
        String syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        HashMap map = new HashMap();
        List itemList = EasXtSyncItemType.getEnumList();
        for (int i = 0; i < itemList.size(); ++i) {
            EasXtSyncItemType syncItemType = (EasXtSyncItemType)((Object)itemList.get(i));
            try {
                int succCount = EasXtSyncLogUtils.getSyncLogCount(ctx, syncItemType, null, syncTimeId, true);
                int failCount = EasXtSyncLogUtils.getSyncLogCount(ctx, syncItemType, null, syncTimeId, false);
                if (succCount <= 0 && failCount <= 0) continue;
                sb.append(syncItemType.getAlias()).append("\uff1a   \u6210\u529f(").append(succCount).append(")\u6761\uff0c\u5931\u8d25(").append(failCount).append(")\u6761 \n");
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)"\u53d1\u9001\u6d88\u606f\u5931\u8d25---------------------------------");
                e.printStackTrace();
            }
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String[] userIds = new String[]{user.getId().toString()};
        String sender = user.getName();
        if (sb.length() > 0) {
            try {
                EasXtCommonUtils.sendMessage(ctx, userIds, "\u540c\u6b65\u5de5\u5177\u540e\u53f0\u4e8b\u7269\u540c\u6b65\u7ed3\u679c\u901a\u77e5", sender, sb.toString());
            }
            catch (EASBizException e) {
                logger.error((Object)"\u53d1\u9001\u6d88\u606f\u5931\u8d25---------------------------------");
                e.printStackTrace();
            }
            catch (BOSException e) {
                logger.error((Object)"\u53d1\u9001\u6d88\u606f\u5931\u8d25---------------------------------");
                e.printStackTrace();
            }
        }
    }

    @Override
    protected String _firstBind(Context ctx, EasXtSyncType syncType) throws BOSException {
        return "true";
    }

    @Override
    protected boolean _setNoSyncOrg(Context ctx, boolean noSync, String orgId) throws BOSException {
        return EasXtViewDataUtil.setNoSyncOrg(ctx, noSync, true, orgId);
    }

    @Override
    protected boolean _setNoSyncPosition(Context ctx, boolean noSync, String positionId) throws BOSException, EASBizException {
        return EasXtViewDataUtil.setNoSyncPosition(ctx, noSync, true, positionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _setNoSyncPerson(Context ctx, boolean noSync, List personIds) throws BOSException {
        if (personIds == null || personIds.size() <= 0) {
            return true;
        }
        HashSet pSet = new HashSet();
        for (int i = personIds.size() - 1; i > -1; --i) {
            pSet.add(personIds.get(i));
        }
        String insertSql = "insert into T_XT_NoSyncPerson(FPersonId) values(?)";
        String deleteSql = "delete from T_XT_NoSyncPerson where FPersonId in ";
        String selectSql = "select FPersonId from T_XT_NoSyncPerson";
        IRowSet rs = null;
        String logSql = "select fnumber,fname_l2 from t_bd_person where fid in ";
        try {
            rs = EasXtSyncUtil.executeQuery(ctx, logSql + EasXtCommonUtils.toPreSta(personIds), personIds.toArray());
            StringBuilder detailLogMsg = new StringBuilder();
            while (rs.next()) {
                detailLogMsg.append("\u4eba\u5458\u3010");
                detailLogMsg.append(rs.getString("fnumber") + "  ");
                detailLogMsg.append(rs.getString("fname_l2"));
                detailLogMsg.append("\u3011\u5df2\u88ab\u8bbe\u7f6e\u4e3a'");
                detailLogMsg.append(noSync ? "\u4e0d\u540c\u6b65" : "\u540c\u6b65");
                detailLogMsg.append("';\n");
            }
            String companyId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            IObjectPK beginLog = LogUtil.beginLog((Context)ctx, (String)"\u540c\u6b65\u5de5\u5177-\u540c\u6b65\u8bbe\u7f6e\u8303\u56f4", (BOSObjectType)new BOSObjectType("F4AF4F04"), (IObjectPK)ctx.getCaller(), (String)detailLogMsg.toString(), (String)"XTSync_Operate", (String)companyId);
            if (null != beginLog) {
                String sql = "update T_LOG_App set FENTITYALIAS_L2 = '\u540c\u6b65\u5de5\u5177' where fid = '" + beginLog.toString() + "'";
                EasXtSyncUtil.execute(ctx, sql);
            }
            if (!noSync) {
                EasXtSyncUtil.execute(ctx, deleteSql + EasXtCommonUtils.toPreSta(personIds), personIds.toArray());
            } else if (noSync) {
                rs = EasXtSyncUtil.executeQuery(ctx, selectSql);
                while (rs.next()) {
                    String fpersonId = rs.getString("FPersonId");
                    if (!pSet.contains(fpersonId)) continue;
                    pSet.remove(fpersonId);
                }
                ArrayList<String[]> params = new ArrayList<String[]>();
                Iterator it = pSet.iterator();
                while (it.hasNext()) {
                    params.add(new String[]{(String)it.next()});
                }
                if (params.size() > 0) {
                    EasXtSyncUtil.executeBatch(ctx, insertSql, params);
                }
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)beginLog);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    @Override
    protected IRowSet _exportData(Context ctx, EasXtSyncItemType syncItemType) throws BOSException {
        IRowSet rs = null;
        String itemTypeStr = syncItemType.getValue();
        if (StringUtils.isEmpty((String)itemTypeStr)) {
            throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)syncItemType));
        }
        int type = Integer.parseInt(itemTypeStr);
        switch (type) {
            case 13: {
                rs = this.exportNoCellPersonDatas(ctx);
                break;
            }
            case 19: {
                rs = this.exportSameCellAndEmailPersonDatas(ctx);
                break;
            }
        }
        return rs;
    }

    private IRowSet exportSameCellAndEmailPersonDatas(Context ctx) {
        StringBuilder sbSql = new StringBuilder();
        String dbType = (String)ctx.get((Object)"dbType");
        if ("Oracle".equals(dbType)) {
            sbSql.append("SELECT fuserid,fpersonid,fusernumber,fpersonname,fcell,femail,fposition,forglongname FROM t_pm_easxtusermap where FEmail in (select FEmail FROM t_pm_easxtusermap group by FEmail having count(FEmail) >= 2 and FEmail is not null) union SELECT fuserid,fpersonid,fusernumber,fpersonname,fcell,femail,fposition,forglongname FROM t_pm_easxtusermap where FCell in (select fcell FROM t_pm_easxtusermap group by FCell having count(FCell) >= 2 and FCell is not null)");
        } else {
            sbSql.append("SELECT fuserid,fpersonid,fusernumber,fpersonname,fcell,femail,fposition,forglongname FROM t_pm_easxtusermap where FEmail in (select FEmail FROM t_pm_easxtusermap group by FEmail having count(FEmail) >= 2 and FEmail is not null and FEmail != '') union SELECT fuserid,fpersonid,fusernumber,fpersonname,fcell,femail,fposition,forglongname FROM t_pm_easxtusermap where FCell in (select fcell FROM t_pm_easxtusermap group by FCell having count(FCell) >= 2 and FCell is not null and FCell != '')");
        }
        IRowSet rs = null;
        try {
            rs = EasXtSyncUtil.executeQuery(ctx, sbSql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rs;
    }

    private IRowSet exportNoCellPersonDatas(Context ctx) {
        StringBuilder sbSql = new StringBuilder();
        sbSql.append("SELECT fuserid,fpersonid,fusernumber,fpersonname,fcell,femail,fposition,forglongname FROM t_pm_easxtusermap where  (fcell is null or fcell = '') and (FEmail = '' or FEmail is null)");
        sbSql.append(" order by FUserNumber");
        IRowSet rs = null;
        try {
            rs = EasXtSyncUtil.executeQuery(ctx, sbSql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rs;
    }

    @Override
    protected boolean _deleteYZJ(Context ctx, List logIds) throws BOSException, EASBizException {
        logger.error((Object)"-----------\u79bb\u804c\u4eba\u5458\u65e5\u5fd7\u9875\u9762\u6570\u636e--------------");
        String sql = "select fpersonname,fxtid from T_XT_SYNCPERSONLOG where fid in (" + ToolUtils.aryToStr((List)logIds) + ")";
        JSONArray jsonArray = new JSONArray();
        IRowSet rs = EasXtSyncUtil.executeQuery(ctx, sql.toString());
        try {
            while (rs.next()) {
                String xtId = rs.getString("fxtid");
                if (StringUtils.isEmpty((String)xtId)) {
                    logger.error((Object)(rs.getString("fpersonname") + "\u5bf9\u5e94\u7684\u4e91\u4e4b\u5bb6ID\u4e3anull"));
                    continue;
                }
                jsonArray.add((Object)xtId);
            }
            com.alibaba.fastjson.JSONObject response = XtCommunicateUtil.getInstance(ctx).deletePersonStatus(jsonArray);
            logger.error((Object)("\u79bb\u804c\u6570\u636eFXTID\u4e3a\uff1a" + jsonArray.toString()));
            if (response.getBooleanValue("success")) {
                // empty if block
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected boolean _autoCleanLogs(Context ctx) throws BOSException, EASBizException {
        Map logConfig = this._getCleanLogConfig(ctx);
        String jsonString = com.alibaba.fastjson.JSONObject.toJSONString((Object)logConfig);
        return EasXtViewDataUtil.clearLog(ctx, jsonString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _getCleanLogConfig(Context ctx) throws BOSException, EASBizException {
        String sql = "SELECT TOP 1 FIsDeleteOrgLog,FIsDeletePersonLog,FIsDeleteDeptLeaderLog, FIsDeletePartJobLog ,FIsDeleteRelationsLog, FLogCleanTime FROM T_XT_CleanLogSetting ORDER BY FCreateTime DESC";
        IRowSet rs = null;
        Properties map = new Properties();
        try {
            rs = EasXtSyncUtil.executeQuery(ctx, sql);
            if (rs.next()) {
                int logCleanTimeInt = rs.getInt("FLogCleanTime");
                int isDeleteOrgLog = rs.getInt("FIsDeleteOrgLog");
                int isDeletePersonLog = rs.getInt("FIsDeletePersonLog");
                int isDeleteDeptLeaderLog = rs.getInt("FIsDeleteDeptLeaderLog");
                int isDeletePartJobLog = rs.getInt("FIsDeletePartJobLog");
                int isDeleteRelationsLog = rs.getInt("FIsDeleteRelationsLog");
                map.put("logCleanTime", logCleanTimeInt);
                map.put("isDeleteOrgLog", isDeleteOrgLog);
                map.put("isDeletePersonLog", isDeletePersonLog);
                map.put("isDeleteDeptLeaderLog", isDeleteDeptLeaderLog);
                map.put("isDeletePartJobLog", isDeletePartJobLog);
                map.put("isDeleteRelationsLog", isDeleteRelationsLog);
                Properties properties = map;
                return properties;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        map.put("logCleanTime", 365);
        map.put("isDeleteOrgLog", 0);
        map.put("isDeletePersonLog", 0);
        map.put("isDeleteDeptLeaderLog", 0);
        map.put("isDeletePartJobLog", 0);
        map.put("isDeleteRelationsLog", 0);
        return map;
    }
}

