/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.basesync.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.AbstractBaseSyncService;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncCommunitcateUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SyncDeptBaseService
extends AbstractBaseSyncService {
    public SyncDeptBaseService(SyncContext syncCtx) {
        super(syncCtx);
    }

    public String beforeSync() throws BOSException, EASBizException {
        this.getAllOrg();
        this.updateOrgLongName();
        this.updateOrgName();
        this.updateOrgStatus();
        this.updateOrgParentId();
        this.insertNewOrgToMap();
        return "true";
    }

    @Override
    public String sync(String itemType) throws BOSException, EASBizException, EASBizException {
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        if (type == null) {
            throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)type));
        }
        if (SyncItemType.AddNewOrg.equals((Object)type)) {
            return this.syncAddNewOrg(itemType);
        }
        if (SyncItemType.DeptSyncBefore.equals((Object)type)) {
            return this.beforeSync();
        }
        if (SyncItemType.DeptSyncAfter.equals((Object)type)) {
            return this.afterSync();
        }
        if (SyncItemType.SetOrgWeights.equals((Object)type) || SyncItemType.UpdateOrgName.equals((Object)type) || SyncItemType.MoveOrg.equals((Object)type) || SyncItemType.DeleteOrg.equals((Object)type)) {
            return this.syncUpdateOrgInfo(itemType);
        }
        throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + itemType);
    }

    public String afterSync() throws BOSException, EASBizException {
        this.getAllOrg();
        this.dataBind();
        return "true";
    }

    @Override
    public void dataBind() throws BOSException, EASBizException {
        this.bindOrgByOrgLongName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String syncAddNewOrg(String itemType) throws BOSException {
        String sql = this.getAddNewOrgSql();
        IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
        String[] syncJsonKey = this.getSyncJsonKey(itemType);
        String[] syncJsonValue = this.getSyncJsonValue(itemType);
        String[] syncLogColName = this.getSyncLogColName(itemType);
        String[] syncLogColValue = this.getSyncLogColValue(itemType);
        JSONArray dataArray = new JSONArray();
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        logMap.put("logColName", syncLogColName);
        ArrayList logArrays = new ArrayList();
        String result = null;
        try {
            ArrayList<String> logValue = null;
            while (rowSet.next()) {
                int i;
                JSONObject dataJSON = new JSONObject();
                if (rowSet.getString(1) == null) continue;
                for (i = 0; i < syncJsonKey.length; ++i) {
                    dataJSON.put(syncJsonKey[i], (Object)(rowSet.getObject(syncJsonValue[i]) == null ? "" : rowSet.getObject(syncJsonValue[i]).toString()));
                }
                logValue = new ArrayList<String>();
                for (i = 0; i < syncLogColName.length; ++i) {
                    logValue.add(rowSet.getObject(syncLogColValue[i]).toString());
                }
                logArrays.add(logValue);
                dataArray.add((Object)dataJSON);
            }
            logMap.put("logColValue", logArrays);
            result = this.syncDept(this.syncCtx, dataArray, itemType, logMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String syncUpdateOrgInfo(String itemType) throws BOSException {
        String sql = this.getUpdateOrgSql(itemType);
        IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
        String[] syncJsonKey = this.getSyncJsonKey(itemType);
        String[] syncJsonValue = this.getSyncJsonValue(itemType);
        String[] syncLogColName = this.getSyncLogColName(itemType);
        String[] syncLogColValue = this.getSyncLogColValue(itemType);
        JSONArray dataArray = new JSONArray();
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        logMap.put("logColName", syncLogColName);
        ArrayList logArrays = new ArrayList();
        String result = null;
        try {
            ArrayList<String> logValue = null;
            while (rowSet.next()) {
                int i;
                JSONObject dataJSON = new JSONObject();
                if (rowSet.getString(1) == null) continue;
                for (i = 0; i < syncJsonKey.length; ++i) {
                    dataJSON.put(syncJsonKey[i], (Object)(rowSet.getObject(syncJsonValue[i]) == null ? "" : rowSet.getObject(syncJsonValue[i]).toString()));
                }
                logValue = new ArrayList<String>();
                for (i = 0; i < syncLogColName.length; ++i) {
                    logValue.add(rowSet.getObject(syncLogColValue[i]).toString());
                }
                logArrays.add(logValue);
                dataArray.add((Object)dataJSON);
            }
            logMap.put("logColValue", logArrays);
            result = this.syncDept(this.syncCtx, dataArray, itemType, logMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String syncDept(SyncContext syncCtx, JSONArray dataArray, String itemType, Map logList) throws BOSException, IOException {
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        if (type == null) {
            throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)type));
        }
        if (dataArray.size() < 1) {
            return JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, type.getValue()));
        }
        JSONArray logArray = new JSONArray();
        JSONObject result = null;
        try {
            String url = this.getSyncURL(itemType);
            if (SyncItemType.DeleteOrg.equals((Object)type)) {
                ArrayList<String> reomveOrgIds = new ArrayList<String>();
                for (int i = 0; i < dataArray.size(); ++i) {
                    JSONObject dataJSON = dataArray.getJSONObject(i);
                    result = SyncCommunitcateUtil.getSyncResponse(url + "&id=" + dataJSON.getString("id"));
                    logArray.add((Object)result);
                    if (!"0".equals(result.getString("errcode"))) continue;
                    reomveOrgIds.add(dataJSON.getString("id"));
                }
                this.removeMapOrg(syncCtx, reomveOrgIds);
            } else {
                for (int i = 0; i < dataArray.size(); ++i) {
                    JSONObject dataJSON = dataArray.getJSONObject(i);
                    result = SyncCommunitcateUtil.getSyncResponse(dataJSON, url);
                    logArray.add((Object)result);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SyncLogUtils.syncLog(syncCtx, logList, logArray, type.getValue());
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, type.getValue()));
    }

    protected void removeMapOrg(SyncContext syncCtx, List<String> reomveOrgIds) throws BOSException {
        if (reomveOrgIds.size() < 1) {
            return;
        }
        StringBuilder sql = new StringBuilder("DELETE FROM " + syncCtx.getMappingTableName() + " WHERE  " + syncCtx.getMappingOrgIdColnum() + " IN (");
        for (String id : reomveOrgIds) {
            sql.append("'" + id + "',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        EasXtSyncUtil.execute(this.ctx, sql.toString());
    }

    protected String[] getSyncLogColName(String itemType) {
        String[] head = null;
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.AddNewOrg.equals((Object)baseEnum)) {
            head = new String[]{"FOrgLongName", "FOldOrgLongName"};
            return head;
        }
        if (SyncItemType.UpdateOrgName.equals((Object)baseEnum)) {
            head = new String[]{"FOrgLongName", "FOldOrgLongName"};
            return head;
        }
        if (SyncItemType.SetOrgWeights.equals((Object)baseEnum)) {
            head = new String[]{"FOrgLongName", "FWeight"};
            return head;
        }
        if (SyncItemType.MoveOrg.equals((Object)baseEnum)) {
            head = new String[]{"FOrgLongName", "FOldOrgLongName"};
            return head;
        }
        if (SyncItemType.DeleteOrg.equals((Object)baseEnum)) {
            head = new String[]{"FOrgLongName"};
            return head;
        }
        return head;
    }

    protected String[] getSyncLogColValue(String itemType) {
        String[] head = null;
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.AddNewOrg.equals((Object)baseEnum)) {
            head = new String[]{"FOrgLongName", "FName"};
            return head;
        }
        if (SyncItemType.UpdateOrgName.equals((Object)baseEnum)) {
            head = new String[]{"FOrgLongName", "FOldOrgLongName"};
            return head;
        }
        if (SyncItemType.SetOrgWeights.equals((Object)baseEnum)) {
            head = new String[]{"FOrgLongName", "FWeight"};
            return head;
        }
        if (SyncItemType.MoveOrg.equals((Object)baseEnum)) {
            head = new String[]{"FOrgLongName", "FOldOrgLongName"};
            return head;
        }
        if (SyncItemType.DeleteOrg.equals((Object)baseEnum)) {
            head = new String[]{"FOrgLongName"};
            return head;
        }
        return head;
    }

    protected String[] getSyncJsonKey(String itemType) {
        String[] head = null;
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.AddNewOrg.equals((Object)baseEnum)) {
            head = new String[]{"id", "name", "parentid", "order"};
            return head;
        }
        if (SyncItemType.UpdateOrgName.equals((Object)baseEnum)) {
            head = new String[]{"id", "name"};
            return head;
        }
        if (SyncItemType.SetOrgWeights.equals((Object)baseEnum)) {
            head = new String[]{"id", "order"};
            return head;
        }
        if (SyncItemType.MoveOrg.equals((Object)baseEnum)) {
            head = new String[]{"id", "parentid"};
            return head;
        }
        if (SyncItemType.DeleteOrg.equals((Object)baseEnum)) {
            head = new String[]{"id"};
            return head;
        }
        return head;
    }

    protected String[] getSyncJsonValue(String itemType) {
        String[] head = null;
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.AddNewOrg.equals((Object)baseEnum)) {
            head = new String[]{this.syncCtx.getMappingOrgIdColnum(), "FName", "FParentId", "FWeight"};
            return head;
        }
        if (SyncItemType.UpdateOrgName.equals((Object)baseEnum)) {
            head = new String[]{this.syncCtx.getMappingOrgIdColnum(), "FName"};
            return head;
        }
        if (SyncItemType.SetOrgWeights.equals((Object)baseEnum)) {
            head = new String[]{this.syncCtx.getMappingOrgIdColnum(), "FWeight"};
            return head;
        }
        if (SyncItemType.MoveOrg.equals((Object)baseEnum)) {
            head = new String[]{this.syncCtx.getMappingOrgIdColnum(), "FParentId"};
            return head;
        }
        if (SyncItemType.DeleteOrg.equals((Object)baseEnum)) {
            head = new String[]{this.syncCtx.getMappingOrgIdColnum()};
            return head;
        }
        return head;
    }

    protected String getAddNewOrgSql() throws BOSException {
        String sql = this.getInstance().getValue("selectAddNewOrgInfo");
        SyncBaseUtil.fillTemplateSql(sql, 0, this.syncCtx.getMappingTableName());
        SyncBaseUtil.fillTemplateSql(sql, 1, this.syncCtx.getSyncTableName());
        return sql;
    }

    protected String getUpdateOrgSql(String itemType) throws BOSException {
        String sql = null;
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.UpdateOrgName.equals((Object)baseEnum)) {
            sql = this.getInstance().getValue("selectUpdateOrgName");
            return this.fillTemplateSql(sql, 0);
        }
        if (SyncItemType.SetOrgWeights.equals((Object)baseEnum)) {
            sql = this.getInstance().getValue("selectUpdateOrgWeights");
            return this.fillTemplateSql(sql, 0);
        }
        if (SyncItemType.MoveOrg.equals((Object)baseEnum)) {
            sql = this.getInstance().getValue("selectMoveOrg");
            return this.fillTemplateSql(sql, 0);
        }
        if (SyncItemType.DeleteOrg.equals((Object)baseEnum)) {
            sql = this.getInstance().getValue("selectDeleteOrgInfo");
            return this.fillTemplateSql(sql, 0);
        }
        return this.fillTemplateSql(sql, 0);
    }

    protected SyncConfigUtil getInstance() {
        return SyncConfigUtil.getInstance();
    }
}

