/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.basesync.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.base.xtsync.EasXtSyncItemType;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;

public class ExportExcelTools {
    private SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private static final int CELL_TYPE_NUMERIC = 0;
    private static final int CELL_TYPE_STRING = 1;
    private static final int CELL_TYPE_FORMULA = 2;
    private static final int CELL_TYPE_BLANK = 3;
    private static final int CELL_TYPE_BOOLEAN = 4;
    private static final int CELL_TYPE_ERROR = 5;

    public HSSFWorkbook writeWorkBook(IRowSet rs, String fileName, String[] titles) {
        HSSFWorkbook workbook = null;
        try {
            workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet(fileName);
            HSSFFont boldFont = workbook.createFont();
            boldFont.setFontHeight((short)260);
            HSSFCellStyle titleStyle = workbook.createCellStyle();
            titleStyle.setFont(boldFont);
            boldFont = workbook.createFont();
            boldFont.setFontHeight((short)200);
            HSSFCellStyle textStyle = workbook.createCellStyle();
            textStyle.setFont(boldFont);
            HSSFRow titleRow = sheet.createRow(0);
            HSSFCell cell = titleRow.createCell(3);
            if (titleStyle != null) {
                cell.setCellStyle(titleStyle);
            }
            if (fileName != null) {
                cell.setCellValue(fileName);
            } else {
                cell.setCellValue("");
            }
            HSSFRow row = sheet.createRow(1);
            int n = titles.length;
            for (int i = 0; i < n; ++i) {
                cell = row.createCell((int)((short)i));
                if (titleStyle != null) {
                    cell.setCellStyle(titleStyle);
                }
                if (titles[i] != null) {
                    cell.setCellValue(titles[i]);
                    continue;
                }
                cell.setCellValue("");
            }
            int dataRowStart = 2;
            int dataColStart = 1;
            rs.beforeFirst();
            while (rs.next()) {
                int col = 0;
                row = sheet.createRow((int)((short)dataRowStart++));
                int n2 = titles.length;
                block11: for (int i = dataColStart; i <= n2; ++i) {
                    Object value = rs.getObject(i);
                    int cellType = 1;
                    if ("\u540c\u6b65\u7c7b\u578b".equals(titles[i - 1])) {
                        EasXtSyncItemType syncItemType = value == null ? null : EasXtSyncItemType.getEnum(value.toString());
                        Object object = value = syncItemType == null ? "" : syncItemType.getAlias();
                    }
                    if (value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Short || value instanceof BigDecimal) {
                        cellType = 0;
                    } else if (value instanceof Boolean) {
                        cellType = 4;
                    } else if (value instanceof Date || value instanceof Time || value instanceof Timestamp) {
                        value = this.sdf2.format(value);
                    }
                    cell = row.createCell((int)((short)col++));
                    if (textStyle != null) {
                        cell.setCellStyle(textStyle);
                    }
                    switch (cellType) {
                        case 3: {
                            continue block11;
                        }
                        case 1: {
                            if (value != null) {
                                cell.setCellValue(value.toString());
                                continue block11;
                            }
                            cell.setCellValue("");
                            continue block11;
                        }
                        case 0: {
                            cell.setCellType(CellType.NUMERIC);
                            if (value != null) {
                                try {
                                    cell.setCellValue(Double.parseDouble(value.toString()));
                                }
                                catch (Exception e) {
                                    cell.setCellValue("");
                                }
                                continue block11;
                            }
                            cell.setCellValue("");
                            continue block11;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workbook;
    }

    public HSSFWorkbook writeWorkBook(JSONArray jbody, String fileName, String[] titles) {
        HSSFWorkbook workbook = null;
        try {
            workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet(fileName);
            HSSFFont boldFont = workbook.createFont();
            boldFont.setFontHeight((short)260);
            HSSFCellStyle titleStyle = workbook.createCellStyle();
            titleStyle.setFont(boldFont);
            boldFont = workbook.createFont();
            boldFont.setFontHeight((short)200);
            HSSFCellStyle textStyle = workbook.createCellStyle();
            textStyle.setFont(boldFont);
            HSSFRow titleRow = sheet.createRow(0);
            HSSFCell cell = titleRow.createCell(3);
            if (titleStyle != null) {
                cell.setCellStyle(titleStyle);
            }
            if (fileName != null) {
                cell.setCellValue(fileName);
            } else {
                cell.setCellValue("");
            }
            HSSFRow row = sheet.createRow(1);
            int n = titles.length;
            for (int i = 0; i < n; ++i) {
                cell = row.createCell((int)((short)i));
                if (titleStyle != null) {
                    cell.setCellStyle(titleStyle);
                }
                if (titles[i] != null) {
                    cell.setCellValue(titles[i]);
                    continue;
                }
                cell.setCellValue("");
            }
            int dataRowStart = 2;
            boolean dataColStart = true;
            int n0 = jbody.size();
            for (int j = 0; j < n0; ++j) {
                int col = 0;
                row = sheet.createRow((int)((short)dataRowStart++));
                int n2 = titles.length;
                block11: for (int i = 0; i < n2; ++i) {
                    Object value = ((JSONObject)jbody.get(j)).get((Object)titles[i]);
                    int cellType = 1;
                    if (value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Short || value instanceof BigDecimal) {
                        cellType = 0;
                    } else if (value instanceof Boolean) {
                        cellType = 4;
                    } else if (value instanceof Date || value instanceof Time || value instanceof Timestamp) {
                        value = this.sdf2.format(value);
                    }
                    cell = row.createCell((int)((short)col++));
                    if (textStyle != null) {
                        cell.setCellStyle(textStyle);
                    }
                    switch (cellType) {
                        case 3: {
                            continue block11;
                        }
                        case 1: {
                            if (value != null) {
                                cell.setCellValue(value.toString());
                                continue block11;
                            }
                            cell.setCellValue("");
                            continue block11;
                        }
                        case 0: {
                            cell.setCellType(CellType.NUMERIC);
                            if (value != null) {
                                try {
                                    cell.setCellValue(Double.parseDouble(value.toString()));
                                }
                                catch (Exception e) {
                                    cell.setCellValue("");
                                }
                                continue block11;
                            }
                            cell.setCellValue("");
                            continue block11;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workbook;
    }

    public HSSFWorkbook writeWorkBook(List<Map> rows, String fileName, String[] titles, String[] baseCol) {
        HSSFWorkbook workbook = null;
        try {
            workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet(fileName);
            HSSFFont boldFont = workbook.createFont();
            boldFont.setFontHeight((short)260);
            HSSFCellStyle titleStyle = workbook.createCellStyle();
            titleStyle.setFont(boldFont);
            boldFont = workbook.createFont();
            boldFont.setFontHeight((short)200);
            HSSFCellStyle textStyle = workbook.createCellStyle();
            textStyle.setFont(boldFont);
            HSSFRow titleRow = sheet.createRow(0);
            HSSFCell cell = titleRow.createCell(3);
            if (titleStyle != null) {
                cell.setCellStyle(titleStyle);
            }
            if (fileName != null) {
                cell.setCellValue(fileName);
            } else {
                cell.setCellValue("");
            }
            HSSFRow row = sheet.createRow(1);
            int n = titles.length;
            for (int i = 0; i < n; ++i) {
                cell = row.createCell((int)((short)i));
                if (titleStyle != null) {
                    cell.setCellStyle(titleStyle);
                }
                if (titles[i] != null) {
                    cell.setCellValue(titles[i]);
                    continue;
                }
                cell.setCellValue("");
            }
            int dataRowStart = 2;
            int n0 = rows.size();
            for (int j = 0; j < n0; ++j) {
                int col = 0;
                row = sheet.createRow((int)((short)dataRowStart++));
                int n2 = baseCol.length;
                block11: for (int i = 0; i < n2; ++i) {
                    Object value = rows.get(j).get(baseCol[i]);
                    int cellType = 1;
                    if (value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Short || value instanceof BigDecimal) {
                        cellType = 0;
                    } else if (value instanceof Boolean) {
                        cellType = 4;
                    } else if (value instanceof Date || value instanceof Time || value instanceof Timestamp) {
                        value = this.sdf2.format(value);
                    }
                    cell = row.createCell((int)((short)col++));
                    if (textStyle != null) {
                        cell.setCellStyle(textStyle);
                    }
                    switch (cellType) {
                        case 3: {
                            continue block11;
                        }
                        case 1: {
                            if (value != null) {
                                cell.setCellValue(value.toString());
                                continue block11;
                            }
                            cell.setCellValue("");
                            continue block11;
                        }
                        case 0: {
                            cell.setCellType(CellType.NUMERIC);
                            if (value != null) {
                                try {
                                    cell.setCellValue(Double.parseDouble(value.toString()));
                                }
                                catch (Exception e) {
                                    cell.setCellValue("");
                                }
                                continue block11;
                            }
                            cell.setCellValue("");
                            continue block11;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workbook;
    }
}

