/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.ddsync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.trdsync.SyncHighItemType;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.IBaseSync;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncServiceFactoryHelper;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.DDSyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.imp.DDSyncDeptLeaderService;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.imp.DDSyncDeptService;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.imp.DDSyncPartService;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.imp.DDSyncPersonService;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.util.DDSyncUtil;
import java.util.Map;

public class DDSyncServiceFactotyHelper
extends SyncServiceFactoryHelper {
    public static final String ORG_MAPPING_TABLE = "T_PM_EASDDORGMAP";
    public static final String ORG_SYNC_TABLE = "T_DD_ORG";
    public static final String ORG_SYNCLOG_TABLE = "T_DD_SYNCDEPTLOG";
    public static final String ORG_DD_ID = "FDDORGID";
    public static final String ORG_DD_PARENTID = "FDDPARENTID";
    public static final String ORG_DD_NOSYNCORG = "T_DD_NOSYNCORG";
    public static final String USER_MAPPING_TABLE = "T_PM_EASDTUSERMAP";
    public static final String USER_SYNC_TABLE = "T_DD_USER";
    public static final String USER_SYNCLOG_TABLE = "T_DD_SYNCPERSONLOG";
    public static final String USER_DD_ID = "FXTID";
    public static final String USER_DD_NOSYNCPERSON = "T_DD_NOSYNCPERSON";
    public static final String PART_MAPPING_TABLE = "T_PM_EASDDPARTMAP";
    public static final String PART_SYNC_TABLE = "T_DD_PART";
    public static final String PART_SYNCLOG_TABLE = "T_DD_SYNCPARTLOG";
    public static final String DEPRLEADER_MAPPING_TABLE = "T_PM_EASDDORGLEADERMAP";
    public static final String DEPRLEADER_SYNC_TABLE = "T_DD_ORGLEADER";
    public static final String DEPRLEADER_SYNCLOG_TABLE = "T_DD_SYNCORGLEADERLOG";

    @Override
    protected IBaseSync getSyncServiceImpByType(Context ctx, String syncItemType, int type) throws BOSException {
        SyncItemType syncType = SyncBaseUtil.getBaseEnum(syncItemType);
        if (syncType != null) {
            return super.getSyncServiceImpByType(ctx, syncItemType, type);
        }
        DDSyncItemType ddType = DDSyncUtil.getDDSyncEnum(syncItemType);
        IBaseSync baseSync = null;
        switch (Integer.parseInt(ddType.getValue())) {
            case 100: {
                SyncContext syncPartCtx = this.getSyncContextByType(SyncHighItemType.PartJob, type);
                syncPartCtx.setCtx(ctx);
                baseSync = this.getPartServiceImp(syncPartCtx);
            }
        }
        return baseSync;
    }

    @Override
    protected void init(Map syncImpMap) {
        super.init(syncImpMap);
    }

    @Override
    public SyncContext getSyncContextByType(SyncHighItemType itemType, int type) {
        SyncContext syncCtx = new SyncContext();
        syncCtx.setType(type);
        if (SyncHighItemType.Dept.equals((Object)itemType)) {
            syncCtx.setMappingTableName(ORG_MAPPING_TABLE);
            syncCtx.setSyncTableName(ORG_SYNC_TABLE);
            syncCtx.setMappingOrgIdColnum(ORG_DD_ID);
            syncCtx.setLogTableName(ORG_SYNCLOG_TABLE);
            syncCtx.setHighItemType(SyncHighItemType.Dept);
            syncCtx.setMappingOrgParentIdColnum(ORG_DD_PARENTID);
            syncCtx.setNoSyncTableName(ORG_DD_NOSYNCORG);
        } else if (SyncHighItemType.Person.equals((Object)itemType)) {
            syncCtx.setMappingTableName(USER_MAPPING_TABLE);
            syncCtx.setSyncTableName(USER_SYNC_TABLE);
            syncCtx.setLogTableName(USER_SYNCLOG_TABLE);
            syncCtx.setMappingUserIdColnum(USER_DD_ID);
            syncCtx.setMappingOrgIdColnum(ORG_DD_ID);
            syncCtx.setHighItemType(SyncHighItemType.Person);
            syncCtx.setNoSyncTableName(USER_DD_NOSYNCPERSON);
        } else if (SyncHighItemType.PartJob.equals((Object)itemType)) {
            syncCtx.setMappingTableName(PART_MAPPING_TABLE);
            syncCtx.setSyncTableName(PART_SYNC_TABLE);
            syncCtx.setLogTableName(PART_SYNCLOG_TABLE);
            syncCtx.setHighItemType(SyncHighItemType.PartJob);
            syncCtx.setNoSyncTableName(USER_DD_NOSYNCPERSON);
        } else if (SyncHighItemType.DeptLeader.equals((Object)itemType)) {
            syncCtx.setMappingTableName(DEPRLEADER_MAPPING_TABLE);
            syncCtx.setSyncTableName(DEPRLEADER_SYNC_TABLE);
            syncCtx.setLogTableName(DEPRLEADER_SYNCLOG_TABLE);
            syncCtx.setHighItemType(SyncHighItemType.DeptLeader);
            syncCtx.setNoSyncTableName(USER_DD_NOSYNCPERSON);
        }
        return syncCtx;
    }

    @Override
    protected IBaseSync getDeptServiceImp(SyncContext ctx) {
        return new DDSyncDeptService(ctx);
    }

    @Override
    protected IBaseSync getPersonServiceImp(SyncContext ctx) {
        return new DDSyncPersonService(ctx);
    }

    @Override
    protected IBaseSync getDeptLeaderServiceImp(SyncContext syncDeptLeaderCtx) {
        return new DDSyncDeptLeaderService(syncDeptLeaderCtx);
    }

    @Override
    protected IBaseSync getPartServiceImp(SyncContext syncPartCtx) {
        return new DDSyncPartService(syncPartCtx);
    }
}

