/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.wlsync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.trdsync.SyncHighItemType;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.IBaseSync;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncServiceFactoryHelper;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.WLSyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.imp.WLSyncDeptLeaderService;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.imp.WLSyncDeptService;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.imp.WLSyncPartService;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.imp.WLSyncPersonService;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncUtil;
import java.util.List;
import java.util.Map;

public class WLSyncServiceFactoryHelper
extends SyncServiceFactoryHelper {
    public static final String ORG_MAPPING_TABLE = "T_PM_EASWLORGMAP";
    public static final String ORG_SYNC_TABLE = "T_WL_ORG";
    public static final String ORG_SYNCLOG_TABLE = "T_WL_SYNCDEPTLOG";
    public static final String ORG_WL_ID = "FWLORGID";
    public static final String ORG_WL_PARENTID = "FWLPARENTID";
    public static final String ORG_WL_NOSYNCORG = "T_WL_NOSYNCORG";
    public static final String USER_MAPPING_TABLE = "T_PM_EASWLUSERMAP";
    public static final String USER_SYNC_TABLE = "T_WL_USER";
    public static final String USER_WL_ID = "FXTID";
    public static final String USER_SYNCLOG_TABLE = "T_WL_SYNCPERSONLOG";
    public static final String USER_WL_NOSYNCPERSON = "T_WL_NOSYNCPERSON";
    public static final String PART_MAPPING_TABLE = "T_PM_EASWLPARTMAP";
    public static final String PART_SYNC_TABLE = "T_WL_PART";
    public static final String PART_SYNCLOG_TABLE = "T_WL_SYNCPARTLOG";
    public static final String DEPRLEADER_MAPPING_TABLE = "T_PM_EASWLORGLEADERMAP";
    public static final String DEPRLEADER_SYNC_TABLE = "T_WL_ORGLEADER";
    public static final String DEPRLEADER_SYNCLOG_TABLE = "T_WL_SYNCORGLEADERLOG";
    public static List<SyncItemType> enumList = null;

    @Override
    protected IBaseSync getSyncServiceImpByType(Context ctx, String syncItemType, int type) throws BOSException {
        SyncItemType syncType = SyncBaseUtil.getBaseEnum(syncItemType);
        if (syncType != null) {
            return super.getSyncServiceImpByType(ctx, syncItemType, type);
        }
        WLSyncItemType WLType = WLSyncUtil.getWLSyncEnum(syncItemType);
        IBaseSync baseSync = null;
        switch (Integer.parseInt(WLType.getValue())) {
            case 100: {
                SyncContext syncPartCtx = this.getSyncContextByType(SyncHighItemType.PartJob, type);
                syncPartCtx.setCtx(ctx);
                baseSync = this.getPartServiceImp(syncPartCtx);
                break;
            }
            case 101: {
                SyncContext syncLeaderCtx = this.getSyncContextByType(SyncHighItemType.DeptLeader, type);
                syncLeaderCtx.setCtx(ctx);
                baseSync = this.getDeptLeaderServiceImp(syncLeaderCtx);
            }
        }
        return baseSync;
    }

    @Override
    protected void init(Map syncImpMap) {
        super.init(syncImpMap);
    }

    @Override
    public SyncContext getSyncContextByType(SyncHighItemType itemType, int type) {
        SyncContext syncCtx = new SyncContext();
        syncCtx.setType(type);
        if (SyncHighItemType.Dept.equals((Object)itemType)) {
            syncCtx.setMappingTableName(ORG_MAPPING_TABLE);
            syncCtx.setSyncTableName(ORG_SYNC_TABLE);
            syncCtx.setMappingOrgIdColnum(ORG_WL_ID);
            syncCtx.setMappingOrgParentIdColnum(ORG_WL_PARENTID);
            syncCtx.setLogTableName(ORG_SYNCLOG_TABLE);
            syncCtx.setHighItemType(SyncHighItemType.Dept);
            syncCtx.setNoSyncTableName(ORG_WL_NOSYNCORG);
        } else if (SyncHighItemType.Person.equals((Object)itemType)) {
            syncCtx.setMappingTableName(USER_MAPPING_TABLE);
            syncCtx.setSyncTableName(USER_SYNC_TABLE);
            syncCtx.setLogTableName(USER_SYNCLOG_TABLE);
            syncCtx.setMappingUserIdColnum(USER_WL_ID);
            syncCtx.setMappingOrgIdColnum(ORG_WL_ID);
            syncCtx.setHighItemType(SyncHighItemType.Person);
            syncCtx.setNoSyncTableName(USER_WL_NOSYNCPERSON);
        } else if (SyncHighItemType.PartJob.equals((Object)itemType)) {
            syncCtx.setMappingTableName(PART_MAPPING_TABLE);
            syncCtx.setSyncTableName(PART_SYNC_TABLE);
            syncCtx.setLogTableName(PART_SYNCLOG_TABLE);
            syncCtx.setHighItemType(SyncHighItemType.PartJob);
            syncCtx.setNoSyncTableName(USER_WL_NOSYNCPERSON);
        } else if (SyncHighItemType.DeptLeader.equals((Object)itemType)) {
            syncCtx.setMappingTableName(DEPRLEADER_MAPPING_TABLE);
            syncCtx.setSyncTableName(DEPRLEADER_SYNC_TABLE);
            syncCtx.setLogTableName(DEPRLEADER_SYNCLOG_TABLE);
            syncCtx.setHighItemType(SyncHighItemType.DeptLeader);
            syncCtx.setNoSyncTableName(USER_WL_NOSYNCPERSON);
        }
        return syncCtx;
    }

    @Override
    protected IBaseSync getDeptServiceImp(SyncContext ctx) {
        return new WLSyncDeptService(ctx);
    }

    @Override
    protected IBaseSync getPersonServiceImp(SyncContext ctx) {
        return new WLSyncPersonService(ctx);
    }

    @Override
    protected IBaseSync getDeptLeaderServiceImp(SyncContext syncDeptLeaderCtx) {
        return new WLSyncDeptLeaderService(syncDeptLeaderCtx);
    }

    @Override
    protected IBaseSync getPartServiceImp(SyncContext syncPartCtx) {
        return new WLSyncPartService(syncPartCtx);
    }
}

